//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple8000series/armstorsimple8000series"
	"net/http"
	"net/url"
	"regexp"
)

// StorageAccountCredentialsServer is a fake server for instances of the armstorsimple8000series.StorageAccountCredentialsClient type.
type StorageAccountCredentialsServer struct {
	// BeginCreateOrUpdate is the fake for method StorageAccountCredentialsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, storageAccountCredentialName string, resourceGroupName string, managerName string, parameters armstorsimple8000series.StorageAccountCredential, options *armstorsimple8000series.StorageAccountCredentialsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armstorsimple8000series.StorageAccountCredentialsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method StorageAccountCredentialsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, storageAccountCredentialName string, resourceGroupName string, managerName string, options *armstorsimple8000series.StorageAccountCredentialsClientBeginDeleteOptions) (resp azfake.PollerResponder[armstorsimple8000series.StorageAccountCredentialsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method StorageAccountCredentialsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, storageAccountCredentialName string, resourceGroupName string, managerName string, options *armstorsimple8000series.StorageAccountCredentialsClientGetOptions) (resp azfake.Responder[armstorsimple8000series.StorageAccountCredentialsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByManagerPager is the fake for method StorageAccountCredentialsClient.NewListByManagerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagerPager func(resourceGroupName string, managerName string, options *armstorsimple8000series.StorageAccountCredentialsClientListByManagerOptions) (resp azfake.PagerResponder[armstorsimple8000series.StorageAccountCredentialsClientListByManagerResponse])
}

// NewStorageAccountCredentialsServerTransport creates a new instance of StorageAccountCredentialsServerTransport with the provided implementation.
// The returned StorageAccountCredentialsServerTransport instance is connected to an instance of armstorsimple8000series.StorageAccountCredentialsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewStorageAccountCredentialsServerTransport(srv *StorageAccountCredentialsServer) *StorageAccountCredentialsServerTransport {
	return &StorageAccountCredentialsServerTransport{
		srv:                   srv,
		beginCreateOrUpdate:   newTracker[azfake.PollerResponder[armstorsimple8000series.StorageAccountCredentialsClientCreateOrUpdateResponse]](),
		beginDelete:           newTracker[azfake.PollerResponder[armstorsimple8000series.StorageAccountCredentialsClientDeleteResponse]](),
		newListByManagerPager: newTracker[azfake.PagerResponder[armstorsimple8000series.StorageAccountCredentialsClientListByManagerResponse]](),
	}
}

// StorageAccountCredentialsServerTransport connects instances of armstorsimple8000series.StorageAccountCredentialsClient to instances of StorageAccountCredentialsServer.
// Don't use this type directly, use NewStorageAccountCredentialsServerTransport instead.
type StorageAccountCredentialsServerTransport struct {
	srv                   *StorageAccountCredentialsServer
	beginCreateOrUpdate   *tracker[azfake.PollerResponder[armstorsimple8000series.StorageAccountCredentialsClientCreateOrUpdateResponse]]
	beginDelete           *tracker[azfake.PollerResponder[armstorsimple8000series.StorageAccountCredentialsClientDeleteResponse]]
	newListByManagerPager *tracker[azfake.PagerResponder[armstorsimple8000series.StorageAccountCredentialsClientListByManagerResponse]]
}

// Do implements the policy.Transporter interface for StorageAccountCredentialsServerTransport.
func (s *StorageAccountCredentialsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "StorageAccountCredentialsClient.BeginCreateOrUpdate":
		resp, err = s.dispatchBeginCreateOrUpdate(req)
	case "StorageAccountCredentialsClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "StorageAccountCredentialsClient.Get":
		resp, err = s.dispatchGet(req)
	case "StorageAccountCredentialsClient.NewListByManagerPager":
		resp, err = s.dispatchNewListByManagerPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *StorageAccountCredentialsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := s.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccountCredentials/(?P<storageAccountCredentialName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorsimple8000series.StorageAccountCredential](req)
		if err != nil {
			return nil, err
		}
		storageAccountCredentialNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageAccountCredentialName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdate(req.Context(), storageAccountCredentialNameParam, resourceGroupNameParam, managerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		s.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		s.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (s *StorageAccountCredentialsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccountCredentials/(?P<storageAccountCredentialName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		storageAccountCredentialNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageAccountCredentialName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), storageAccountCredentialNameParam, resourceGroupNameParam, managerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *StorageAccountCredentialsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccountCredentials/(?P<storageAccountCredentialName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	storageAccountCredentialNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageAccountCredentialName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), storageAccountCredentialNameParam, resourceGroupNameParam, managerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StorageAccountCredential, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StorageAccountCredentialsServerTransport) dispatchNewListByManagerPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByManagerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagerPager not implemented")}
	}
	newListByManagerPager := s.newListByManagerPager.get(req)
	if newListByManagerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorSimple/managers/(?P<managerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageAccountCredentials`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managerName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByManagerPager(resourceGroupNameParam, managerNameParam, nil)
		newListByManagerPager = &resp
		s.newListByManagerPager.add(req, newListByManagerPager)
	}
	resp, err := server.PagerResponderNext(newListByManagerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByManagerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagerPager) {
		s.newListByManagerPager.remove(req)
	}
	return resp, nil
}
