//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstoragecache

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIOperation.
func (a APIOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", a.Display)
	populate(objectMap, "isDataAction", a.IsDataAction)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "origin", a.Origin)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIOperation.
func (a *APIOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &a.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &a.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &a.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIOperationDisplay.
func (a APIOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "operation", a.Operation)
	populate(objectMap, "provider", a.Provider)
	populate(objectMap, "resource", a.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIOperationDisplay.
func (a *APIOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &a.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &a.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIOperationListResult.
func (a APIOperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIOperationListResult.
func (a *APIOperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIOperationProperties.
func (a APIOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", a.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIOperationProperties.
func (a *APIOperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &a.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIOperationPropertiesServiceSpecification.
func (a APIOperationPropertiesServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logSpecifications", a.LogSpecifications)
	populate(objectMap, "metricSpecifications", a.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIOperationPropertiesServiceSpecification.
func (a *APIOperationPropertiesServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &a.LogSpecifications)
			delete(rawMsg, key)
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &a.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystem.
func (a AmlFilesystem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "zones", a.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystem.
func (a *AmlFilesystem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &a.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemArchive.
func (a AmlFilesystemArchive) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filesystemPath", a.FilesystemPath)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemArchive.
func (a *AmlFilesystemArchive) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filesystemPath":
			err = unpopulate(val, "FilesystemPath", &a.FilesystemPath)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemArchiveInfo.
func (a AmlFilesystemArchiveInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filesystemPath", a.FilesystemPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemArchiveInfo.
func (a *AmlFilesystemArchiveInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filesystemPath":
			err = unpopulate(val, "FilesystemPath", &a.FilesystemPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemArchiveStatus.
func (a AmlFilesystemArchiveStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", a.ErrorCode)
	populate(objectMap, "errorMessage", a.ErrorMessage)
	populateDateTimeRFC3339(objectMap, "lastCompletionTime", a.LastCompletionTime)
	populateDateTimeRFC3339(objectMap, "lastStartedTime", a.LastStartedTime)
	populate(objectMap, "percentComplete", a.PercentComplete)
	populate(objectMap, "state", a.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemArchiveStatus.
func (a *AmlFilesystemArchiveStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &a.ErrorCode)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &a.ErrorMessage)
			delete(rawMsg, key)
		case "lastCompletionTime":
			err = unpopulateDateTimeRFC3339(val, "LastCompletionTime", &a.LastCompletionTime)
			delete(rawMsg, key)
		case "lastStartedTime":
			err = unpopulateDateTimeRFC3339(val, "LastStartedTime", &a.LastStartedTime)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &a.PercentComplete)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemCheckSubnetError.
func (a AmlFilesystemCheckSubnetError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filesystemSubnet", a.FilesystemSubnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemCheckSubnetError.
func (a *AmlFilesystemCheckSubnetError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filesystemSubnet":
			err = unpopulate(val, "FilesystemSubnet", &a.FilesystemSubnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemCheckSubnetErrorFilesystemSubnet.
func (a AmlFilesystemCheckSubnetErrorFilesystemSubnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", a.Message)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemCheckSubnetErrorFilesystemSubnet.
func (a *AmlFilesystemCheckSubnetErrorFilesystemSubnet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemClientInfo.
func (a AmlFilesystemClientInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerStorageInterface", a.ContainerStorageInterface)
	populate(objectMap, "lustreVersion", a.LustreVersion)
	populate(objectMap, "mgsAddress", a.MgsAddress)
	populate(objectMap, "mountCommand", a.MountCommand)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemClientInfo.
func (a *AmlFilesystemClientInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerStorageInterface":
			err = unpopulate(val, "ContainerStorageInterface", &a.ContainerStorageInterface)
			delete(rawMsg, key)
		case "lustreVersion":
			err = unpopulate(val, "LustreVersion", &a.LustreVersion)
			delete(rawMsg, key)
		case "mgsAddress":
			err = unpopulate(val, "MgsAddress", &a.MgsAddress)
			delete(rawMsg, key)
		case "mountCommand":
			err = unpopulate(val, "MountCommand", &a.MountCommand)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemContainerStorageInterface.
func (a AmlFilesystemContainerStorageInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "persistentVolume", a.PersistentVolume)
	populate(objectMap, "persistentVolumeClaim", a.PersistentVolumeClaim)
	populate(objectMap, "storageClass", a.StorageClass)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemContainerStorageInterface.
func (a *AmlFilesystemContainerStorageInterface) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "persistentVolume":
			err = unpopulate(val, "PersistentVolume", &a.PersistentVolume)
			delete(rawMsg, key)
		case "persistentVolumeClaim":
			err = unpopulate(val, "PersistentVolumeClaim", &a.PersistentVolumeClaim)
			delete(rawMsg, key)
		case "storageClass":
			err = unpopulate(val, "StorageClass", &a.StorageClass)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemEncryptionSettings.
func (a AmlFilesystemEncryptionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyEncryptionKey", a.KeyEncryptionKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemEncryptionSettings.
func (a *AmlFilesystemEncryptionSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &a.KeyEncryptionKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemHealth.
func (a AmlFilesystemHealth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", a.State)
	populate(objectMap, "statusCode", a.StatusCode)
	populate(objectMap, "statusDescription", a.StatusDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemHealth.
func (a *AmlFilesystemHealth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &a.StatusCode)
			delete(rawMsg, key)
		case "statusDescription":
			err = unpopulate(val, "StatusDescription", &a.StatusDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemHsmSettings.
func (a AmlFilesystemHsmSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "container", a.Container)
	populate(objectMap, "importPrefix", a.ImportPrefix)
	populate(objectMap, "loggingContainer", a.LoggingContainer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemHsmSettings.
func (a *AmlFilesystemHsmSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "container":
			err = unpopulate(val, "Container", &a.Container)
			delete(rawMsg, key)
		case "importPrefix":
			err = unpopulate(val, "ImportPrefix", &a.ImportPrefix)
			delete(rawMsg, key)
		case "loggingContainer":
			err = unpopulate(val, "LoggingContainer", &a.LoggingContainer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemIdentity.
func (a AmlFilesystemIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", a.PrincipalID)
	populate(objectMap, "tenantId", a.TenantID)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "userAssignedIdentities", a.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemIdentity.
func (a *AmlFilesystemIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &a.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &a.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemProperties.
func (a AmlFilesystemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientInfo", a.ClientInfo)
	populate(objectMap, "encryptionSettings", a.EncryptionSettings)
	populate(objectMap, "filesystemSubnet", a.FilesystemSubnet)
	populate(objectMap, "health", a.Health)
	populate(objectMap, "hsm", a.Hsm)
	populate(objectMap, "maintenanceWindow", a.MaintenanceWindow)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "rootSquashSettings", a.RootSquashSettings)
	populate(objectMap, "storageCapacityTiB", a.StorageCapacityTiB)
	populate(objectMap, "throughputProvisionedMBps", a.ThroughputProvisionedMBps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemProperties.
func (a *AmlFilesystemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientInfo":
			err = unpopulate(val, "ClientInfo", &a.ClientInfo)
			delete(rawMsg, key)
		case "encryptionSettings":
			err = unpopulate(val, "EncryptionSettings", &a.EncryptionSettings)
			delete(rawMsg, key)
		case "filesystemSubnet":
			err = unpopulate(val, "FilesystemSubnet", &a.FilesystemSubnet)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &a.Health)
			delete(rawMsg, key)
		case "hsm":
			err = unpopulate(val, "Hsm", &a.Hsm)
			delete(rawMsg, key)
		case "maintenanceWindow":
			err = unpopulate(val, "MaintenanceWindow", &a.MaintenanceWindow)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "rootSquashSettings":
			err = unpopulate(val, "RootSquashSettings", &a.RootSquashSettings)
			delete(rawMsg, key)
		case "storageCapacityTiB":
			err = unpopulate(val, "StorageCapacityTiB", &a.StorageCapacityTiB)
			delete(rawMsg, key)
		case "throughputProvisionedMBps":
			err = unpopulate(val, "ThroughputProvisionedMBps", &a.ThroughputProvisionedMBps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemPropertiesHsm.
func (a AmlFilesystemPropertiesHsm) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "archiveStatus", a.ArchiveStatus)
	populate(objectMap, "settings", a.Settings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemPropertiesHsm.
func (a *AmlFilesystemPropertiesHsm) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "archiveStatus":
			err = unpopulate(val, "ArchiveStatus", &a.ArchiveStatus)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &a.Settings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemPropertiesMaintenanceWindow.
func (a AmlFilesystemPropertiesMaintenanceWindow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dayOfWeek", a.DayOfWeek)
	populate(objectMap, "timeOfDayUTC", a.TimeOfDayUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemPropertiesMaintenanceWindow.
func (a *AmlFilesystemPropertiesMaintenanceWindow) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dayOfWeek":
			err = unpopulate(val, "DayOfWeek", &a.DayOfWeek)
			delete(rawMsg, key)
		case "timeOfDayUTC":
			err = unpopulate(val, "TimeOfDayUTC", &a.TimeOfDayUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemRootSquashSettings.
func (a AmlFilesystemRootSquashSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mode", a.Mode)
	populate(objectMap, "noSquashNidLists", a.NoSquashNidLists)
	populate(objectMap, "squashGID", a.SquashGID)
	populate(objectMap, "squashUID", a.SquashUID)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemRootSquashSettings.
func (a *AmlFilesystemRootSquashSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &a.Mode)
			delete(rawMsg, key)
		case "noSquashNidLists":
			err = unpopulate(val, "NoSquashNidLists", &a.NoSquashNidLists)
			delete(rawMsg, key)
		case "squashGID":
			err = unpopulate(val, "SquashGID", &a.SquashGID)
			delete(rawMsg, key)
		case "squashUID":
			err = unpopulate(val, "SquashUID", &a.SquashUID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemSubnetInfo.
func (a AmlFilesystemSubnetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filesystemSubnet", a.FilesystemSubnet)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "storageCapacityTiB", a.StorageCapacityTiB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemSubnetInfo.
func (a *AmlFilesystemSubnetInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filesystemSubnet":
			err = unpopulate(val, "FilesystemSubnet", &a.FilesystemSubnet)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "storageCapacityTiB":
			err = unpopulate(val, "StorageCapacityTiB", &a.StorageCapacityTiB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemUpdate.
func (a AmlFilesystemUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemUpdate.
func (a *AmlFilesystemUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemUpdateProperties.
func (a AmlFilesystemUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionSettings", a.EncryptionSettings)
	populate(objectMap, "maintenanceWindow", a.MaintenanceWindow)
	populate(objectMap, "rootSquashSettings", a.RootSquashSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemUpdateProperties.
func (a *AmlFilesystemUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionSettings":
			err = unpopulate(val, "EncryptionSettings", &a.EncryptionSettings)
			delete(rawMsg, key)
		case "maintenanceWindow":
			err = unpopulate(val, "MaintenanceWindow", &a.MaintenanceWindow)
			delete(rawMsg, key)
		case "rootSquashSettings":
			err = unpopulate(val, "RootSquashSettings", &a.RootSquashSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemUpdatePropertiesMaintenanceWindow.
func (a AmlFilesystemUpdatePropertiesMaintenanceWindow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dayOfWeek", a.DayOfWeek)
	populate(objectMap, "timeOfDayUTC", a.TimeOfDayUTC)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemUpdatePropertiesMaintenanceWindow.
func (a *AmlFilesystemUpdatePropertiesMaintenanceWindow) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dayOfWeek":
			err = unpopulate(val, "DayOfWeek", &a.DayOfWeek)
			delete(rawMsg, key)
		case "timeOfDayUTC":
			err = unpopulate(val, "TimeOfDayUTC", &a.TimeOfDayUTC)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlFilesystemsListResult.
func (a AmlFilesystemsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlFilesystemsListResult.
func (a *AmlFilesystemsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AscOperation.
func (a AscOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endTime", a.EndTime)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "startTime", a.StartTime)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AscOperation.
func (a *AscOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AscOperationProperties.
func (a AscOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "output", a.Output)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AscOperationProperties.
func (a *AscOperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "output":
			err = unpopulate(val, "Output", &a.Output)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobNfsTarget.
func (b BlobNfsTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "target", b.Target)
	populate(objectMap, "usageModel", b.UsageModel)
	populate(objectMap, "verificationTimer", b.VerificationTimer)
	populate(objectMap, "writeBackTimer", b.WriteBackTimer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobNfsTarget.
func (b *BlobNfsTarget) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "target":
			err = unpopulate(val, "Target", &b.Target)
			delete(rawMsg, key)
		case "usageModel":
			err = unpopulate(val, "UsageModel", &b.UsageModel)
			delete(rawMsg, key)
		case "verificationTimer":
			err = unpopulate(val, "VerificationTimer", &b.VerificationTimer)
			delete(rawMsg, key)
		case "writeBackTimer":
			err = unpopulate(val, "WriteBackTimer", &b.WriteBackTimer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Cache.
func (c Cache) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Cache.
func (c *Cache) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &c.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &c.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheActiveDirectorySettings.
func (c CacheActiveDirectorySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cacheNetBiosName", c.CacheNetBiosName)
	populate(objectMap, "credentials", c.Credentials)
	populate(objectMap, "domainJoined", c.DomainJoined)
	populate(objectMap, "domainName", c.DomainName)
	populate(objectMap, "domainNetBiosName", c.DomainNetBiosName)
	populate(objectMap, "primaryDnsIpAddress", c.PrimaryDNSIPAddress)
	populate(objectMap, "secondaryDnsIpAddress", c.SecondaryDNSIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheActiveDirectorySettings.
func (c *CacheActiveDirectorySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cacheNetBiosName":
			err = unpopulate(val, "CacheNetBiosName", &c.CacheNetBiosName)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &c.Credentials)
			delete(rawMsg, key)
		case "domainJoined":
			err = unpopulate(val, "DomainJoined", &c.DomainJoined)
			delete(rawMsg, key)
		case "domainName":
			err = unpopulate(val, "DomainName", &c.DomainName)
			delete(rawMsg, key)
		case "domainNetBiosName":
			err = unpopulate(val, "DomainNetBiosName", &c.DomainNetBiosName)
			delete(rawMsg, key)
		case "primaryDnsIpAddress":
			err = unpopulate(val, "PrimaryDNSIPAddress", &c.PrimaryDNSIPAddress)
			delete(rawMsg, key)
		case "secondaryDnsIpAddress":
			err = unpopulate(val, "SecondaryDNSIPAddress", &c.SecondaryDNSIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheActiveDirectorySettingsCredentials.
func (c CacheActiveDirectorySettingsCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", c.Password)
	populate(objectMap, "username", c.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheActiveDirectorySettingsCredentials.
func (c *CacheActiveDirectorySettingsCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &c.Password)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &c.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheDirectorySettings.
func (c CacheDirectorySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeDirectory", c.ActiveDirectory)
	populate(objectMap, "usernameDownload", c.UsernameDownload)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheDirectorySettings.
func (c *CacheDirectorySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeDirectory":
			err = unpopulate(val, "ActiveDirectory", &c.ActiveDirectory)
			delete(rawMsg, key)
		case "usernameDownload":
			err = unpopulate(val, "UsernameDownload", &c.UsernameDownload)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheEncryptionSettings.
func (c CacheEncryptionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyEncryptionKey", c.KeyEncryptionKey)
	populate(objectMap, "rotationToLatestKeyVersionEnabled", c.RotationToLatestKeyVersionEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheEncryptionSettings.
func (c *CacheEncryptionSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyEncryptionKey":
			err = unpopulate(val, "KeyEncryptionKey", &c.KeyEncryptionKey)
			delete(rawMsg, key)
		case "rotationToLatestKeyVersionEnabled":
			err = unpopulate(val, "RotationToLatestKeyVersionEnabled", &c.RotationToLatestKeyVersionEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheHealth.
func (c CacheHealth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "conditions", c.Conditions)
	populate(objectMap, "state", c.State)
	populate(objectMap, "statusDescription", c.StatusDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheHealth.
func (c *CacheHealth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "conditions":
			err = unpopulate(val, "Conditions", &c.Conditions)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "statusDescription":
			err = unpopulate(val, "StatusDescription", &c.StatusDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheIdentity.
func (c CacheIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", c.PrincipalID)
	populate(objectMap, "tenantId", c.TenantID)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "userAssignedIdentities", c.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheIdentity.
func (c *CacheIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &c.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &c.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &c.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheNetworkSettings.
func (c CacheNetworkSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSearchDomain", c.DNSSearchDomain)
	populate(objectMap, "dnsServers", c.DNSServers)
	populate(objectMap, "mtu", c.Mtu)
	populate(objectMap, "ntpServer", c.NtpServer)
	populate(objectMap, "utilityAddresses", c.UtilityAddresses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheNetworkSettings.
func (c *CacheNetworkSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSearchDomain":
			err = unpopulate(val, "DNSSearchDomain", &c.DNSSearchDomain)
			delete(rawMsg, key)
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &c.DNSServers)
			delete(rawMsg, key)
		case "mtu":
			err = unpopulate(val, "Mtu", &c.Mtu)
			delete(rawMsg, key)
		case "ntpServer":
			err = unpopulate(val, "NtpServer", &c.NtpServer)
			delete(rawMsg, key)
		case "utilityAddresses":
			err = unpopulate(val, "UtilityAddresses", &c.UtilityAddresses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheProperties.
func (c CacheProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cacheSizeGB", c.CacheSizeGB)
	populate(objectMap, "directoryServicesSettings", c.DirectoryServicesSettings)
	populate(objectMap, "encryptionSettings", c.EncryptionSettings)
	populate(objectMap, "health", c.Health)
	populate(objectMap, "mountAddresses", c.MountAddresses)
	populate(objectMap, "networkSettings", c.NetworkSettings)
	populate(objectMap, "primingJobs", c.PrimingJobs)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "securitySettings", c.SecuritySettings)
	populate(objectMap, "spaceAllocation", c.SpaceAllocation)
	populate(objectMap, "subnet", c.Subnet)
	populate(objectMap, "upgradeSettings", c.UpgradeSettings)
	populate(objectMap, "upgradeStatus", c.UpgradeStatus)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheProperties.
func (c *CacheProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cacheSizeGB":
			err = unpopulate(val, "CacheSizeGB", &c.CacheSizeGB)
			delete(rawMsg, key)
		case "directoryServicesSettings":
			err = unpopulate(val, "DirectoryServicesSettings", &c.DirectoryServicesSettings)
			delete(rawMsg, key)
		case "encryptionSettings":
			err = unpopulate(val, "EncryptionSettings", &c.EncryptionSettings)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &c.Health)
			delete(rawMsg, key)
		case "mountAddresses":
			err = unpopulate(val, "MountAddresses", &c.MountAddresses)
			delete(rawMsg, key)
		case "networkSettings":
			err = unpopulate(val, "NetworkSettings", &c.NetworkSettings)
			delete(rawMsg, key)
		case "primingJobs":
			err = unpopulate(val, "PrimingJobs", &c.PrimingJobs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "securitySettings":
			err = unpopulate(val, "SecuritySettings", &c.SecuritySettings)
			delete(rawMsg, key)
		case "spaceAllocation":
			err = unpopulate(val, "SpaceAllocation", &c.SpaceAllocation)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &c.Subnet)
			delete(rawMsg, key)
		case "upgradeSettings":
			err = unpopulate(val, "UpgradeSettings", &c.UpgradeSettings)
			delete(rawMsg, key)
		case "upgradeStatus":
			err = unpopulate(val, "UpgradeStatus", &c.UpgradeStatus)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &c.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheSKU.
func (c CacheSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheSKU.
func (c *CacheSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheSecuritySettings.
func (c CacheSecuritySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessPolicies", c.AccessPolicies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheSecuritySettings.
func (c *CacheSecuritySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessPolicies":
			err = unpopulate(val, "AccessPolicies", &c.AccessPolicies)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheUpgradeSettings.
func (c CacheUpgradeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "scheduledTime", c.ScheduledTime)
	populate(objectMap, "upgradeScheduleEnabled", c.UpgradeScheduleEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheUpgradeSettings.
func (c *CacheUpgradeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scheduledTime":
			err = unpopulateDateTimeRFC3339(val, "ScheduledTime", &c.ScheduledTime)
			delete(rawMsg, key)
		case "upgradeScheduleEnabled":
			err = unpopulate(val, "UpgradeScheduleEnabled", &c.UpgradeScheduleEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheUpgradeStatus.
func (c CacheUpgradeStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentFirmwareVersion", c.CurrentFirmwareVersion)
	populateDateTimeRFC3339(objectMap, "firmwareUpdateDeadline", c.FirmwareUpdateDeadline)
	populate(objectMap, "firmwareUpdateStatus", c.FirmwareUpdateStatus)
	populateDateTimeRFC3339(objectMap, "lastFirmwareUpdate", c.LastFirmwareUpdate)
	populate(objectMap, "pendingFirmwareVersion", c.PendingFirmwareVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheUpgradeStatus.
func (c *CacheUpgradeStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentFirmwareVersion":
			err = unpopulate(val, "CurrentFirmwareVersion", &c.CurrentFirmwareVersion)
			delete(rawMsg, key)
		case "firmwareUpdateDeadline":
			err = unpopulateDateTimeRFC3339(val, "FirmwareUpdateDeadline", &c.FirmwareUpdateDeadline)
			delete(rawMsg, key)
		case "firmwareUpdateStatus":
			err = unpopulate(val, "FirmwareUpdateStatus", &c.FirmwareUpdateStatus)
			delete(rawMsg, key)
		case "lastFirmwareUpdate":
			err = unpopulateDateTimeRFC3339(val, "LastFirmwareUpdate", &c.LastFirmwareUpdate)
			delete(rawMsg, key)
		case "pendingFirmwareVersion":
			err = unpopulate(val, "PendingFirmwareVersion", &c.PendingFirmwareVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheUsernameDownloadSettings.
func (c CacheUsernameDownloadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoDownloadCertificate", c.AutoDownloadCertificate)
	populate(objectMap, "caCertificateURI", c.CaCertificateURI)
	populate(objectMap, "credentials", c.Credentials)
	populate(objectMap, "encryptLdapConnection", c.EncryptLdapConnection)
	populate(objectMap, "extendedGroups", c.ExtendedGroups)
	populate(objectMap, "groupFileURI", c.GroupFileURI)
	populate(objectMap, "ldapBaseDN", c.LdapBaseDN)
	populate(objectMap, "ldapServer", c.LdapServer)
	populate(objectMap, "requireValidCertificate", c.RequireValidCertificate)
	populate(objectMap, "userFileURI", c.UserFileURI)
	populate(objectMap, "usernameDownloaded", c.UsernameDownloaded)
	populate(objectMap, "usernameSource", c.UsernameSource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheUsernameDownloadSettings.
func (c *CacheUsernameDownloadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoDownloadCertificate":
			err = unpopulate(val, "AutoDownloadCertificate", &c.AutoDownloadCertificate)
			delete(rawMsg, key)
		case "caCertificateURI":
			err = unpopulate(val, "CaCertificateURI", &c.CaCertificateURI)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &c.Credentials)
			delete(rawMsg, key)
		case "encryptLdapConnection":
			err = unpopulate(val, "EncryptLdapConnection", &c.EncryptLdapConnection)
			delete(rawMsg, key)
		case "extendedGroups":
			err = unpopulate(val, "ExtendedGroups", &c.ExtendedGroups)
			delete(rawMsg, key)
		case "groupFileURI":
			err = unpopulate(val, "GroupFileURI", &c.GroupFileURI)
			delete(rawMsg, key)
		case "ldapBaseDN":
			err = unpopulate(val, "LdapBaseDN", &c.LdapBaseDN)
			delete(rawMsg, key)
		case "ldapServer":
			err = unpopulate(val, "LdapServer", &c.LdapServer)
			delete(rawMsg, key)
		case "requireValidCertificate":
			err = unpopulate(val, "RequireValidCertificate", &c.RequireValidCertificate)
			delete(rawMsg, key)
		case "userFileURI":
			err = unpopulate(val, "UserFileURI", &c.UserFileURI)
			delete(rawMsg, key)
		case "usernameDownloaded":
			err = unpopulate(val, "UsernameDownloaded", &c.UsernameDownloaded)
			delete(rawMsg, key)
		case "usernameSource":
			err = unpopulate(val, "UsernameSource", &c.UsernameSource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CacheUsernameDownloadSettingsCredentials.
func (c CacheUsernameDownloadSettingsCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bindDn", c.BindDn)
	populate(objectMap, "bindPassword", c.BindPassword)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CacheUsernameDownloadSettingsCredentials.
func (c *CacheUsernameDownloadSettingsCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bindDn":
			err = unpopulate(val, "BindDn", &c.BindDn)
			delete(rawMsg, key)
		case "bindPassword":
			err = unpopulate(val, "BindPassword", &c.BindPassword)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CachesListResult.
func (c CachesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CachesListResult.
func (c *CachesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClfsTarget.
func (c ClfsTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClfsTarget.
func (c *ClfsTarget) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudErrorBody.
func (c CloudErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", c.Code)
	populate(objectMap, "details", c.Details)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudErrorBody.
func (c *CloudErrorBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &c.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &c.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Condition.
func (c Condition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populateDateTimeRFC3339(objectMap, "timestamp", c.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Condition.
func (c *Condition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &c.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKeyReference.
func (k KeyVaultKeyReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyUrl", k.KeyURL)
	populate(objectMap, "sourceVault", k.SourceVault)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKeyReference.
func (k *KeyVaultKeyReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyUrl":
			err = unpopulate(val, "KeyURL", &k.KeyURL)
			delete(rawMsg, key)
		case "sourceVault":
			err = unpopulate(val, "SourceVault", &k.SourceVault)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKeyReferenceSourceVault.
func (k KeyVaultKeyReferenceSourceVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", k.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKeyReferenceSourceVault.
func (k *KeyVaultKeyReferenceSourceVault) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSpecification.
func (l LogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSpecification.
func (l *LogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricDimension.
func (m MetricDimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "internalName", m.InternalName)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "toBeExportedForShoebox", m.ToBeExportedForShoebox)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricDimension.
func (m *MetricDimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "internalName":
			err = unpopulate(val, "InternalName", &m.InternalName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "toBeExportedForShoebox":
			err = unpopulate(val, "ToBeExportedForShoebox", &m.ToBeExportedForShoebox)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricSpecification.
func (m MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "metricClass", m.MetricClass)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "supportedAggregationTypes", m.SupportedAggregationTypes)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricSpecification.
func (m *MetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &m.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "metricClass":
			err = unpopulate(val, "MetricClass", &m.MetricClass)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "supportedAggregationTypes":
			err = unpopulate(val, "SupportedAggregationTypes", &m.SupportedAggregationTypes)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamespaceJunction.
func (n NamespaceJunction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "namespacePath", n.NamespacePath)
	populate(objectMap, "nfsAccessPolicy", n.NfsAccessPolicy)
	populate(objectMap, "nfsExport", n.NfsExport)
	populate(objectMap, "targetPath", n.TargetPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamespaceJunction.
func (n *NamespaceJunction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "namespacePath":
			err = unpopulate(val, "NamespacePath", &n.NamespacePath)
			delete(rawMsg, key)
		case "nfsAccessPolicy":
			err = unpopulate(val, "NfsAccessPolicy", &n.NfsAccessPolicy)
			delete(rawMsg, key)
		case "nfsExport":
			err = unpopulate(val, "NfsExport", &n.NfsExport)
			delete(rawMsg, key)
		case "targetPath":
			err = unpopulate(val, "TargetPath", &n.TargetPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Nfs3Target.
func (n Nfs3Target) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "target", n.Target)
	populate(objectMap, "usageModel", n.UsageModel)
	populate(objectMap, "verificationTimer", n.VerificationTimer)
	populate(objectMap, "writeBackTimer", n.WriteBackTimer)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Nfs3Target.
func (n *Nfs3Target) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "target":
			err = unpopulate(val, "Target", &n.Target)
			delete(rawMsg, key)
		case "usageModel":
			err = unpopulate(val, "UsageModel", &n.UsageModel)
			delete(rawMsg, key)
		case "verificationTimer":
			err = unpopulate(val, "VerificationTimer", &n.VerificationTimer)
			delete(rawMsg, key)
		case "writeBackTimer":
			err = unpopulate(val, "WriteBackTimer", &n.WriteBackTimer)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NfsAccessPolicy.
func (n NfsAccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessRules", n.AccessRules)
	populate(objectMap, "name", n.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NfsAccessPolicy.
func (n *NfsAccessPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessRules":
			err = unpopulate(val, "AccessRules", &n.AccessRules)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NfsAccessRule.
func (n NfsAccessRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access", n.Access)
	populate(objectMap, "anonymousGID", n.AnonymousGID)
	populate(objectMap, "anonymousUID", n.AnonymousUID)
	populate(objectMap, "filter", n.Filter)
	populate(objectMap, "rootSquash", n.RootSquash)
	populate(objectMap, "scope", n.Scope)
	populate(objectMap, "submountAccess", n.SubmountAccess)
	populate(objectMap, "suid", n.Suid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NfsAccessRule.
func (n *NfsAccessRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access":
			err = unpopulate(val, "Access", &n.Access)
			delete(rawMsg, key)
		case "anonymousGID":
			err = unpopulate(val, "AnonymousGID", &n.AnonymousGID)
			delete(rawMsg, key)
		case "anonymousUID":
			err = unpopulate(val, "AnonymousUID", &n.AnonymousUID)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &n.Filter)
			delete(rawMsg, key)
		case "rootSquash":
			err = unpopulate(val, "RootSquash", &n.RootSquash)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &n.Scope)
			delete(rawMsg, key)
		case "submountAccess":
			err = unpopulate(val, "SubmountAccess", &n.SubmountAccess)
			delete(rawMsg, key)
		case "suid":
			err = unpopulate(val, "Suid", &n.Suid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrimingJob.
func (p PrimingJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primingJobDetails", p.PrimingJobDetails)
	populate(objectMap, "primingJobId", p.PrimingJobID)
	populate(objectMap, "primingJobName", p.PrimingJobName)
	populate(objectMap, "primingJobPercentComplete", p.PrimingJobPercentComplete)
	populate(objectMap, "primingJobState", p.PrimingJobState)
	populate(objectMap, "primingJobStatus", p.PrimingJobStatus)
	populate(objectMap, "primingManifestUrl", p.PrimingManifestURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrimingJob.
func (p *PrimingJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primingJobDetails":
			err = unpopulate(val, "PrimingJobDetails", &p.PrimingJobDetails)
			delete(rawMsg, key)
		case "primingJobId":
			err = unpopulate(val, "PrimingJobID", &p.PrimingJobID)
			delete(rawMsg, key)
		case "primingJobName":
			err = unpopulate(val, "PrimingJobName", &p.PrimingJobName)
			delete(rawMsg, key)
		case "primingJobPercentComplete":
			err = unpopulate(val, "PrimingJobPercentComplete", &p.PrimingJobPercentComplete)
			delete(rawMsg, key)
		case "primingJobState":
			err = unpopulate(val, "PrimingJobState", &p.PrimingJobState)
			delete(rawMsg, key)
		case "primingJobStatus":
			err = unpopulate(val, "PrimingJobStatus", &p.PrimingJobStatus)
			delete(rawMsg, key)
		case "primingManifestUrl":
			err = unpopulate(val, "PrimingManifestURL", &p.PrimingManifestURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrimingJobIDParameter.
func (p PrimingJobIDParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primingJobId", p.PrimingJobID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrimingJobIDParameter.
func (p *PrimingJobIDParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primingJobId":
			err = unpopulate(val, "PrimingJobID", &p.PrimingJobID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequiredAmlFilesystemSubnetsSize.
func (r RequiredAmlFilesystemSubnetsSize) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filesystemSubnetSize", r.FilesystemSubnetSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequiredAmlFilesystemSubnetsSize.
func (r *RequiredAmlFilesystemSubnetsSize) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filesystemSubnetSize":
			err = unpopulate(val, "FilesystemSubnetSize", &r.FilesystemSubnetSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequiredAmlFilesystemSubnetsSizeInfo.
func (r RequiredAmlFilesystemSubnetsSizeInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "storageCapacityTiB", r.StorageCapacityTiB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequiredAmlFilesystemSubnetsSizeInfo.
func (r *RequiredAmlFilesystemSubnetsSizeInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		case "storageCapacityTiB":
			err = unpopulate(val, "StorageCapacityTiB", &r.StorageCapacityTiB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKU.
func (r ResourceSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", r.Capabilities)
	populate(objectMap, "locationInfo", r.LocationInfo)
	populate(objectMap, "locations", r.Locations)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "resourceType", r.ResourceType)
	populate(objectMap, "restrictions", r.Restrictions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKU.
func (r *ResourceSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &r.Capabilities)
			delete(rawMsg, key)
		case "locationInfo":
			err = unpopulate(val, "LocationInfo", &r.LocationInfo)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &r.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		case "restrictions":
			err = unpopulate(val, "Restrictions", &r.Restrictions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKUCapabilities.
func (r ResourceSKUCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKUCapabilities.
func (r *ResourceSKUCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKULocationInfo.
func (r ResourceSKULocationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "zones", r.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKULocationInfo.
func (r *ResourceSKULocationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &r.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceSKUsResult.
func (r ResourceSKUsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceSKUsResult.
func (r *ResourceSKUsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceUsage.
func (r ResourceUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", r.CurrentValue)
	populate(objectMap, "limit", r.Limit)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "unit", r.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceUsage.
func (r *ResourceUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &r.CurrentValue)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &r.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &r.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceUsageName.
func (r ResourceUsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", r.LocalizedValue)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceUsageName.
func (r *ResourceUsageName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &r.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceUsagesListResult.
func (r ResourceUsagesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceUsagesListResult.
func (r *ResourceUsagesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Restriction.
func (r Restriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reasonCode", r.ReasonCode)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "values", r.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Restriction.
func (r *Restriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reasonCode":
			err = unpopulate(val, "ReasonCode", &r.ReasonCode)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &r.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUName.
func (s SKUName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUName.
func (s *SKUName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageTarget.
func (s StorageTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageTarget.
func (s *StorageTarget) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageTargetProperties.
func (s StorageTargetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocationPercentage", s.AllocationPercentage)
	populate(objectMap, "blobNfs", s.BlobNfs)
	populate(objectMap, "clfs", s.Clfs)
	populate(objectMap, "junctions", s.Junctions)
	populate(objectMap, "nfs3", s.Nfs3)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "state", s.State)
	populate(objectMap, "targetType", s.TargetType)
	populate(objectMap, "unknown", s.Unknown)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageTargetProperties.
func (s *StorageTargetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocationPercentage":
			err = unpopulate(val, "AllocationPercentage", &s.AllocationPercentage)
			delete(rawMsg, key)
		case "blobNfs":
			err = unpopulate(val, "BlobNfs", &s.BlobNfs)
			delete(rawMsg, key)
		case "clfs":
			err = unpopulate(val, "Clfs", &s.Clfs)
			delete(rawMsg, key)
		case "junctions":
			err = unpopulate(val, "Junctions", &s.Junctions)
			delete(rawMsg, key)
		case "nfs3":
			err = unpopulate(val, "Nfs3", &s.Nfs3)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "targetType":
			err = unpopulate(val, "TargetType", &s.TargetType)
			delete(rawMsg, key)
		case "unknown":
			err = unpopulate(val, "Unknown", &s.Unknown)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageTargetResource.
func (s StorageTargetResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageTargetResource.
func (s *StorageTargetResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageTargetSpaceAllocation.
func (s StorageTargetSpaceAllocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocationPercentage", s.AllocationPercentage)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageTargetSpaceAllocation.
func (s *StorageTargetSpaceAllocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocationPercentage":
			err = unpopulate(val, "AllocationPercentage", &s.AllocationPercentage)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageTargetsResult.
func (s StorageTargetsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageTargetsResult.
func (s *StorageTargetsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnknownTarget.
func (u UnknownTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", u.Attributes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnknownTarget.
func (u *UnknownTarget) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &u.Attributes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageModel.
func (u UsageModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", u.Display)
	populate(objectMap, "modelName", u.ModelName)
	populate(objectMap, "targetType", u.TargetType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageModel.
func (u *UsageModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &u.Display)
			delete(rawMsg, key)
		case "modelName":
			err = unpopulate(val, "ModelName", &u.ModelName)
			delete(rawMsg, key)
		case "targetType":
			err = unpopulate(val, "TargetType", &u.TargetType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageModelDisplay.
func (u UsageModelDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", u.Description)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageModelDisplay.
func (u *UsageModelDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &u.Description)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageModelsResult.
func (u UsageModelsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageModelsResult.
func (u *UsageModelsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentitiesValue.
func (u UserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentitiesValue.
func (u *UserAssignedIdentitiesValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
