//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// VulnerabilityAssessmentScansClient contains the methods for the SQLVulnerabilityAssessmentScans group.
// Don't use this type directly, use NewVulnerabilityAssessmentScansClient() instead.
type VulnerabilityAssessmentScansClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewVulnerabilityAssessmentScansClient creates a new instance of VulnerabilityAssessmentScansClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVulnerabilityAssessmentScansClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VulnerabilityAssessmentScansClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VulnerabilityAssessmentScansClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Get a system database vulnerability assessment scan record.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - VulnerabilityAssessmentScansClientGetOptions contains the optional parameters for the VulnerabilityAssessmentScansClient.Get
//     method.
func (client *VulnerabilityAssessmentScansClient) Get(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *VulnerabilityAssessmentScansClientGetOptions) (VulnerabilityAssessmentScansClientGetResponse, error) {
	var err error
	const operationName = "VulnerabilityAssessmentScansClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, scanID, options)
	if err != nil {
		return VulnerabilityAssessmentScansClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VulnerabilityAssessmentScansClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VulnerabilityAssessmentScansClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *VulnerabilityAssessmentScansClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *VulnerabilityAssessmentScansClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("systemDatabaseName", "master")
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VulnerabilityAssessmentScansClient) getHandleResponse(resp *http.Response) (VulnerabilityAssessmentScansClientGetResponse, error) {
	result := VulnerabilityAssessmentScansClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanRecordForSQL); err != nil {
		return VulnerabilityAssessmentScansClientGetResponse{}, err
	}
	return result, nil
}

// NewListBySQLVulnerabilityAssessmentsPager - Lists the vulnerability assessment scans of a database.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsOptions contains the optional parameters for
//     the VulnerabilityAssessmentScansClient.NewListBySQLVulnerabilityAssessmentsPager method.
func (client *VulnerabilityAssessmentScansClient) NewListBySQLVulnerabilityAssessmentsPager(resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsOptions) *runtime.Pager[VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse] {
	return runtime.NewPager(runtime.PagingHandler[VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse]{
		More: func(page VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse) (VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VulnerabilityAssessmentScansClient.NewListBySQLVulnerabilityAssessmentsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySQLVulnerabilityAssessmentsCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, options)
			}, nil)
			if err != nil {
				return VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse{}, err
			}
			return client.listBySQLVulnerabilityAssessmentsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySQLVulnerabilityAssessmentsCreateRequest creates the ListBySQLVulnerabilityAssessments request.
func (client *VulnerabilityAssessmentScansClient) listBySQLVulnerabilityAssessmentsCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("systemDatabaseName", "master")
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySQLVulnerabilityAssessmentsHandleResponse handles the ListBySQLVulnerabilityAssessments response.
func (client *VulnerabilityAssessmentScansClient) listBySQLVulnerabilityAssessmentsHandleResponse(resp *http.Response) (VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse, error) {
	result := VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanRecordForSQLListResult); err != nil {
		return VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse{}, err
	}
	return result, nil
}
