//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// VulnerabilityAssessmentRuleBaselineClient contains the methods for the SQLVulnerabilityAssessmentRuleBaseline group.
// Don't use this type directly, use NewVulnerabilityAssessmentRuleBaselineClient() instead.
type VulnerabilityAssessmentRuleBaselineClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewVulnerabilityAssessmentRuleBaselineClient creates a new instance of VulnerabilityAssessmentRuleBaselineClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVulnerabilityAssessmentRuleBaselineClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VulnerabilityAssessmentRuleBaselineClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VulnerabilityAssessmentRuleBaselineClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates a database's vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - ruleID - The vulnerability assessment rule ID.
//   - parameters - The requested rule baseline resource.
//   - options - VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateOptions contains the optional parameters for the VulnerabilityAssessmentRuleBaselineClient.CreateOrUpdate
//     method.
func (client *VulnerabilityAssessmentRuleBaselineClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, ruleID string, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineInput, options *VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateOptions) (VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "VulnerabilityAssessmentRuleBaselineClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleID, parameters, options)
	if err != nil {
		return VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *VulnerabilityAssessmentRuleBaselineClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, ruleID string, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineInput, options *VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("systemDatabaseName", "master")
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *VulnerabilityAssessmentRuleBaselineClient) createOrUpdateHandleResponse(resp *http.Response) (VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateResponse, error) {
	result := VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseSQLVulnerabilityAssessmentRuleBaseline); err != nil {
		return VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Get - Gets a system database's sql vulnerability assessment rule baseline.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - ruleID - The vulnerability assessment rule ID.
//   - options - VulnerabilityAssessmentRuleBaselineClientGetOptions contains the optional parameters for the VulnerabilityAssessmentRuleBaselineClient.Get
//     method.
func (client *VulnerabilityAssessmentRuleBaselineClient) Get(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, ruleID string, options *VulnerabilityAssessmentRuleBaselineClientGetOptions) (VulnerabilityAssessmentRuleBaselineClientGetResponse, error) {
	var err error
	const operationName = "VulnerabilityAssessmentRuleBaselineClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, ruleID, options)
	if err != nil {
		return VulnerabilityAssessmentRuleBaselineClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VulnerabilityAssessmentRuleBaselineClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VulnerabilityAssessmentRuleBaselineClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *VulnerabilityAssessmentRuleBaselineClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, ruleID string, options *VulnerabilityAssessmentRuleBaselineClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if ruleID == "" {
		return nil, errors.New("parameter ruleID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleId}", url.PathEscape(ruleID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("systemDatabaseName", "master")
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VulnerabilityAssessmentRuleBaselineClient) getHandleResponse(resp *http.Response) (VulnerabilityAssessmentRuleBaselineClientGetResponse, error) {
	result := VulnerabilityAssessmentRuleBaselineClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseSQLVulnerabilityAssessmentRuleBaseline); err != nil {
		return VulnerabilityAssessmentRuleBaselineClientGetResponse{}, err
	}
	return result, nil
}

// NewListByBaselinePager - Gets a system database's sql vulnerability assessment rule baseline.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - VulnerabilityAssessmentRuleBaselineClientListByBaselineOptions contains the optional parameters for the VulnerabilityAssessmentRuleBaselineClient.NewListByBaselinePager
//     method.
func (client *VulnerabilityAssessmentRuleBaselineClient) NewListByBaselinePager(resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, options *VulnerabilityAssessmentRuleBaselineClientListByBaselineOptions) *runtime.Pager[VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse] {
	return runtime.NewPager(runtime.PagingHandler[VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse]{
		More: func(page VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse) (VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VulnerabilityAssessmentRuleBaselineClient.NewListByBaselinePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByBaselineCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, options)
			}, nil)
			if err != nil {
				return VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse{}, err
			}
			return client.listByBaselineHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByBaselineCreateRequest creates the ListByBaseline request.
func (client *VulnerabilityAssessmentRuleBaselineClient) listByBaselineCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, options *VulnerabilityAssessmentRuleBaselineClientListByBaselineOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("systemDatabaseName", "master")
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByBaselineHandleResponse handles the ListByBaseline response.
func (client *VulnerabilityAssessmentRuleBaselineClient) listByBaselineHandleResponse(resp *http.Response) (VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse, error) {
	result := VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult); err != nil {
		return VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse{}, err
	}
	return result, nil
}
