//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armspringappdiscovery

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SpringbootsitesClient contains the methods for the Springbootsites group.
// Don't use this type directly, use NewSpringbootsitesClient() instead.
type SpringbootsitesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSpringbootsitesClient creates a new instance of SpringbootsitesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSpringbootsitesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SpringbootsitesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SpringbootsitesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Create a springbootsites resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - springbootsitesName - The springbootsites name.
//   - springbootsites - Create a springbootsites payload.
//   - options - SpringbootsitesClientCreateOrUpdateOptions contains the optional parameters for the SpringbootsitesClient.CreateOrUpdate
//     method.
func (client *SpringbootsitesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, springbootsitesName string, springbootsites SpringbootsitesModel, options *SpringbootsitesClientCreateOrUpdateOptions) (SpringbootsitesClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "SpringbootsitesClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, springbootsitesName, springbootsites, options)
	if err != nil {
		return SpringbootsitesClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SpringbootsitesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return SpringbootsitesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *SpringbootsitesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, springbootsitesName string, springbootsites SpringbootsitesModel, options *SpringbootsitesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if springbootsitesName == "" {
		return nil, errors.New("parameter springbootsitesName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{springbootsitesName}", url.PathEscape(springbootsitesName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, springbootsites); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *SpringbootsitesClient) createOrUpdateHandleResponse(resp *http.Response) (SpringbootsitesClientCreateOrUpdateResponse, error) {
	result := SpringbootsitesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SpringbootsitesModel); err != nil {
		return SpringbootsitesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// BeginDelete - Delete a springbootsites resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - springbootsitesName - The springbootsites name.
//   - options - SpringbootsitesClientBeginDeleteOptions contains the optional parameters for the SpringbootsitesClient.BeginDelete
//     method.
func (client *SpringbootsitesClient) BeginDelete(ctx context.Context, resourceGroupName string, springbootsitesName string, options *SpringbootsitesClientBeginDeleteOptions) (*runtime.Poller[SpringbootsitesClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, springbootsitesName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SpringbootsitesClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SpringbootsitesClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Delete a springbootsites resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
func (client *SpringbootsitesClient) deleteOperation(ctx context.Context, resourceGroupName string, springbootsitesName string, options *SpringbootsitesClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "SpringbootsitesClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, springbootsitesName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SpringbootsitesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, springbootsitesName string, options *SpringbootsitesClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if springbootsitesName == "" {
		return nil, errors.New("parameter springbootsitesName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{springbootsitesName}", url.PathEscape(springbootsitesName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a springbootsites resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - springbootsitesName - The springbootsites name.
//   - options - SpringbootsitesClientGetOptions contains the optional parameters for the SpringbootsitesClient.Get method.
func (client *SpringbootsitesClient) Get(ctx context.Context, resourceGroupName string, springbootsitesName string, options *SpringbootsitesClientGetOptions) (SpringbootsitesClientGetResponse, error) {
	var err error
	const operationName = "SpringbootsitesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, springbootsitesName, options)
	if err != nil {
		return SpringbootsitesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SpringbootsitesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SpringbootsitesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SpringbootsitesClient) getCreateRequest(ctx context.Context, resourceGroupName string, springbootsitesName string, options *SpringbootsitesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if springbootsitesName == "" {
		return nil, errors.New("parameter springbootsitesName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{springbootsitesName}", url.PathEscape(springbootsitesName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SpringbootsitesClient) getHandleResponse(resp *http.Response) (SpringbootsitesClientGetResponse, error) {
	result := SpringbootsitesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SpringbootsitesModel); err != nil {
		return SpringbootsitesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - List springbootsites resource by resourceGroup.
//
// Generated from API version 2023-01-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - SpringbootsitesClientListByResourceGroupOptions contains the optional parameters for the SpringbootsitesClient.NewListByResourceGroupPager
//     method.
func (client *SpringbootsitesClient) NewListByResourceGroupPager(resourceGroupName string, options *SpringbootsitesClientListByResourceGroupOptions) *runtime.Pager[SpringbootsitesClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[SpringbootsitesClientListByResourceGroupResponse]{
		More: func(page SpringbootsitesClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SpringbootsitesClientListByResourceGroupResponse) (SpringbootsitesClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SpringbootsitesClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return SpringbootsitesClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *SpringbootsitesClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *SpringbootsitesClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *SpringbootsitesClient) listByResourceGroupHandleResponse(resp *http.Response) (SpringbootsitesClientListByResourceGroupResponse, error) {
	result := SpringbootsitesClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SpringbootsitesListResult); err != nil {
		return SpringbootsitesClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - List springbootsites resource by subscription
//
// Generated from API version 2023-01-01-preview
//   - options - SpringbootsitesClientListBySubscriptionOptions contains the optional parameters for the SpringbootsitesClient.NewListBySubscriptionPager
//     method.
func (client *SpringbootsitesClient) NewListBySubscriptionPager(options *SpringbootsitesClientListBySubscriptionOptions) *runtime.Pager[SpringbootsitesClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[SpringbootsitesClientListBySubscriptionResponse]{
		More: func(page SpringbootsitesClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SpringbootsitesClientListBySubscriptionResponse) (SpringbootsitesClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SpringbootsitesClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return SpringbootsitesClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *SpringbootsitesClient) listBySubscriptionCreateRequest(ctx context.Context, options *SpringbootsitesClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *SpringbootsitesClient) listBySubscriptionHandleResponse(resp *http.Response) (SpringbootsitesClientListBySubscriptionResponse, error) {
	result := SpringbootsitesClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SpringbootsitesListResult); err != nil {
		return SpringbootsitesClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// BeginTriggerRefreshSite - Trigger refresh springbootsites action
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - springbootsitesName - The springbootsites name.
//   - options - SpringbootsitesClientBeginTriggerRefreshSiteOptions contains the optional parameters for the SpringbootsitesClient.BeginTriggerRefreshSite
//     method.
func (client *SpringbootsitesClient) BeginTriggerRefreshSite(ctx context.Context, resourceGroupName string, springbootsitesName string, options *SpringbootsitesClientBeginTriggerRefreshSiteOptions) (*runtime.Poller[SpringbootsitesClientTriggerRefreshSiteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.triggerRefreshSite(ctx, resourceGroupName, springbootsitesName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SpringbootsitesClientTriggerRefreshSiteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SpringbootsitesClientTriggerRefreshSiteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// TriggerRefreshSite - Trigger refresh springbootsites action
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
func (client *SpringbootsitesClient) triggerRefreshSite(ctx context.Context, resourceGroupName string, springbootsitesName string, options *SpringbootsitesClientBeginTriggerRefreshSiteOptions) (*http.Response, error) {
	var err error
	const operationName = "SpringbootsitesClient.BeginTriggerRefreshSite"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.triggerRefreshSiteCreateRequest(ctx, resourceGroupName, springbootsitesName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// triggerRefreshSiteCreateRequest creates the TriggerRefreshSite request.
func (client *SpringbootsitesClient) triggerRefreshSiteCreateRequest(ctx context.Context, resourceGroupName string, springbootsitesName string, options *SpringbootsitesClientBeginTriggerRefreshSiteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}/refreshSite"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if springbootsitesName == "" {
		return nil, errors.New("parameter springbootsitesName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{springbootsitesName}", url.PathEscape(springbootsitesName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginUpdate - Update a springbootsites resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - springbootsitesName - The springbootsites name.
//   - springbootsites - Update a springbootsites payload.
//   - options - SpringbootsitesClientBeginUpdateOptions contains the optional parameters for the SpringbootsitesClient.BeginUpdate
//     method.
func (client *SpringbootsitesClient) BeginUpdate(ctx context.Context, resourceGroupName string, springbootsitesName string, springbootsites SpringbootsitesPatch, options *SpringbootsitesClientBeginUpdateOptions) (*runtime.Poller[SpringbootsitesClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, springbootsitesName, springbootsites, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SpringbootsitesClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SpringbootsitesClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Update a springbootsites resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
func (client *SpringbootsitesClient) update(ctx context.Context, resourceGroupName string, springbootsitesName string, springbootsites SpringbootsitesPatch, options *SpringbootsitesClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "SpringbootsitesClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, springbootsitesName, springbootsites, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *SpringbootsitesClient) updateCreateRequest(ctx context.Context, resourceGroupName string, springbootsitesName string, springbootsites SpringbootsitesPatch, options *SpringbootsitesClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if springbootsitesName == "" {
		return nil, errors.New("parameter springbootsitesName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{springbootsitesName}", url.PathEscape(springbootsitesName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, springbootsites); err != nil {
		return nil, err
	}
	return req, nil
}
