//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsphere

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewCatalogsClient creates a new instance of CatalogsClient.
func (c *ClientFactory) NewCatalogsClient() *CatalogsClient {
	return &CatalogsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCertificatesClient creates a new instance of CertificatesClient.
func (c *ClientFactory) NewCertificatesClient() *CertificatesClient {
	return &CertificatesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDeploymentsClient creates a new instance of DeploymentsClient.
func (c *ClientFactory) NewDeploymentsClient() *DeploymentsClient {
	return &DeploymentsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDeviceGroupsClient creates a new instance of DeviceGroupsClient.
func (c *ClientFactory) NewDeviceGroupsClient() *DeviceGroupsClient {
	return &DeviceGroupsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDevicesClient creates a new instance of DevicesClient.
func (c *ClientFactory) NewDevicesClient() *DevicesClient {
	return &DevicesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewImagesClient creates a new instance of ImagesClient.
func (c *ClientFactory) NewImagesClient() *ImagesClient {
	return &ImagesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}

// NewProductsClient creates a new instance of ProductsClient.
func (c *ClientFactory) NewProductsClient() *ProductsClient {
	return &ProductsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}
