//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armservicefabricmesh_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/servicefabricmesh/armservicefabricmesh"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/servicefabricmesh/resource-manager/Microsoft.ServiceFabricMesh/preview/2018-09-01-preview/examples/networks/create_update.json
func ExampleNetworkClient_Create() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armservicefabricmesh.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNetworkClient().Create(ctx, "sbz_demo", "sampleNetwork", armservicefabricmesh.NetworkResourceDescription{
		Location: to.Ptr("EastUS"),
		Tags:     map[string]*string{},
		Properties: &armservicefabricmesh.LocalNetworkResourceProperties{
			Kind:                 to.Ptr(armservicefabricmesh.NetworkKindLocal),
			Description:          to.Ptr("Service Fabric Mesh sample network."),
			NetworkAddressPrefix: to.Ptr("2.0.0.0/16"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkResourceDescription = armservicefabricmesh.NetworkResourceDescription{
	// 	Name: to.Ptr("sampleNetwork"),
	// 	Type: to.Ptr("Microsoft.ServiceFabricMesh/networks"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/sbz_demo/providers/Microsoft.ServiceFabricMesh/networks/sampleNetwork"),
	// 	Location: to.Ptr("EastUS"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armservicefabricmesh.LocalNetworkResourceProperties{
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Kind: to.Ptr(armservicefabricmesh.NetworkKindLocal),
	// 		Description: to.Ptr("Service Fabric Mesh sample network."),
	// 		Status: to.Ptr(armservicefabricmesh.ResourceStatusReady),
	// 		NetworkAddressPrefix: to.Ptr("2.0.0.0/16"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/servicefabricmesh/resource-manager/Microsoft.ServiceFabricMesh/preview/2018-09-01-preview/examples/networks/get.json
func ExampleNetworkClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armservicefabricmesh.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNetworkClient().Get(ctx, "sbz_demo", "sampleNetwork", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NetworkResourceDescription = armservicefabricmesh.NetworkResourceDescription{
	// 	Name: to.Ptr("sampleNetwork"),
	// 	Type: to.Ptr("Microsoft.ServiceFabricMesh/networks"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/sbz_demo/providers/Microsoft.ServiceFabricMesh/networks/sampleNetwork"),
	// 	Location: to.Ptr("EastUS"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armservicefabricmesh.LocalNetworkResourceProperties{
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Kind: to.Ptr(armservicefabricmesh.NetworkKindLocal),
	// 		Description: to.Ptr("Service Fabric Mesh sample network."),
	// 		Status: to.Ptr(armservicefabricmesh.ResourceStatusReady),
	// 		NetworkAddressPrefix: to.Ptr("2.0.0.0/16"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/servicefabricmesh/resource-manager/Microsoft.ServiceFabricMesh/preview/2018-09-01-preview/examples/networks/delete.json
func ExampleNetworkClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armservicefabricmesh.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewNetworkClient().Delete(ctx, "sbz_demo", "sampleNetwork", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/servicefabricmesh/resource-manager/Microsoft.ServiceFabricMesh/preview/2018-09-01-preview/examples/networks/list_byResourceGroup.json
func ExampleNetworkClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armservicefabricmesh.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewNetworkClient().NewListByResourceGroupPager("sbz_demo", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.NetworkResourceDescriptionList = armservicefabricmesh.NetworkResourceDescriptionList{
		// 	Value: []*armservicefabricmesh.NetworkResourceDescription{
		// 		{
		// 			Name: to.Ptr("sampleNetwork"),
		// 			Type: to.Ptr("Microsoft.ServiceFabricMesh/networks"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/sbz_demo/providers/Microsoft.ServiceFabricMesh/networks/sampleNetwork"),
		// 			Location: to.Ptr("EastUS"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armservicefabricmesh.LocalNetworkResourceProperties{
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				Kind: to.Ptr(armservicefabricmesh.NetworkKindLocal),
		// 				Description: to.Ptr("Service Fabric Mesh sample network."),
		// 				Status: to.Ptr(armservicefabricmesh.ResourceStatusReady),
		// 				NetworkAddressPrefix: to.Ptr("2.0.0.0/16"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/servicefabricmesh/resource-manager/Microsoft.ServiceFabricMesh/preview/2018-09-01-preview/examples/networks/list_bySubscriptionId.json
func ExampleNetworkClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armservicefabricmesh.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewNetworkClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.NetworkResourceDescriptionList = armservicefabricmesh.NetworkResourceDescriptionList{
		// 	Value: []*armservicefabricmesh.NetworkResourceDescription{
		// 		{
		// 			Name: to.Ptr("sampleNetwork"),
		// 			Type: to.Ptr("Microsoft.ServiceFabricMesh/networks"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/sbz_demo/providers/Microsoft.ServiceFabricMesh/networks/sampleNetwork"),
		// 			Location: to.Ptr("EastUS"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armservicefabricmesh.LocalNetworkResourceProperties{
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				Kind: to.Ptr(armservicefabricmesh.NetworkKindLocal),
		// 				Description: to.Ptr("Service Fabric Mesh sample network."),
		// 				Status: to.Ptr(armservicefabricmesh.ResourceStatusReady),
		// 				NetworkAddressPrefix: to.Ptr("2.0.0.0/16"),
		// 			},
		// 	}},
		// }
	}
}
