//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armservicefabricmesh

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AddRemoveReplicaScalingMechanism.
func (a AddRemoveReplicaScalingMechanism) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = AutoScalingMechanismKindAddRemoveReplica
	populate(objectMap, "maxCount", a.MaxCount)
	populate(objectMap, "minCount", a.MinCount)
	populate(objectMap, "scaleIncrement", a.ScaleIncrement)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddRemoveReplicaScalingMechanism.
func (a *AddRemoveReplicaScalingMechanism) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "maxCount":
			err = unpopulate(val, "MaxCount", &a.MaxCount)
			delete(rawMsg, key)
		case "minCount":
			err = unpopulate(val, "MinCount", &a.MinCount)
			delete(rawMsg, key)
		case "scaleIncrement":
			err = unpopulate(val, "ScaleIncrement", &a.ScaleIncrement)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationProperties.
func (a ApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "debugParams", a.DebugParams)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "diagnostics", a.Diagnostics)
	populate(objectMap, "healthState", a.HealthState)
	populate(objectMap, "serviceNames", a.ServiceNames)
	populate(objectMap, "services", a.Services)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "statusDetails", a.StatusDetails)
	populate(objectMap, "unhealthyEvaluation", a.UnhealthyEvaluation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationProperties.
func (a *ApplicationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "debugParams":
			err = unpopulate(val, "DebugParams", &a.DebugParams)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &a.Diagnostics)
			delete(rawMsg, key)
		case "healthState":
			err = unpopulate(val, "HealthState", &a.HealthState)
			delete(rawMsg, key)
		case "serviceNames":
			err = unpopulate(val, "ServiceNames", &a.ServiceNames)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &a.Services)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &a.StatusDetails)
			delete(rawMsg, key)
		case "unhealthyEvaluation":
			err = unpopulate(val, "UnhealthyEvaluation", &a.UnhealthyEvaluation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResourceDescription.
func (a ApplicationResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationResourceDescription.
func (a *ApplicationResourceDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResourceDescriptionList.
func (a ApplicationResourceDescriptionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationResourceDescriptionList.
func (a *ApplicationResourceDescriptionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationResourceProperties.
func (a ApplicationResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "debugParams", a.DebugParams)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "diagnostics", a.Diagnostics)
	populate(objectMap, "healthState", a.HealthState)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "serviceNames", a.ServiceNames)
	populate(objectMap, "services", a.Services)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "statusDetails", a.StatusDetails)
	populate(objectMap, "unhealthyEvaluation", a.UnhealthyEvaluation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationResourceProperties.
func (a *ApplicationResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "debugParams":
			err = unpopulate(val, "DebugParams", &a.DebugParams)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &a.Diagnostics)
			delete(rawMsg, key)
		case "healthState":
			err = unpopulate(val, "HealthState", &a.HealthState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "serviceNames":
			err = unpopulate(val, "ServiceNames", &a.ServiceNames)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &a.Services)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &a.StatusDetails)
			delete(rawMsg, key)
		case "unhealthyEvaluation":
			err = unpopulate(val, "UnhealthyEvaluation", &a.UnhealthyEvaluation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationScopedVolume.
func (a ApplicationScopedVolume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "creationParameters", a.CreationParameters)
	populate(objectMap, "destinationPath", a.DestinationPath)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "readOnly", a.ReadOnly)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationScopedVolume.
func (a *ApplicationScopedVolume) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationParameters":
			a.CreationParameters, err = unmarshalApplicationScopedVolumeCreationParametersClassification(val)
			delete(rawMsg, key)
		case "destinationPath":
			err = unpopulate(val, "DestinationPath", &a.DestinationPath)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "readOnly":
			err = unpopulate(val, "ReadOnly", &a.ReadOnly)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationScopedVolumeCreationParameters.
func (a ApplicationScopedVolumeCreationParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	objectMap["kind"] = a.Kind
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationScopedVolumeCreationParameters.
func (a *ApplicationScopedVolumeCreationParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk.
func (a ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	objectMap["kind"] = ApplicationScopedVolumeKindServiceFabricVolumeDisk
	populate(objectMap, "sizeDisk", a.SizeDisk)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk.
func (a *ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "sizeDisk":
			err = unpopulate(val, "SizeDisk", &a.SizeDisk)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoScalingMechanism.
func (a AutoScalingMechanism) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = a.Kind
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoScalingMechanism.
func (a *AutoScalingMechanism) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoScalingMetric.
func (a AutoScalingMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = a.Kind
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoScalingMetric.
func (a *AutoScalingMetric) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoScalingPolicy.
func (a AutoScalingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mechanism", a.Mechanism)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "trigger", a.Trigger)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoScalingPolicy.
func (a *AutoScalingPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mechanism":
			a.Mechanism, err = unmarshalAutoScalingMechanismClassification(val)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "trigger":
			a.Trigger, err = unmarshalAutoScalingTriggerClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoScalingResourceMetric.
func (a AutoScalingResourceMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = AutoScalingMetricKindResource
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoScalingResourceMetric.
func (a *AutoScalingResourceMetric) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoScalingTrigger.
func (a AutoScalingTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = a.Kind
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoScalingTrigger.
func (a *AutoScalingTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableOperationDisplay.
func (a AvailableOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "operation", a.Operation)
	populate(objectMap, "provider", a.Provider)
	populate(objectMap, "resource", a.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableOperationDisplay.
func (a *AvailableOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &a.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &a.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AverageLoadScalingTrigger.
func (a AverageLoadScalingTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = AutoScalingTriggerKindAverageLoad
	populate(objectMap, "lowerLoadThreshold", a.LowerLoadThreshold)
	populate(objectMap, "metric", a.Metric)
	populate(objectMap, "scaleIntervalInSeconds", a.ScaleIntervalInSeconds)
	populate(objectMap, "upperLoadThreshold", a.UpperLoadThreshold)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AverageLoadScalingTrigger.
func (a *AverageLoadScalingTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "lowerLoadThreshold":
			err = unpopulate(val, "LowerLoadThreshold", &a.LowerLoadThreshold)
			delete(rawMsg, key)
		case "metric":
			a.Metric, err = unmarshalAutoScalingMetricClassification(val)
			delete(rawMsg, key)
		case "scaleIntervalInSeconds":
			err = unpopulate(val, "ScaleIntervalInSeconds", &a.ScaleIntervalInSeconds)
			delete(rawMsg, key)
		case "upperLoadThreshold":
			err = unpopulate(val, "UpperLoadThreshold", &a.UpperLoadThreshold)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureInternalMonitoringPipelineSinkDescription.
func (a AzureInternalMonitoringPipelineSinkDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "autoKeyConfigUrl", a.AutoKeyConfigURL)
	populate(objectMap, "description", a.Description)
	populateAny(objectMap, "fluentdConfigUrl", a.FluentdConfigURL)
	objectMap["kind"] = DiagnosticsSinkKindAzureInternalMonitoringPipeline
	populate(objectMap, "maConfigUrl", a.MaConfigURL)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "namespace", a.Namespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureInternalMonitoringPipelineSinkDescription.
func (a *AzureInternalMonitoringPipelineSinkDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "autoKeyConfigUrl":
			err = unpopulate(val, "AutoKeyConfigURL", &a.AutoKeyConfigURL)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "fluentdConfigUrl":
			err = unpopulate(val, "FluentdConfigURL", &a.FluentdConfigURL)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "maConfigUrl":
			err = unpopulate(val, "MaConfigURL", &a.MaConfigURL)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &a.Namespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerCodePackageProperties.
func (c ContainerCodePackageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "commands", c.Commands)
	populate(objectMap, "diagnostics", c.Diagnostics)
	populate(objectMap, "endpoints", c.Endpoints)
	populate(objectMap, "entrypoint", c.Entrypoint)
	populate(objectMap, "environmentVariables", c.EnvironmentVariables)
	populate(objectMap, "image", c.Image)
	populate(objectMap, "imageRegistryCredential", c.ImageRegistryCredential)
	populate(objectMap, "instanceView", c.InstanceView)
	populate(objectMap, "labels", c.Labels)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "reliableCollectionsRefs", c.ReliableCollectionsRefs)
	populate(objectMap, "resources", c.Resources)
	populate(objectMap, "settings", c.Settings)
	populate(objectMap, "volumeRefs", c.VolumeRefs)
	populate(objectMap, "volumes", c.Volumes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerCodePackageProperties.
func (c *ContainerCodePackageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commands":
			err = unpopulate(val, "Commands", &c.Commands)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &c.Diagnostics)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &c.Endpoints)
			delete(rawMsg, key)
		case "entrypoint":
			err = unpopulate(val, "Entrypoint", &c.Entrypoint)
			delete(rawMsg, key)
		case "environmentVariables":
			err = unpopulate(val, "EnvironmentVariables", &c.EnvironmentVariables)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &c.Image)
			delete(rawMsg, key)
		case "imageRegistryCredential":
			err = unpopulate(val, "ImageRegistryCredential", &c.ImageRegistryCredential)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &c.InstanceView)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &c.Labels)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "reliableCollectionsRefs":
			err = unpopulate(val, "ReliableCollectionsRefs", &c.ReliableCollectionsRefs)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &c.Resources)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &c.Settings)
			delete(rawMsg, key)
		case "volumeRefs":
			err = unpopulate(val, "VolumeRefs", &c.VolumeRefs)
			delete(rawMsg, key)
		case "volumes":
			err = unpopulate(val, "Volumes", &c.Volumes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerEvent.
func (c ContainerEvent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", c.Count)
	populate(objectMap, "firstTimestamp", c.FirstTimestamp)
	populate(objectMap, "lastTimestamp", c.LastTimestamp)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerEvent.
func (c *ContainerEvent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &c.Count)
			delete(rawMsg, key)
		case "firstTimestamp":
			err = unpopulate(val, "FirstTimestamp", &c.FirstTimestamp)
			delete(rawMsg, key)
		case "lastTimestamp":
			err = unpopulate(val, "LastTimestamp", &c.LastTimestamp)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerInstanceView.
func (c ContainerInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentState", c.CurrentState)
	populate(objectMap, "events", c.Events)
	populate(objectMap, "previousState", c.PreviousState)
	populate(objectMap, "restartCount", c.RestartCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerInstanceView.
func (c *ContainerInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentState":
			err = unpopulate(val, "CurrentState", &c.CurrentState)
			delete(rawMsg, key)
		case "events":
			err = unpopulate(val, "Events", &c.Events)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &c.PreviousState)
			delete(rawMsg, key)
		case "restartCount":
			err = unpopulate(val, "RestartCount", &c.RestartCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerLabel.
func (c ContainerLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerLabel.
func (c *ContainerLabel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerLogs.
func (c ContainerLogs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", c.Content)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerLogs.
func (c *ContainerLogs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerState.
func (c ContainerState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detailStatus", c.DetailStatus)
	populate(objectMap, "exitCode", c.ExitCode)
	populateTimeRFC3339(objectMap, "finishTime", c.FinishTime)
	populateTimeRFC3339(objectMap, "startTime", c.StartTime)
	populate(objectMap, "state", c.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerState.
func (c *ContainerState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detailStatus":
			err = unpopulate(val, "DetailStatus", &c.DetailStatus)
			delete(rawMsg, key)
		case "exitCode":
			err = unpopulate(val, "ExitCode", &c.ExitCode)
			delete(rawMsg, key)
		case "finishTime":
			err = unpopulateTimeRFC3339(val, "FinishTime", &c.FinishTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &c.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsDescription.
func (d DiagnosticsDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultSinkRefs", d.DefaultSinkRefs)
	populate(objectMap, "enabled", d.Enabled)
	populate(objectMap, "sinks", d.Sinks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsDescription.
func (d *DiagnosticsDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultSinkRefs":
			err = unpopulate(val, "DefaultSinkRefs", &d.DefaultSinkRefs)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		case "sinks":
			d.Sinks, err = unmarshalDiagnosticsSinkPropertiesClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsRef.
func (d DiagnosticsRef) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", d.Enabled)
	populate(objectMap, "sinkRefs", d.SinkRefs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsRef.
func (d *DiagnosticsRef) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &d.Enabled)
			delete(rawMsg, key)
		case "sinkRefs":
			err = unpopulate(val, "SinkRefs", &d.SinkRefs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsSinkProperties.
func (d DiagnosticsSinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", d.Description)
	objectMap["kind"] = d.Kind
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsSinkProperties.
func (d *DiagnosticsSinkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointProperties.
func (e EndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "port", e.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointProperties.
func (e *EndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &e.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointRef.
func (e EndpointRef) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointRef.
func (e *EndpointRef) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVariable.
func (e EnvironmentVariable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVariable.
func (e *EnvironmentVariable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetailsModel.
func (e ErrorDetailsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetailsModel.
func (e *ErrorDetailsModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorErrorModel.
func (e ErrorErrorModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "innerError", e.InnerError)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorErrorModel.
func (e *ErrorErrorModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &e.InnerError)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorModel.
func (e ErrorModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorModel.
func (e *ErrorModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayDestination.
func (g GatewayDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationName", g.ApplicationName)
	populate(objectMap, "endpointName", g.EndpointName)
	populate(objectMap, "serviceName", g.ServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayDestination.
func (g *GatewayDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationName":
			err = unpopulate(val, "ApplicationName", &g.ApplicationName)
			delete(rawMsg, key)
		case "endpointName":
			err = unpopulate(val, "EndpointName", &g.EndpointName)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &g.ServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayProperties.
func (g GatewayProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "destinationNetwork", g.DestinationNetwork)
	populate(objectMap, "http", g.HTTP)
	populate(objectMap, "ipAddress", g.IPAddress)
	populate(objectMap, "sourceNetwork", g.SourceNetwork)
	populate(objectMap, "status", g.Status)
	populate(objectMap, "statusDetails", g.StatusDetails)
	populate(objectMap, "tcp", g.TCP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayProperties.
func (g *GatewayProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "destinationNetwork":
			err = unpopulate(val, "DestinationNetwork", &g.DestinationNetwork)
			delete(rawMsg, key)
		case "http":
			err = unpopulate(val, "HTTP", &g.HTTP)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &g.IPAddress)
			delete(rawMsg, key)
		case "sourceNetwork":
			err = unpopulate(val, "SourceNetwork", &g.SourceNetwork)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &g.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &g.StatusDetails)
			delete(rawMsg, key)
		case "tcp":
			err = unpopulate(val, "TCP", &g.TCP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayResourceDescription.
func (g GatewayResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayResourceDescription.
func (g *GatewayResourceDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayResourceDescriptionList.
func (g GatewayResourceDescriptionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayResourceDescriptionList.
func (g *GatewayResourceDescriptionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayResourceProperties.
func (g GatewayResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "destinationNetwork", g.DestinationNetwork)
	populate(objectMap, "http", g.HTTP)
	populate(objectMap, "ipAddress", g.IPAddress)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "sourceNetwork", g.SourceNetwork)
	populate(objectMap, "status", g.Status)
	populate(objectMap, "statusDetails", g.StatusDetails)
	populate(objectMap, "tcp", g.TCP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayResourceProperties.
func (g *GatewayResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "destinationNetwork":
			err = unpopulate(val, "DestinationNetwork", &g.DestinationNetwork)
			delete(rawMsg, key)
		case "http":
			err = unpopulate(val, "HTTP", &g.HTTP)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &g.IPAddress)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "sourceNetwork":
			err = unpopulate(val, "SourceNetwork", &g.SourceNetwork)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &g.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &g.StatusDetails)
			delete(rawMsg, key)
		case "tcp":
			err = unpopulate(val, "TCP", &g.TCP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPConfig.
func (h HTTPConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hosts", h.Hosts)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "port", h.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPConfig.
func (h *HTTPConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hosts":
			err = unpopulate(val, "Hosts", &h.Hosts)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &h.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPHostConfig.
func (h HTTPHostConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "routes", h.Routes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPHostConfig.
func (h *HTTPHostConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &h.Routes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPRouteConfig.
func (h HTTPRouteConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destination", h.Destination)
	populate(objectMap, "match", h.Match)
	populate(objectMap, "name", h.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPRouteConfig.
func (h *HTTPRouteConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destination":
			err = unpopulate(val, "Destination", &h.Destination)
			delete(rawMsg, key)
		case "match":
			err = unpopulate(val, "Match", &h.Match)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPRouteMatchHeader.
func (h HTTPRouteMatchHeader) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "type", h.Type)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPRouteMatchHeader.
func (h *HTTPRouteMatchHeader) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPRouteMatchPath.
func (h HTTPRouteMatchPath) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rewrite", h.Rewrite)
	populate(objectMap, "type", h.Type)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPRouteMatchPath.
func (h *HTTPRouteMatchPath) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rewrite":
			err = unpopulate(val, "Rewrite", &h.Rewrite)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPRouteMatchRule.
func (h HTTPRouteMatchRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "headers", h.Headers)
	populate(objectMap, "path", h.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPRouteMatchRule.
func (h *HTTPRouteMatchRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "headers":
			err = unpopulate(val, "Headers", &h.Headers)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &h.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageRegistryCredential.
func (i ImageRegistryCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", i.Password)
	populate(objectMap, "server", i.Server)
	populate(objectMap, "username", i.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageRegistryCredential.
func (i *ImageRegistryCredential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &i.Password)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &i.Server)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &i.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InlinedValueSecretResourceProperties.
func (i InlinedValueSecretResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentType", i.ContentType)
	populate(objectMap, "description", i.Description)
	objectMap["kind"] = SecretKindInlinedValue
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "status", i.Status)
	populate(objectMap, "statusDetails", i.StatusDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InlinedValueSecretResourceProperties.
func (i *InlinedValueSecretResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentType":
			err = unpopulate(val, "ContentType", &i.ContentType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &i.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &i.StatusDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalNetworkResourceProperties.
func (l LocalNetworkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", l.Description)
	objectMap["kind"] = NetworkKindLocal
	populate(objectMap, "networkAddressPrefix", l.NetworkAddressPrefix)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "status", l.Status)
	populate(objectMap, "statusDetails", l.StatusDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalNetworkResourceProperties.
func (l *LocalNetworkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &l.Kind)
			delete(rawMsg, key)
		case "networkAddressPrefix":
			err = unpopulate(val, "NetworkAddressPrefix", &l.NetworkAddressPrefix)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &l.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &l.StatusDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedProxyResource.
func (m ManagedProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedProxyResource.
func (m *ManagedProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkRef.
func (n NetworkRef) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointRefs", n.EndpointRefs)
	populate(objectMap, "name", n.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkRef.
func (n *NetworkRef) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointRefs":
			err = unpopulate(val, "EndpointRefs", &n.EndpointRefs)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkResourceDescription.
func (n NetworkResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkResourceDescription.
func (n *NetworkResourceDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			n.Properties, err = unmarshalNetworkResourcePropertiesClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkResourceDescriptionList.
func (n NetworkResourceDescriptionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkResourceDescriptionList.
func (n *NetworkResourceDescriptionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkResourceProperties.
func (n NetworkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", n.Description)
	objectMap["kind"] = "NetworkResourceProperties"
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "status", n.Status)
	populate(objectMap, "statusDetails", n.StatusDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkResourceProperties.
func (n *NetworkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &n.Kind)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &n.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &n.StatusDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkResourcePropertiesBase.
func (n NetworkResourcePropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = n.Kind
	populate(objectMap, "provisioningState", n.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkResourcePropertiesBase.
func (n *NetworkResourcePropertiesBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &n.Kind)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResult.
func (o OperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResult.
func (o *OperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedResourceProperties.
func (p ProvisionedResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedResourceProperties.
func (p *ProvisionedResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReliableCollectionsRef.
func (r ReliableCollectionsRef) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "doNotPersistState", r.DoNotPersistState)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReliableCollectionsRef.
func (r *ReliableCollectionsRef) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "doNotPersistState":
			err = unpopulate(val, "DoNotPersistState", &r.DoNotPersistState)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceLimits.
func (r ResourceLimits) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpu", r.CPU)
	populate(objectMap, "memoryInGB", r.MemoryInGB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceLimits.
func (r *ResourceLimits) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpu":
			err = unpopulate(val, "CPU", &r.CPU)
			delete(rawMsg, key)
		case "memoryInGB":
			err = unpopulate(val, "MemoryInGB", &r.MemoryInGB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceRequests.
func (r ResourceRequests) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpu", r.CPU)
	populate(objectMap, "memoryInGB", r.MemoryInGB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceRequests.
func (r *ResourceRequests) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpu":
			err = unpopulate(val, "CPU", &r.CPU)
			delete(rawMsg, key)
		case "memoryInGB":
			err = unpopulate(val, "MemoryInGB", &r.MemoryInGB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceRequirements.
func (r ResourceRequirements) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "limits", r.Limits)
	populate(objectMap, "requests", r.Requests)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceRequirements.
func (r *ResourceRequirements) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "limits":
			err = unpopulate(val, "Limits", &r.Limits)
			delete(rawMsg, key)
		case "requests":
			err = unpopulate(val, "Requests", &r.Requests)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretResourceDescription.
func (s SecretResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretResourceDescription.
func (s *SecretResourceDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			s.Properties, err = unmarshalSecretResourcePropertiesClassification(val)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretResourceDescriptionList.
func (s SecretResourceDescriptionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretResourceDescriptionList.
func (s *SecretResourceDescriptionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretResourceProperties.
func (s SecretResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "description", s.Description)
	objectMap["kind"] = "SecretResourceProperties"
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "statusDetails", s.StatusDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretResourceProperties.
func (s *SecretResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentType":
			err = unpopulate(val, "ContentType", &s.ContentType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &s.StatusDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretResourcePropertiesBase.
func (s SecretResourcePropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["kind"] = s.Kind
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretResourcePropertiesBase.
func (s *SecretResourcePropertiesBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretValue.
func (s SecretValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretValue.
func (s *SecretValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretValueProperties.
func (s SecretValueProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretValueProperties.
func (s *SecretValueProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretValueResourceDescription.
func (s SecretValueResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretValueResourceDescription.
func (s *SecretValueResourceDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretValueResourceDescriptionList.
func (s SecretValueResourceDescriptionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretValueResourceDescriptionList.
func (s *SecretValueResourceDescriptionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretValueResourceProperties.
func (s SecretValueResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretValueResourceProperties.
func (s *SecretValueResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProperties.
func (s ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoScalingPolicies", s.AutoScalingPolicies)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "healthState", s.HealthState)
	populate(objectMap, "replicaCount", s.ReplicaCount)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "statusDetails", s.StatusDetails)
	populate(objectMap, "unhealthyEvaluation", s.UnhealthyEvaluation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceProperties.
func (s *ServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoScalingPolicies":
			err = unpopulate(val, "AutoScalingPolicies", &s.AutoScalingPolicies)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "healthState":
			err = unpopulate(val, "HealthState", &s.HealthState)
			delete(rawMsg, key)
		case "replicaCount":
			err = unpopulate(val, "ReplicaCount", &s.ReplicaCount)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &s.StatusDetails)
			delete(rawMsg, key)
		case "unhealthyEvaluation":
			err = unpopulate(val, "UnhealthyEvaluation", &s.UnhealthyEvaluation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceReplicaDescription.
func (s ServiceReplicaDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "codePackages", s.CodePackages)
	populate(objectMap, "diagnostics", s.Diagnostics)
	populate(objectMap, "networkRefs", s.NetworkRefs)
	populate(objectMap, "osType", s.OSType)
	populate(objectMap, "replicaName", s.ReplicaName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceReplicaDescription.
func (s *ServiceReplicaDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "codePackages":
			err = unpopulate(val, "CodePackages", &s.CodePackages)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &s.Diagnostics)
			delete(rawMsg, key)
		case "networkRefs":
			err = unpopulate(val, "NetworkRefs", &s.NetworkRefs)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		case "replicaName":
			err = unpopulate(val, "ReplicaName", &s.ReplicaName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceReplicaDescriptionList.
func (s ServiceReplicaDescriptionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceReplicaDescriptionList.
func (s *ServiceReplicaDescriptionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceReplicaProperties.
func (s ServiceReplicaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "codePackages", s.CodePackages)
	populate(objectMap, "diagnostics", s.Diagnostics)
	populate(objectMap, "networkRefs", s.NetworkRefs)
	populate(objectMap, "osType", s.OSType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceReplicaProperties.
func (s *ServiceReplicaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "codePackages":
			err = unpopulate(val, "CodePackages", &s.CodePackages)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &s.Diagnostics)
			delete(rawMsg, key)
		case "networkRefs":
			err = unpopulate(val, "NetworkRefs", &s.NetworkRefs)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceDescription.
func (s ServiceResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceDescription.
func (s *ServiceResourceDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceDescriptionList.
func (s ServiceResourceDescriptionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceDescriptionList.
func (s *ServiceResourceDescriptionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceResourceProperties.
func (s ServiceResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoScalingPolicies", s.AutoScalingPolicies)
	populate(objectMap, "codePackages", s.CodePackages)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "diagnostics", s.Diagnostics)
	populate(objectMap, "healthState", s.HealthState)
	populate(objectMap, "networkRefs", s.NetworkRefs)
	populate(objectMap, "osType", s.OSType)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "replicaCount", s.ReplicaCount)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "statusDetails", s.StatusDetails)
	populate(objectMap, "unhealthyEvaluation", s.UnhealthyEvaluation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceResourceProperties.
func (s *ServiceResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoScalingPolicies":
			err = unpopulate(val, "AutoScalingPolicies", &s.AutoScalingPolicies)
			delete(rawMsg, key)
		case "codePackages":
			err = unpopulate(val, "CodePackages", &s.CodePackages)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "diagnostics":
			err = unpopulate(val, "Diagnostics", &s.Diagnostics)
			delete(rawMsg, key)
		case "healthState":
			err = unpopulate(val, "HealthState", &s.HealthState)
			delete(rawMsg, key)
		case "networkRefs":
			err = unpopulate(val, "NetworkRefs", &s.NetworkRefs)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "replicaCount":
			err = unpopulate(val, "ReplicaCount", &s.ReplicaCount)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &s.StatusDetails)
			delete(rawMsg, key)
		case "unhealthyEvaluation":
			err = unpopulate(val, "UnhealthyEvaluation", &s.UnhealthyEvaluation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Setting.
func (s Setting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Setting.
func (s *Setting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TCPConfig.
func (t TCPConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destination", t.Destination)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "port", t.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TCPConfig.
func (t *TCPConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destination":
			err = unpopulate(val, "Destination", &t.Destination)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &t.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeProperties.
func (v VolumeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureFileParameters", v.AzureFileParameters)
	populate(objectMap, "description", v.Description)
	populate(objectMap, "provider", v.Provider)
	populate(objectMap, "status", v.Status)
	populate(objectMap, "statusDetails", v.StatusDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeProperties.
func (v *VolumeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFileParameters":
			err = unpopulate(val, "AzureFileParameters", &v.AzureFileParameters)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &v.Provider)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &v.StatusDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeProviderParametersAzureFile.
func (v VolumeProviderParametersAzureFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountKey", v.AccountKey)
	populate(objectMap, "accountName", v.AccountName)
	populate(objectMap, "shareName", v.ShareName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeProviderParametersAzureFile.
func (v *VolumeProviderParametersAzureFile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountKey":
			err = unpopulate(val, "AccountKey", &v.AccountKey)
			delete(rawMsg, key)
		case "accountName":
			err = unpopulate(val, "AccountName", &v.AccountName)
			delete(rawMsg, key)
		case "shareName":
			err = unpopulate(val, "ShareName", &v.ShareName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeReference.
func (v VolumeReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationPath", v.DestinationPath)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "readOnly", v.ReadOnly)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeReference.
func (v *VolumeReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationPath":
			err = unpopulate(val, "DestinationPath", &v.DestinationPath)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "readOnly":
			err = unpopulate(val, "ReadOnly", &v.ReadOnly)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeResourceDescription.
func (v VolumeResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeResourceDescription.
func (v *VolumeResourceDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeResourceDescriptionList.
func (v VolumeResourceDescriptionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeResourceDescriptionList.
func (v *VolumeResourceDescriptionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeResourceProperties.
func (v VolumeResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureFileParameters", v.AzureFileParameters)
	populate(objectMap, "description", v.Description)
	populate(objectMap, "provider", v.Provider)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "status", v.Status)
	populate(objectMap, "statusDetails", v.StatusDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeResourceProperties.
func (v *VolumeResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFileParameters":
			err = unpopulate(val, "AzureFileParameters", &v.AzureFileParameters)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &v.Provider)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &v.StatusDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
