//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armselfhelp

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/selfhelp/armselfhelp"
	moduleVersion = "v2.0.0-beta.4"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// AggregationType - Allowed values are Sum, Avg, Count, Min, Max. Default is Sum
type AggregationType string

const (
	AggregationTypeAvg   AggregationType = "Avg"
	AggregationTypeCount AggregationType = "Count"
	AggregationTypeMax   AggregationType = "Max"
	AggregationTypeMin   AggregationType = "Min"
	AggregationTypeSum   AggregationType = "Sum"
)

// PossibleAggregationTypeValues returns the possible values for the AggregationType const type.
func PossibleAggregationTypeValues() []AggregationType {
	return []AggregationType{
		AggregationTypeAvg,
		AggregationTypeCount,
		AggregationTypeMax,
		AggregationTypeMin,
		AggregationTypeSum,
	}
}

// AutomatedCheckResultType - Type of Result.
type AutomatedCheckResultType string

const (
	AutomatedCheckResultTypeError       AutomatedCheckResultType = "Error"
	AutomatedCheckResultTypeInformation AutomatedCheckResultType = "Information"
	AutomatedCheckResultTypeSuccess     AutomatedCheckResultType = "Success"
	AutomatedCheckResultTypeWarning     AutomatedCheckResultType = "Warning"
)

// PossibleAutomatedCheckResultTypeValues returns the possible values for the AutomatedCheckResultType const type.
func PossibleAutomatedCheckResultTypeValues() []AutomatedCheckResultType {
	return []AutomatedCheckResultType{
		AutomatedCheckResultTypeError,
		AutomatedCheckResultTypeInformation,
		AutomatedCheckResultTypeSuccess,
		AutomatedCheckResultTypeWarning,
	}
}

// Confidence - Confidence of the search result.
type Confidence string

const (
	ConfidenceHigh   Confidence = "High"
	ConfidenceLow    Confidence = "Low"
	ConfidenceMedium Confidence = "Medium"
)

// PossibleConfidenceValues returns the possible values for the Confidence const type.
func PossibleConfidenceValues() []Confidence {
	return []Confidence{
		ConfidenceHigh,
		ConfidenceLow,
		ConfidenceMedium,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DiagnosticProvisioningState - Status of diagnostic provisioning.
type DiagnosticProvisioningState string

const (
	// DiagnosticProvisioningStateCanceled - When Diagnostic request gets canceled.
	DiagnosticProvisioningStateCanceled DiagnosticProvisioningState = "Canceled"
	// DiagnosticProvisioningStateFailed - All Diagnostics failed to run.
	DiagnosticProvisioningStateFailed DiagnosticProvisioningState = "Failed"
	// DiagnosticProvisioningStatePartialComplete - Some Diagnostics are still running or failed.
	DiagnosticProvisioningStatePartialComplete DiagnosticProvisioningState = "PartialComplete"
	// DiagnosticProvisioningStateRunning - All Diagnostics are still running.
	DiagnosticProvisioningStateRunning DiagnosticProvisioningState = "Running"
	// DiagnosticProvisioningStateSucceeded - All Diagnostics in the Batch succeeded.
	DiagnosticProvisioningStateSucceeded DiagnosticProvisioningState = "Succeeded"
)

// PossibleDiagnosticProvisioningStateValues returns the possible values for the DiagnosticProvisioningState const type.
func PossibleDiagnosticProvisioningStateValues() []DiagnosticProvisioningState {
	return []DiagnosticProvisioningState{
		DiagnosticProvisioningStateCanceled,
		DiagnosticProvisioningStateFailed,
		DiagnosticProvisioningStatePartialComplete,
		DiagnosticProvisioningStateRunning,
		DiagnosticProvisioningStateSucceeded,
	}
}

// ExecutionStatus - Status of Troubleshooter Step execution.
type ExecutionStatus string

const (
	// ExecutionStatusFailed - Step execution failed
	ExecutionStatusFailed ExecutionStatus = "Failed"
	// ExecutionStatusRunning - Step execution running
	ExecutionStatusRunning ExecutionStatus = "Running"
	// ExecutionStatusSuccess - Step execution succeeded.
	ExecutionStatusSuccess ExecutionStatus = "Success"
	// ExecutionStatusWarning - Step execution warning
	ExecutionStatusWarning ExecutionStatus = "Warning"
)

// PossibleExecutionStatusValues returns the possible values for the ExecutionStatus const type.
func PossibleExecutionStatusValues() []ExecutionStatus {
	return []ExecutionStatus{
		ExecutionStatusFailed,
		ExecutionStatusRunning,
		ExecutionStatusSuccess,
		ExecutionStatusWarning,
	}
}

// ImportanceLevel - Importance level of the insight.
type ImportanceLevel string

const (
	// ImportanceLevelCritical - A critical insight has been found after running the diagnostic.
	ImportanceLevelCritical ImportanceLevel = "Critical"
	// ImportanceLevelInformation - An information insight has been found after running the diagnostic.
	ImportanceLevelInformation ImportanceLevel = "Information"
	// ImportanceLevelWarning - A warning insight has been found after running the diagnostic.
	ImportanceLevelWarning ImportanceLevel = "Warning"
)

// PossibleImportanceLevelValues returns the possible values for the ImportanceLevel const type.
func PossibleImportanceLevelValues() []ImportanceLevel {
	return []ImportanceLevel{
		ImportanceLevelCritical,
		ImportanceLevelInformation,
		ImportanceLevelWarning,
	}
}

// Name - Trigger criterion name.
type Name string

const (
	NameProblemClassificationID Name = "ProblemClassificationId"
	NameReplacementKey          Name = "ReplacementKey"
	NameSolutionID              Name = "SolutionId"
)

// PossibleNameValues returns the possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{
		NameProblemClassificationID,
		NameReplacementKey,
		NameSolutionID,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// QuestionContentType - Default is Text.
type QuestionContentType string

const (
	QuestionContentTypeHTML     QuestionContentType = "Html"
	QuestionContentTypeMarkdown QuestionContentType = "Markdown"
	QuestionContentTypeText     QuestionContentType = "Text"
)

// PossibleQuestionContentTypeValues returns the possible values for the QuestionContentType const type.
func PossibleQuestionContentTypeValues() []QuestionContentType {
	return []QuestionContentType{
		QuestionContentTypeHTML,
		QuestionContentTypeMarkdown,
		QuestionContentTypeText,
	}
}

// QuestionType - Type of Question
type QuestionType string

const (
	// QuestionTypeDateTimePicker - DateTime Picker
	QuestionTypeDateTimePicker QuestionType = "DateTimePicker"
	// QuestionTypeDropdown - SingleChoice dropdown.
	QuestionTypeDropdown QuestionType = "Dropdown"
	// QuestionTypeMultiLineInfoBox - MultiLineInfoBox
	QuestionTypeMultiLineInfoBox QuestionType = "MultiLineInfoBox"
	// QuestionTypeMultiSelect - Multi Select
	QuestionTypeMultiSelect QuestionType = "MultiSelect"
	// QuestionTypeRadioButton - SingleChoice radio button
	QuestionTypeRadioButton QuestionType = "RadioButton"
	// QuestionTypeTextInput - Text Input
	QuestionTypeTextInput QuestionType = "TextInput"
)

// PossibleQuestionTypeValues returns the possible values for the QuestionType const type.
func PossibleQuestionTypeValues() []QuestionType {
	return []QuestionType{
		QuestionTypeDateTimePicker,
		QuestionTypeDropdown,
		QuestionTypeMultiLineInfoBox,
		QuestionTypeMultiSelect,
		QuestionTypeRadioButton,
		QuestionTypeTextInput,
	}
}

// ResultType - Result type of the search result.
type ResultType string

const (
	ResultTypeCommunity     ResultType = "Community"
	ResultTypeDocumentation ResultType = "Documentation"
)

// PossibleResultTypeValues returns the possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{
		ResultTypeCommunity,
		ResultTypeDocumentation,
	}
}

// SolutionProvisioningState - Status of solution provisioning.
type SolutionProvisioningState string

const (
	// SolutionProvisioningStateCanceled - When Solutions request gets canceled.
	SolutionProvisioningStateCanceled SolutionProvisioningState = "Canceled"
	// SolutionProvisioningStateFailed - All Solutions failed to run.
	SolutionProvisioningStateFailed SolutionProvisioningState = "Failed"
	// SolutionProvisioningStatePartialComplete - Some Solutions are still running or failed.
	SolutionProvisioningStatePartialComplete SolutionProvisioningState = "PartialComplete"
	// SolutionProvisioningStateRunning - All Solutions are still running.
	SolutionProvisioningStateRunning SolutionProvisioningState = "Running"
	// SolutionProvisioningStateSucceeded - All Solutions in the Batch succeeded.
	SolutionProvisioningStateSucceeded SolutionProvisioningState = "Succeeded"
)

// PossibleSolutionProvisioningStateValues returns the possible values for the SolutionProvisioningState const type.
func PossibleSolutionProvisioningStateValues() []SolutionProvisioningState {
	return []SolutionProvisioningState{
		SolutionProvisioningStateCanceled,
		SolutionProvisioningStateFailed,
		SolutionProvisioningStatePartialComplete,
		SolutionProvisioningStateRunning,
		SolutionProvisioningStateSucceeded,
	}
}

// SolutionType - Solution Type.
type SolutionType string

const (
	// SolutionTypeDiagnostics - Diagnostics resource type.
	SolutionTypeDiagnostics SolutionType = "Diagnostics"
	// SolutionTypeSelfHelp - SelfHelp resource type.
	SolutionTypeSelfHelp SolutionType = "SelfHelp"
	// SolutionTypeSolutions - Solutions resource type.
	SolutionTypeSolutions SolutionType = "Solutions"
	// SolutionTypeTroubleshooters - Troubleshooters resource type.
	SolutionTypeTroubleshooters SolutionType = "Troubleshooters"
)

// PossibleSolutionTypeValues returns the possible values for the SolutionType const type.
func PossibleSolutionTypeValues() []SolutionType {
	return []SolutionType{
		SolutionTypeDiagnostics,
		SolutionTypeSelfHelp,
		SolutionTypeSolutions,
		SolutionTypeTroubleshooters,
	}
}

// Status - Denotes the status of the diagnostic resource.
type Status string

const (
	// StatusFailed - Diagnostic creation failed.
	StatusFailed Status = "Failed"
	// StatusMissingInputs - Request is missing required inputs to run.
	StatusMissingInputs Status = "MissingInputs"
	// StatusRunning - Diagnostic is still running.
	StatusRunning Status = "Running"
	// StatusSucceeded - Diagnostic creation succeeded.
	StatusSucceeded Status = "Succeeded"
	// StatusTimeout - Diagnostic was timed out.
	StatusTimeout Status = "Timeout"
)

// PossibleStatusValues returns the possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{
		StatusFailed,
		StatusMissingInputs,
		StatusRunning,
		StatusSucceeded,
		StatusTimeout,
	}
}

// TroubleshooterProvisioningState - Status of troubleshooter provisioning.
type TroubleshooterProvisioningState string

const (
	TroubleshooterProvisioningStateAutoContinue TroubleshooterProvisioningState = "AutoContinue"
	TroubleshooterProvisioningStateCanceled     TroubleshooterProvisioningState = "Canceled"
	TroubleshooterProvisioningStateFailed       TroubleshooterProvisioningState = "Failed"
	TroubleshooterProvisioningStateRunning      TroubleshooterProvisioningState = "Running"
	TroubleshooterProvisioningStateSucceeded    TroubleshooterProvisioningState = "Succeeded"
)

// PossibleTroubleshooterProvisioningStateValues returns the possible values for the TroubleshooterProvisioningState const type.
func PossibleTroubleshooterProvisioningStateValues() []TroubleshooterProvisioningState {
	return []TroubleshooterProvisioningState{
		TroubleshooterProvisioningStateAutoContinue,
		TroubleshooterProvisioningStateCanceled,
		TroubleshooterProvisioningStateFailed,
		TroubleshooterProvisioningStateRunning,
		TroubleshooterProvisioningStateSucceeded,
	}
}

// Type - Type of Troubleshooting step.
type Type string

const (
	TypeAutomatedCheck Type = "AutomatedCheck"
	TypeDecision       Type = "Decision"
	TypeInput          Type = "Input"
	TypeInsight        Type = "Insight"
	TypeSolution       Type = "Solution"
)

// PossibleTypeValues returns the possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{
		TypeAutomatedCheck,
		TypeDecision,
		TypeInput,
		TypeInsight,
		TypeSolution,
	}
}

// ValidationScope - Validation scope
type ValidationScope string

const (
	ValidationScopeGUIDFormat       ValidationScope = "GuidFormat"
	ValidationScopeIPAddressFormat  ValidationScope = "IpAddressFormat"
	ValidationScopeNone             ValidationScope = "None"
	ValidationScopeNumberOnlyFormat ValidationScope = "NumberOnlyFormat"
	ValidationScopeURLFormat        ValidationScope = "URLFormat"
)

// PossibleValidationScopeValues returns the possible values for the ValidationScope const type.
func PossibleValidationScopeValues() []ValidationScope {
	return []ValidationScope{
		ValidationScopeGUIDFormat,
		ValidationScopeIPAddressFormat,
		ValidationScopeNone,
		ValidationScopeNumberOnlyFormat,
		ValidationScopeURLFormat,
	}
}
