//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurityinsights

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewActionsClient creates a new instance of ActionsClient.
func (c *ClientFactory) NewActionsClient() *ActionsClient {
	subClient, _ := NewActionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAlertRuleTemplatesClient creates a new instance of AlertRuleTemplatesClient.
func (c *ClientFactory) NewAlertRuleTemplatesClient() *AlertRuleTemplatesClient {
	subClient, _ := NewAlertRuleTemplatesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAlertRulesClient creates a new instance of AlertRulesClient.
func (c *ClientFactory) NewAlertRulesClient() *AlertRulesClient {
	subClient, _ := NewAlertRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAutomationRulesClient creates a new instance of AutomationRulesClient.
func (c *ClientFactory) NewAutomationRulesClient() *AutomationRulesClient {
	subClient, _ := NewAutomationRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBookmarksClient creates a new instance of BookmarksClient.
func (c *ClientFactory) NewBookmarksClient() *BookmarksClient {
	subClient, _ := NewBookmarksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataConnectorsClient creates a new instance of DataConnectorsClient.
func (c *ClientFactory) NewDataConnectorsClient() *DataConnectorsClient {
	subClient, _ := NewDataConnectorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIncidentCommentsClient creates a new instance of IncidentCommentsClient.
func (c *ClientFactory) NewIncidentCommentsClient() *IncidentCommentsClient {
	subClient, _ := NewIncidentCommentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIncidentRelationsClient creates a new instance of IncidentRelationsClient.
func (c *ClientFactory) NewIncidentRelationsClient() *IncidentRelationsClient {
	subClient, _ := NewIncidentRelationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIncidentsClient creates a new instance of IncidentsClient.
func (c *ClientFactory) NewIncidentsClient() *IncidentsClient {
	subClient, _ := NewIncidentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewSentinelOnboardingStatesClient creates a new instance of SentinelOnboardingStatesClient.
func (c *ClientFactory) NewSentinelOnboardingStatesClient() *SentinelOnboardingStatesClient {
	subClient, _ := NewSentinelOnboardingStatesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewThreatIntelligenceIndicatorClient creates a new instance of ThreatIntelligenceIndicatorClient.
func (c *ClientFactory) NewThreatIntelligenceIndicatorClient() *ThreatIntelligenceIndicatorClient {
	subClient, _ := NewThreatIntelligenceIndicatorClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewThreatIntelligenceIndicatorMetricsClient creates a new instance of ThreatIntelligenceIndicatorMetricsClient.
func (c *ClientFactory) NewThreatIntelligenceIndicatorMetricsClient() *ThreatIntelligenceIndicatorMetricsClient {
	subClient, _ := NewThreatIntelligenceIndicatorMetricsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewThreatIntelligenceIndicatorsClient creates a new instance of ThreatIntelligenceIndicatorsClient.
func (c *ClientFactory) NewThreatIntelligenceIndicatorsClient() *ThreatIntelligenceIndicatorsClient {
	subClient, _ := NewThreatIntelligenceIndicatorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWatchlistItemsClient creates a new instance of WatchlistItemsClient.
func (c *ClientFactory) NewWatchlistItemsClient() *WatchlistItemsClient {
	subClient, _ := NewWatchlistItemsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWatchlistsClient creates a new instance of WatchlistsClient.
func (c *ClientFactory) NewWatchlistsClient() *WatchlistsClient {
	subClient, _ := NewWatchlistsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
