//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// SecureScoreControlsServer is a fake server for instances of the armsecurity.SecureScoreControlsClient type.
type SecureScoreControlsServer struct {
	// NewListPager is the fake for method SecureScoreControlsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsecurity.SecureScoreControlsClientListOptions) (resp azfake.PagerResponder[armsecurity.SecureScoreControlsClientListResponse])

	// NewListBySecureScorePager is the fake for method SecureScoreControlsClient.NewListBySecureScorePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySecureScorePager func(secureScoreName string, options *armsecurity.SecureScoreControlsClientListBySecureScoreOptions) (resp azfake.PagerResponder[armsecurity.SecureScoreControlsClientListBySecureScoreResponse])
}

// NewSecureScoreControlsServerTransport creates a new instance of SecureScoreControlsServerTransport with the provided implementation.
// The returned SecureScoreControlsServerTransport instance is connected to an instance of armsecurity.SecureScoreControlsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSecureScoreControlsServerTransport(srv *SecureScoreControlsServer) *SecureScoreControlsServerTransport {
	return &SecureScoreControlsServerTransport{
		srv:                       srv,
		newListPager:              newTracker[azfake.PagerResponder[armsecurity.SecureScoreControlsClientListResponse]](),
		newListBySecureScorePager: newTracker[azfake.PagerResponder[armsecurity.SecureScoreControlsClientListBySecureScoreResponse]](),
	}
}

// SecureScoreControlsServerTransport connects instances of armsecurity.SecureScoreControlsClient to instances of SecureScoreControlsServer.
// Don't use this type directly, use NewSecureScoreControlsServerTransport instead.
type SecureScoreControlsServerTransport struct {
	srv                       *SecureScoreControlsServer
	newListPager              *tracker[azfake.PagerResponder[armsecurity.SecureScoreControlsClientListResponse]]
	newListBySecureScorePager *tracker[azfake.PagerResponder[armsecurity.SecureScoreControlsClientListBySecureScoreResponse]]
}

// Do implements the policy.Transporter interface for SecureScoreControlsServerTransport.
func (s *SecureScoreControlsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SecureScoreControlsClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "SecureScoreControlsClient.NewListBySecureScorePager":
		resp, err = s.dispatchNewListBySecureScorePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SecureScoreControlsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/secureScoreControls`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(armsecurity.ExpandControlsEnum(expandUnescaped))
		var options *armsecurity.SecureScoreControlsClientListOptions
		if expandParam != nil {
			options = &armsecurity.SecureScoreControlsClientListOptions{
				Expand: expandParam,
			}
		}
		resp := s.srv.NewListPager(options)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.SecureScoreControlsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *SecureScoreControlsServerTransport) dispatchNewListBySecureScorePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySecureScorePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySecureScorePager not implemented")}
	}
	newListBySecureScorePager := s.newListBySecureScorePager.get(req)
	if newListBySecureScorePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/secureScores/(?P<secureScoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/secureScoreControls`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		secureScoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("secureScoreName")])
		if err != nil {
			return nil, err
		}
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(armsecurity.ExpandControlsEnum(expandUnescaped))
		var options *armsecurity.SecureScoreControlsClientListBySecureScoreOptions
		if expandParam != nil {
			options = &armsecurity.SecureScoreControlsClientListBySecureScoreOptions{
				Expand: expandParam,
			}
		}
		resp := s.srv.NewListBySecureScorePager(secureScoreNameParam, options)
		newListBySecureScorePager = &resp
		s.newListBySecureScorePager.add(req, newListBySecureScorePager)
		server.PagerResponderInjectNextLinks(newListBySecureScorePager, req, func(page *armsecurity.SecureScoreControlsClientListBySecureScoreResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySecureScorePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySecureScorePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySecureScorePager) {
		s.newListBySecureScorePager.remove(req)
	}
	return resp, nil
}
