//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
)

// CenterServer is a fake server for instances of the armsecurity.CenterClient type.
type CenterServer struct {
	// GetSensitivitySettings is the fake for method CenterClient.GetSensitivitySettings
	// HTTP status codes to indicate success: http.StatusOK
	GetSensitivitySettings func(ctx context.Context, options *armsecurity.CenterClientGetSensitivitySettingsOptions) (resp azfake.Responder[armsecurity.CenterClientGetSensitivitySettingsResponse], errResp azfake.ErrorResponder)

	// UpdateSensitivitySettings is the fake for method CenterClient.UpdateSensitivitySettings
	// HTTP status codes to indicate success: http.StatusOK
	UpdateSensitivitySettings func(ctx context.Context, sensitivitySettings armsecurity.UpdateSensitivitySettingsRequest, options *armsecurity.CenterClientUpdateSensitivitySettingsOptions) (resp azfake.Responder[armsecurity.CenterClientUpdateSensitivitySettingsResponse], errResp azfake.ErrorResponder)
}

// NewCenterServerTransport creates a new instance of CenterServerTransport with the provided implementation.
// The returned CenterServerTransport instance is connected to an instance of armsecurity.CenterClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCenterServerTransport(srv *CenterServer) *CenterServerTransport {
	return &CenterServerTransport{srv: srv}
}

// CenterServerTransport connects instances of armsecurity.CenterClient to instances of CenterServer.
// Don't use this type directly, use NewCenterServerTransport instead.
type CenterServerTransport struct {
	srv *CenterServer
}

// Do implements the policy.Transporter interface for CenterServerTransport.
func (c *CenterServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CenterClient.GetSensitivitySettings":
		resp, err = c.dispatchGetSensitivitySettings(req)
	case "CenterClient.UpdateSensitivitySettings":
		resp, err = c.dispatchUpdateSensitivitySettings(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CenterServerTransport) dispatchGetSensitivitySettings(req *http.Request) (*http.Response, error) {
	if c.srv.GetSensitivitySettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSensitivitySettings not implemented")}
	}
	respr, errRespr := c.srv.GetSensitivitySettings(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GetSensitivitySettingsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CenterServerTransport) dispatchUpdateSensitivitySettings(req *http.Request) (*http.Response, error) {
	if c.srv.UpdateSensitivitySettings == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateSensitivitySettings not implemented")}
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurity.UpdateSensitivitySettingsRequest](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.UpdateSensitivitySettings(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GetSensitivitySettingsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
