//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armscheduler

import "time"

type BasicAuthentication struct {
	// REQUIRED; Gets or sets the HTTP authentication type.
	Type *HTTPAuthenticationType

	// Gets or sets the password, return value will always be empty.
	Password *string

	// Gets or sets the username.
	Username *string
}

// GetHTTPAuthentication implements the HTTPAuthenticationClassification interface for type BasicAuthentication.
func (b *BasicAuthentication) GetHTTPAuthentication() *HTTPAuthentication {
	return &HTTPAuthentication{
		Type: b.Type,
	}
}

type ClientCertAuthentication struct {
	// REQUIRED; Gets or sets the HTTP authentication type.
	Type *HTTPAuthenticationType

	// Gets or sets the certificate expiration date.
	CertificateExpirationDate *time.Time

	// Gets or sets the certificate subject name.
	CertificateSubjectName *string

	// Gets or sets the certificate thumbprint.
	CertificateThumbprint *string

	// Gets or sets the certificate password, return value will always be empty.
	Password *string

	// Gets or sets the pfx certificate. Accepts certification in base64 encoding, return value will always be empty.
	Pfx *string
}

// GetHTTPAuthentication implements the HTTPAuthenticationClassification interface for type ClientCertAuthentication.
func (c *ClientCertAuthentication) GetHTTPAuthentication() *HTTPAuthentication {
	return &HTTPAuthentication{
		Type: c.Type,
	}
}

type HTTPAuthentication struct {
	// REQUIRED; Gets or sets the HTTP authentication type.
	Type *HTTPAuthenticationType
}

// GetHTTPAuthentication implements the HTTPAuthenticationClassification interface for type HTTPAuthentication.
func (h *HTTPAuthentication) GetHTTPAuthentication() *HTTPAuthentication { return h }

type HTTPRequest struct {
	// Gets or sets the authentication method of the request.
	Authentication HTTPAuthenticationClassification

	// Gets or sets the request body.
	Body *string

	// Gets or sets the headers.
	Headers map[string]*string

	// Gets or sets the method of the request.
	Method *string

	// Gets or sets the URI of the request.
	URI *string
}

type JobAction struct {
	// Gets or sets the error action.
	ErrorAction *JobErrorAction

	// Gets or sets the storage queue message.
	QueueMessage *StorageQueueMessage

	// Gets or sets the http requests.
	Request *HTTPRequest

	// Gets or sets the retry policy.
	RetryPolicy *RetryPolicy

	// Gets or sets the service bus queue message.
	ServiceBusQueueMessage *ServiceBusQueueMessage

	// Gets or sets the service bus topic message.
	ServiceBusTopicMessage *ServiceBusTopicMessage

	// Gets or sets the job action type.
	Type *JobActionType
}

type JobCollectionDefinition struct {
	// Gets or sets the storage account location.
	Location *string

	// Gets or sets the job collection resource name.
	Name *string

	// Gets or sets the job collection properties.
	Properties *JobCollectionProperties

	// Gets or sets the tags.
	Tags map[string]*string

	// READ-ONLY; Gets the job collection resource identifier.
	ID *string

	// READ-ONLY; Gets the job collection resource type.
	Type *string
}

type JobCollectionListResult struct {
	// Gets or sets the URL to get the next set of job collections.
	NextLink *string

	// READ-ONLY; Gets the job collections.
	Value []*JobCollectionDefinition
}

type JobCollectionProperties struct {
	// Gets or sets the job collection quota.
	Quota *JobCollectionQuota

	// Gets or sets the SKU.
	SKU *SKU

	// Gets or sets the state.
	State *JobCollectionState
}

type JobCollectionQuota struct {
	// Gets or set the maximum job count.
	MaxJobCount *int32

	// Gets or sets the maximum job occurrence.
	MaxJobOccurrence *int32

	// Gets or set the maximum recurrence.
	MaxRecurrence *JobMaxRecurrence
}

type JobDefinition struct {
	// Gets or sets the job properties.
	Properties *JobProperties

	// READ-ONLY; Gets the job resource identifier.
	ID *string

	// READ-ONLY; Gets the job resource name.
	Name *string

	// READ-ONLY; Gets the job resource type.
	Type *string
}

type JobErrorAction struct {
	// Gets or sets the storage queue message.
	QueueMessage *StorageQueueMessage

	// Gets or sets the http requests.
	Request *HTTPRequest

	// Gets or sets the retry policy.
	RetryPolicy *RetryPolicy

	// Gets or sets the service bus queue message.
	ServiceBusQueueMessage *ServiceBusQueueMessage

	// Gets or sets the service bus topic message.
	ServiceBusTopicMessage *ServiceBusTopicMessage

	// Gets or sets the job error action type.
	Type *JobActionType
}

type JobHistoryDefinition struct {
	// READ-ONLY; Gets the job history identifier.
	ID *string

	// READ-ONLY; Gets the job history name.
	Name *string

	// READ-ONLY; Gets or sets the job history properties.
	Properties *JobHistoryDefinitionProperties

	// READ-ONLY; Gets the job history resource type.
	Type *string
}

type JobHistoryDefinitionProperties struct {
	// READ-ONLY; Gets the job history action name.
	ActionName *JobHistoryActionName

	// READ-ONLY; Gets the end time for this job.
	EndTime *time.Time

	// READ-ONLY; Gets the expected execution time for this job.
	ExpectedExecutionTime *time.Time

	// READ-ONLY; Gets the message for the job history.
	Message *string

	// READ-ONLY; Gets the repeat count for the job.
	RepeatCount *int32

	// READ-ONLY; Gets the retry count for job.
	RetryCount *int32

	// READ-ONLY; Gets the start time for this job.
	StartTime *time.Time

	// READ-ONLY; Gets the job history status.
	Status *JobExecutionStatus
}

type JobHistoryFilter struct {
	// Gets or sets the job execution status.
	Status *JobExecutionStatus
}

type JobHistoryListResult struct {
	// Gets or sets the URL to get the next set of job histories.
	NextLink *string

	// Gets or sets the job histories under job.
	Value []*JobHistoryDefinition
}

type JobListResult struct {
	// Gets or sets the URL to get the next set of jobs.
	NextLink *string

	// Gets or sets all jobs under job collection.
	Value []*JobDefinition
}

type JobMaxRecurrence struct {
	// Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
	Frequency *RecurrenceFrequency

	// Gets or sets the interval between retries.
	Interval *int32
}

type JobProperties struct {
	// Gets or sets the job action.
	Action *JobAction

	// Gets or sets the job recurrence.
	Recurrence *JobRecurrence

	// Gets or sets the job start time.
	StartTime *time.Time

	// Gets or set the job state.
	State *JobState

	// READ-ONLY; Gets the job status.
	Status *JobStatus
}

type JobRecurrence struct {
	// Gets or sets the maximum number of times that the job should run.
	Count *int32

	// Gets or sets the time at which the job will complete.
	EndTime *time.Time

	// Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
	Frequency *RecurrenceFrequency

	// Gets or sets the interval between retries.
	Interval *int32
	Schedule *JobRecurrenceSchedule
}

type JobRecurrenceSchedule struct {
	// Gets or sets the hours of the day that the job should execute at.
	Hours []*int32

	// Gets or sets the minutes of the hour that the job should execute at.
	Minutes []*int32

	// Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
	MonthDays []*int32

	// Gets or sets the occurrences of days within a month.
	MonthlyOccurrences []*JobRecurrenceScheduleMonthlyOccurrence

	// Gets or sets the days of the week that the job should execute on.
	WeekDays []*DayOfWeek
}

type JobRecurrenceScheduleMonthlyOccurrence struct {
	// Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
	Day *JobScheduleDay

	// Gets or sets the occurrence. Must be between -5 and 5.
	Occurrence *int32
}

type JobStateFilter struct {
	// Gets or sets the job state.
	State *JobState
}

type JobStatus struct {
	// READ-ONLY; Gets the number of times this job has executed.
	ExecutionCount *int32

	// READ-ONLY; Gets the number of times this job has failed.
	FailureCount *int32

	// READ-ONLY; Gets the number of faulted occurrences (occurrences that were retried and failed as many times as the retry
	// policy states).
	FaultedCount *int32

	// READ-ONLY; Gets the time the last occurrence executed in ISO-8601 format. Could be empty if job has not run yet.
	LastExecutionTime *time.Time

	// READ-ONLY; Gets the time of the next occurrence in ISO-8601 format. Could be empty if the job is completed.
	NextExecutionTime *time.Time
}

type OAuthAuthentication struct {
	// REQUIRED; Gets or sets the HTTP authentication type.
	Type *HTTPAuthenticationType

	// Gets or sets the audience.
	Audience *string

	// Gets or sets the client identifier.
	ClientID *string

	// Gets or sets the secret, return value will always be empty.
	Secret *string

	// Gets or sets the tenant.
	Tenant *string
}

// GetHTTPAuthentication implements the HTTPAuthenticationClassification interface for type OAuthAuthentication.
func (o *OAuthAuthentication) GetHTTPAuthentication() *HTTPAuthentication {
	return &HTTPAuthentication{
		Type: o.Type,
	}
}

type RetryPolicy struct {
	// Gets or sets the number of times a retry should be attempted.
	RetryCount *int32

	// Gets or sets the retry interval between retries, specify duration in ISO 8601 format.
	RetryInterval *string

	// Gets or sets the retry strategy to be used.
	RetryType *RetryType
}

type SKU struct {
	// Gets or set the SKU.
	Name *SKUDefinition
}

type ServiceBusAuthentication struct {
	// Gets or sets the SAS key.
	SasKey *string

	// Gets or sets the SAS key name.
	SasKeyName *string

	// Gets or sets the authentication type.
	Type *ServiceBusAuthenticationType
}

type ServiceBusBrokeredMessageProperties struct {
	// Gets or sets the content type.
	ContentType *string

	// Gets or sets the correlation ID.
	CorrelationID *string

	// Gets or sets the force persistence.
	ForcePersistence *bool

	// Gets or sets the label.
	Label *string

	// Gets or sets the message ID.
	MessageID *string

	// Gets or sets the partition key.
	PartitionKey *string

	// Gets or sets the reply to.
	ReplyTo *string

	// Gets or sets the reply to session ID.
	ReplyToSessionID *string

	// Gets or sets the scheduled enqueue time UTC.
	ScheduledEnqueueTimeUTC *time.Time

	// Gets or sets the session ID.
	SessionID *string

	// Gets or sets the time to live.
	TimeToLive *string

	// Gets or sets the to.
	To *string

	// Gets or sets the via partition key.
	ViaPartitionKey *string
}

type ServiceBusMessage struct {
	// Gets or sets the Service Bus authentication.
	Authentication *ServiceBusAuthentication

	// Gets or sets the brokered message properties.
	BrokeredMessageProperties *ServiceBusBrokeredMessageProperties

	// Gets or sets the custom message properties.
	CustomMessageProperties map[string]*string

	// Gets or sets the message.
	Message *string

	// Gets or sets the namespace.
	Namespace *string

	// Gets or sets the transport type.
	TransportType *ServiceBusTransportType
}

type ServiceBusQueueMessage struct {
	// Gets or sets the Service Bus authentication.
	Authentication *ServiceBusAuthentication

	// Gets or sets the brokered message properties.
	BrokeredMessageProperties *ServiceBusBrokeredMessageProperties

	// Gets or sets the custom message properties.
	CustomMessageProperties map[string]*string

	// Gets or sets the message.
	Message *string

	// Gets or sets the namespace.
	Namespace *string

	// Gets or sets the queue name.
	QueueName *string

	// Gets or sets the transport type.
	TransportType *ServiceBusTransportType
}

type ServiceBusTopicMessage struct {
	// Gets or sets the Service Bus authentication.
	Authentication *ServiceBusAuthentication

	// Gets or sets the brokered message properties.
	BrokeredMessageProperties *ServiceBusBrokeredMessageProperties

	// Gets or sets the custom message properties.
	CustomMessageProperties map[string]*string

	// Gets or sets the message.
	Message *string

	// Gets or sets the namespace.
	Namespace *string

	// Gets or sets the topic path.
	TopicPath *string

	// Gets or sets the transport type.
	TransportType *ServiceBusTransportType
}

type StorageQueueMessage struct {
	// Gets or sets the message.
	Message *string

	// Gets or sets the queue name.
	QueueName *string

	// Gets or sets the SAS key.
	SasToken *string

	// Gets or sets the storage account name.
	StorageAccount *string
}
