//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/saas/armsaas"
	"net/http"
	"net/url"
	"regexp"
)

// Server is a fake server for instances of the armsaas.Client type.
type Server struct {
	// BeginCreateResource is the fake for method Client.BeginCreateResource
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateResource func(ctx context.Context, parameters armsaas.ResourceCreation, options *armsaas.ClientBeginCreateResourceOptions) (resp azfake.PollerResponder[armsaas.ClientCreateResourceResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method Client.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceID string, parameters armsaas.DeleteOptions, options *armsaas.ClientBeginDeleteOptions) (resp azfake.PollerResponder[armsaas.ClientDeleteResponse], errResp azfake.ErrorResponder)

	// GetResource is the fake for method Client.GetResource
	// HTTP status codes to indicate success: http.StatusOK
	GetResource func(ctx context.Context, resourceID string, options *armsaas.ClientGetResourceOptions) (resp azfake.Responder[armsaas.ClientGetResourceResponse], errResp azfake.ErrorResponder)

	// BeginUpdateResource is the fake for method Client.BeginUpdateResource
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginUpdateResource func(ctx context.Context, resourceID string, parameters armsaas.ResourceCreation, options *armsaas.ClientBeginUpdateResourceOptions) (resp azfake.PollerResponder[armsaas.ClientUpdateResourceResponse], errResp azfake.ErrorResponder)
}

// NewServerTransport creates a new instance of ServerTransport with the provided implementation.
// The returned ServerTransport instance is connected to an instance of armsaas.Client via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerTransport(srv *Server) *ServerTransport {
	return &ServerTransport{
		srv:                 srv,
		beginCreateResource: newTracker[azfake.PollerResponder[armsaas.ClientCreateResourceResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armsaas.ClientDeleteResponse]](),
		beginUpdateResource: newTracker[azfake.PollerResponder[armsaas.ClientUpdateResourceResponse]](),
	}
}

// ServerTransport connects instances of armsaas.Client to instances of Server.
// Don't use this type directly, use NewServerTransport instead.
type ServerTransport struct {
	srv                 *Server
	beginCreateResource *tracker[azfake.PollerResponder[armsaas.ClientCreateResourceResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armsaas.ClientDeleteResponse]]
	beginUpdateResource *tracker[azfake.PollerResponder[armsaas.ClientUpdateResourceResponse]]
}

// Do implements the policy.Transporter interface for ServerTransport.
func (s *ServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "Client.BeginCreateResource":
		resp, err = s.dispatchBeginCreateResource(req)
	case "Client.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "Client.GetResource":
		resp, err = s.dispatchGetResource(req)
	case "Client.BeginUpdateResource":
		resp, err = s.dispatchBeginUpdateResource(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServerTransport) dispatchBeginCreateResource(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateResource not implemented")}
	}
	beginCreateResource := s.beginCreateResource.get(req)
	if beginCreateResource == nil {
		body, err := server.UnmarshalRequestAsJSON[armsaas.ResourceCreation](req)
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateResource(req.Context(), body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateResource = &respr
		s.beginCreateResource.add(req, beginCreateResource)
	}

	resp, err := server.PollerResponderNext(beginCreateResource, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateResource.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateResource) {
		s.beginCreateResource.remove(req)
	}

	return resp, nil
}

func (s *ServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/providers/Microsoft\.SaaS/saasresources/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsaas.DeleteOptions](req)
		if err != nil {
			return nil, err
		}
		resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *ServerTransport) dispatchGetResource(req *http.Request) (*http.Response, error) {
	if s.srv.GetResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetResource not implemented")}
	}
	const regexStr = `/providers/Microsoft\.SaaS/saasresources/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetResource(req.Context(), resourceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Resource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerTransport) dispatchBeginUpdateResource(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdateResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateResource not implemented")}
	}
	beginUpdateResource := s.beginUpdateResource.get(req)
	if beginUpdateResource == nil {
		const regexStr = `/providers/Microsoft\.SaaS/saasresources/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsaas.ResourceCreation](req)
		if err != nil {
			return nil, err
		}
		resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdateResource(req.Context(), resourceIDParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateResource = &respr
		s.beginUpdateResource.add(req, beginUpdateResource)
	}

	resp, err := server.PollerResponderNext(beginUpdateResource, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginUpdateResource.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateResource) {
		s.beginUpdateResource.remove(req)
	}

	return resp, nil
}
