//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armresources"
	"net/http"
	"net/url"
	"regexp"
)

// ProviderResourceTypesServer is a fake server for instances of the armresources.ProviderResourceTypesClient type.
type ProviderResourceTypesServer struct {
	// List is the fake for method ProviderResourceTypesClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceProviderNamespace string, options *armresources.ProviderResourceTypesClientListOptions) (resp azfake.Responder[armresources.ProviderResourceTypesClientListResponse], errResp azfake.ErrorResponder)
}

// NewProviderResourceTypesServerTransport creates a new instance of ProviderResourceTypesServerTransport with the provided implementation.
// The returned ProviderResourceTypesServerTransport instance is connected to an instance of armresources.ProviderResourceTypesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewProviderResourceTypesServerTransport(srv *ProviderResourceTypesServer) *ProviderResourceTypesServerTransport {
	return &ProviderResourceTypesServerTransport{srv: srv}
}

// ProviderResourceTypesServerTransport connects instances of armresources.ProviderResourceTypesClient to instances of ProviderResourceTypesServer.
// Don't use this type directly, use NewProviderResourceTypesServerTransport instead.
type ProviderResourceTypesServerTransport struct {
	srv *ProviderResourceTypesServer
}

// Do implements the policy.Transporter interface for ProviderResourceTypesServerTransport.
func (p *ProviderResourceTypesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ProviderResourceTypesClient.List":
		resp, err = p.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *ProviderResourceTypesServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if p.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceTypes`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
	if err != nil {
		return nil, err
	}
	var options *armresources.ProviderResourceTypesClientListOptions
	if expandParam != nil {
		options = &armresources.ProviderResourceTypesClientListOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := p.srv.List(req.Context(), resourceProviderNamespaceParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProviderResourceTypeListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
