//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armpolicy"
	"net/http"
	"net/url"
	"regexp"
)

// DataPolicyManifestsServer is a fake server for instances of the armpolicy.DataPolicyManifestsClient type.
type DataPolicyManifestsServer struct {
	// GetByPolicyMode is the fake for method DataPolicyManifestsClient.GetByPolicyMode
	// HTTP status codes to indicate success: http.StatusOK
	GetByPolicyMode func(ctx context.Context, policyMode string, options *armpolicy.DataPolicyManifestsClientGetByPolicyModeOptions) (resp azfake.Responder[armpolicy.DataPolicyManifestsClientGetByPolicyModeResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method DataPolicyManifestsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armpolicy.DataPolicyManifestsClientListOptions) (resp azfake.PagerResponder[armpolicy.DataPolicyManifestsClientListResponse])
}

// NewDataPolicyManifestsServerTransport creates a new instance of DataPolicyManifestsServerTransport with the provided implementation.
// The returned DataPolicyManifestsServerTransport instance is connected to an instance of armpolicy.DataPolicyManifestsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDataPolicyManifestsServerTransport(srv *DataPolicyManifestsServer) *DataPolicyManifestsServerTransport {
	return &DataPolicyManifestsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armpolicy.DataPolicyManifestsClientListResponse]](),
	}
}

// DataPolicyManifestsServerTransport connects instances of armpolicy.DataPolicyManifestsClient to instances of DataPolicyManifestsServer.
// Don't use this type directly, use NewDataPolicyManifestsServerTransport instead.
type DataPolicyManifestsServerTransport struct {
	srv          *DataPolicyManifestsServer
	newListPager *tracker[azfake.PagerResponder[armpolicy.DataPolicyManifestsClientListResponse]]
}

// Do implements the policy.Transporter interface for DataPolicyManifestsServerTransport.
func (d *DataPolicyManifestsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DataPolicyManifestsClient.GetByPolicyMode":
		resp, err = d.dispatchGetByPolicyMode(req)
	case "DataPolicyManifestsClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DataPolicyManifestsServerTransport) dispatchGetByPolicyMode(req *http.Request) (*http.Response, error) {
	if d.srv.GetByPolicyMode == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByPolicyMode not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Authorization/dataPolicyManifests/(?P<policyMode>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	policyModeParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyMode")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetByPolicyMode(req.Context(), policyModeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataPolicyManifest, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataPolicyManifestsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armpolicy.DataPolicyManifestsClientListOptions
		if filterParam != nil {
			options = &armpolicy.DataPolicyManifestsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := d.srv.NewListPager(options)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armpolicy.DataPolicyManifestsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}
