//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/redis/armredis/v3"
	"net/http"
	"net/url"
	"regexp"
)

// PatchSchedulesServer is a fake server for instances of the armredis.PatchSchedulesClient type.
type PatchSchedulesServer struct {
	// CreateOrUpdate is the fake for method PatchSchedulesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, name string, defaultParam armredis.DefaultName, parameters armredis.PatchSchedule, options *armredis.PatchSchedulesClientCreateOrUpdateOptions) (resp azfake.Responder[armredis.PatchSchedulesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method PatchSchedulesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, name string, defaultParam armredis.DefaultName, options *armredis.PatchSchedulesClientDeleteOptions) (resp azfake.Responder[armredis.PatchSchedulesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PatchSchedulesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, name string, defaultParam armredis.DefaultName, options *armredis.PatchSchedulesClientGetOptions) (resp azfake.Responder[armredis.PatchSchedulesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByRedisResourcePager is the fake for method PatchSchedulesClient.NewListByRedisResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByRedisResourcePager func(resourceGroupName string, cacheName string, options *armredis.PatchSchedulesClientListByRedisResourceOptions) (resp azfake.PagerResponder[armredis.PatchSchedulesClientListByRedisResourceResponse])
}

// NewPatchSchedulesServerTransport creates a new instance of PatchSchedulesServerTransport with the provided implementation.
// The returned PatchSchedulesServerTransport instance is connected to an instance of armredis.PatchSchedulesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPatchSchedulesServerTransport(srv *PatchSchedulesServer) *PatchSchedulesServerTransport {
	return &PatchSchedulesServerTransport{
		srv:                         srv,
		newListByRedisResourcePager: newTracker[azfake.PagerResponder[armredis.PatchSchedulesClientListByRedisResourceResponse]](),
	}
}

// PatchSchedulesServerTransport connects instances of armredis.PatchSchedulesClient to instances of PatchSchedulesServer.
// Don't use this type directly, use NewPatchSchedulesServerTransport instead.
type PatchSchedulesServerTransport struct {
	srv                         *PatchSchedulesServer
	newListByRedisResourcePager *tracker[azfake.PagerResponder[armredis.PatchSchedulesClientListByRedisResourceResponse]]
}

// Do implements the policy.Transporter interface for PatchSchedulesServerTransport.
func (p *PatchSchedulesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PatchSchedulesClient.CreateOrUpdate":
		resp, err = p.dispatchCreateOrUpdate(req)
	case "PatchSchedulesClient.Delete":
		resp, err = p.dispatchDelete(req)
	case "PatchSchedulesClient.Get":
		resp, err = p.dispatchGet(req)
	case "PatchSchedulesClient.NewListByRedisResourcePager":
		resp, err = p.dispatchNewListByRedisResourcePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PatchSchedulesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cache/redis/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/patchSchedules/(?P<default>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armredis.PatchSchedule](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	defaultParamParam, err := parseWithCast(matches[regex.SubexpIndex("default")], func(v string) (armredis.DefaultName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armredis.DefaultName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, nameParam, defaultParamParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PatchSchedule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PatchSchedulesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if p.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cache/redis/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/patchSchedules/(?P<default>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	defaultParamParam, err := parseWithCast(matches[regex.SubexpIndex("default")], func(v string) (armredis.DefaultName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armredis.DefaultName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Delete(req.Context(), resourceGroupNameParam, nameParam, defaultParamParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PatchSchedulesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cache/redis/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/patchSchedules/(?P<default>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	defaultParamParam, err := parseWithCast(matches[regex.SubexpIndex("default")], func(v string) (armredis.DefaultName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armredis.DefaultName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, nameParam, defaultParamParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PatchSchedule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PatchSchedulesServerTransport) dispatchNewListByRedisResourcePager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByRedisResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByRedisResourcePager not implemented")}
	}
	newListByRedisResourcePager := p.newListByRedisResourcePager.get(req)
	if newListByRedisResourcePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cache/redis/(?P<cacheName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/patchSchedules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		cacheNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("cacheName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByRedisResourcePager(resourceGroupNameParam, cacheNameParam, nil)
		newListByRedisResourcePager = &resp
		p.newListByRedisResourcePager.add(req, newListByRedisResourcePager)
		server.PagerResponderInjectNextLinks(newListByRedisResourcePager, req, func(page *armredis.PatchSchedulesClientListByRedisResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByRedisResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByRedisResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByRedisResourcePager) {
		p.newListByRedisResourcePager.remove(req)
	}
	return resp, nil
}
