//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ReplicationNetworkMappingsServer is a fake server for instances of the armrecoveryservicessiterecovery.ReplicationNetworkMappingsClient type.
type ReplicationNetworkMappingsServer struct {
	// BeginCreate is the fake for method ReplicationNetworkMappingsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, networkName string, networkMappingName string, input armrecoveryservicessiterecovery.CreateNetworkMappingInput, options *armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientBeginCreateOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ReplicationNetworkMappingsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, networkName string, networkMappingName string, options *armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientBeginDeleteOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ReplicationNetworkMappingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, networkName string, networkMappingName string, options *armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientGetOptions) (resp azfake.Responder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ReplicationNetworkMappingsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceName string, resourceGroupName string, options *armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientListOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientListResponse])

	// NewListByReplicationNetworksPager is the fake for method ReplicationNetworkMappingsClient.NewListByReplicationNetworksPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByReplicationNetworksPager func(resourceName string, resourceGroupName string, fabricName string, networkName string, options *armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientListByReplicationNetworksOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientListByReplicationNetworksResponse])

	// BeginUpdate is the fake for method ReplicationNetworkMappingsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, networkName string, networkMappingName string, input armrecoveryservicessiterecovery.UpdateNetworkMappingInput, options *armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientBeginUpdateOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewReplicationNetworkMappingsServerTransport creates a new instance of ReplicationNetworkMappingsServerTransport with the provided implementation.
// The returned ReplicationNetworkMappingsServerTransport instance is connected to an instance of armrecoveryservicessiterecovery.ReplicationNetworkMappingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReplicationNetworkMappingsServerTransport(srv *ReplicationNetworkMappingsServer) *ReplicationNetworkMappingsServerTransport {
	return &ReplicationNetworkMappingsServerTransport{
		srv:                               srv,
		beginCreate:                       newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientCreateResponse]](),
		beginDelete:                       newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientDeleteResponse]](),
		newListPager:                      newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientListResponse]](),
		newListByReplicationNetworksPager: newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientListByReplicationNetworksResponse]](),
		beginUpdate:                       newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientUpdateResponse]](),
	}
}

// ReplicationNetworkMappingsServerTransport connects instances of armrecoveryservicessiterecovery.ReplicationNetworkMappingsClient to instances of ReplicationNetworkMappingsServer.
// Don't use this type directly, use NewReplicationNetworkMappingsServerTransport instead.
type ReplicationNetworkMappingsServerTransport struct {
	srv                               *ReplicationNetworkMappingsServer
	beginCreate                       *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientCreateResponse]]
	beginDelete                       *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientDeleteResponse]]
	newListPager                      *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientListResponse]]
	newListByReplicationNetworksPager *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientListByReplicationNetworksResponse]]
	beginUpdate                       *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for ReplicationNetworkMappingsServerTransport.
func (r *ReplicationNetworkMappingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReplicationNetworkMappingsClient.BeginCreate":
		resp, err = r.dispatchBeginCreate(req)
	case "ReplicationNetworkMappingsClient.BeginDelete":
		resp, err = r.dispatchBeginDelete(req)
	case "ReplicationNetworkMappingsClient.Get":
		resp, err = r.dispatchGet(req)
	case "ReplicationNetworkMappingsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "ReplicationNetworkMappingsClient.NewListByReplicationNetworksPager":
		resp, err = r.dispatchNewListByReplicationNetworksPager(req)
	case "ReplicationNetworkMappingsClient.BeginUpdate":
		resp, err = r.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReplicationNetworkMappingsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := r.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationNetworks/(?P<networkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationNetworkMappings/(?P<networkMappingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.CreateNetworkMappingInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		networkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkName")])
		if err != nil {
			return nil, err
		}
		networkMappingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkMappingName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCreate(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, networkNameParam, networkMappingNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		r.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		r.beginCreate.remove(req)
	}

	return resp, nil
}

func (r *ReplicationNetworkMappingsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if r.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := r.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationNetworks/(?P<networkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationNetworkMappings/(?P<networkMappingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		networkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkName")])
		if err != nil {
			return nil, err
		}
		networkMappingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkMappingName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginDelete(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, networkNameParam, networkMappingNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		r.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		r.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		r.beginDelete.remove(req)
	}

	return resp, nil
}

func (r *ReplicationNetworkMappingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationNetworks/(?P<networkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationNetworkMappings/(?P<networkMappingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	networkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkName")])
	if err != nil {
		return nil, err
	}
	networkMappingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkMappingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, networkNameParam, networkMappingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkMapping, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReplicationNetworkMappingsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationNetworkMappings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListPager(resourceNameParam, resourceGroupNameParam, nil)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *ReplicationNetworkMappingsServerTransport) dispatchNewListByReplicationNetworksPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByReplicationNetworksPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByReplicationNetworksPager not implemented")}
	}
	newListByReplicationNetworksPager := r.newListByReplicationNetworksPager.get(req)
	if newListByReplicationNetworksPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationNetworks/(?P<networkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationNetworkMappings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		networkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByReplicationNetworksPager(resourceNameParam, resourceGroupNameParam, fabricNameParam, networkNameParam, nil)
		newListByReplicationNetworksPager = &resp
		r.newListByReplicationNetworksPager.add(req, newListByReplicationNetworksPager)
		server.PagerResponderInjectNextLinks(newListByReplicationNetworksPager, req, func(page *armrecoveryservicessiterecovery.ReplicationNetworkMappingsClientListByReplicationNetworksResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByReplicationNetworksPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByReplicationNetworksPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByReplicationNetworksPager) {
		r.newListByReplicationNetworksPager.remove(req)
	}
	return resp, nil
}

func (r *ReplicationNetworkMappingsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := r.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationNetworks/(?P<networkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationNetworkMappings/(?P<networkMappingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.UpdateNetworkMappingInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		networkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkName")])
		if err != nil {
			return nil, err
		}
		networkMappingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkMappingName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginUpdate(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, networkNameParam, networkMappingNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		r.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		r.beginUpdate.remove(req)
	}

	return resp, nil
}
