//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v4"
	"net/http"
	"net/url"
	"regexp"
)

// ProtectionIntentServer is a fake server for instances of the armrecoveryservicesbackup.ProtectionIntentClient type.
type ProtectionIntentServer struct {
	// CreateOrUpdate is the fake for method ProtectionIntentClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, vaultName string, resourceGroupName string, fabricName string, intentObjectName string, parameters armrecoveryservicesbackup.ProtectionIntentResource, options *armrecoveryservicesbackup.ProtectionIntentClientCreateOrUpdateOptions) (resp azfake.Responder[armrecoveryservicesbackup.ProtectionIntentClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ProtectionIntentClient.Delete
	// HTTP status codes to indicate success: http.StatusNoContent
	Delete func(ctx context.Context, vaultName string, resourceGroupName string, fabricName string, intentObjectName string, options *armrecoveryservicesbackup.ProtectionIntentClientDeleteOptions) (resp azfake.Responder[armrecoveryservicesbackup.ProtectionIntentClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ProtectionIntentClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, vaultName string, resourceGroupName string, fabricName string, intentObjectName string, options *armrecoveryservicesbackup.ProtectionIntentClientGetOptions) (resp azfake.Responder[armrecoveryservicesbackup.ProtectionIntentClientGetResponse], errResp azfake.ErrorResponder)

	// Validate is the fake for method ProtectionIntentClient.Validate
	// HTTP status codes to indicate success: http.StatusOK
	Validate func(ctx context.Context, azureRegion string, parameters armrecoveryservicesbackup.PreValidateEnableBackupRequest, options *armrecoveryservicesbackup.ProtectionIntentClientValidateOptions) (resp azfake.Responder[armrecoveryservicesbackup.ProtectionIntentClientValidateResponse], errResp azfake.ErrorResponder)
}

// NewProtectionIntentServerTransport creates a new instance of ProtectionIntentServerTransport with the provided implementation.
// The returned ProtectionIntentServerTransport instance is connected to an instance of armrecoveryservicesbackup.ProtectionIntentClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewProtectionIntentServerTransport(srv *ProtectionIntentServer) *ProtectionIntentServerTransport {
	return &ProtectionIntentServerTransport{srv: srv}
}

// ProtectionIntentServerTransport connects instances of armrecoveryservicesbackup.ProtectionIntentClient to instances of ProtectionIntentServer.
// Don't use this type directly, use NewProtectionIntentServerTransport instead.
type ProtectionIntentServerTransport struct {
	srv *ProtectionIntentServer
}

// Do implements the policy.Transporter interface for ProtectionIntentServerTransport.
func (p *ProtectionIntentServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ProtectionIntentClient.CreateOrUpdate":
		resp, err = p.dispatchCreateOrUpdate(req)
	case "ProtectionIntentClient.Delete":
		resp, err = p.dispatchDelete(req)
	case "ProtectionIntentClient.Get":
		resp, err = p.dispatchGet(req)
	case "ProtectionIntentClient.Validate":
		resp, err = p.dispatchValidate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *ProtectionIntentServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/Subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupProtectionIntent/(?P<intentObjectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armrecoveryservicesbackup.ProtectionIntentResource](req)
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	intentObjectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("intentObjectName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.CreateOrUpdate(req.Context(), vaultNameParam, resourceGroupNameParam, fabricNameParam, intentObjectNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProtectionIntentResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProtectionIntentServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if p.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/Subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupProtectionIntent/(?P<intentObjectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	intentObjectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("intentObjectName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Delete(req.Context(), vaultNameParam, resourceGroupNameParam, fabricNameParam, intentObjectNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProtectionIntentServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/Subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupProtectionIntent/(?P<intentObjectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	intentObjectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("intentObjectName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), vaultNameParam, resourceGroupNameParam, fabricNameParam, intentObjectNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProtectionIntentResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProtectionIntentServerTransport) dispatchValidate(req *http.Request) (*http.Response, error) {
	if p.srv.Validate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Validate not implemented")}
	}
	const regexStr = `/Subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/locations/(?P<azureRegion>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupPreValidateProtection`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armrecoveryservicesbackup.PreValidateEnableBackupRequest](req)
	if err != nil {
		return nil, err
	}
	azureRegionParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureRegion")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Validate(req.Context(), azureRegionParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PreValidateEnableBackupResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
