//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpowerbiprivatelinks

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// PrivateLinkServicesForPowerBIClient contains the methods for the PrivateLinkServicesForPowerBI group.
// Don't use this type directly, use NewPrivateLinkServicesForPowerBIClient() instead.
type PrivateLinkServicesForPowerBIClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewPrivateLinkServicesForPowerBIClient creates a new instance of PrivateLinkServicesForPowerBIClient with the specified values.
//   - subscriptionID - The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewPrivateLinkServicesForPowerBIClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*PrivateLinkServicesForPowerBIClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &PrivateLinkServicesForPowerBIClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// ListBySubscriptionID - Gets all the private link resources for the given subscription id.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-06-01
//   - options - PrivateLinkServicesForPowerBIClientListBySubscriptionIDOptions contains the optional parameters for the PrivateLinkServicesForPowerBIClient.ListBySubscriptionID
//     method.
func (client *PrivateLinkServicesForPowerBIClient) ListBySubscriptionID(ctx context.Context, options *PrivateLinkServicesForPowerBIClientListBySubscriptionIDOptions) (PrivateLinkServicesForPowerBIClientListBySubscriptionIDResponse, error) {
	var err error
	const operationName = "PrivateLinkServicesForPowerBIClient.ListBySubscriptionID"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listBySubscriptionIDCreateRequest(ctx, options)
	if err != nil {
		return PrivateLinkServicesForPowerBIClientListBySubscriptionIDResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PrivateLinkServicesForPowerBIClientListBySubscriptionIDResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PrivateLinkServicesForPowerBIClientListBySubscriptionIDResponse{}, err
	}
	resp, err := client.listBySubscriptionIDHandleResponse(httpResp)
	return resp, err
}

// listBySubscriptionIDCreateRequest creates the ListBySubscriptionID request.
func (client *PrivateLinkServicesForPowerBIClient) listBySubscriptionIDCreateRequest(ctx context.Context, options *PrivateLinkServicesForPowerBIClientListBySubscriptionIDOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PowerBI/privateLinkServicesForPowerBI"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionIDHandleResponse handles the ListBySubscriptionID response.
func (client *PrivateLinkServicesForPowerBIClient) listBySubscriptionIDHandleResponse(resp *http.Response) (PrivateLinkServicesForPowerBIClientListBySubscriptionIDResponse, error) {
	result := PrivateLinkServicesForPowerBIClientListBySubscriptionIDResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TenantResourceArray); err != nil {
		return PrivateLinkServicesForPowerBIClientListBySubscriptionIDResponse{}, err
	}
	return result, nil
}
