//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/peering/armpeering"
	"net/http"
	"net/url"
	"regexp"
)

// PrefixesServer is a fake server for instances of the armpeering.PrefixesClient type.
type PrefixesServer struct {
	// CreateOrUpdate is the fake for method PrefixesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, peeringServiceName string, prefixName string, peeringServicePrefix armpeering.ServicePrefix, options *armpeering.PrefixesClientCreateOrUpdateOptions) (resp azfake.Responder[armpeering.PrefixesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method PrefixesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, peeringServiceName string, prefixName string, options *armpeering.PrefixesClientDeleteOptions) (resp azfake.Responder[armpeering.PrefixesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PrefixesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, peeringServiceName string, prefixName string, options *armpeering.PrefixesClientGetOptions) (resp azfake.Responder[armpeering.PrefixesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByPeeringServicePager is the fake for method PrefixesClient.NewListByPeeringServicePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByPeeringServicePager func(resourceGroupName string, peeringServiceName string, options *armpeering.PrefixesClientListByPeeringServiceOptions) (resp azfake.PagerResponder[armpeering.PrefixesClientListByPeeringServiceResponse])
}

// NewPrefixesServerTransport creates a new instance of PrefixesServerTransport with the provided implementation.
// The returned PrefixesServerTransport instance is connected to an instance of armpeering.PrefixesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrefixesServerTransport(srv *PrefixesServer) *PrefixesServerTransport {
	return &PrefixesServerTransport{
		srv:                          srv,
		newListByPeeringServicePager: newTracker[azfake.PagerResponder[armpeering.PrefixesClientListByPeeringServiceResponse]](),
	}
}

// PrefixesServerTransport connects instances of armpeering.PrefixesClient to instances of PrefixesServer.
// Don't use this type directly, use NewPrefixesServerTransport instead.
type PrefixesServerTransport struct {
	srv                          *PrefixesServer
	newListByPeeringServicePager *tracker[azfake.PagerResponder[armpeering.PrefixesClientListByPeeringServiceResponse]]
}

// Do implements the policy.Transporter interface for PrefixesServerTransport.
func (p *PrefixesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrefixesClient.CreateOrUpdate":
		resp, err = p.dispatchCreateOrUpdate(req)
	case "PrefixesClient.Delete":
		resp, err = p.dispatchDelete(req)
	case "PrefixesClient.Get":
		resp, err = p.dispatchGet(req)
	case "PrefixesClient.NewListByPeeringServicePager":
		resp, err = p.dispatchNewListByPeeringServicePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrefixesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peeringServices/(?P<peeringServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/prefixes/(?P<prefixName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpeering.ServicePrefix](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	peeringServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringServiceName")])
	if err != nil {
		return nil, err
	}
	prefixNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("prefixName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, peeringServiceNameParam, prefixNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServicePrefix, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrefixesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if p.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peeringServices/(?P<peeringServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/prefixes/(?P<prefixName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	peeringServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringServiceName")])
	if err != nil {
		return nil, err
	}
	prefixNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("prefixName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Delete(req.Context(), resourceGroupNameParam, peeringServiceNameParam, prefixNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrefixesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peeringServices/(?P<peeringServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/prefixes/(?P<prefixName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	peeringServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringServiceName")])
	if err != nil {
		return nil, err
	}
	prefixNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("prefixName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armpeering.PrefixesClientGetOptions
	if expandParam != nil {
		options = &armpeering.PrefixesClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, peeringServiceNameParam, prefixNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServicePrefix, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrefixesServerTransport) dispatchNewListByPeeringServicePager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByPeeringServicePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByPeeringServicePager not implemented")}
	}
	newListByPeeringServicePager := p.newListByPeeringServicePager.get(req)
	if newListByPeeringServicePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Peering/peeringServices/(?P<peeringServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/prefixes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		peeringServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("peeringServiceName")])
		if err != nil {
			return nil, err
		}
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		var options *armpeering.PrefixesClientListByPeeringServiceOptions
		if expandParam != nil {
			options = &armpeering.PrefixesClientListByPeeringServiceOptions{
				Expand: expandParam,
			}
		}
		resp := p.srv.NewListByPeeringServicePager(resourceGroupNameParam, peeringServiceNameParam, options)
		newListByPeeringServicePager = &resp
		p.newListByPeeringServicePager.add(req, newListByPeeringServicePager)
		server.PagerResponderInjectNextLinks(newListByPeeringServicePager, req, func(page *armpeering.PrefixesClientListByPeeringServiceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByPeeringServicePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByPeeringServicePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByPeeringServicePager) {
		p.newListByPeeringServicePager.remove(req)
	}
	return resp, nil
}
