//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/paloaltonetworksngfw/armpanngfw"
	"net/http"
	"net/url"
	"regexp"
)

// PrefixListLocalRulestackServer is a fake server for instances of the armpanngfw.PrefixListLocalRulestackClient type.
type PrefixListLocalRulestackServer struct {
	// BeginCreateOrUpdate is the fake for method PrefixListLocalRulestackClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, localRulestackName string, name string, resource armpanngfw.PrefixListResource, options *armpanngfw.PrefixListLocalRulestackClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armpanngfw.PrefixListLocalRulestackClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method PrefixListLocalRulestackClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, localRulestackName string, name string, options *armpanngfw.PrefixListLocalRulestackClientBeginDeleteOptions) (resp azfake.PollerResponder[armpanngfw.PrefixListLocalRulestackClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PrefixListLocalRulestackClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, localRulestackName string, name string, options *armpanngfw.PrefixListLocalRulestackClientGetOptions) (resp azfake.Responder[armpanngfw.PrefixListLocalRulestackClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByLocalRulestacksPager is the fake for method PrefixListLocalRulestackClient.NewListByLocalRulestacksPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLocalRulestacksPager func(resourceGroupName string, localRulestackName string, options *armpanngfw.PrefixListLocalRulestackClientListByLocalRulestacksOptions) (resp azfake.PagerResponder[armpanngfw.PrefixListLocalRulestackClientListByLocalRulestacksResponse])
}

// NewPrefixListLocalRulestackServerTransport creates a new instance of PrefixListLocalRulestackServerTransport with the provided implementation.
// The returned PrefixListLocalRulestackServerTransport instance is connected to an instance of armpanngfw.PrefixListLocalRulestackClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrefixListLocalRulestackServerTransport(srv *PrefixListLocalRulestackServer) *PrefixListLocalRulestackServerTransport {
	return &PrefixListLocalRulestackServerTransport{
		srv:                           srv,
		beginCreateOrUpdate:           newTracker[azfake.PollerResponder[armpanngfw.PrefixListLocalRulestackClientCreateOrUpdateResponse]](),
		beginDelete:                   newTracker[azfake.PollerResponder[armpanngfw.PrefixListLocalRulestackClientDeleteResponse]](),
		newListByLocalRulestacksPager: newTracker[azfake.PagerResponder[armpanngfw.PrefixListLocalRulestackClientListByLocalRulestacksResponse]](),
	}
}

// PrefixListLocalRulestackServerTransport connects instances of armpanngfw.PrefixListLocalRulestackClient to instances of PrefixListLocalRulestackServer.
// Don't use this type directly, use NewPrefixListLocalRulestackServerTransport instead.
type PrefixListLocalRulestackServerTransport struct {
	srv                           *PrefixListLocalRulestackServer
	beginCreateOrUpdate           *tracker[azfake.PollerResponder[armpanngfw.PrefixListLocalRulestackClientCreateOrUpdateResponse]]
	beginDelete                   *tracker[azfake.PollerResponder[armpanngfw.PrefixListLocalRulestackClientDeleteResponse]]
	newListByLocalRulestacksPager *tracker[azfake.PagerResponder[armpanngfw.PrefixListLocalRulestackClientListByLocalRulestacksResponse]]
}

// Do implements the policy.Transporter interface for PrefixListLocalRulestackServerTransport.
func (p *PrefixListLocalRulestackServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrefixListLocalRulestackClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "PrefixListLocalRulestackClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "PrefixListLocalRulestackClient.Get":
		resp, err = p.dispatchGet(req)
	case "PrefixListLocalRulestackClient.NewListByLocalRulestacksPager":
		resp, err = p.dispatchNewListByLocalRulestacksPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrefixListLocalRulestackServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/prefixlists/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpanngfw.PrefixListResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, localRulestackNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *PrefixListLocalRulestackServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/prefixlists/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), resourceGroupNameParam, localRulestackNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *PrefixListLocalRulestackServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/prefixlists/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, localRulestackNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrefixListResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrefixListLocalRulestackServerTransport) dispatchNewListByLocalRulestacksPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByLocalRulestacksPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLocalRulestacksPager not implemented")}
	}
	newListByLocalRulestacksPager := p.newListByLocalRulestacksPager.get(req)
	if newListByLocalRulestacksPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/localRulestacks/(?P<localRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/prefixlists`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		localRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("localRulestackName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByLocalRulestacksPager(resourceGroupNameParam, localRulestackNameParam, nil)
		newListByLocalRulestacksPager = &resp
		p.newListByLocalRulestacksPager.add(req, newListByLocalRulestacksPager)
		server.PagerResponderInjectNextLinks(newListByLocalRulestacksPager, req, func(page *armpanngfw.PrefixListLocalRulestackClientListByLocalRulestacksResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLocalRulestacksPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByLocalRulestacksPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLocalRulestacksPager) {
		p.newListByLocalRulestacksPager.remove(req)
	}
	return resp, nil
}
