//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/migrationdiscovery/armmigrationdiscoverysap"
	"net/http"
	"net/url"
	"regexp"
)

// SapInstancesServer is a fake server for instances of the armmigrationdiscoverysap.SapInstancesClient type.
type SapInstancesServer struct {
	// BeginCreate is the fake for method SapInstancesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, resource armmigrationdiscoverysap.SAPInstance, options *armmigrationdiscoverysap.SapInstancesClientBeginCreateOptions) (resp azfake.PollerResponder[armmigrationdiscoverysap.SapInstancesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SapInstancesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, options *armmigrationdiscoverysap.SapInstancesClientBeginDeleteOptions) (resp azfake.PollerResponder[armmigrationdiscoverysap.SapInstancesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SapInstancesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, options *armmigrationdiscoverysap.SapInstancesClientGetOptions) (resp azfake.Responder[armmigrationdiscoverysap.SapInstancesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySapDiscoverySitePager is the fake for method SapInstancesClient.NewListBySapDiscoverySitePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySapDiscoverySitePager func(resourceGroupName string, sapDiscoverySiteName string, options *armmigrationdiscoverysap.SapInstancesClientListBySapDiscoverySiteOptions) (resp azfake.PagerResponder[armmigrationdiscoverysap.SapInstancesClientListBySapDiscoverySiteResponse])

	// Update is the fake for method SapInstancesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, properties armmigrationdiscoverysap.SAPInstanceTagsUpdate, options *armmigrationdiscoverysap.SapInstancesClientUpdateOptions) (resp azfake.Responder[armmigrationdiscoverysap.SapInstancesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewSapInstancesServerTransport creates a new instance of SapInstancesServerTransport with the provided implementation.
// The returned SapInstancesServerTransport instance is connected to an instance of armmigrationdiscoverysap.SapInstancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSapInstancesServerTransport(srv *SapInstancesServer) *SapInstancesServerTransport {
	return &SapInstancesServerTransport{
		srv:                            srv,
		beginCreate:                    newTracker[azfake.PollerResponder[armmigrationdiscoverysap.SapInstancesClientCreateResponse]](),
		beginDelete:                    newTracker[azfake.PollerResponder[armmigrationdiscoverysap.SapInstancesClientDeleteResponse]](),
		newListBySapDiscoverySitePager: newTracker[azfake.PagerResponder[armmigrationdiscoverysap.SapInstancesClientListBySapDiscoverySiteResponse]](),
	}
}

// SapInstancesServerTransport connects instances of armmigrationdiscoverysap.SapInstancesClient to instances of SapInstancesServer.
// Don't use this type directly, use NewSapInstancesServerTransport instead.
type SapInstancesServerTransport struct {
	srv                            *SapInstancesServer
	beginCreate                    *tracker[azfake.PollerResponder[armmigrationdiscoverysap.SapInstancesClientCreateResponse]]
	beginDelete                    *tracker[azfake.PollerResponder[armmigrationdiscoverysap.SapInstancesClientDeleteResponse]]
	newListBySapDiscoverySitePager *tracker[azfake.PagerResponder[armmigrationdiscoverysap.SapInstancesClientListBySapDiscoverySiteResponse]]
}

// Do implements the policy.Transporter interface for SapInstancesServerTransport.
func (s *SapInstancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SapInstancesClient.BeginCreate":
		resp, err = s.dispatchBeginCreate(req)
	case "SapInstancesClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SapInstancesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SapInstancesClient.NewListBySapDiscoverySitePager":
		resp, err = s.dispatchNewListBySapDiscoverySitePager(req)
	case "SapInstancesClient.Update":
		resp, err = s.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SapInstancesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := s.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapDiscoverySites/(?P<sapDiscoverySiteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sapInstances/(?P<sapInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmigrationdiscoverysap.SAPInstance](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapDiscoverySiteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapDiscoverySiteName")])
		if err != nil {
			return nil, err
		}
		sapInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreate(req.Context(), resourceGroupNameParam, sapDiscoverySiteNameParam, sapInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		s.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		s.beginCreate.remove(req)
	}

	return resp, nil
}

func (s *SapInstancesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapDiscoverySites/(?P<sapDiscoverySiteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sapInstances/(?P<sapInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapDiscoverySiteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapDiscoverySiteName")])
		if err != nil {
			return nil, err
		}
		sapInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, sapDiscoverySiteNameParam, sapInstanceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SapInstancesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapDiscoverySites/(?P<sapDiscoverySiteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sapInstances/(?P<sapInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	sapDiscoverySiteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapDiscoverySiteName")])
	if err != nil {
		return nil, err
	}
	sapInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, sapDiscoverySiteNameParam, sapInstanceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SAPInstance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SapInstancesServerTransport) dispatchNewListBySapDiscoverySitePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySapDiscoverySitePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySapDiscoverySitePager not implemented")}
	}
	newListBySapDiscoverySitePager := s.newListBySapDiscoverySitePager.get(req)
	if newListBySapDiscoverySitePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapDiscoverySites/(?P<sapDiscoverySiteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sapInstances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapDiscoverySiteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapDiscoverySiteName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListBySapDiscoverySitePager(resourceGroupNameParam, sapDiscoverySiteNameParam, nil)
		newListBySapDiscoverySitePager = &resp
		s.newListBySapDiscoverySitePager.add(req, newListBySapDiscoverySitePager)
		server.PagerResponderInjectNextLinks(newListBySapDiscoverySitePager, req, func(page *armmigrationdiscoverysap.SapInstancesClientListBySapDiscoverySiteResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySapDiscoverySitePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySapDiscoverySitePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySapDiscoverySitePager) {
		s.newListBySapDiscoverySitePager.remove(req)
	}
	return resp, nil
}

func (s *SapInstancesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapDiscoverySites/(?P<sapDiscoverySiteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sapInstances/(?P<sapInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmigrationdiscoverysap.SAPInstanceTagsUpdate](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	sapDiscoverySiteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapDiscoverySiteName")])
	if err != nil {
		return nil, err
	}
	sapInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Update(req.Context(), resourceGroupNameParam, sapDiscoverySiteNameParam, sapInstanceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SAPInstance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
