//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armmediaservices.ClientFactory type.
type ServerFactory struct {
	AccountFiltersServer              AccountFiltersServer
	AssetFiltersServer                AssetFiltersServer
	AssetTrackOperationResultsServer  AssetTrackOperationResultsServer
	AssetTrackOperationStatusesServer AssetTrackOperationStatusesServer
	AssetsServer                      AssetsServer
	Server                            Server
	ContentKeyPoliciesServer          ContentKeyPoliciesServer
	JobsServer                        JobsServer
	LiveEventsServer                  LiveEventsServer
	LiveOutputsServer                 LiveOutputsServer
	LocationsServer                   LocationsServer
	OperationResultsServer            OperationResultsServer
	OperationStatusesServer           OperationStatusesServer
	OperationsServer                  OperationsServer
	PrivateEndpointConnectionsServer  PrivateEndpointConnectionsServer
	PrivateLinkResourcesServer        PrivateLinkResourcesServer
	StreamingEndpointsServer          StreamingEndpointsServer
	StreamingLocatorsServer           StreamingLocatorsServer
	StreamingPoliciesServer           StreamingPoliciesServer
	TracksServer                      TracksServer
	TransformsServer                  TransformsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armmediaservices.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armmediaservices.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                 *ServerFactory
	trMu                                sync.Mutex
	trAccountFiltersServer              *AccountFiltersServerTransport
	trAssetFiltersServer                *AssetFiltersServerTransport
	trAssetTrackOperationResultsServer  *AssetTrackOperationResultsServerTransport
	trAssetTrackOperationStatusesServer *AssetTrackOperationStatusesServerTransport
	trAssetsServer                      *AssetsServerTransport
	trServer                            *ServerTransport
	trContentKeyPoliciesServer          *ContentKeyPoliciesServerTransport
	trJobsServer                        *JobsServerTransport
	trLiveEventsServer                  *LiveEventsServerTransport
	trLiveOutputsServer                 *LiveOutputsServerTransport
	trLocationsServer                   *LocationsServerTransport
	trOperationResultsServer            *OperationResultsServerTransport
	trOperationStatusesServer           *OperationStatusesServerTransport
	trOperationsServer                  *OperationsServerTransport
	trPrivateEndpointConnectionsServer  *PrivateEndpointConnectionsServerTransport
	trPrivateLinkResourcesServer        *PrivateLinkResourcesServerTransport
	trStreamingEndpointsServer          *StreamingEndpointsServerTransport
	trStreamingLocatorsServer           *StreamingLocatorsServerTransport
	trStreamingPoliciesServer           *StreamingPoliciesServerTransport
	trTracksServer                      *TracksServerTransport
	trTransformsServer                  *TransformsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AccountFiltersClient":
		initServer(s, &s.trAccountFiltersServer, func() *AccountFiltersServerTransport {
			return NewAccountFiltersServerTransport(&s.srv.AccountFiltersServer)
		})
		resp, err = s.trAccountFiltersServer.Do(req)
	case "AssetFiltersClient":
		initServer(s, &s.trAssetFiltersServer, func() *AssetFiltersServerTransport { return NewAssetFiltersServerTransport(&s.srv.AssetFiltersServer) })
		resp, err = s.trAssetFiltersServer.Do(req)
	case "AssetTrackOperationResultsClient":
		initServer(s, &s.trAssetTrackOperationResultsServer, func() *AssetTrackOperationResultsServerTransport {
			return NewAssetTrackOperationResultsServerTransport(&s.srv.AssetTrackOperationResultsServer)
		})
		resp, err = s.trAssetTrackOperationResultsServer.Do(req)
	case "AssetTrackOperationStatusesClient":
		initServer(s, &s.trAssetTrackOperationStatusesServer, func() *AssetTrackOperationStatusesServerTransport {
			return NewAssetTrackOperationStatusesServerTransport(&s.srv.AssetTrackOperationStatusesServer)
		})
		resp, err = s.trAssetTrackOperationStatusesServer.Do(req)
	case "AssetsClient":
		initServer(s, &s.trAssetsServer, func() *AssetsServerTransport { return NewAssetsServerTransport(&s.srv.AssetsServer) })
		resp, err = s.trAssetsServer.Do(req)
	case "Client":
		initServer(s, &s.trServer, func() *ServerTransport { return NewServerTransport(&s.srv.Server) })
		resp, err = s.trServer.Do(req)
	case "ContentKeyPoliciesClient":
		initServer(s, &s.trContentKeyPoliciesServer, func() *ContentKeyPoliciesServerTransport {
			return NewContentKeyPoliciesServerTransport(&s.srv.ContentKeyPoliciesServer)
		})
		resp, err = s.trContentKeyPoliciesServer.Do(req)
	case "JobsClient":
		initServer(s, &s.trJobsServer, func() *JobsServerTransport { return NewJobsServerTransport(&s.srv.JobsServer) })
		resp, err = s.trJobsServer.Do(req)
	case "LiveEventsClient":
		initServer(s, &s.trLiveEventsServer, func() *LiveEventsServerTransport { return NewLiveEventsServerTransport(&s.srv.LiveEventsServer) })
		resp, err = s.trLiveEventsServer.Do(req)
	case "LiveOutputsClient":
		initServer(s, &s.trLiveOutputsServer, func() *LiveOutputsServerTransport { return NewLiveOutputsServerTransport(&s.srv.LiveOutputsServer) })
		resp, err = s.trLiveOutputsServer.Do(req)
	case "LocationsClient":
		initServer(s, &s.trLocationsServer, func() *LocationsServerTransport { return NewLocationsServerTransport(&s.srv.LocationsServer) })
		resp, err = s.trLocationsServer.Do(req)
	case "OperationResultsClient":
		initServer(s, &s.trOperationResultsServer, func() *OperationResultsServerTransport {
			return NewOperationResultsServerTransport(&s.srv.OperationResultsServer)
		})
		resp, err = s.trOperationResultsServer.Do(req)
	case "OperationStatusesClient":
		initServer(s, &s.trOperationStatusesServer, func() *OperationStatusesServerTransport {
			return NewOperationStatusesServerTransport(&s.srv.OperationStatusesServer)
		})
		resp, err = s.trOperationStatusesServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PrivateEndpointConnectionsClient":
		initServer(s, &s.trPrivateEndpointConnectionsServer, func() *PrivateEndpointConnectionsServerTransport {
			return NewPrivateEndpointConnectionsServerTransport(&s.srv.PrivateEndpointConnectionsServer)
		})
		resp, err = s.trPrivateEndpointConnectionsServer.Do(req)
	case "PrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkResourcesServer, func() *PrivateLinkResourcesServerTransport {
			return NewPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkResourcesServer.Do(req)
	case "StreamingEndpointsClient":
		initServer(s, &s.trStreamingEndpointsServer, func() *StreamingEndpointsServerTransport {
			return NewStreamingEndpointsServerTransport(&s.srv.StreamingEndpointsServer)
		})
		resp, err = s.trStreamingEndpointsServer.Do(req)
	case "StreamingLocatorsClient":
		initServer(s, &s.trStreamingLocatorsServer, func() *StreamingLocatorsServerTransport {
			return NewStreamingLocatorsServerTransport(&s.srv.StreamingLocatorsServer)
		})
		resp, err = s.trStreamingLocatorsServer.Do(req)
	case "StreamingPoliciesClient":
		initServer(s, &s.trStreamingPoliciesServer, func() *StreamingPoliciesServerTransport {
			return NewStreamingPoliciesServerTransport(&s.srv.StreamingPoliciesServer)
		})
		resp, err = s.trStreamingPoliciesServer.Do(req)
	case "TracksClient":
		initServer(s, &s.trTracksServer, func() *TracksServerTransport { return NewTracksServerTransport(&s.srv.TracksServer) })
		resp, err = s.trTracksServer.Do(req)
	case "TransformsClient":
		initServer(s, &s.trTransformsServer, func() *TransformsServerTransport { return NewTransformsServerTransport(&s.srv.TransformsServer) })
		resp, err = s.trTransformsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
