//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armmanagementgroups.ClientFactory type.
type ServerFactory struct {
	APIServer                          APIServer
	Server                             Server
	EntitiesServer                     EntitiesServer
	HierarchySettingsServer            HierarchySettingsServer
	ManagementGroupSubscriptionsServer ManagementGroupSubscriptionsServer
	OperationsServer                   OperationsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armmanagementgroups.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armmanagementgroups.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                  *ServerFactory
	trMu                                 sync.Mutex
	trAPIServer                          *APIServerTransport
	trServer                             *ServerTransport
	trEntitiesServer                     *EntitiesServerTransport
	trHierarchySettingsServer            *HierarchySettingsServerTransport
	trManagementGroupSubscriptionsServer *ManagementGroupSubscriptionsServerTransport
	trOperationsServer                   *OperationsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "APIClient":
		initServer(s, &s.trAPIServer, func() *APIServerTransport { return NewAPIServerTransport(&s.srv.APIServer) })
		resp, err = s.trAPIServer.Do(req)
	case "Client":
		initServer(s, &s.trServer, func() *ServerTransport { return NewServerTransport(&s.srv.Server) })
		resp, err = s.trServer.Do(req)
	case "EntitiesClient":
		initServer(s, &s.trEntitiesServer, func() *EntitiesServerTransport { return NewEntitiesServerTransport(&s.srv.EntitiesServer) })
		resp, err = s.trEntitiesServer.Do(req)
	case "HierarchySettingsClient":
		initServer(s, &s.trHierarchySettingsServer, func() *HierarchySettingsServerTransport {
			return NewHierarchySettingsServerTransport(&s.srv.HierarchySettingsServer)
		})
		resp, err = s.trHierarchySettingsServer.Do(req)
	case "ManagementGroupSubscriptionsClient":
		initServer(s, &s.trManagementGroupSubscriptionsServer, func() *ManagementGroupSubscriptionsServerTransport {
			return NewManagementGroupSubscriptionsServerTransport(&s.srv.ManagementGroupSubscriptionsServer)
		})
		resp, err = s.trManagementGroupSubscriptionsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
