//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmaintenance

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ConfigurationAssignmentsForResourceGroupClient contains the methods for the ConfigurationAssignmentsForResourceGroup group.
// Don't use this type directly, use NewConfigurationAssignmentsForResourceGroupClient() instead.
type ConfigurationAssignmentsForResourceGroupClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewConfigurationAssignmentsForResourceGroupClient creates a new instance of ConfigurationAssignmentsForResourceGroupClient with the specified values.
//   - subscriptionID - Subscription credentials that uniquely identify a Microsoft Azure subscription. The subscription ID forms
//     part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewConfigurationAssignmentsForResourceGroupClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ConfigurationAssignmentsForResourceGroupClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ConfigurationAssignmentsForResourceGroupClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Register configuration for resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01
//   - resourceGroupName - Resource group name
//   - configurationAssignmentName - Configuration assignment name
//   - configurationAssignment - The configurationAssignment
//   - options - ConfigurationAssignmentsForResourceGroupClientCreateOrUpdateOptions contains the optional parameters for the
//     ConfigurationAssignmentsForResourceGroupClient.CreateOrUpdate method.
func (client *ConfigurationAssignmentsForResourceGroupClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, configurationAssignmentName string, configurationAssignment ConfigurationAssignment, options *ConfigurationAssignmentsForResourceGroupClientCreateOrUpdateOptions) (ConfigurationAssignmentsForResourceGroupClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "ConfigurationAssignmentsForResourceGroupClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, configurationAssignmentName, configurationAssignment, options)
	if err != nil {
		return ConfigurationAssignmentsForResourceGroupClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ConfigurationAssignmentsForResourceGroupClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ConfigurationAssignmentsForResourceGroupClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ConfigurationAssignmentsForResourceGroupClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, configurationAssignmentName string, configurationAssignment ConfigurationAssignment, options *ConfigurationAssignmentsForResourceGroupClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Maintenance/configurationAssignments/{configurationAssignmentName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if configurationAssignmentName == "" {
		return nil, errors.New("parameter configurationAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{configurationAssignmentName}", url.PathEscape(configurationAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, configurationAssignment); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ConfigurationAssignmentsForResourceGroupClient) createOrUpdateHandleResponse(resp *http.Response) (ConfigurationAssignmentsForResourceGroupClientCreateOrUpdateResponse, error) {
	result := ConfigurationAssignmentsForResourceGroupClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConfigurationAssignment); err != nil {
		return ConfigurationAssignmentsForResourceGroupClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Unregister configuration for resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01
//   - resourceGroupName - Resource group name
//   - configurationAssignmentName - Unique configuration assignment name
//   - options - ConfigurationAssignmentsForResourceGroupClientDeleteOptions contains the optional parameters for the ConfigurationAssignmentsForResourceGroupClient.Delete
//     method.
func (client *ConfigurationAssignmentsForResourceGroupClient) Delete(ctx context.Context, resourceGroupName string, configurationAssignmentName string, options *ConfigurationAssignmentsForResourceGroupClientDeleteOptions) (ConfigurationAssignmentsForResourceGroupClientDeleteResponse, error) {
	var err error
	const operationName = "ConfigurationAssignmentsForResourceGroupClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, configurationAssignmentName, options)
	if err != nil {
		return ConfigurationAssignmentsForResourceGroupClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ConfigurationAssignmentsForResourceGroupClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ConfigurationAssignmentsForResourceGroupClientDeleteResponse{}, err
	}
	resp, err := client.deleteHandleResponse(httpResp)
	return resp, err
}

// deleteCreateRequest creates the Delete request.
func (client *ConfigurationAssignmentsForResourceGroupClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, configurationAssignmentName string, options *ConfigurationAssignmentsForResourceGroupClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Maintenance/configurationAssignments/{configurationAssignmentName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if configurationAssignmentName == "" {
		return nil, errors.New("parameter configurationAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{configurationAssignmentName}", url.PathEscape(configurationAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *ConfigurationAssignmentsForResourceGroupClient) deleteHandleResponse(resp *http.Response) (ConfigurationAssignmentsForResourceGroupClientDeleteResponse, error) {
	result := ConfigurationAssignmentsForResourceGroupClientDeleteResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConfigurationAssignment); err != nil {
		return ConfigurationAssignmentsForResourceGroupClientDeleteResponse{}, err
	}
	return result, nil
}

// Get - Get configuration assignment for resource..
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01
//   - resourceGroupName - Resource group name
//   - configurationAssignmentName - Configuration assignment name
//   - options - ConfigurationAssignmentsForResourceGroupClientGetOptions contains the optional parameters for the ConfigurationAssignmentsForResourceGroupClient.Get
//     method.
func (client *ConfigurationAssignmentsForResourceGroupClient) Get(ctx context.Context, resourceGroupName string, configurationAssignmentName string, options *ConfigurationAssignmentsForResourceGroupClientGetOptions) (ConfigurationAssignmentsForResourceGroupClientGetResponse, error) {
	var err error
	const operationName = "ConfigurationAssignmentsForResourceGroupClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, configurationAssignmentName, options)
	if err != nil {
		return ConfigurationAssignmentsForResourceGroupClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ConfigurationAssignmentsForResourceGroupClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ConfigurationAssignmentsForResourceGroupClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ConfigurationAssignmentsForResourceGroupClient) getCreateRequest(ctx context.Context, resourceGroupName string, configurationAssignmentName string, options *ConfigurationAssignmentsForResourceGroupClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Maintenance/configurationAssignments/{configurationAssignmentName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if configurationAssignmentName == "" {
		return nil, errors.New("parameter configurationAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{configurationAssignmentName}", url.PathEscape(configurationAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ConfigurationAssignmentsForResourceGroupClient) getHandleResponse(resp *http.Response) (ConfigurationAssignmentsForResourceGroupClientGetResponse, error) {
	result := ConfigurationAssignmentsForResourceGroupClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConfigurationAssignment); err != nil {
		return ConfigurationAssignmentsForResourceGroupClientGetResponse{}, err
	}
	return result, nil
}

// Update - Register configuration for resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-04-01
//   - resourceGroupName - Resource group name
//   - configurationAssignmentName - Configuration assignment name
//   - configurationAssignment - The configurationAssignment
//   - options - ConfigurationAssignmentsForResourceGroupClientUpdateOptions contains the optional parameters for the ConfigurationAssignmentsForResourceGroupClient.Update
//     method.
func (client *ConfigurationAssignmentsForResourceGroupClient) Update(ctx context.Context, resourceGroupName string, configurationAssignmentName string, configurationAssignment ConfigurationAssignment, options *ConfigurationAssignmentsForResourceGroupClientUpdateOptions) (ConfigurationAssignmentsForResourceGroupClientUpdateResponse, error) {
	var err error
	const operationName = "ConfigurationAssignmentsForResourceGroupClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, configurationAssignmentName, configurationAssignment, options)
	if err != nil {
		return ConfigurationAssignmentsForResourceGroupClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ConfigurationAssignmentsForResourceGroupClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ConfigurationAssignmentsForResourceGroupClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *ConfigurationAssignmentsForResourceGroupClient) updateCreateRequest(ctx context.Context, resourceGroupName string, configurationAssignmentName string, configurationAssignment ConfigurationAssignment, options *ConfigurationAssignmentsForResourceGroupClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Maintenance/configurationAssignments/{configurationAssignmentName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if configurationAssignmentName == "" {
		return nil, errors.New("parameter configurationAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{configurationAssignmentName}", url.PathEscape(configurationAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, configurationAssignment); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *ConfigurationAssignmentsForResourceGroupClient) updateHandleResponse(resp *http.Response) (ConfigurationAssignmentsForResourceGroupClientUpdateResponse, error) {
	result := ConfigurationAssignmentsForResourceGroupClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ConfigurationAssignment); err != nil {
		return ConfigurationAssignmentsForResourceGroupClientUpdateResponse{}, err
	}
	return result, nil
}
