//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armlogic_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logic/armlogic"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccounts_ListBySubscription.json
func ExampleIntegrationAccountsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIntegrationAccountsClient().NewListBySubscriptionPager(&armlogic.IntegrationAccountsClientListBySubscriptionOptions{Top: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IntegrationAccountListResult = armlogic.IntegrationAccountListResult{
		// 	Value: []*armlogic.IntegrationAccount{
		// 		{
		// 			Name: to.Ptr("daviburgIAFabrikam"),
		// 			Type: to.Ptr("Microsoft.Logic/integrationAccounts"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/testIntegrationAccount"),
		// 			Location: to.Ptr("northcentralus"),
		// 			Properties: &armlogic.IntegrationAccountProperties{
		// 			},
		// 			SKU: &armlogic.IntegrationAccountSKU{
		// 				Name: to.Ptr(armlogic.IntegrationAccountSKUNameFree),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccounts_ListByResourceGroup.json
func ExampleIntegrationAccountsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIntegrationAccountsClient().NewListByResourceGroupPager("testResourceGroup", &armlogic.IntegrationAccountsClientListByResourceGroupOptions{Top: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IntegrationAccountListResult = armlogic.IntegrationAccountListResult{
		// 	Value: []*armlogic.IntegrationAccount{
		// 		{
		// 			Name: to.Ptr("IntegrationAccount9020"),
		// 			Type: to.Ptr("Microsoft.Logic/integrationAccounts"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/IntegrationAccount9020"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armlogic.IntegrationAccountProperties{
		// 			},
		// 			SKU: &armlogic.IntegrationAccountSKU{
		// 				Name: to.Ptr(armlogic.IntegrationAccountSKUNameStandard),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccounts_Get.json
func ExampleIntegrationAccountsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationAccountsClient().Get(ctx, "testResourceGroup", "testIntegrationAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IntegrationAccount = armlogic.IntegrationAccount{
	// 	Name: to.Ptr("IntegrationAccount5892"),
	// 	Type: to.Ptr("Microsoft.Logic/integrationAccounts"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/testIntegrationAccount"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armlogic.IntegrationAccountProperties{
	// 		IntegrationServiceEnvironment: &armlogic.ResourceReference{
	// 			Name: to.Ptr("test-integration-service-environment"),
	// 			Type: to.Ptr("Microsoft.Logic/integrationServiceEnvironments"),
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationServiceEnvironments/test-integration-service-environment"),
	// 		},
	// 		State: to.Ptr(armlogic.WorkflowStateEnabled),
	// 	},
	// 	SKU: &armlogic.IntegrationAccountSKU{
	// 		Name: to.Ptr(armlogic.IntegrationAccountSKUNameStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccounts_CreateOrUpdate.json
func ExampleIntegrationAccountsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationAccountsClient().CreateOrUpdate(ctx, "testResourceGroup", "testIntegrationAccount", armlogic.IntegrationAccount{
		Location:   to.Ptr("westus"),
		Properties: &armlogic.IntegrationAccountProperties{},
		SKU: &armlogic.IntegrationAccountSKU{
			Name: to.Ptr(armlogic.IntegrationAccountSKUNameStandard),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IntegrationAccount = armlogic.IntegrationAccount{
	// 	Name: to.Ptr("testIntegrationAccount"),
	// 	Type: to.Ptr("Microsoft.Logic/integrationAccounts"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/testIntegrationAccount"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armlogic.IntegrationAccountProperties{
	// 	},
	// 	SKU: &armlogic.IntegrationAccountSKU{
	// 		Name: to.Ptr(armlogic.IntegrationAccountSKUNameStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccounts_Update.json
func ExampleIntegrationAccountsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationAccountsClient().Update(ctx, "testResourceGroup", "testIntegrationAccount", armlogic.IntegrationAccount{
		Location:   to.Ptr("westus"),
		Properties: &armlogic.IntegrationAccountProperties{},
		SKU: &armlogic.IntegrationAccountSKU{
			Name: to.Ptr(armlogic.IntegrationAccountSKUNameStandard),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IntegrationAccount = armlogic.IntegrationAccount{
	// 	Name: to.Ptr("testIntegrationAccount"),
	// 	Type: to.Ptr("Microsoft.Logic/integrationAccounts"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/testIntegrationAccount"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armlogic.IntegrationAccountProperties{
	// 	},
	// 	SKU: &armlogic.IntegrationAccountSKU{
	// 		Name: to.Ptr(armlogic.IntegrationAccountSKUNameStandard),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccounts_Delete.json
func ExampleIntegrationAccountsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewIntegrationAccountsClient().Delete(ctx, "testResourceGroup", "testIntegrationAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccounts_ListCallbackUrl.json
func ExampleIntegrationAccountsClient_ListCallbackURL() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationAccountsClient().ListCallbackURL(ctx, "testResourceGroup", "testIntegrationAccount", armlogic.GetCallbackURLParameters{
		KeyType:  to.Ptr(armlogic.KeyTypePrimary),
		NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-05T08:00:00.000Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CallbackURL = armlogic.CallbackURL{
	// 	Value: to.Ptr("https://testprod-westus.logic.azure.com:443/integrationAccounts/ce41a499a1e64d95b874f5f14b4bf3b6?api-version=2015-08-01-preview&se=2017-03-17T07%3A00%3A00.0000000Z&sp=%2F%2F%2A&sv=1.0"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccounts_ListKeyVaultKeys.json
func ExampleIntegrationAccountsClient_NewListKeyVaultKeysPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIntegrationAccountsClient().NewListKeyVaultKeysPager("testResourceGroup", "testIntegrationAccount", armlogic.ListKeyVaultKeysDefinition{
		KeyVault: &armlogic.KeyVaultReference{
			ID: to.Ptr("subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.KeyVault/vaults/testKeyVault"),
		},
		SkipToken: to.Ptr("testSkipToken"),
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.KeyVaultKeyCollection = armlogic.KeyVaultKeyCollection{
		// 	SkipToken: to.Ptr("testSkipToken"),
		// 	Value: []*armlogic.KeyVaultKey{
		// 		{
		// 			Attributes: &armlogic.KeyVaultKeyAttributes{
		// 				Created: to.Ptr[int64](1498072075),
		// 				Enabled: to.Ptr(true),
		// 				Updated: to.Ptr[int64](1498072075),
		// 			},
		// 			Kid: to.Ptr("https://testKeyVault.vault.azure.net/keys/testkey"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccounts_LogTrackingEvents.json
func ExampleIntegrationAccountsClient_LogTrackingEvents() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewIntegrationAccountsClient().LogTrackingEvents(ctx, "testResourceGroup", "testIntegrationAccount", armlogic.TrackingEventsDefinition{
		Events: []*armlogic.TrackingEvent{
			{
				Error: &armlogic.TrackingEventErrorInfo{
					Code:    to.Ptr("NotFound"),
					Message: to.Ptr("Some error occurred"),
				},
				EventLevel: to.Ptr(armlogic.EventLevelInformational),
				EventTime:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-08-05T01:54:49.505Z"); return t }()),
				Record: map[string]any{
					"agreementProperties": map[string]any{
						"agreementName":       "testAgreement",
						"as2From":             "testas2from",
						"as2To":               "testas2to",
						"receiverPartnerName": "testPartner2",
						"senderPartnerName":   "testPartner1",
					},
					"messageProperties": map[string]any{
						"IsMessageEncrypted":   false,
						"IsMessageSigned":      false,
						"correlationMessageId": "Unique message identifier",
						"direction":            "Receive",
						"dispositionType":      "received-success",
						"fileName":             "test",
						"isMdnExpected":        true,
						"isMessageCompressed":  false,
						"isMessageFailed":      false,
						"isNrrEnabled":         true,
						"mdnType":              "Async",
						"messageId":            "12345",
					},
				},
				RecordType: to.Ptr(armlogic.TrackingRecordTypeAS2Message),
			}},
		SourceType: to.Ptr("Microsoft.Logic/workflows"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccounts_RegenerateAccessKey.json
func ExampleIntegrationAccountsClient_RegenerateAccessKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationAccountsClient().RegenerateAccessKey(ctx, "testResourceGroup", "testIntegrationAccount", armlogic.RegenerateActionParameter{
		KeyType: to.Ptr(armlogic.KeyTypePrimary),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IntegrationAccount = armlogic.IntegrationAccount{
	// 	Name: to.Ptr("testIntegrationAccount"),
	// 	Type: to.Ptr("Microsoft.Logic/integrationAccounts"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/testIntegrationAccount"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armlogic.IntegrationAccountProperties{
	// 	},
	// 	SKU: &armlogic.IntegrationAccountSKU{
	// 		Name: to.Ptr(armlogic.IntegrationAccountSKUNameStandard),
	// 	},
	// }
}
