//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logic/armlogic"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// WorkflowVersionTriggersServer is a fake server for instances of the armlogic.WorkflowVersionTriggersClient type.
type WorkflowVersionTriggersServer struct {
	// ListCallbackURL is the fake for method WorkflowVersionTriggersClient.ListCallbackURL
	// HTTP status codes to indicate success: http.StatusOK
	ListCallbackURL func(ctx context.Context, resourceGroupName string, workflowName string, versionID string, triggerName string, options *armlogic.WorkflowVersionTriggersClientListCallbackURLOptions) (resp azfake.Responder[armlogic.WorkflowVersionTriggersClientListCallbackURLResponse], errResp azfake.ErrorResponder)
}

// NewWorkflowVersionTriggersServerTransport creates a new instance of WorkflowVersionTriggersServerTransport with the provided implementation.
// The returned WorkflowVersionTriggersServerTransport instance is connected to an instance of armlogic.WorkflowVersionTriggersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWorkflowVersionTriggersServerTransport(srv *WorkflowVersionTriggersServer) *WorkflowVersionTriggersServerTransport {
	return &WorkflowVersionTriggersServerTransport{srv: srv}
}

// WorkflowVersionTriggersServerTransport connects instances of armlogic.WorkflowVersionTriggersClient to instances of WorkflowVersionTriggersServer.
// Don't use this type directly, use NewWorkflowVersionTriggersServerTransport instead.
type WorkflowVersionTriggersServerTransport struct {
	srv *WorkflowVersionTriggersServer
}

// Do implements the policy.Transporter interface for WorkflowVersionTriggersServerTransport.
func (w *WorkflowVersionTriggersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WorkflowVersionTriggersClient.ListCallbackURL":
		resp, err = w.dispatchListCallbackURL(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WorkflowVersionTriggersServerTransport) dispatchListCallbackURL(req *http.Request) (*http.Response, error) {
	if w.srv.ListCallbackURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListCallbackURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Logic/workflows/(?P<workflowName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<versionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggers/(?P<triggerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listCallbackUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armlogic.GetCallbackURLParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workflowNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workflowName")])
	if err != nil {
		return nil, err
	}
	versionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("versionId")])
	if err != nil {
		return nil, err
	}
	triggerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("triggerName")])
	if err != nil {
		return nil, err
	}
	var options *armlogic.WorkflowVersionTriggersClientListCallbackURLOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armlogic.WorkflowVersionTriggersClientListCallbackURLOptions{
			Parameters: &body,
		}
	}
	respr, errRespr := w.srv.ListCallbackURL(req.Context(), resourceGroupNameParam, workflowNameParam, versionIDParam, triggerNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkflowTriggerCallbackURL, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
