//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotfirmwaredefense

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iotfirmwaredefense/armiotfirmwaredefense"
	moduleVersion = "v1.0.0"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// ProvisioningState - Provisioning state of the resource.
type ProvisioningState string

const (
	ProvisioningStateAccepted  ProvisioningState = "Accepted"
	ProvisioningStateCanceled  ProvisioningState = "Canceled"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateAccepted,
		ProvisioningStateCanceled,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
	}
}

// Status - The status of firmware scan.
type Status string

const (
	StatusAnalyzing  Status = "Analyzing"
	StatusError      Status = "Error"
	StatusExtracting Status = "Extracting"
	StatusPending    Status = "Pending"
	StatusReady      Status = "Ready"
)

// PossibleStatusValues returns the possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{
		StatusAnalyzing,
		StatusError,
		StatusExtracting,
		StatusPending,
		StatusReady,
	}
}

type SummaryName string

const (
	SummaryNameBinaryHardening   SummaryName = "BinaryHardening"
	SummaryNameCVE               SummaryName = "CVE"
	SummaryNameCryptoCertificate SummaryName = "CryptoCertificate"
	SummaryNameCryptoKey         SummaryName = "CryptoKey"
	SummaryNameFirmware          SummaryName = "Firmware"
)

// PossibleSummaryNameValues returns the possible values for the SummaryName const type.
func PossibleSummaryNameValues() []SummaryName {
	return []SummaryName{
		SummaryNameBinaryHardening,
		SummaryNameCVE,
		SummaryNameCryptoCertificate,
		SummaryNameCryptoKey,
		SummaryNameFirmware,
	}
}

// SummaryType - Describes the type of summary.
type SummaryType string

const (
	SummaryTypeBinaryHardening   SummaryType = "BinaryHardening"
	SummaryTypeCVE               SummaryType = "CVE"
	SummaryTypeCryptoCertificate SummaryType = "CryptoCertificate"
	SummaryTypeCryptoKey         SummaryType = "CryptoKey"
	SummaryTypeFirmware          SummaryType = "Firmware"
)

// PossibleSummaryTypeValues returns the possible values for the SummaryType const type.
func PossibleSummaryTypeValues() []SummaryType {
	return []SummaryType{
		SummaryTypeBinaryHardening,
		SummaryTypeCVE,
		SummaryTypeCryptoCertificate,
		SummaryTypeCryptoKey,
		SummaryTypeFirmware,
	}
}
