//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybriddatamanager

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The Subscription Id
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewDataManagersClient creates a new instance of DataManagersClient.
func (c *ClientFactory) NewDataManagersClient() *DataManagersClient {
	subClient, _ := NewDataManagersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataServicesClient creates a new instance of DataServicesClient.
func (c *ClientFactory) NewDataServicesClient() *DataServicesClient {
	subClient, _ := NewDataServicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataStoreTypesClient creates a new instance of DataStoreTypesClient.
func (c *ClientFactory) NewDataStoreTypesClient() *DataStoreTypesClient {
	subClient, _ := NewDataStoreTypesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataStoresClient creates a new instance of DataStoresClient.
func (c *ClientFactory) NewDataStoresClient() *DataStoresClient {
	subClient, _ := NewDataStoresClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobDefinitionsClient creates a new instance of JobDefinitionsClient.
func (c *ClientFactory) NewJobDefinitionsClient() *JobDefinitionsClient {
	subClient, _ := NewJobDefinitionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewJobsClient creates a new instance of JobsClient.
func (c *ClientFactory) NewJobsClient() *JobsClient {
	subClient, _ := NewJobsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPublicKeysClient creates a new instance of PublicKeysClient.
func (c *ClientFactory) NewPublicKeysClient() *PublicKeysClient {
	subClient, _ := NewPublicKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
