//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hdinsight/armhdinsight"
	"net/http"
	"net/url"
	"regexp"
)

// ScriptExecutionHistoryServer is a fake server for instances of the armhdinsight.ScriptExecutionHistoryClient type.
type ScriptExecutionHistoryServer struct {
	// NewListByClusterPager is the fake for method ScriptExecutionHistoryClient.NewListByClusterPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByClusterPager func(resourceGroupName string, clusterName string, options *armhdinsight.ScriptExecutionHistoryClientListByClusterOptions) (resp azfake.PagerResponder[armhdinsight.ScriptExecutionHistoryClientListByClusterResponse])

	// Promote is the fake for method ScriptExecutionHistoryClient.Promote
	// HTTP status codes to indicate success: http.StatusOK
	Promote func(ctx context.Context, resourceGroupName string, clusterName string, scriptExecutionID string, options *armhdinsight.ScriptExecutionHistoryClientPromoteOptions) (resp azfake.Responder[armhdinsight.ScriptExecutionHistoryClientPromoteResponse], errResp azfake.ErrorResponder)
}

// NewScriptExecutionHistoryServerTransport creates a new instance of ScriptExecutionHistoryServerTransport with the provided implementation.
// The returned ScriptExecutionHistoryServerTransport instance is connected to an instance of armhdinsight.ScriptExecutionHistoryClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewScriptExecutionHistoryServerTransport(srv *ScriptExecutionHistoryServer) *ScriptExecutionHistoryServerTransport {
	return &ScriptExecutionHistoryServerTransport{
		srv:                   srv,
		newListByClusterPager: newTracker[azfake.PagerResponder[armhdinsight.ScriptExecutionHistoryClientListByClusterResponse]](),
	}
}

// ScriptExecutionHistoryServerTransport connects instances of armhdinsight.ScriptExecutionHistoryClient to instances of ScriptExecutionHistoryServer.
// Don't use this type directly, use NewScriptExecutionHistoryServerTransport instead.
type ScriptExecutionHistoryServerTransport struct {
	srv                   *ScriptExecutionHistoryServer
	newListByClusterPager *tracker[azfake.PagerResponder[armhdinsight.ScriptExecutionHistoryClientListByClusterResponse]]
}

// Do implements the policy.Transporter interface for ScriptExecutionHistoryServerTransport.
func (s *ScriptExecutionHistoryServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ScriptExecutionHistoryClient.NewListByClusterPager":
		resp, err = s.dispatchNewListByClusterPager(req)
	case "ScriptExecutionHistoryClient.Promote":
		resp, err = s.dispatchPromote(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ScriptExecutionHistoryServerTransport) dispatchNewListByClusterPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByClusterPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByClusterPager not implemented")}
	}
	newListByClusterPager := s.newListByClusterPager.get(req)
	if newListByClusterPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scriptExecutionHistory`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByClusterPager(resourceGroupNameParam, clusterNameParam, nil)
		newListByClusterPager = &resp
		s.newListByClusterPager.add(req, newListByClusterPager)
		server.PagerResponderInjectNextLinks(newListByClusterPager, req, func(page *armhdinsight.ScriptExecutionHistoryClientListByClusterResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByClusterPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByClusterPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByClusterPager) {
		s.newListByClusterPager.remove(req)
	}
	return resp, nil
}

func (s *ScriptExecutionHistoryServerTransport) dispatchPromote(req *http.Request) (*http.Response, error) {
	if s.srv.Promote == nil {
		return nil, &nonRetriableError{errors.New("fake for method Promote not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scriptExecutionHistory/(?P<scriptExecutionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/promote`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	scriptExecutionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scriptExecutionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Promote(req.Context(), resourceGroupNameParam, clusterNameParam, scriptExecutionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
