//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/guestconfiguration/armguestconfiguration"
	"net/http"
	"net/url"
	"regexp"
)

// AssignmentsServer is a fake server for instances of the armguestconfiguration.AssignmentsClient type.
type AssignmentsServer struct {
	// CreateOrUpdate is the fake for method AssignmentsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, guestConfigurationAssignmentName string, resourceGroupName string, vmName string, parameters armguestconfiguration.Assignment, options *armguestconfiguration.AssignmentsClientCreateOrUpdateOptions) (resp azfake.Responder[armguestconfiguration.AssignmentsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method AssignmentsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK
	Delete func(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, vmName string, options *armguestconfiguration.AssignmentsClientDeleteOptions) (resp azfake.Responder[armguestconfiguration.AssignmentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AssignmentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, vmName string, options *armguestconfiguration.AssignmentsClientGetOptions) (resp azfake.Responder[armguestconfiguration.AssignmentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method AssignmentsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, vmName string, options *armguestconfiguration.AssignmentsClientListOptions) (resp azfake.PagerResponder[armguestconfiguration.AssignmentsClientListResponse])

	// NewRGListPager is the fake for method AssignmentsClient.NewRGListPager
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	NewRGListPager func(resourceGroupName string, options *armguestconfiguration.AssignmentsClientRGListOptions) (resp azfake.PagerResponder[armguestconfiguration.AssignmentsClientRGListResponse])

	// NewSubscriptionListPager is the fake for method AssignmentsClient.NewSubscriptionListPager
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	NewSubscriptionListPager func(options *armguestconfiguration.AssignmentsClientSubscriptionListOptions) (resp azfake.PagerResponder[armguestconfiguration.AssignmentsClientSubscriptionListResponse])
}

// NewAssignmentsServerTransport creates a new instance of AssignmentsServerTransport with the provided implementation.
// The returned AssignmentsServerTransport instance is connected to an instance of armguestconfiguration.AssignmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAssignmentsServerTransport(srv *AssignmentsServer) *AssignmentsServerTransport {
	return &AssignmentsServerTransport{
		srv:                      srv,
		newListPager:             newTracker[azfake.PagerResponder[armguestconfiguration.AssignmentsClientListResponse]](),
		newRGListPager:           newTracker[azfake.PagerResponder[armguestconfiguration.AssignmentsClientRGListResponse]](),
		newSubscriptionListPager: newTracker[azfake.PagerResponder[armguestconfiguration.AssignmentsClientSubscriptionListResponse]](),
	}
}

// AssignmentsServerTransport connects instances of armguestconfiguration.AssignmentsClient to instances of AssignmentsServer.
// Don't use this type directly, use NewAssignmentsServerTransport instead.
type AssignmentsServerTransport struct {
	srv                      *AssignmentsServer
	newListPager             *tracker[azfake.PagerResponder[armguestconfiguration.AssignmentsClientListResponse]]
	newRGListPager           *tracker[azfake.PagerResponder[armguestconfiguration.AssignmentsClientRGListResponse]]
	newSubscriptionListPager *tracker[azfake.PagerResponder[armguestconfiguration.AssignmentsClientSubscriptionListResponse]]
}

// Do implements the policy.Transporter interface for AssignmentsServerTransport.
func (a *AssignmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AssignmentsClient.CreateOrUpdate":
		resp, err = a.dispatchCreateOrUpdate(req)
	case "AssignmentsClient.Delete":
		resp, err = a.dispatchDelete(req)
	case "AssignmentsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AssignmentsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	case "AssignmentsClient.NewRGListPager":
		resp, err = a.dispatchNewRGListPager(req)
	case "AssignmentsClient.NewSubscriptionListPager":
		resp, err = a.dispatchNewSubscriptionListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.GuestConfiguration/guestConfigurationAssignments/(?P<guestConfigurationAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armguestconfiguration.Assignment](req)
	if err != nil {
		return nil, err
	}
	guestConfigurationAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("guestConfigurationAssignmentName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateOrUpdate(req.Context(), guestConfigurationAssignmentNameParam, resourceGroupNameParam, vmNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if a.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.GuestConfiguration/guestConfigurationAssignments/(?P<guestConfigurationAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	guestConfigurationAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("guestConfigurationAssignmentName")])
	if err != nil {
		return nil, err
	}
	vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Delete(req.Context(), resourceGroupNameParam, guestConfigurationAssignmentNameParam, vmNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.GuestConfiguration/guestConfigurationAssignments/(?P<guestConfigurationAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	guestConfigurationAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("guestConfigurationAssignmentName")])
	if err != nil {
		return nil, err
	}
	vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, guestConfigurationAssignmentNameParam, vmNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Compute/virtualMachines/(?P<vmName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.GuestConfiguration/guestConfigurationAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vmNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vmName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListPager(resourceGroupNameParam, vmNameParam, nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchNewRGListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewRGListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewRGListPager not implemented")}
	}
	newRGListPager := a.newRGListPager.get(req)
	if newRGListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.GuestConfiguration/guestConfigurationAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewRGListPager(resourceGroupNameParam, nil)
		newRGListPager = &resp
		a.newRGListPager.add(req, newRGListPager)
	}
	resp, err := server.PagerResponderNext(newRGListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK, http.StatusNoContent}, resp.StatusCode) {
		a.newRGListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newRGListPager) {
		a.newRGListPager.remove(req)
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchNewSubscriptionListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewSubscriptionListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewSubscriptionListPager not implemented")}
	}
	newSubscriptionListPager := a.newSubscriptionListPager.get(req)
	if newSubscriptionListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.GuestConfiguration/guestConfigurationAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := a.srv.NewSubscriptionListPager(nil)
		newSubscriptionListPager = &resp
		a.newSubscriptionListPager.add(req, newSubscriptionListPager)
	}
	resp, err := server.PagerResponderNext(newSubscriptionListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK, http.StatusNoContent}, resp.StatusCode) {
		a.newSubscriptionListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newSubscriptionListPager) {
		a.newSubscriptionListPager.remove(req)
	}
	return resp, nil
}
