//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/frontdoor/armfrontdoor"
	"net/http"
	"regexp"
)

// NameAvailabilityWithSubscriptionServer is a fake server for instances of the armfrontdoor.NameAvailabilityWithSubscriptionClient type.
type NameAvailabilityWithSubscriptionServer struct {
	// Check is the fake for method NameAvailabilityWithSubscriptionClient.Check
	// HTTP status codes to indicate success: http.StatusOK
	Check func(ctx context.Context, checkFrontDoorNameAvailabilityInput armfrontdoor.CheckNameAvailabilityInput, options *armfrontdoor.NameAvailabilityWithSubscriptionClientCheckOptions) (resp azfake.Responder[armfrontdoor.NameAvailabilityWithSubscriptionClientCheckResponse], errResp azfake.ErrorResponder)
}

// NewNameAvailabilityWithSubscriptionServerTransport creates a new instance of NameAvailabilityWithSubscriptionServerTransport with the provided implementation.
// The returned NameAvailabilityWithSubscriptionServerTransport instance is connected to an instance of armfrontdoor.NameAvailabilityWithSubscriptionClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewNameAvailabilityWithSubscriptionServerTransport(srv *NameAvailabilityWithSubscriptionServer) *NameAvailabilityWithSubscriptionServerTransport {
	return &NameAvailabilityWithSubscriptionServerTransport{srv: srv}
}

// NameAvailabilityWithSubscriptionServerTransport connects instances of armfrontdoor.NameAvailabilityWithSubscriptionClient to instances of NameAvailabilityWithSubscriptionServer.
// Don't use this type directly, use NewNameAvailabilityWithSubscriptionServerTransport instead.
type NameAvailabilityWithSubscriptionServerTransport struct {
	srv *NameAvailabilityWithSubscriptionServer
}

// Do implements the policy.Transporter interface for NameAvailabilityWithSubscriptionServerTransport.
func (n *NameAvailabilityWithSubscriptionServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "NameAvailabilityWithSubscriptionClient.Check":
		resp, err = n.dispatchCheck(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (n *NameAvailabilityWithSubscriptionServerTransport) dispatchCheck(req *http.Request) (*http.Response, error) {
	if n.srv.Check == nil {
		return nil, &nonRetriableError{errors.New("fake for method Check not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/checkFrontDoorNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armfrontdoor.CheckNameAvailabilityInput](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.Check(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityOutput, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
