//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armelasticsan_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/elasticsan/armelasticsan"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_ListBySubscription_MaximumSet_Gen.json
func ExampleElasticSansClient_NewListBySubscriptionPager_elasticSansListBySubscriptionMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewElasticSansClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.List = armelasticsan.List{
		// 	Value: []*armelasticsan.ElasticSan{
		// 		{
		// 			Name: to.Ptr("vfoatmakv"),
		// 			Type: to.Ptr("Microsoft.ElasticSan/ElasticSans"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}"),
		// 			SystemData: &armelasticsan.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
		// 				CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
		// 				CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
		// 				LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("France Central"),
		// 			Tags: map[string]*string{
		// 				"key5002": to.Ptr("lhag"),
		// 			},
		// 			Properties: &armelasticsan.Properties{
		// 				AvailabilityZones: []*string{
		// 					to.Ptr("1")},
		// 					BaseSizeTiB: to.Ptr[int64](15),
		// 					ExtendedCapacitySizeTiB: to.Ptr[int64](6),
		// 					PrivateEndpointConnections: []*armelasticsan.PrivateEndpointConnection{
		// 						{
		// 							Name: to.Ptr("{privateEndpointConnectionName}"),
		// 							Type: to.Ptr("Microsoft.ElasticSan/elasticSans/privateEndpointConnections"),
		// 							ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/privateEndpointConnections/{privateEndpointConnectionName}"),
		// 							SystemData: &armelasticsan.SystemData{
		// 								CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
		// 								CreatedBy: to.Ptr("kakcyehdrphqkilgkhpbdtvpupak"),
		// 								CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 								LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
		// 								LastModifiedBy: to.Ptr("bcclmbseed"),
		// 								LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 							},
		// 							Properties: &armelasticsan.PrivateEndpointConnectionProperties{
		// 								GroupIDs: []*string{
		// 									to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")},
		// 									PrivateEndpoint: &armelasticsan.PrivateEndpoint{
		// 										ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}"),
		// 									},
		// 									PrivateLinkServiceConnectionState: &armelasticsan.PrivateLinkServiceConnectionState{
		// 										Description: to.Ptr("Auto-Approved"),
		// 										ActionsRequired: to.Ptr("None"),
		// 										Status: to.Ptr(armelasticsan.PrivateEndpointServiceConnectionStatusPending),
		// 									},
		// 									ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
		// 								},
		// 						}},
		// 						ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
		// 						PublicNetworkAccess: to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
		// 						SKU: &armelasticsan.SKU{
		// 							Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
		// 							Tier: to.Ptr(armelasticsan.SKUTierPremium),
		// 						},
		// 						TotalIops: to.Ptr[int64](22),
		// 						TotalMBps: to.Ptr[int64](4),
		// 						TotalSizeTiB: to.Ptr[int64](27),
		// 						TotalVolumeSizeGiB: to.Ptr[int64](15),
		// 						VolumeGroupCount: to.Ptr[int64](24),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_ListBySubscription_MinimumSet_Gen.json
func ExampleElasticSansClient_NewListBySubscriptionPager_elasticSansListBySubscriptionMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewElasticSansClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.List = armelasticsan.List{
		// 	Value: []*armelasticsan.ElasticSan{
		// 		{
		// 			Name: to.Ptr("vfoatmakv"),
		// 			Type: to.Ptr("Microsoft.ElasticSan/ElasticSans"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}"),
		// 			SystemData: &armelasticsan.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
		// 				CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
		// 				CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
		// 				LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("France Central"),
		// 			Tags: map[string]*string{
		// 				"key5002": to.Ptr("lhag"),
		// 			},
		// 			Properties: &armelasticsan.Properties{
		// 				AvailabilityZones: []*string{
		// 					to.Ptr("1")},
		// 					BaseSizeTiB: to.Ptr[int64](15),
		// 					ExtendedCapacitySizeTiB: to.Ptr[int64](6),
		// 					PrivateEndpointConnections: []*armelasticsan.PrivateEndpointConnection{
		// 						{
		// 							Name: to.Ptr("{privateEndpointConnectionName}"),
		// 							Type: to.Ptr("Microsoft.ElasticSan/elasticSans/privateEndpointConnections"),
		// 							ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/privateEndpointConnections/{privateEndpointConnectionName}"),
		// 							SystemData: &armelasticsan.SystemData{
		// 								CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
		// 								CreatedBy: to.Ptr("kakcyehdrphqkilgkhpbdtvpupak"),
		// 								CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 								LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
		// 								LastModifiedBy: to.Ptr("bcclmbseed"),
		// 								LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 							},
		// 							Properties: &armelasticsan.PrivateEndpointConnectionProperties{
		// 								GroupIDs: []*string{
		// 									to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")},
		// 									PrivateEndpoint: &armelasticsan.PrivateEndpoint{
		// 										ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}"),
		// 									},
		// 									PrivateLinkServiceConnectionState: &armelasticsan.PrivateLinkServiceConnectionState{
		// 										Description: to.Ptr("Auto-Approved"),
		// 										ActionsRequired: to.Ptr("None"),
		// 										Status: to.Ptr(armelasticsan.PrivateEndpointServiceConnectionStatusPending),
		// 									},
		// 									ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
		// 								},
		// 						}},
		// 						ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
		// 						PublicNetworkAccess: to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
		// 						SKU: &armelasticsan.SKU{
		// 							Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
		// 							Tier: to.Ptr(armelasticsan.SKUTierPremium),
		// 						},
		// 						TotalIops: to.Ptr[int64](22),
		// 						TotalMBps: to.Ptr[int64](4),
		// 						TotalSizeTiB: to.Ptr[int64](27),
		// 						TotalVolumeSizeGiB: to.Ptr[int64](15),
		// 						VolumeGroupCount: to.Ptr[int64](24),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_ListByResourceGroup_MaximumSet_Gen.json
func ExampleElasticSansClient_NewListByResourceGroupPager_elasticSansListByResourceGroupMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewElasticSansClient().NewListByResourceGroupPager("resourcegroupname", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.List = armelasticsan.List{
		// 	Value: []*armelasticsan.ElasticSan{
		// 		{
		// 			Name: to.Ptr("vfoatmakv"),
		// 			Type: to.Ptr("Microsoft.ElasticSan/ElasticSans"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}"),
		// 			SystemData: &armelasticsan.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
		// 				CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
		// 				CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
		// 				LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("France Central"),
		// 			Tags: map[string]*string{
		// 				"key5002": to.Ptr("lhag"),
		// 			},
		// 			Properties: &armelasticsan.Properties{
		// 				AvailabilityZones: []*string{
		// 					to.Ptr("1")},
		// 					BaseSizeTiB: to.Ptr[int64](15),
		// 					ExtendedCapacitySizeTiB: to.Ptr[int64](6),
		// 					PrivateEndpointConnections: []*armelasticsan.PrivateEndpointConnection{
		// 						{
		// 							Name: to.Ptr("{privateEndpointConnectionName}"),
		// 							Type: to.Ptr("Microsoft.ElasticSan/elasticSans/privateEndpointConnections"),
		// 							ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/privateEndpointConnections/{privateEndpointConnectionName}"),
		// 							SystemData: &armelasticsan.SystemData{
		// 								CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
		// 								CreatedBy: to.Ptr("kakcyehdrphqkilgkhpbdtvpupak"),
		// 								CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 								LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
		// 								LastModifiedBy: to.Ptr("bcclmbseed"),
		// 								LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 							},
		// 							Properties: &armelasticsan.PrivateEndpointConnectionProperties{
		// 								GroupIDs: []*string{
		// 									to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")},
		// 									PrivateEndpoint: &armelasticsan.PrivateEndpoint{
		// 										ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}"),
		// 									},
		// 									PrivateLinkServiceConnectionState: &armelasticsan.PrivateLinkServiceConnectionState{
		// 										Description: to.Ptr("Auto-Approved"),
		// 										ActionsRequired: to.Ptr("None"),
		// 										Status: to.Ptr(armelasticsan.PrivateEndpointServiceConnectionStatusPending),
		// 									},
		// 									ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
		// 								},
		// 						}},
		// 						ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
		// 						PublicNetworkAccess: to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
		// 						SKU: &armelasticsan.SKU{
		// 							Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
		// 							Tier: to.Ptr(armelasticsan.SKUTierPremium),
		// 						},
		// 						TotalIops: to.Ptr[int64](22),
		// 						TotalMBps: to.Ptr[int64](4),
		// 						TotalSizeTiB: to.Ptr[int64](27),
		// 						TotalVolumeSizeGiB: to.Ptr[int64](15),
		// 						VolumeGroupCount: to.Ptr[int64](24),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_ListByResourceGroup_MinimumSet_Gen.json
func ExampleElasticSansClient_NewListByResourceGroupPager_elasticSansListByResourceGroupMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewElasticSansClient().NewListByResourceGroupPager("resourcegroupname", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.List = armelasticsan.List{
		// 	Value: []*armelasticsan.ElasticSan{
		// 		{
		// 			Name: to.Ptr("vfoatmakv"),
		// 			Type: to.Ptr("Microsoft.ElasticSan/ElasticSans"),
		// 			ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}"),
		// 			SystemData: &armelasticsan.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
		// 				CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
		// 				CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
		// 				LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("France Central"),
		// 			Tags: map[string]*string{
		// 				"key5002": to.Ptr("lhag"),
		// 			},
		// 			Properties: &armelasticsan.Properties{
		// 				AvailabilityZones: []*string{
		// 					to.Ptr("1")},
		// 					BaseSizeTiB: to.Ptr[int64](15),
		// 					ExtendedCapacitySizeTiB: to.Ptr[int64](6),
		// 					PrivateEndpointConnections: []*armelasticsan.PrivateEndpointConnection{
		// 						{
		// 							Name: to.Ptr("{privateEndpointConnectionName}"),
		// 							Type: to.Ptr("Microsoft.ElasticSan/elasticSans/privateEndpointConnections"),
		// 							ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/privateEndpointConnections/{privateEndpointConnectionName}"),
		// 							SystemData: &armelasticsan.SystemData{
		// 								CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
		// 								CreatedBy: to.Ptr("kakcyehdrphqkilgkhpbdtvpupak"),
		// 								CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 								LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
		// 								LastModifiedBy: to.Ptr("bcclmbseed"),
		// 								LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
		// 							},
		// 							Properties: &armelasticsan.PrivateEndpointConnectionProperties{
		// 								GroupIDs: []*string{
		// 									to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")},
		// 									PrivateEndpoint: &armelasticsan.PrivateEndpoint{
		// 										ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}"),
		// 									},
		// 									PrivateLinkServiceConnectionState: &armelasticsan.PrivateLinkServiceConnectionState{
		// 										Description: to.Ptr("Auto-Approved"),
		// 										ActionsRequired: to.Ptr("None"),
		// 										Status: to.Ptr(armelasticsan.PrivateEndpointServiceConnectionStatusPending),
		// 									},
		// 									ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
		// 								},
		// 						}},
		// 						ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
		// 						PublicNetworkAccess: to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
		// 						SKU: &armelasticsan.SKU{
		// 							Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
		// 							Tier: to.Ptr(armelasticsan.SKUTierPremium),
		// 						},
		// 						TotalIops: to.Ptr[int64](22),
		// 						TotalMBps: to.Ptr[int64](4),
		// 						TotalSizeTiB: to.Ptr[int64](27),
		// 						TotalVolumeSizeGiB: to.Ptr[int64](15),
		// 						VolumeGroupCount: to.Ptr[int64](24),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_Create_MaximumSet_Gen.json
func ExampleElasticSansClient_BeginCreate_elasticSansCreateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewElasticSansClient().BeginCreate(ctx, "resourcegroupname", "elasticsanname", armelasticsan.ElasticSan{
		Location: to.Ptr("France Central"),
		Tags: map[string]*string{
			"key9316": to.Ptr("ihndtieqibtob"),
		},
		Properties: &armelasticsan.Properties{
			AvailabilityZones: []*string{
				to.Ptr("1")},
			BaseSizeTiB:             to.Ptr[int64](5),
			ExtendedCapacitySizeTiB: to.Ptr[int64](25),
			PublicNetworkAccess:     to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
			SKU: &armelasticsan.SKU{
				Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
				Tier: to.Ptr(armelasticsan.SKUTierPremium),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ElasticSan = armelasticsan.ElasticSan{
	// 	Name: to.Ptr("vfoatmakv"),
	// 	Type: to.Ptr("Microsoft.ElasticSan/ElasticSans"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}"),
	// 	SystemData: &armelasticsan.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
	// 		CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
	// 		LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("France Central"),
	// 	Tags: map[string]*string{
	// 		"key5002": to.Ptr("lhag"),
	// 	},
	// 	Properties: &armelasticsan.Properties{
	// 		AvailabilityZones: []*string{
	// 			to.Ptr("1")},
	// 			BaseSizeTiB: to.Ptr[int64](15),
	// 			ExtendedCapacitySizeTiB: to.Ptr[int64](6),
	// 			ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
	// 			PublicNetworkAccess: to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
	// 			SKU: &armelasticsan.SKU{
	// 				Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
	// 				Tier: to.Ptr(armelasticsan.SKUTierPremium),
	// 			},
	// 			TotalIops: to.Ptr[int64](22),
	// 			TotalMBps: to.Ptr[int64](4),
	// 			TotalSizeTiB: to.Ptr[int64](27),
	// 			TotalVolumeSizeGiB: to.Ptr[int64](15),
	// 			VolumeGroupCount: to.Ptr[int64](24),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_Create_MinimumSet_Gen.json
func ExampleElasticSansClient_BeginCreate_elasticSansCreateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewElasticSansClient().BeginCreate(ctx, "resourcegroupname", "elasticsanname", armelasticsan.ElasticSan{
		Location: to.Ptr("France Central"),
		Properties: &armelasticsan.Properties{
			BaseSizeTiB:             to.Ptr[int64](15),
			ExtendedCapacitySizeTiB: to.Ptr[int64](27),
			SKU: &armelasticsan.SKU{
				Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ElasticSan = armelasticsan.ElasticSan{
	// 	Name: to.Ptr("vfoatmakv"),
	// 	Type: to.Ptr("Microsoft.ElasticSan/ElasticSans"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}"),
	// 	SystemData: &armelasticsan.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
	// 		CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
	// 		LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("France Central"),
	// 	Tags: map[string]*string{
	// 		"key5002": to.Ptr("lhag"),
	// 	},
	// 	Properties: &armelasticsan.Properties{
	// 		AvailabilityZones: []*string{
	// 			to.Ptr("1")},
	// 			BaseSizeTiB: to.Ptr[int64](15),
	// 			ExtendedCapacitySizeTiB: to.Ptr[int64](6),
	// 			ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
	// 			PublicNetworkAccess: to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
	// 			SKU: &armelasticsan.SKU{
	// 				Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
	// 				Tier: to.Ptr(armelasticsan.SKUTierPremium),
	// 			},
	// 			TotalIops: to.Ptr[int64](22),
	// 			TotalMBps: to.Ptr[int64](4),
	// 			TotalSizeTiB: to.Ptr[int64](27),
	// 			TotalVolumeSizeGiB: to.Ptr[int64](15),
	// 			VolumeGroupCount: to.Ptr[int64](24),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_Update_MaximumSet_Gen.json
func ExampleElasticSansClient_BeginUpdate_elasticSansUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewElasticSansClient().BeginUpdate(ctx, "resourcegroupname", "elasticsanname", armelasticsan.Update{
		Properties: &armelasticsan.UpdateProperties{
			BaseSizeTiB:             to.Ptr[int64](13),
			ExtendedCapacitySizeTiB: to.Ptr[int64](29),
			PublicNetworkAccess:     to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
		},
		Tags: map[string]*string{
			"key1931": to.Ptr("yhjwkgmrrwrcoxblgwgzjqusch"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ElasticSan = armelasticsan.ElasticSan{
	// 	Name: to.Ptr("vfoatmakv"),
	// 	Type: to.Ptr("Microsoft.ElasticSan/ElasticSans"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}"),
	// 	SystemData: &armelasticsan.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
	// 		CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
	// 		LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("France Central"),
	// 	Tags: map[string]*string{
	// 		"key5002": to.Ptr("lhag"),
	// 	},
	// 	Properties: &armelasticsan.Properties{
	// 		AvailabilityZones: []*string{
	// 			to.Ptr("1")},
	// 			BaseSizeTiB: to.Ptr[int64](15),
	// 			ExtendedCapacitySizeTiB: to.Ptr[int64](6),
	// 			PrivateEndpointConnections: []*armelasticsan.PrivateEndpointConnection{
	// 				{
	// 					Name: to.Ptr("{privateEndpointConnectionName}"),
	// 					Type: to.Ptr("Microsoft.ElasticSan/elasticSans/privateEndpointConnections"),
	// 					ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/privateEndpointConnections/{privateEndpointConnectionName}"),
	// 					SystemData: &armelasticsan.SystemData{
	// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
	// 						CreatedBy: to.Ptr("kakcyehdrphqkilgkhpbdtvpupak"),
	// 						CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
	// 						LastModifiedBy: to.Ptr("bcclmbseed"),
	// 						LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 					},
	// 					Properties: &armelasticsan.PrivateEndpointConnectionProperties{
	// 						GroupIDs: []*string{
	// 							to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")},
	// 							PrivateEndpoint: &armelasticsan.PrivateEndpoint{
	// 								ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}"),
	// 							},
	// 							PrivateLinkServiceConnectionState: &armelasticsan.PrivateLinkServiceConnectionState{
	// 								Description: to.Ptr("Auto-Approved"),
	// 								ActionsRequired: to.Ptr("None"),
	// 								Status: to.Ptr(armelasticsan.PrivateEndpointServiceConnectionStatusPending),
	// 							},
	// 							ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
	// 						},
	// 				}},
	// 				ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
	// 				PublicNetworkAccess: to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
	// 				SKU: &armelasticsan.SKU{
	// 					Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
	// 					Tier: to.Ptr(armelasticsan.SKUTierPremium),
	// 				},
	// 				TotalIops: to.Ptr[int64](22),
	// 				TotalMBps: to.Ptr[int64](4),
	// 				TotalSizeTiB: to.Ptr[int64](27),
	// 				TotalVolumeSizeGiB: to.Ptr[int64](15),
	// 				VolumeGroupCount: to.Ptr[int64](24),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_Update_MinimumSet_Gen.json
func ExampleElasticSansClient_BeginUpdate_elasticSansUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewElasticSansClient().BeginUpdate(ctx, "resourcegroupname", "elasticsanname", armelasticsan.Update{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ElasticSan = armelasticsan.ElasticSan{
	// 	Name: to.Ptr("vfoatmakv"),
	// 	Type: to.Ptr("Microsoft.ElasticSan/ElasticSans"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}"),
	// 	SystemData: &armelasticsan.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
	// 		CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
	// 		LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("France Central"),
	// 	Tags: map[string]*string{
	// 		"key5002": to.Ptr("lhag"),
	// 	},
	// 	Properties: &armelasticsan.Properties{
	// 		AvailabilityZones: []*string{
	// 			to.Ptr("1")},
	// 			BaseSizeTiB: to.Ptr[int64](15),
	// 			ExtendedCapacitySizeTiB: to.Ptr[int64](6),
	// 			PrivateEndpointConnections: []*armelasticsan.PrivateEndpointConnection{
	// 				{
	// 					Name: to.Ptr("{privateEndpointConnectionName}"),
	// 					Type: to.Ptr("Microsoft.ElasticSan/elasticSans/privateEndpointConnections"),
	// 					ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/privateEndpointConnections/{privateEndpointConnectionName}"),
	// 					SystemData: &armelasticsan.SystemData{
	// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
	// 						CreatedBy: to.Ptr("kakcyehdrphqkilgkhpbdtvpupak"),
	// 						CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-23T12:16:10.057Z"); return t}()),
	// 						LastModifiedBy: to.Ptr("bcclmbseed"),
	// 						LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 					},
	// 					Properties: &armelasticsan.PrivateEndpointConnectionProperties{
	// 						GroupIDs: []*string{
	// 							to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")},
	// 							PrivateEndpoint: &armelasticsan.PrivateEndpoint{
	// 								ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}"),
	// 							},
	// 							PrivateLinkServiceConnectionState: &armelasticsan.PrivateLinkServiceConnectionState{
	// 								Description: to.Ptr("Auto-Approved"),
	// 								ActionsRequired: to.Ptr("None"),
	// 								Status: to.Ptr(armelasticsan.PrivateEndpointServiceConnectionStatusPending),
	// 							},
	// 							ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
	// 						},
	// 				}},
	// 				ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
	// 				PublicNetworkAccess: to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
	// 				SKU: &armelasticsan.SKU{
	// 					Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
	// 					Tier: to.Ptr(armelasticsan.SKUTierPremium),
	// 				},
	// 				TotalIops: to.Ptr[int64](22),
	// 				TotalMBps: to.Ptr[int64](4),
	// 				TotalSizeTiB: to.Ptr[int64](27),
	// 				TotalVolumeSizeGiB: to.Ptr[int64](15),
	// 				VolumeGroupCount: to.Ptr[int64](24),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_Delete_MaximumSet_Gen.json
func ExampleElasticSansClient_BeginDelete_elasticSansDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewElasticSansClient().BeginDelete(ctx, "resourcegroupname", "elasticsanname", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_Delete_MinimumSet_Gen.json
func ExampleElasticSansClient_BeginDelete_elasticSansDeleteMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewElasticSansClient().BeginDelete(ctx, "resourcegroupname", "elasticsanname", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_Get_MaximumSet_Gen.json
func ExampleElasticSansClient_Get_elasticSansGetMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewElasticSansClient().Get(ctx, "resourcegroupname", "elasticsanname", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ElasticSan = armelasticsan.ElasticSan{
	// 	Name: to.Ptr("vfoatmakv"),
	// 	Type: to.Ptr("Microsoft.ElasticSan/ElasticSans"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}"),
	// 	SystemData: &armelasticsan.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
	// 		CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
	// 		LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("France Central"),
	// 	Tags: map[string]*string{
	// 		"key5002": to.Ptr("lhag"),
	// 	},
	// 	Properties: &armelasticsan.Properties{
	// 		AvailabilityZones: []*string{
	// 			to.Ptr("1")},
	// 			BaseSizeTiB: to.Ptr[int64](15),
	// 			ExtendedCapacitySizeTiB: to.Ptr[int64](6),
	// 			PrivateEndpointConnections: []*armelasticsan.PrivateEndpointConnection{
	// 				{
	// 					Name: to.Ptr("{privateEndpointConnectionName}"),
	// 					Type: to.Ptr("Microsoft.ElasticSan/elasticSans/privateEndpointConnections"),
	// 					ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/privateEndpointConnections/{privateEndpointConnectionName}"),
	// 					SystemData: &armelasticsan.SystemData{
	// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 						CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
	// 						CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 						LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
	// 						LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 					},
	// 					Properties: &armelasticsan.PrivateEndpointConnectionProperties{
	// 						GroupIDs: []*string{
	// 							to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")},
	// 							PrivateEndpoint: &armelasticsan.PrivateEndpoint{
	// 								ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}"),
	// 							},
	// 							PrivateLinkServiceConnectionState: &armelasticsan.PrivateLinkServiceConnectionState{
	// 								Description: to.Ptr("Auto-Approved"),
	// 								ActionsRequired: to.Ptr("None"),
	// 								Status: to.Ptr(armelasticsan.PrivateEndpointServiceConnectionStatusPending),
	// 							},
	// 							ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
	// 						},
	// 				}},
	// 				ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
	// 				PublicNetworkAccess: to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
	// 				SKU: &armelasticsan.SKU{
	// 					Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
	// 					Tier: to.Ptr(armelasticsan.SKUTierPremium),
	// 				},
	// 				TotalIops: to.Ptr[int64](22),
	// 				TotalMBps: to.Ptr[int64](4),
	// 				TotalSizeTiB: to.Ptr[int64](27),
	// 				TotalVolumeSizeGiB: to.Ptr[int64](15),
	// 				VolumeGroupCount: to.Ptr[int64](24),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/907b79c0a6a660826e54dc1f16ea14b831b201d2/specification/elasticsan/resource-manager/Microsoft.ElasticSan/stable/2023-01-01/examples/ElasticSans_Get_MinimumSet_Gen.json
func ExampleElasticSansClient_Get_elasticSansGetMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armelasticsan.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewElasticSansClient().Get(ctx, "resourcegroupname", "elasticsanname", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ElasticSan = armelasticsan.ElasticSan{
	// 	Name: to.Ptr("vfoatmakv"),
	// 	Type: to.Ptr("Microsoft.ElasticSan/ElasticSans"),
	// 	ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}"),
	// 	SystemData: &armelasticsan.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
	// 		CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
	// 		LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("France Central"),
	// 	Tags: map[string]*string{
	// 		"key5002": to.Ptr("lhag"),
	// 	},
	// 	Properties: &armelasticsan.Properties{
	// 		AvailabilityZones: []*string{
	// 			to.Ptr("1")},
	// 			BaseSizeTiB: to.Ptr[int64](15),
	// 			ExtendedCapacitySizeTiB: to.Ptr[int64](6),
	// 			PrivateEndpointConnections: []*armelasticsan.PrivateEndpointConnection{
	// 				{
	// 					Name: to.Ptr("{privateEndpointConnectionName}"),
	// 					Type: to.Ptr("Microsoft.ElasticSan/elasticSans/privateEndpointConnections"),
	// 					ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/privateEndpointConnections/{privateEndpointConnectionName}"),
	// 					SystemData: &armelasticsan.SystemData{
	// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 						CreatedBy: to.Ptr("otfifnrahdshqombvtg"),
	// 						CreatedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-03T09:59:45.919Z"); return t}()),
	// 						LastModifiedBy: to.Ptr("jnaxavnlhrboshtidtib"),
	// 						LastModifiedByType: to.Ptr(armelasticsan.CreatedByTypeUser),
	// 					},
	// 					Properties: &armelasticsan.PrivateEndpointConnectionProperties{
	// 						GroupIDs: []*string{
	// 							to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}")},
	// 							PrivateEndpoint: &armelasticsan.PrivateEndpoint{
	// 								ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}"),
	// 							},
	// 							PrivateLinkServiceConnectionState: &armelasticsan.PrivateLinkServiceConnectionState{
	// 								Description: to.Ptr("Auto-Approved"),
	// 								ActionsRequired: to.Ptr("None"),
	// 								Status: to.Ptr(armelasticsan.PrivateEndpointServiceConnectionStatusPending),
	// 							},
	// 							ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
	// 						},
	// 				}},
	// 				ProvisioningState: to.Ptr(armelasticsan.ProvisioningStatesSucceeded),
	// 				PublicNetworkAccess: to.Ptr(armelasticsan.PublicNetworkAccessEnabled),
	// 				SKU: &armelasticsan.SKU{
	// 					Name: to.Ptr(armelasticsan.SKUNamePremiumLRS),
	// 					Tier: to.Ptr(armelasticsan.SKUTierPremium),
	// 				},
	// 				TotalIops: to.Ptr[int64](22),
	// 				TotalMBps: to.Ptr[int64](4),
	// 				TotalSizeTiB: to.Ptr[int64](27),
	// 				TotalVolumeSizeGiB: to.Ptr[int64](15),
	// 				VolumeGroupCount: to.Ptr[int64](24),
	// 			},
	// 		}
}
