//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armedgeorder_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/edgeorder/armedgeorder"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListOperations.json
func ExampleManagementClient_NewListOperationsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagementClient().NewListOperationsPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armedgeorder.OperationListResult{
		// 	Value: []*armedgeorder.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/addresses/read"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("List or get the Addresses"),
		// 				Operation: to.Ptr("List or Get Addresses"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("Addresses"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/addresses/delete"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("Delete the Addresses"),
		// 				Operation: to.Ptr("Delete Addresses"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("Addresses"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/addresses/write"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("Create or update the Addresses"),
		// 				Operation: to.Ptr("Create or Update Addresses"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("Addresses"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/locations/operationResults/read"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("List or get the Operation Results"),
		// 				Operation: to.Ptr("List or Get Operation Results"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("Operation Results"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/operations/read"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("List or get the Operations"),
		// 				Operation: to.Ptr("List or Get Operations"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("Operations"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/locations/orders/read"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("List or get the Order"),
		// 				Operation: to.Ptr("List or Get Order"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("Order"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/orders/read"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("List or get the Order"),
		// 				Operation: to.Ptr("List or Get Order"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("Order"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/orderItems/cancel/action"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("Cancels an OrderItem in progress."),
		// 				Operation: to.Ptr("Cancel OrderItem"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("OrderItem"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/orderItems/return/action"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("Return an OrderItem."),
		// 				Operation: to.Ptr("Return OrderItem"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("OrderItem"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/orderItems/read"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("List or get the OrderItem"),
		// 				Operation: to.Ptr("List or Get OrderItem"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("OrderItem"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/orderItems/delete"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("Delete the OrderItem"),
		// 				Operation: to.Ptr("Delete OrderItem"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("OrderItem"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/orderItems/write"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("Create or update the OrderItem"),
		// 				Operation: to.Ptr("Create or Update OrderItem"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("OrderItem"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/productFamiliesMetadata/action"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("This method lists or gets the product families metadata."),
		// 				Operation: to.Ptr("List or Get product families metadata"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("ArmApiRes_Microsoft.EdgeOrder"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/listProductFamilies/read"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("This method returns list of product families."),
		// 				Operation: to.Ptr("List Product Families"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("ArmApiRes_Microsoft.EdgeOrder"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.EdgeOrder/listConfigurations/action"),
		// 			Display: &armedgeorder.OperationDisplay{
		// 				Description: to.Ptr("This method returns list of product configurations."),
		// 				Operation: to.Ptr("List Product Configurations"),
		// 				Provider: to.Ptr("Edge Ordering"),
		// 				Resource: to.Ptr("ArmApiRes_Microsoft.EdgeOrder"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 			Origin: to.Ptr(armedgeorder.OriginUser),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListAddressesAtSubscriptionLevel.json
func ExampleManagementClient_NewListAddressesAtSubscriptionLevelPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagementClient().NewListAddressesAtSubscriptionLevelPager(&armedgeorder.ManagementClientListAddressesAtSubscriptionLevelOptions{Filter: nil,
		SkipToken: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AddressResourceList = armedgeorder.AddressResourceList{
		// 	Value: []*armedgeorder.AddressResource{
		// 		{
		// 			Name: to.Ptr("TestAddressName1"),
		// 			Type: to.Ptr("Microsoft.EdgeOrder/addresses"),
		// 			ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/addresses/TestAddressName1"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armedgeorder.AddressProperties{
		// 				AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
		// 				ContactDetails: &armedgeorder.ContactDetails{
		// 					ContactName: to.Ptr("XXXX XXXX"),
		// 					EmailList: []*string{
		// 						to.Ptr("xxxx@xxxx.xxx")},
		// 						Phone: to.Ptr("0000000000"),
		// 						PhoneExtension: to.Ptr(""),
		// 					},
		// 					ShippingAddress: &armedgeorder.ShippingAddress{
		// 						AddressType: to.Ptr(armedgeorder.AddressTypeNone),
		// 						City: to.Ptr("San Francisco"),
		// 						CompanyName: to.Ptr("Microsoft"),
		// 						Country: to.Ptr("US"),
		// 						PostalCode: to.Ptr("94107"),
		// 						StateOrProvince: to.Ptr("CA"),
		// 						StreetAddress1: to.Ptr("16 TOWNSEND ST"),
		// 						StreetAddress2: to.Ptr("UNIT 1"),
		// 					},
		// 				},
		// 				SystemData: &armedgeorder.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("TestAddressName2"),
		// 				Type: to.Ptr("Microsoft.EdgeOrder/addresses"),
		// 				ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/addresses/TestAddressName2"),
		// 				Location: to.Ptr("eastus"),
		// 				Tags: map[string]*string{
		// 				},
		// 				Properties: &armedgeorder.AddressProperties{
		// 					AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
		// 					ContactDetails: &armedgeorder.ContactDetails{
		// 						ContactName: to.Ptr("XXXX XXXX"),
		// 						EmailList: []*string{
		// 							to.Ptr("xxxx@xxxx.xxx")},
		// 							Phone: to.Ptr("0000000000"),
		// 							PhoneExtension: to.Ptr(""),
		// 						},
		// 						ShippingAddress: &armedgeorder.ShippingAddress{
		// 							AddressType: to.Ptr(armedgeorder.AddressTypeNone),
		// 							City: to.Ptr("San Francisco"),
		// 							CompanyName: to.Ptr("Microsoft"),
		// 							Country: to.Ptr("US"),
		// 							PostalCode: to.Ptr("94107"),
		// 							StateOrProvince: to.Ptr("CA"),
		// 							StreetAddress1: to.Ptr("16 TOWNSEND ST"),
		// 							StreetAddress2: to.Ptr("UNIT 1"),
		// 						},
		// 					},
		// 					SystemData: &armedgeorder.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListProductFamilies.json
func ExampleManagementClient_NewListProductFamiliesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagementClient().NewListProductFamiliesPager(armedgeorder.ProductFamiliesRequest{
		FilterableProperties: map[string][]*armedgeorder.FilterableProperty{
			"azurestackedge": {
				{
					Type: to.Ptr(armedgeorder.SupportedFilterTypesShipToCountries),
					SupportedValues: []*string{
						to.Ptr("US")},
				}},
		},
	}, &armedgeorder.ManagementClientListProductFamiliesOptions{Expand: to.Ptr("configurations"),
		SkipToken: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProductFamilies = armedgeorder.ProductFamilies{
		// 	Value: []*armedgeorder.ProductFamily{
		// 		{
		// 			Properties: &armedgeorder.ProductFamilyProperties{
		// 				Description: &armedgeorder.Description{
		// 					Attributes: []*string{
		// 					},
		// 					DescriptionType: to.Ptr(armedgeorder.DescriptionTypeBase),
		// 					Keywords: []*string{
		// 					},
		// 					Links: []*armedgeorder.Link{
		// 					},
		// 					ShortDescription: to.Ptr("Azure managed physical edge compute device"),
		// 				},
		// 				AvailabilityInformation: &armedgeorder.AvailabilityInformation{
		// 					AvailabilityStage: to.Ptr(armedgeorder.AvailabilityStageAvailable),
		// 					DisabledReason: to.Ptr(armedgeorder.DisabledReasonNone),
		// 				},
		// 				DisplayName: to.Ptr("Azure Stack Edge"),
		// 				HierarchyInformation: &armedgeorder.HierarchyInformation{
		// 					ConfigurationName: to.Ptr(""),
		// 					ProductFamilyName: to.Ptr("azurestackedge"),
		// 					ProductLineName: to.Ptr(""),
		// 					ProductName: to.Ptr(""),
		// 				},
		// 				ImageInformation: []*armedgeorder.ImageInformation{
		// 				},
		// 				FilterableProperties: []*armedgeorder.FilterableProperty{
		// 					{
		// 						Type: to.Ptr(armedgeorder.SupportedFilterTypesShipToCountries),
		// 						SupportedValues: []*string{
		// 							to.Ptr("US")},
		// 						},
		// 						{
		// 							Type: to.Ptr(armedgeorder.SupportedFilterTypesDoubleEncryptionStatus),
		// 							SupportedValues: []*string{
		// 								to.Ptr("Enabled")},
		// 						}},
		// 						ProductLines: []*armedgeorder.ProductLine{
		// 							{
		// 								Properties: &armedgeorder.ProductLineProperties{
		// 									Description: &armedgeorder.Description{
		// 										Attributes: []*string{
		// 										},
		// 										DescriptionType: to.Ptr(armedgeorder.DescriptionTypeBase),
		// 										Keywords: []*string{
		// 										},
		// 										Links: []*armedgeorder.Link{
		// 										},
		// 									},
		// 									AvailabilityInformation: &armedgeorder.AvailabilityInformation{
		// 										AvailabilityStage: to.Ptr(armedgeorder.AvailabilityStageAvailable),
		// 										DisabledReason: to.Ptr(armedgeorder.DisabledReasonNone),
		// 									},
		// 									DisplayName: to.Ptr("Azure Stack Edge"),
		// 									HierarchyInformation: &armedgeorder.HierarchyInformation{
		// 										ConfigurationName: to.Ptr(""),
		// 										ProductFamilyName: to.Ptr("azurestackedge"),
		// 										ProductLineName: to.Ptr("azurestackedge"),
		// 										ProductName: to.Ptr(""),
		// 									},
		// 									ImageInformation: []*armedgeorder.ImageInformation{
		// 									},
		// 									FilterableProperties: []*armedgeorder.FilterableProperty{
		// 										{
		// 											Type: to.Ptr(armedgeorder.SupportedFilterTypesShipToCountries),
		// 											SupportedValues: []*string{
		// 												to.Ptr("US")},
		// 											},
		// 											{
		// 												Type: to.Ptr(armedgeorder.SupportedFilterTypesDoubleEncryptionStatus),
		// 												SupportedValues: []*string{
		// 													to.Ptr("Enabled")},
		// 											}},
		// 											Products: []*armedgeorder.Product{
		// 												{
		// 													Properties: &armedgeorder.ProductProperties{
		// 														Description: &armedgeorder.Description{
		// 															Attributes: []*string{
		// 																to.Ptr("1U rack mount device with network data transfer capabilities"),
		// 																to.Ptr("Hardware accelerated ML using Nvidia T4 GPU"),
		// 																to.Ptr("Azure Private Edge Zones enabled")},
		// 																DescriptionType: to.Ptr(armedgeorder.DescriptionTypeBase),
		// 																Keywords: []*string{
		// 																	to.Ptr("GPU")},
		// 																	Links: []*armedgeorder.Link{
		// 																		{
		// 																			LinkType: to.Ptr(armedgeorder.LinkTypeSpecification),
		// 																			LinkURL: to.Ptr("https://aka.ms/edgeHWcenter-asepro-devicespec"),
		// 																		},
		// 																		{
		// 																			LinkType: to.Ptr(armedgeorder.LinkTypeGeneric),
		// 																			LinkURL: to.Ptr("https://aka.ms/ase-gpu-billing"),
		// 																		},
		// 																		{
		// 																			LinkType: to.Ptr(armedgeorder.LinkTypeTermsAndConditions),
		// 																			LinkURL: to.Ptr("https://aka.ms/ase-gpu-product-terms"),
		// 																		},
		// 																		{
		// 																			LinkType: to.Ptr(armedgeorder.LinkTypeKnowMore),
		// 																			LinkURL: to.Ptr("https://aka.ms/edgeHWcenter-asepro-documentation"),
		// 																	}},
		// 																	LongDescription: to.Ptr("Azure Stack Edge Pro is an AI-enabled edge computing device with network data transfer capabilities. The device is powered with NVIDIA T4 GPUs to provide accelerated AI inferencing at the edge. You can choose from the following configurations based upon your business need"),
		// 																	ShortDescription: to.Ptr("Azure managed physical edge compute device"),
		// 																},
		// 																AvailabilityInformation: &armedgeorder.AvailabilityInformation{
		// 																	AvailabilityStage: to.Ptr(armedgeorder.AvailabilityStageAvailable),
		// 																	DisabledReason: to.Ptr(armedgeorder.DisabledReasonNone),
		// 																},
		// 																DisplayName: to.Ptr("Azure Stack Edge Pro - GPU"),
		// 																HierarchyInformation: &armedgeorder.HierarchyInformation{
		// 																	ConfigurationName: to.Ptr(""),
		// 																	ProductFamilyName: to.Ptr("azurestackedge"),
		// 																	ProductLineName: to.Ptr("azurestackedge"),
		// 																	ProductName: to.Ptr("azurestackedgegpu"),
		// 																},
		// 																ImageInformation: []*armedgeorder.ImageInformation{
		// 																},
		// 																FilterableProperties: []*armedgeorder.FilterableProperty{
		// 																	{
		// 																		Type: to.Ptr(armedgeorder.SupportedFilterTypesShipToCountries),
		// 																		SupportedValues: []*string{
		// 																			to.Ptr("US")},
		// 																	}},
		// 																	Configurations: []*armedgeorder.Configuration{
		// 																		{
		// 																			Properties: &armedgeorder.ConfigurationProperties{
		// 																				Description: &armedgeorder.Description{
		// 																					Attributes: []*string{
		// 																					},
		// 																					DescriptionType: to.Ptr(armedgeorder.DescriptionTypeBase),
		// 																					Keywords: []*string{
		// 																						to.Ptr("GPU")},
		// 																						Links: []*armedgeorder.Link{
		// 																						},
		// 																						LongDescription: to.Ptr(""),
		// 																						ShortDescription: to.Ptr(""),
		// 																					},
		// 																					AvailabilityInformation: &armedgeorder.AvailabilityInformation{
		// 																						AvailabilityStage: to.Ptr(armedgeorder.AvailabilityStageAvailable),
		// 																						DisabledReason: to.Ptr(armedgeorder.DisabledReasonNone),
		// 																					},
		// 																					CostInformation: &armedgeorder.CostInformation{
		// 																						BillingMeterDetails: []*armedgeorder.BillingMeterDetails{
		// 																						},
		// 																					},
		// 																					DisplayName: to.Ptr("Azure Stack Edge Pro - 1 GPU"),
		// 																					HierarchyInformation: &armedgeorder.HierarchyInformation{
		// 																						ConfigurationName: to.Ptr("edgep_base"),
		// 																						ProductFamilyName: to.Ptr("azurestackedge"),
		// 																						ProductLineName: to.Ptr("azurestackedge"),
		// 																						ProductName: to.Ptr("azurestackedgegpu"),
		// 																					},
		// 																					ImageInformation: []*armedgeorder.ImageInformation{
		// 																					},
		// 																					FilterableProperties: []*armedgeorder.FilterableProperty{
		// 																						{
		// 																							Type: to.Ptr(armedgeorder.SupportedFilterTypesShipToCountries),
		// 																							SupportedValues: []*string{
		// 																								to.Ptr("US")},
		// 																						}},
		// 																						Dimensions: &armedgeorder.Dimensions{
		// 																							Depth: to.Ptr[float64](2),
		// 																							Height: to.Ptr[float64](15),
		// 																							Length: to.Ptr[float64](50),
		// 																							LengthHeightUnit: to.Ptr(armedgeorder.LengthHeightUnitIN),
		// 																							Weight: to.Ptr[float64](50),
		// 																							WeightUnit: to.Ptr(armedgeorder.WeightMeasurementUnitLBS),
		// 																							Width: to.Ptr[float64](5),
		// 																						},
		// 																						Specifications: []*armedgeorder.Specification{
		// 																							{
		// 																								Name: to.Ptr("Usable compute"),
		// 																								Value: to.Ptr("40 vCPU"),
		// 																							},
		// 																							{
		// 																								Name: to.Ptr("Usable memory"),
		// 																								Value: to.Ptr("102 GB"),
		// 																							},
		// 																							{
		// 																								Name: to.Ptr("Usable storage"),
		// 																								Value: to.Ptr("4.2 TB"),
		// 																						}},
		// 																					},
		// 																			}},
		// 																		},
		// 																}},
		// 															},
		// 													}},
		// 													ResourceProviderDetails: []*armedgeorder.ResourceProviderDetails{
		// 														{
		// 															ResourceProviderNamespace: to.Ptr("Microsoft.DataBoxEdge"),
		// 													}},
		// 												},
		// 										}},
		// 									}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListConfigurations.json
func ExampleManagementClient_NewListConfigurationsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagementClient().NewListConfigurationsPager(armedgeorder.ConfigurationsRequest{
		ConfigurationFilters: []*armedgeorder.ConfigurationFilters{
			{
				FilterableProperty: []*armedgeorder.FilterableProperty{
					{
						Type: to.Ptr(armedgeorder.SupportedFilterTypesShipToCountries),
						SupportedValues: []*string{
							to.Ptr("US")},
					}},
				HierarchyInformation: &armedgeorder.HierarchyInformation{
					ProductFamilyName: to.Ptr("azurestackedge"),
					ProductLineName:   to.Ptr("azurestackedge"),
					ProductName:       to.Ptr("azurestackedgegpu"),
				},
			}},
	}, &armedgeorder.ManagementClientListConfigurationsOptions{SkipToken: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.Configurations = armedgeorder.Configurations{
		// 	Value: []*armedgeorder.Configuration{
		// 		{
		// 			Properties: &armedgeorder.ConfigurationProperties{
		// 				Description: &armedgeorder.Description{
		// 					Attributes: []*string{
		// 					},
		// 					DescriptionType: to.Ptr(armedgeorder.DescriptionTypeBase),
		// 					Keywords: []*string{
		// 						to.Ptr("GPU")},
		// 						Links: []*armedgeorder.Link{
		// 						},
		// 						LongDescription: to.Ptr(""),
		// 						ShortDescription: to.Ptr(""),
		// 					},
		// 					AvailabilityInformation: &armedgeorder.AvailabilityInformation{
		// 						AvailabilityStage: to.Ptr(armedgeorder.AvailabilityStageAvailable),
		// 						DisabledReason: to.Ptr(armedgeorder.DisabledReasonNone),
		// 					},
		// 					CostInformation: &armedgeorder.CostInformation{
		// 						BillingMeterDetails: []*armedgeorder.BillingMeterDetails{
		// 						},
		// 					},
		// 					DisplayName: to.Ptr("Azure Stack Edge Pro - 1 GPU"),
		// 					HierarchyInformation: &armedgeorder.HierarchyInformation{
		// 						ConfigurationName: to.Ptr("edgep_base"),
		// 						ProductFamilyName: to.Ptr("azurestackedge"),
		// 						ProductLineName: to.Ptr("azurestackedge"),
		// 						ProductName: to.Ptr("azurestackedgegpu"),
		// 					},
		// 					ImageInformation: []*armedgeorder.ImageInformation{
		// 					},
		// 					FilterableProperties: []*armedgeorder.FilterableProperty{
		// 						{
		// 							Type: to.Ptr(armedgeorder.SupportedFilterTypesShipToCountries),
		// 							SupportedValues: []*string{
		// 								to.Ptr("US")},
		// 						}},
		// 						Dimensions: &armedgeorder.Dimensions{
		// 							Depth: to.Ptr[float64](2),
		// 							Height: to.Ptr[float64](15),
		// 							Length: to.Ptr[float64](50),
		// 							LengthHeightUnit: to.Ptr(armedgeorder.LengthHeightUnitIN),
		// 							Weight: to.Ptr[float64](50),
		// 							WeightUnit: to.Ptr(armedgeorder.WeightMeasurementUnitLBS),
		// 							Width: to.Ptr[float64](5),
		// 						},
		// 						Specifications: []*armedgeorder.Specification{
		// 							{
		// 								Name: to.Ptr("Usable compute"),
		// 								Value: to.Ptr("40 vCPU"),
		// 							},
		// 							{
		// 								Name: to.Ptr("Usable memory"),
		// 								Value: to.Ptr("102 GB"),
		// 							},
		// 							{
		// 								Name: to.Ptr("Usable storage"),
		// 								Value: to.Ptr("4.2 TB"),
		// 						}},
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListProductFamiliesMetadata.json
func ExampleManagementClient_NewListProductFamiliesMetadataPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagementClient().NewListProductFamiliesMetadataPager(&armedgeorder.ManagementClientListProductFamiliesMetadataOptions{SkipToken: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProductFamiliesMetadata = armedgeorder.ProductFamiliesMetadata{
		// 	Value: []*armedgeorder.ProductFamiliesMetadataDetails{
		// 		{
		// 			Properties: &armedgeorder.ProductFamilyProperties{
		// 				Description: &armedgeorder.Description{
		// 					Attributes: []*string{
		// 					},
		// 					DescriptionType: to.Ptr(armedgeorder.DescriptionTypeBase),
		// 					Keywords: []*string{
		// 					},
		// 					Links: []*armedgeorder.Link{
		// 					},
		// 					ShortDescription: to.Ptr("Azure managed physical edge compute device"),
		// 				},
		// 				AvailabilityInformation: &armedgeorder.AvailabilityInformation{
		// 					AvailabilityStage: to.Ptr(armedgeorder.AvailabilityStageAvailable),
		// 					DisabledReason: to.Ptr(armedgeorder.DisabledReasonNone),
		// 				},
		// 				DisplayName: to.Ptr("Azure Stack Edge"),
		// 				HierarchyInformation: &armedgeorder.HierarchyInformation{
		// 					ConfigurationName: to.Ptr(""),
		// 					ProductFamilyName: to.Ptr("azurestackedge"),
		// 					ProductLineName: to.Ptr(""),
		// 					ProductName: to.Ptr(""),
		// 				},
		// 				ImageInformation: []*armedgeorder.ImageInformation{
		// 				},
		// 				FilterableProperties: []*armedgeorder.FilterableProperty{
		// 					{
		// 						Type: to.Ptr(armedgeorder.SupportedFilterTypesShipToCountries),
		// 						SupportedValues: []*string{
		// 							to.Ptr("US")},
		// 						},
		// 						{
		// 							Type: to.Ptr(armedgeorder.SupportedFilterTypesDoubleEncryptionStatus),
		// 							SupportedValues: []*string{
		// 								to.Ptr("Enabled")},
		// 						}},
		// 						ProductLines: []*armedgeorder.ProductLine{
		// 						},
		// 						ResourceProviderDetails: []*armedgeorder.ResourceProviderDetails{
		// 							{
		// 								ResourceProviderNamespace: to.Ptr("Microsoft.DataBoxEdge"),
		// 						}},
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListOrderAtSubscriptionLevel.json
func ExampleManagementClient_NewListOrderAtSubscriptionLevelPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagementClient().NewListOrderAtSubscriptionLevelPager(&armedgeorder.ManagementClientListOrderAtSubscriptionLevelOptions{SkipToken: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OrderResourceList = armedgeorder.OrderResourceList{
		// 	Value: []*armedgeorder.OrderResource{
		// 		{
		// 			Name: to.Ptr("TestOrderItemName1"),
		// 			Type: to.Ptr("Microsoft.EdgeOrder/orders"),
		// 			ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName1"),
		// 			Properties: &armedgeorder.OrderProperties{
		// 				CurrentStage: &armedgeorder.StageDetails{
		// 					StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 					StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:25:46.943Z"); return t}()),
		// 				},
		// 				OrderItemIDs: []*string{
		// 					to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName1")},
		// 					OrderStageHistory: []*armedgeorder.StageDetails{
		// 						{
		// 							StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 							StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 							StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:25:46.943Z"); return t}()),
		// 						},
		// 						{
		// 							StageName: to.Ptr(armedgeorder.StageNameInReview),
		// 							StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 					}},
		// 				},
		// 				SystemData: &armedgeorder.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("TestOrderItemName2"),
		// 				Type: to.Ptr("Microsoft.EdgeOrder/orders"),
		// 				ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2"),
		// 				Properties: &armedgeorder.OrderProperties{
		// 					CurrentStage: &armedgeorder.StageDetails{
		// 						StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 						StageStatus: to.Ptr(armedgeorder.StageStatusInProgress),
		// 						StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:28:46.524Z"); return t}()),
		// 					},
		// 					OrderItemIDs: []*string{
		// 						to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName2")},
		// 						OrderStageHistory: []*armedgeorder.StageDetails{
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameInReview),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 						}},
		// 					},
		// 					SystemData: &armedgeorder.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListOrderItemsAtSubscriptionLevel.json
func ExampleManagementClient_NewListOrderItemsAtSubscriptionLevelPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagementClient().NewListOrderItemsAtSubscriptionLevelPager(&armedgeorder.ManagementClientListOrderItemsAtSubscriptionLevelOptions{Filter: nil,
		Expand:    nil,
		SkipToken: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OrderItemResourceList = armedgeorder.OrderItemResourceList{
		// 	Value: []*armedgeorder.OrderItemResource{
		// 		{
		// 			Name: to.Ptr("TestOrderItemName1"),
		// 			Type: to.Ptr("Microsoft.EdgeOrder/orderItems"),
		// 			ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName1"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armedgeorder.OrderItemProperties{
		// 				AddressDetails: &armedgeorder.AddressDetails{
		// 					ForwardAddress: &armedgeorder.AddressProperties{
		// 						AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
		// 						ContactDetails: &armedgeorder.ContactDetails{
		// 							ContactName: to.Ptr("XXXX XXXX"),
		// 							EmailList: []*string{
		// 								to.Ptr("xxxx@xxxx.xxx")},
		// 								Phone: to.Ptr("0000000000"),
		// 								PhoneExtension: to.Ptr(""),
		// 							},
		// 							ShippingAddress: &armedgeorder.ShippingAddress{
		// 								AddressType: to.Ptr(armedgeorder.AddressTypeNone),
		// 								City: to.Ptr("San Francisco"),
		// 								CompanyName: to.Ptr("Microsoft"),
		// 								Country: to.Ptr("US"),
		// 								PostalCode: to.Ptr("94107"),
		// 								StateOrProvince: to.Ptr("CA"),
		// 								StreetAddress1: to.Ptr("16 TOWNSEND ST"),
		// 								StreetAddress2: to.Ptr("UNIT 1"),
		// 							},
		// 						},
		// 					},
		// 					OrderID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName1"),
		// 					OrderItemDetails: &armedgeorder.OrderItemDetails{
		// 						CancellationStatus: to.Ptr(armedgeorder.OrderItemCancellationEnumNotCancellable),
		// 						CurrentStage: &armedgeorder.StageDetails{
		// 							StageName: to.Ptr(armedgeorder.StageNameConfirmed),
		// 							StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 							StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:35:00.357Z"); return t}()),
		// 						},
		// 						DeletionStatus: to.Ptr(armedgeorder.ActionStatusEnumNotAllowed),
		// 						ManagementRpDetailsList: []*armedgeorder.ResourceProviderDetails{
		// 							{
		// 								ResourceProviderNamespace: to.Ptr("Microsoft.DataBoxEdge"),
		// 						}},
		// 						NotificationEmailList: []*string{
		// 						},
		// 						OrderItemStageHistory: []*armedgeorder.StageDetails{
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 								StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:25:54.342Z"); return t}()),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameConfirmed),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 								StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:35:00.357Z"); return t}()),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameReadyToShip),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameShipped),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameDelivered),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameInUse),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 						}},
		// 						OrderItemType: to.Ptr(armedgeorder.OrderItemTypePurchase),
		// 						Preferences: &armedgeorder.Preferences{
		// 							TransportPreferences: &armedgeorder.TransportPreferences{
		// 								PreferredShipmentType: to.Ptr(armedgeorder.TransportShipmentTypesMicrosoftManaged),
		// 							},
		// 						},
		// 						ProductDetails: &armedgeorder.ProductDetails{
		// 							Count: to.Ptr[int32](0),
		// 							DisplayInfo: &armedgeorder.DisplayInfo{
		// 								ConfigurationDisplayName: to.Ptr("Azure Stack Edge Pro - 1 GPU"),
		// 								ProductFamilyDisplayName: to.Ptr("Azure Stack Edge"),
		// 							},
		// 							HierarchyInformation: &armedgeorder.HierarchyInformation{
		// 								ConfigurationName: to.Ptr("edgep_base"),
		// 								ProductFamilyName: to.Ptr("azurestackedge"),
		// 								ProductLineName: to.Ptr("azurestackedge"),
		// 								ProductName: to.Ptr("azurestackedgegpu"),
		// 							},
		// 							ProductDoubleEncryptionStatus: to.Ptr(armedgeorder.DoubleEncryptionStatusDisabled),
		// 						},
		// 						ReturnStatus: to.Ptr(armedgeorder.OrderItemReturnEnumNotReturnable),
		// 					},
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:25:10.282Z"); return t}()),
		// 				},
		// 				SystemData: &armedgeorder.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("TestOrderItemName2"),
		// 				Type: to.Ptr("Microsoft.EdgeOrder/orderItems"),
		// 				ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName2"),
		// 				Location: to.Ptr("eastus"),
		// 				Tags: map[string]*string{
		// 				},
		// 				Properties: &armedgeorder.OrderItemProperties{
		// 					AddressDetails: &armedgeorder.AddressDetails{
		// 						ForwardAddress: &armedgeorder.AddressProperties{
		// 							AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
		// 							ContactDetails: &armedgeorder.ContactDetails{
		// 								ContactName: to.Ptr("XXXX XXXX"),
		// 								EmailList: []*string{
		// 									to.Ptr("xxxx@xxxx.xxx")},
		// 									Phone: to.Ptr("0000000000"),
		// 									PhoneExtension: to.Ptr(""),
		// 								},
		// 								ShippingAddress: &armedgeorder.ShippingAddress{
		// 									AddressType: to.Ptr(armedgeorder.AddressTypeNone),
		// 									City: to.Ptr("San Francisco"),
		// 									CompanyName: to.Ptr("Microsoft"),
		// 									Country: to.Ptr("US"),
		// 									PostalCode: to.Ptr("94107"),
		// 									StateOrProvince: to.Ptr("CA"),
		// 									StreetAddress1: to.Ptr("16 TOWNSEND ST"),
		// 									StreetAddress2: to.Ptr("UNIT 1"),
		// 								},
		// 							},
		// 						},
		// 						OrderID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2"),
		// 						OrderItemDetails: &armedgeorder.OrderItemDetails{
		// 							CancellationStatus: to.Ptr(armedgeorder.OrderItemCancellationEnumNotCancellable),
		// 							CurrentStage: &armedgeorder.StageDetails{
		// 								StageName: to.Ptr(armedgeorder.StageNameConfirmed),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 								StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:37:29.989Z"); return t}()),
		// 							},
		// 							DeletionStatus: to.Ptr(armedgeorder.ActionStatusEnumNotAllowed),
		// 							ManagementRpDetailsList: []*armedgeorder.ResourceProviderDetails{
		// 								{
		// 									ResourceProviderNamespace: to.Ptr("Microsoft.DataBoxEdge"),
		// 							}},
		// 							NotificationEmailList: []*string{
		// 							},
		// 							OrderItemStageHistory: []*armedgeorder.StageDetails{
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 									StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:29:04.970Z"); return t}()),
		// 								},
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNameConfirmed),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 									StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:37:29.989Z"); return t}()),
		// 								},
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNameReadyToShip),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 								},
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNameShipped),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 								},
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNameDelivered),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 								},
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNameInUse),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 							}},
		// 							OrderItemType: to.Ptr(armedgeorder.OrderItemTypePurchase),
		// 							Preferences: &armedgeorder.Preferences{
		// 								TransportPreferences: &armedgeorder.TransportPreferences{
		// 									PreferredShipmentType: to.Ptr(armedgeorder.TransportShipmentTypesMicrosoftManaged),
		// 								},
		// 							},
		// 							ProductDetails: &armedgeorder.ProductDetails{
		// 								Count: to.Ptr[int32](0),
		// 								DisplayInfo: &armedgeorder.DisplayInfo{
		// 									ConfigurationDisplayName: to.Ptr("Azure Stack Edge Pro - 1 GPU"),
		// 									ProductFamilyDisplayName: to.Ptr("Azure Stack Edge"),
		// 								},
		// 								HierarchyInformation: &armedgeorder.HierarchyInformation{
		// 									ConfigurationName: to.Ptr("edgep_base"),
		// 									ProductFamilyName: to.Ptr("azurestackedge"),
		// 									ProductLineName: to.Ptr("azurestackedge"),
		// 									ProductName: to.Ptr("azurestackedgegpu"),
		// 								},
		// 								ProductDoubleEncryptionStatus: to.Ptr(armedgeorder.DoubleEncryptionStatusDisabled),
		// 							},
		// 							ReturnStatus: to.Ptr(armedgeorder.OrderItemReturnEnumNotReturnable),
		// 						},
		// 						StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:28:27.582Z"); return t}()),
		// 					},
		// 					SystemData: &armedgeorder.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListAddressesAtResourceGroupLevel.json
func ExampleManagementClient_NewListAddressesAtResourceGroupLevelPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagementClient().NewListAddressesAtResourceGroupLevelPager("YourResourceGroupName", &armedgeorder.ManagementClientListAddressesAtResourceGroupLevelOptions{Filter: nil,
		SkipToken: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AddressResourceList = armedgeorder.AddressResourceList{
		// 	Value: []*armedgeorder.AddressResource{
		// 		{
		// 			Name: to.Ptr("TestAddressName1"),
		// 			Type: to.Ptr("Microsoft.EdgeOrder/addresses"),
		// 			ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/addresses/TestAddressName1"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armedgeorder.AddressProperties{
		// 				AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
		// 				ContactDetails: &armedgeorder.ContactDetails{
		// 					ContactName: to.Ptr("XXXX XXXX"),
		// 					EmailList: []*string{
		// 						to.Ptr("xxxx@xxxx.xxx")},
		// 						Phone: to.Ptr("0000000000"),
		// 						PhoneExtension: to.Ptr(""),
		// 					},
		// 					ShippingAddress: &armedgeorder.ShippingAddress{
		// 						AddressType: to.Ptr(armedgeorder.AddressTypeNone),
		// 						City: to.Ptr("San Francisco"),
		// 						CompanyName: to.Ptr("Microsoft"),
		// 						Country: to.Ptr("US"),
		// 						PostalCode: to.Ptr("94107"),
		// 						StateOrProvince: to.Ptr("CA"),
		// 						StreetAddress1: to.Ptr("16 TOWNSEND ST"),
		// 						StreetAddress2: to.Ptr("UNIT 1"),
		// 					},
		// 				},
		// 				SystemData: &armedgeorder.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("TestAddressName2"),
		// 				Type: to.Ptr("Microsoft.EdgeOrder/addresses"),
		// 				ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/addresses/TestAddressName2"),
		// 				Location: to.Ptr("eastus"),
		// 				Tags: map[string]*string{
		// 					"tag1": to.Ptr("value1"),
		// 					"tag2": to.Ptr("value2"),
		// 				},
		// 				Properties: &armedgeorder.AddressProperties{
		// 					AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
		// 					ContactDetails: &armedgeorder.ContactDetails{
		// 						ContactName: to.Ptr("YYYY YYYY"),
		// 						EmailList: []*string{
		// 							to.Ptr("xxxx@xxxx.xxx")},
		// 							Phone: to.Ptr("0000000000"),
		// 							PhoneExtension: to.Ptr(""),
		// 						},
		// 						ShippingAddress: &armedgeorder.ShippingAddress{
		// 							AddressType: to.Ptr(armedgeorder.AddressTypeNone),
		// 							City: to.Ptr("San Francisco"),
		// 							CompanyName: to.Ptr("Microsoft"),
		// 							Country: to.Ptr("US"),
		// 							PostalCode: to.Ptr("94107"),
		// 							StateOrProvince: to.Ptr("CA"),
		// 							StreetAddress1: to.Ptr("16 TOWNSEND ST"),
		// 							StreetAddress2: to.Ptr("UNIT 1"),
		// 						},
		// 					},
		// 					SystemData: &armedgeorder.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/GetAddressByName.json
func ExampleManagementClient_GetAddressByName() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagementClient().GetAddressByName(ctx, "TestAddressName1", "YourResourceGroupName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AddressResource = armedgeorder.AddressResource{
	// 	Name: to.Ptr("TestAddressName1"),
	// 	Type: to.Ptr("Microsoft.EdgeOrder/addresses"),
	// 	ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/addresses/TestAddressName1"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armedgeorder.AddressProperties{
	// 		AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
	// 		ContactDetails: &armedgeorder.ContactDetails{
	// 			ContactName: to.Ptr("XXXX XXXX"),
	// 			EmailList: []*string{
	// 				to.Ptr("xxxx@xxxx.xxx")},
	// 				Phone: to.Ptr("0000000000"),
	// 				PhoneExtension: to.Ptr(""),
	// 			},
	// 			ShippingAddress: &armedgeorder.ShippingAddress{
	// 				AddressType: to.Ptr(armedgeorder.AddressTypeNone),
	// 				City: to.Ptr("San Francisco"),
	// 				CompanyName: to.Ptr("Microsoft"),
	// 				Country: to.Ptr("US"),
	// 				PostalCode: to.Ptr("94107"),
	// 				StateOrProvince: to.Ptr("CA"),
	// 				StreetAddress1: to.Ptr("16 TOWNSEND ST"),
	// 				StreetAddress2: to.Ptr("UNIT 1"),
	// 			},
	// 		},
	// 		SystemData: &armedgeorder.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/CreateAddress.json
func ExampleManagementClient_BeginCreateAddress() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagementClient().BeginCreateAddress(ctx, "TestAddressName2", "YourResourceGroupName", armedgeorder.AddressResource{
		Location: to.Ptr("eastus"),
		Properties: &armedgeorder.AddressProperties{
			ContactDetails: &armedgeorder.ContactDetails{
				ContactName: to.Ptr("XXXX XXXX"),
				EmailList: []*string{
					to.Ptr("xxxx@xxxx.xxx")},
				Phone:          to.Ptr("0000000000"),
				PhoneExtension: to.Ptr(""),
			},
			ShippingAddress: &armedgeorder.ShippingAddress{
				AddressType:     to.Ptr(armedgeorder.AddressTypeNone),
				City:            to.Ptr("San Francisco"),
				CompanyName:     to.Ptr("Microsoft"),
				Country:         to.Ptr("US"),
				PostalCode:      to.Ptr("94107"),
				StateOrProvince: to.Ptr("CA"),
				StreetAddress1:  to.Ptr("16 TOWNSEND ST"),
				StreetAddress2:  to.Ptr("UNIT 1"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AddressResource = armedgeorder.AddressResource{
	// 	Name: to.Ptr("TestAddressName2"),
	// 	Type: to.Ptr("Microsoft.EdgeOrder/addresses"),
	// 	ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/addresses/TestAddressName2"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armedgeorder.AddressProperties{
	// 		AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
	// 		ContactDetails: &armedgeorder.ContactDetails{
	// 			ContactName: to.Ptr("XXXX XXXX"),
	// 			EmailList: []*string{
	// 				to.Ptr("xxxx@xxxx.xxx")},
	// 				Phone: to.Ptr("0000000000"),
	// 				PhoneExtension: to.Ptr(""),
	// 			},
	// 			ShippingAddress: &armedgeorder.ShippingAddress{
	// 				AddressType: to.Ptr(armedgeorder.AddressTypeNone),
	// 				City: to.Ptr("San Francisco"),
	// 				CompanyName: to.Ptr("Microsoft"),
	// 				Country: to.Ptr("US"),
	// 				PostalCode: to.Ptr("94107"),
	// 				StateOrProvince: to.Ptr("CA"),
	// 				StreetAddress1: to.Ptr("16 TOWNSEND ST"),
	// 				StreetAddress2: to.Ptr("UNIT 1"),
	// 			},
	// 		},
	// 		SystemData: &armedgeorder.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/DeleteAddressByName.json
func ExampleManagementClient_BeginDeleteAddressByName() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagementClient().BeginDeleteAddressByName(ctx, "TestAddressName1", "YourResourceGroupName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/UpdateAddress.json
func ExampleManagementClient_BeginUpdateAddress() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagementClient().BeginUpdateAddress(ctx, "TestAddressName2", "YourResourceGroupName", armedgeorder.AddressUpdateParameter{
		Properties: &armedgeorder.AddressUpdateProperties{
			ContactDetails: &armedgeorder.ContactDetails{
				ContactName: to.Ptr("YYYY YYYY"),
				EmailList: []*string{
					to.Ptr("xxxx@xxxx.xxx")},
				Phone:          to.Ptr("0000000000"),
				PhoneExtension: to.Ptr(""),
			},
			ShippingAddress: &armedgeorder.ShippingAddress{
				AddressType:     to.Ptr(armedgeorder.AddressTypeNone),
				City:            to.Ptr("San Francisco"),
				CompanyName:     to.Ptr("Microsoft"),
				Country:         to.Ptr("US"),
				PostalCode:      to.Ptr("94107"),
				StateOrProvince: to.Ptr("CA"),
				StreetAddress1:  to.Ptr("16 TOWNSEND ST"),
				StreetAddress2:  to.Ptr("UNIT 1"),
			},
		},
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, &armedgeorder.ManagementClientBeginUpdateAddressOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AddressResource = armedgeorder.AddressResource{
	// 	Name: to.Ptr("TestAddressName2"),
	// 	Type: to.Ptr("Microsoft.EdgeOrder/addresses"),
	// 	ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/addresses/TestAddressName2"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armedgeorder.AddressProperties{
	// 		AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
	// 		ContactDetails: &armedgeorder.ContactDetails{
	// 			ContactName: to.Ptr("YYYY YYYY"),
	// 			EmailList: []*string{
	// 				to.Ptr("xxxx@xxxx.xxx")},
	// 				Phone: to.Ptr("0000000000"),
	// 				PhoneExtension: to.Ptr(""),
	// 			},
	// 			ShippingAddress: &armedgeorder.ShippingAddress{
	// 				AddressType: to.Ptr(armedgeorder.AddressTypeNone),
	// 				City: to.Ptr("San Francisco"),
	// 				CompanyName: to.Ptr("Microsoft"),
	// 				Country: to.Ptr("US"),
	// 				PostalCode: to.Ptr("94107"),
	// 				StateOrProvince: to.Ptr("CA"),
	// 				StreetAddress1: to.Ptr("16 TOWNSEND ST"),
	// 				StreetAddress2: to.Ptr("UNIT 1"),
	// 			},
	// 		},
	// 		SystemData: &armedgeorder.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListOrderAtResourceGroupLevel.json
func ExampleManagementClient_NewListOrderAtResourceGroupLevelPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagementClient().NewListOrderAtResourceGroupLevelPager("YourResourceGroupName", &armedgeorder.ManagementClientListOrderAtResourceGroupLevelOptions{SkipToken: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OrderResourceList = armedgeorder.OrderResourceList{
		// 	Value: []*armedgeorder.OrderResource{
		// 		{
		// 			Name: to.Ptr("TestOrderItemName1"),
		// 			Type: to.Ptr("Microsoft.EdgeOrder/orders"),
		// 			ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName1"),
		// 			Properties: &armedgeorder.OrderProperties{
		// 				CurrentStage: &armedgeorder.StageDetails{
		// 					StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 					StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:25:46.943Z"); return t}()),
		// 				},
		// 				OrderItemIDs: []*string{
		// 					to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName1")},
		// 					OrderStageHistory: []*armedgeorder.StageDetails{
		// 						{
		// 							StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 							StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 							StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:25:46.943Z"); return t}()),
		// 						},
		// 						{
		// 							StageName: to.Ptr(armedgeorder.StageNameInReview),
		// 							StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 					}},
		// 				},
		// 				SystemData: &armedgeorder.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("TestOrderItemName2"),
		// 				Type: to.Ptr("Microsoft.EdgeOrder/orders"),
		// 				ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2"),
		// 				Properties: &armedgeorder.OrderProperties{
		// 					CurrentStage: &armedgeorder.StageDetails{
		// 						StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 						StageStatus: to.Ptr(armedgeorder.StageStatusInProgress),
		// 						StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:28:46.524Z"); return t}()),
		// 					},
		// 					OrderItemIDs: []*string{
		// 						to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName2")},
		// 						OrderStageHistory: []*armedgeorder.StageDetails{
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameInReview),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 						}},
		// 					},
		// 					SystemData: &armedgeorder.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/GetOrderByName.json
func ExampleManagementClient_GetOrderByName() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagementClient().GetOrderByName(ctx, "TestOrderName3", "YourResourceGroupName", "eastus", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OrderResource = armedgeorder.OrderResource{
	// 	Name: to.Ptr("TestOrderName3"),
	// 	Type: to.Ptr("Microsoft.EdgeOrder/orders"),
	// 	ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName3"),
	// 	Properties: &armedgeorder.OrderProperties{
	// 		CurrentStage: &armedgeorder.StageDetails{
	// 			StageName: to.Ptr(armedgeorder.StageNameInReview),
	// 			StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
	// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T06:05:20.852Z"); return t}()),
	// 		},
	// 		OrderItemIDs: []*string{
	// 			to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName3")},
	// 			OrderStageHistory: []*armedgeorder.StageDetails{
	// 				{
	// 					StageName: to.Ptr(armedgeorder.StageNamePlaced),
	// 					StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
	// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T06:00:30.271Z"); return t}()),
	// 				},
	// 				{
	// 					StageName: to.Ptr(armedgeorder.StageNameInReview),
	// 					StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
	// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T06:05:20.852Z"); return t}()),
	// 			}},
	// 		},
	// 		SystemData: &armedgeorder.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListOrderItemsAtResourceGroupLevel.json
func ExampleManagementClient_NewListOrderItemsAtResourceGroupLevelPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagementClient().NewListOrderItemsAtResourceGroupLevelPager("YourResourceGroupName", &armedgeorder.ManagementClientListOrderItemsAtResourceGroupLevelOptions{Filter: nil,
		Expand:    nil,
		SkipToken: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OrderItemResourceList = armedgeorder.OrderItemResourceList{
		// 	Value: []*armedgeorder.OrderItemResource{
		// 		{
		// 			Name: to.Ptr("TestOrderItemName1"),
		// 			Type: to.Ptr("Microsoft.EdgeOrder/orderItems"),
		// 			ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName1"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armedgeorder.OrderItemProperties{
		// 				AddressDetails: &armedgeorder.AddressDetails{
		// 					ForwardAddress: &armedgeorder.AddressProperties{
		// 						AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
		// 						ContactDetails: &armedgeorder.ContactDetails{
		// 							ContactName: to.Ptr("XXXX XXXX"),
		// 							EmailList: []*string{
		// 								to.Ptr("xxxx@xxxx.xxx")},
		// 								Phone: to.Ptr("0000000000"),
		// 								PhoneExtension: to.Ptr(""),
		// 							},
		// 							ShippingAddress: &armedgeorder.ShippingAddress{
		// 								AddressType: to.Ptr(armedgeorder.AddressTypeNone),
		// 								City: to.Ptr("San Francisco"),
		// 								CompanyName: to.Ptr("Microsoft"),
		// 								Country: to.Ptr("US"),
		// 								PostalCode: to.Ptr("94107"),
		// 								StateOrProvince: to.Ptr("CA"),
		// 								StreetAddress1: to.Ptr("16 TOWNSEND ST"),
		// 								StreetAddress2: to.Ptr("UNIT 1"),
		// 							},
		// 						},
		// 					},
		// 					OrderID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName1"),
		// 					OrderItemDetails: &armedgeorder.OrderItemDetails{
		// 						CancellationStatus: to.Ptr(armedgeorder.OrderItemCancellationEnumNotCancellable),
		// 						CurrentStage: &armedgeorder.StageDetails{
		// 							StageName: to.Ptr(armedgeorder.StageNameConfirmed),
		// 							StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 							StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:35:00.357Z"); return t}()),
		// 						},
		// 						DeletionStatus: to.Ptr(armedgeorder.ActionStatusEnumNotAllowed),
		// 						ManagementRpDetailsList: []*armedgeorder.ResourceProviderDetails{
		// 							{
		// 								ResourceProviderNamespace: to.Ptr("Microsoft.DataBoxEdge"),
		// 						}},
		// 						NotificationEmailList: []*string{
		// 						},
		// 						OrderItemStageHistory: []*armedgeorder.StageDetails{
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 								StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:25:54.342Z"); return t}()),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameConfirmed),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 								StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:35:00.357Z"); return t}()),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameReadyToShip),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameShipped),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameDelivered),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 							},
		// 							{
		// 								StageName: to.Ptr(armedgeorder.StageNameInUse),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 						}},
		// 						OrderItemType: to.Ptr(armedgeorder.OrderItemTypePurchase),
		// 						Preferences: &armedgeorder.Preferences{
		// 							TransportPreferences: &armedgeorder.TransportPreferences{
		// 								PreferredShipmentType: to.Ptr(armedgeorder.TransportShipmentTypesMicrosoftManaged),
		// 							},
		// 						},
		// 						ProductDetails: &armedgeorder.ProductDetails{
		// 							Count: to.Ptr[int32](0),
		// 							DisplayInfo: &armedgeorder.DisplayInfo{
		// 								ConfigurationDisplayName: to.Ptr("Azure Stack Edge Pro - 1 GPU"),
		// 								ProductFamilyDisplayName: to.Ptr("Azure Stack Edge"),
		// 							},
		// 							HierarchyInformation: &armedgeorder.HierarchyInformation{
		// 								ConfigurationName: to.Ptr("edgep_base"),
		// 								ProductFamilyName: to.Ptr("azurestackedge"),
		// 								ProductLineName: to.Ptr("azurestackedge"),
		// 								ProductName: to.Ptr("azurestackedgegpu"),
		// 							},
		// 							ProductDoubleEncryptionStatus: to.Ptr(armedgeorder.DoubleEncryptionStatusDisabled),
		// 						},
		// 						ReturnStatus: to.Ptr(armedgeorder.OrderItemReturnEnumNotReturnable),
		// 					},
		// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:25:10.282Z"); return t}()),
		// 				},
		// 				SystemData: &armedgeorder.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("TestOrderItemName2"),
		// 				Type: to.Ptr("Microsoft.EdgeOrder/orderItems"),
		// 				ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName2"),
		// 				Location: to.Ptr("eastus"),
		// 				Tags: map[string]*string{
		// 				},
		// 				Properties: &armedgeorder.OrderItemProperties{
		// 					AddressDetails: &armedgeorder.AddressDetails{
		// 						ForwardAddress: &armedgeorder.AddressProperties{
		// 							AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
		// 							ContactDetails: &armedgeorder.ContactDetails{
		// 								ContactName: to.Ptr("XXXX XXXX"),
		// 								EmailList: []*string{
		// 									to.Ptr("xxxx@xxxx.xxx")},
		// 									Phone: to.Ptr("0000000000"),
		// 									PhoneExtension: to.Ptr(""),
		// 								},
		// 								ShippingAddress: &armedgeorder.ShippingAddress{
		// 									AddressType: to.Ptr(armedgeorder.AddressTypeNone),
		// 									City: to.Ptr("San Francisco"),
		// 									CompanyName: to.Ptr("Microsoft"),
		// 									Country: to.Ptr("US"),
		// 									PostalCode: to.Ptr("94107"),
		// 									StateOrProvince: to.Ptr("CA"),
		// 									StreetAddress1: to.Ptr("16 TOWNSEND ST"),
		// 									StreetAddress2: to.Ptr("UNIT 1"),
		// 								},
		// 							},
		// 						},
		// 						OrderID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2"),
		// 						OrderItemDetails: &armedgeorder.OrderItemDetails{
		// 							CancellationStatus: to.Ptr(armedgeorder.OrderItemCancellationEnumNotCancellable),
		// 							CurrentStage: &armedgeorder.StageDetails{
		// 								StageName: to.Ptr(armedgeorder.StageNameConfirmed),
		// 								StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 								StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:37:29.989Z"); return t}()),
		// 							},
		// 							DeletionStatus: to.Ptr(armedgeorder.ActionStatusEnumNotAllowed),
		// 							ManagementRpDetailsList: []*armedgeorder.ResourceProviderDetails{
		// 								{
		// 									ResourceProviderNamespace: to.Ptr("Microsoft.DataBoxEdge"),
		// 							}},
		// 							NotificationEmailList: []*string{
		// 							},
		// 							OrderItemStageHistory: []*armedgeorder.StageDetails{
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNamePlaced),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 									StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:29:04.970Z"); return t}()),
		// 								},
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNameConfirmed),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
		// 									StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:37:29.989Z"); return t}()),
		// 								},
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNameReadyToShip),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 								},
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNameShipped),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 								},
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNameDelivered),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 								},
		// 								{
		// 									StageName: to.Ptr(armedgeorder.StageNameInUse),
		// 									StageStatus: to.Ptr(armedgeorder.StageStatusNone),
		// 							}},
		// 							OrderItemType: to.Ptr(armedgeorder.OrderItemTypePurchase),
		// 							Preferences: &armedgeorder.Preferences{
		// 								TransportPreferences: &armedgeorder.TransportPreferences{
		// 									PreferredShipmentType: to.Ptr(armedgeorder.TransportShipmentTypesMicrosoftManaged),
		// 								},
		// 							},
		// 							ProductDetails: &armedgeorder.ProductDetails{
		// 								Count: to.Ptr[int32](0),
		// 								DisplayInfo: &armedgeorder.DisplayInfo{
		// 									ConfigurationDisplayName: to.Ptr("Azure Stack Edge Pro - 1 GPU"),
		// 									ProductFamilyDisplayName: to.Ptr("Azure Stack Edge"),
		// 								},
		// 								HierarchyInformation: &armedgeorder.HierarchyInformation{
		// 									ConfigurationName: to.Ptr("edgep_base"),
		// 									ProductFamilyName: to.Ptr("azurestackedge"),
		// 									ProductLineName: to.Ptr("azurestackedge"),
		// 									ProductName: to.Ptr("azurestackedgegpu"),
		// 								},
		// 								ProductDoubleEncryptionStatus: to.Ptr(armedgeorder.DoubleEncryptionStatusDisabled),
		// 							},
		// 							ReturnStatus: to.Ptr(armedgeorder.OrderItemReturnEnumNotReturnable),
		// 						},
		// 						StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:28:27.582Z"); return t}()),
		// 					},
		// 					SystemData: &armedgeorder.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/GetOrderItemByName.json
func ExampleManagementClient_GetOrderItemByName() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagementClient().GetOrderItemByName(ctx, "TestOrderItemName1", "YourResourceGroupName", &armedgeorder.ManagementClientGetOrderItemByNameOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OrderItemResource = armedgeorder.OrderItemResource{
	// 	Name: to.Ptr("TestOrderItemName1"),
	// 	Type: to.Ptr("Microsoft.EdgeOrder/orderItems"),
	// 	ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName1"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armedgeorder.OrderItemProperties{
	// 		AddressDetails: &armedgeorder.AddressDetails{
	// 			ForwardAddress: &armedgeorder.AddressProperties{
	// 				AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
	// 				ContactDetails: &armedgeorder.ContactDetails{
	// 					ContactName: to.Ptr("XXXX XXXX"),
	// 					EmailList: []*string{
	// 						to.Ptr("xxxx@xxxx.xxx")},
	// 						Phone: to.Ptr("0000000000"),
	// 						PhoneExtension: to.Ptr(""),
	// 					},
	// 					ShippingAddress: &armedgeorder.ShippingAddress{
	// 						AddressType: to.Ptr(armedgeorder.AddressTypeNone),
	// 						City: to.Ptr("San Francisco"),
	// 						CompanyName: to.Ptr("Microsoft"),
	// 						Country: to.Ptr("US"),
	// 						PostalCode: to.Ptr("94107"),
	// 						StateOrProvince: to.Ptr("CA"),
	// 						StreetAddress1: to.Ptr("16 TOWNSEND ST"),
	// 						StreetAddress2: to.Ptr("UNIT 1"),
	// 					},
	// 				},
	// 			},
	// 			OrderID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName1"),
	// 			OrderItemDetails: &armedgeorder.OrderItemDetails{
	// 				CancellationStatus: to.Ptr(armedgeorder.OrderItemCancellationEnumNotCancellable),
	// 				CurrentStage: &armedgeorder.StageDetails{
	// 					StageName: to.Ptr(armedgeorder.StageNameConfirmed),
	// 					StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
	// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:35:00.357Z"); return t}()),
	// 				},
	// 				DeletionStatus: to.Ptr(armedgeorder.ActionStatusEnumNotAllowed),
	// 				ManagementRpDetailsList: []*armedgeorder.ResourceProviderDetails{
	// 					{
	// 						ResourceProviderNamespace: to.Ptr("Microsoft.DataBoxEdge"),
	// 				}},
	// 				NotificationEmailList: []*string{
	// 				},
	// 				OrderItemStageHistory: []*armedgeorder.StageDetails{
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNamePlaced),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
	// 						StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:25:54.342Z"); return t}()),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameConfirmed),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
	// 						StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:35:00.357Z"); return t}()),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameReadyToShip),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameShipped),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameDelivered),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameInUse),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 				}},
	// 				OrderItemType: to.Ptr(armedgeorder.OrderItemTypePurchase),
	// 				Preferences: &armedgeorder.Preferences{
	// 					TransportPreferences: &armedgeorder.TransportPreferences{
	// 						PreferredShipmentType: to.Ptr(armedgeorder.TransportShipmentTypesMicrosoftManaged),
	// 					},
	// 				},
	// 				ProductDetails: &armedgeorder.ProductDetails{
	// 					Count: to.Ptr[int32](0),
	// 					DisplayInfo: &armedgeorder.DisplayInfo{
	// 						ConfigurationDisplayName: to.Ptr("Azure Stack Edge Pro - 1 GPU"),
	// 						ProductFamilyDisplayName: to.Ptr("Azure Stack Edge"),
	// 					},
	// 					HierarchyInformation: &armedgeorder.HierarchyInformation{
	// 						ConfigurationName: to.Ptr("edgep_base"),
	// 						ProductFamilyName: to.Ptr("azurestackedge"),
	// 						ProductLineName: to.Ptr("azurestackedge"),
	// 						ProductName: to.Ptr("azurestackedgegpu"),
	// 					},
	// 					ProductDoubleEncryptionStatus: to.Ptr(armedgeorder.DoubleEncryptionStatusDisabled),
	// 				},
	// 				ReturnStatus: to.Ptr(armedgeorder.OrderItemReturnEnumNotReturnable),
	// 			},
	// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:25:10.282Z"); return t}()),
	// 		},
	// 		SystemData: &armedgeorder.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/CreateOrderItem.json
func ExampleManagementClient_BeginCreateOrderItem() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagementClient().BeginCreateOrderItem(ctx, "TestOrderItemName2", "YourResourceGroupName", armedgeorder.OrderItemResource{
		Location: to.Ptr("eastus"),
		Properties: &armedgeorder.OrderItemProperties{
			AddressDetails: &armedgeorder.AddressDetails{
				ForwardAddress: &armedgeorder.AddressProperties{
					ContactDetails: &armedgeorder.ContactDetails{
						ContactName: to.Ptr("XXXX XXXX"),
						EmailList: []*string{
							to.Ptr("xxxx@xxxx.xxx")},
						Phone:          to.Ptr("0000000000"),
						PhoneExtension: to.Ptr(""),
					},
					ShippingAddress: &armedgeorder.ShippingAddress{
						AddressType:     to.Ptr(armedgeorder.AddressTypeNone),
						City:            to.Ptr("San Francisco"),
						CompanyName:     to.Ptr("Microsoft"),
						Country:         to.Ptr("US"),
						PostalCode:      to.Ptr("94107"),
						StateOrProvince: to.Ptr("CA"),
						StreetAddress1:  to.Ptr("16 TOWNSEND ST"),
						StreetAddress2:  to.Ptr("UNIT 1"),
					},
				},
			},
			OrderID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2"),
			OrderItemDetails: &armedgeorder.OrderItemDetails{
				OrderItemType: to.Ptr(armedgeorder.OrderItemTypePurchase),
				Preferences: &armedgeorder.Preferences{
					TransportPreferences: &armedgeorder.TransportPreferences{
						PreferredShipmentType: to.Ptr(armedgeorder.TransportShipmentTypesMicrosoftManaged),
					},
				},
				ProductDetails: &armedgeorder.ProductDetails{
					HierarchyInformation: &armedgeorder.HierarchyInformation{
						ConfigurationName: to.Ptr("edgep_base"),
						ProductFamilyName: to.Ptr("azurestackedge"),
						ProductLineName:   to.Ptr("azurestackedge"),
						ProductName:       to.Ptr("azurestackedgegpu"),
					},
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OrderItemResource = armedgeorder.OrderItemResource{
	// 	Name: to.Ptr("TestOrderItemName2"),
	// 	Type: to.Ptr("Microsoft.EdgeOrder/orderItems"),
	// 	ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName2"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armedgeorder.OrderItemProperties{
	// 		AddressDetails: &armedgeorder.AddressDetails{
	// 			ForwardAddress: &armedgeorder.AddressProperties{
	// 				AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
	// 				ContactDetails: &armedgeorder.ContactDetails{
	// 					ContactName: to.Ptr("XXXX XXXX"),
	// 					EmailList: []*string{
	// 						to.Ptr("xxxx@xxxx.xxx")},
	// 						Phone: to.Ptr("0000000000"),
	// 						PhoneExtension: to.Ptr(""),
	// 					},
	// 					ShippingAddress: &armedgeorder.ShippingAddress{
	// 						AddressType: to.Ptr(armedgeorder.AddressTypeNone),
	// 						City: to.Ptr("San Francisco"),
	// 						CompanyName: to.Ptr("Microsoft"),
	// 						Country: to.Ptr("US"),
	// 						PostalCode: to.Ptr("94107"),
	// 						StateOrProvince: to.Ptr("CA"),
	// 						StreetAddress1: to.Ptr("16 TOWNSEND ST"),
	// 						StreetAddress2: to.Ptr("UNIT 1"),
	// 					},
	// 				},
	// 			},
	// 			OrderID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2"),
	// 			OrderItemDetails: &armedgeorder.OrderItemDetails{
	// 				CancellationStatus: to.Ptr(armedgeorder.OrderItemCancellationEnumCancellable),
	// 				CurrentStage: &armedgeorder.StageDetails{
	// 					StageName: to.Ptr(armedgeorder.StageNamePlaced),
	// 					StageStatus: to.Ptr(armedgeorder.StageStatusInProgress),
	// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:28:27.582Z"); return t}()),
	// 				},
	// 				DeletionStatus: to.Ptr(armedgeorder.ActionStatusEnumNotAllowed),
	// 				ManagementRpDetailsList: []*armedgeorder.ResourceProviderDetails{
	// 					{
	// 						ResourceProviderNamespace: to.Ptr("Microsoft.DataBoxEdge"),
	// 				}},
	// 				NotificationEmailList: []*string{
	// 				},
	// 				OrderItemStageHistory: []*armedgeorder.StageDetails{
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNamePlaced),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameConfirmed),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameReadyToShip),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameShipped),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameDelivered),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameInUse),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 				}},
	// 				OrderItemType: to.Ptr(armedgeorder.OrderItemTypePurchase),
	// 				Preferences: &armedgeorder.Preferences{
	// 					TransportPreferences: &armedgeorder.TransportPreferences{
	// 						PreferredShipmentType: to.Ptr(armedgeorder.TransportShipmentTypesMicrosoftManaged),
	// 					},
	// 				},
	// 				ProductDetails: &armedgeorder.ProductDetails{
	// 					Count: to.Ptr[int32](0),
	// 					DisplayInfo: &armedgeorder.DisplayInfo{
	// 						ConfigurationDisplayName: to.Ptr("Azure Stack Edge Pro - 1 GPU"),
	// 						ProductFamilyDisplayName: to.Ptr("Azure Stack Edge"),
	// 					},
	// 					HierarchyInformation: &armedgeorder.HierarchyInformation{
	// 						ConfigurationName: to.Ptr("edgep_base"),
	// 						ProductFamilyName: to.Ptr("azurestackedge"),
	// 						ProductLineName: to.Ptr("azurestackedge"),
	// 						ProductName: to.Ptr("azurestackedgegpu"),
	// 					},
	// 					ProductDoubleEncryptionStatus: to.Ptr(armedgeorder.DoubleEncryptionStatusDisabled),
	// 				},
	// 				ReturnStatus: to.Ptr(armedgeorder.OrderItemReturnEnumNotReturnable),
	// 			},
	// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:28:27.582Z"); return t}()),
	// 		},
	// 		SystemData: &armedgeorder.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/DeleteOrderItemByName.json
func ExampleManagementClient_BeginDeleteOrderItemByName() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagementClient().BeginDeleteOrderItemByName(ctx, "TestOrderItemName3", "YourResourceGroupName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/UpdateOrderItem.json
func ExampleManagementClient_BeginUpdateOrderItem() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagementClient().BeginUpdateOrderItem(ctx, "TestOrderItemName3", "YourResourceGroupName", armedgeorder.OrderItemUpdateParameter{
		Properties: &armedgeorder.OrderItemUpdateProperties{
			Preferences: &armedgeorder.Preferences{
				TransportPreferences: &armedgeorder.TransportPreferences{
					PreferredShipmentType: to.Ptr(armedgeorder.TransportShipmentTypesCustomerManaged),
				},
			},
		},
	}, &armedgeorder.ManagementClientBeginUpdateOrderItemOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OrderItemResource = armedgeorder.OrderItemResource{
	// 	Name: to.Ptr("TestOrderItemName3"),
	// 	Type: to.Ptr("Microsoft.EdgeOrder/orderItems"),
	// 	ID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/orderItems/TestOrderItemName3"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armedgeorder.OrderItemProperties{
	// 		AddressDetails: &armedgeorder.AddressDetails{
	// 			ForwardAddress: &armedgeorder.AddressProperties{
	// 				AddressValidationStatus: to.Ptr(armedgeorder.AddressValidationStatusValid),
	// 				ContactDetails: &armedgeorder.ContactDetails{
	// 					ContactName: to.Ptr("XXXX XXXX"),
	// 					EmailList: []*string{
	// 						to.Ptr("xxxx@xxxx.xxx")},
	// 						Phone: to.Ptr("0000000000"),
	// 						PhoneExtension: to.Ptr(""),
	// 					},
	// 					ShippingAddress: &armedgeorder.ShippingAddress{
	// 						AddressType: to.Ptr(armedgeorder.AddressTypeNone),
	// 						City: to.Ptr("San Francisco"),
	// 						CompanyName: to.Ptr("Microsoft"),
	// 						Country: to.Ptr("US"),
	// 						PostalCode: to.Ptr("94107"),
	// 						StateOrProvince: to.Ptr("CA"),
	// 						StreetAddress1: to.Ptr("16 TOWNSEND ST"),
	// 						StreetAddress2: to.Ptr("UNIT 1"),
	// 					},
	// 				},
	// 			},
	// 			OrderID: to.Ptr("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName3"),
	// 			OrderItemDetails: &armedgeorder.OrderItemDetails{
	// 				CancellationStatus: to.Ptr(armedgeorder.OrderItemCancellationEnumCancellable),
	// 				CurrentStage: &armedgeorder.StageDetails{
	// 					StageName: to.Ptr(armedgeorder.StageNamePlaced),
	// 					StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
	// 					StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T06:00:31.583Z"); return t}()),
	// 				},
	// 				DeletionStatus: to.Ptr(armedgeorder.ActionStatusEnumNotAllowed),
	// 				ManagementRpDetailsList: []*armedgeorder.ResourceProviderDetails{
	// 					{
	// 						ResourceProviderNamespace: to.Ptr("Microsoft.DataBoxEdge"),
	// 				}},
	// 				NotificationEmailList: []*string{
	// 				},
	// 				OrderItemStageHistory: []*armedgeorder.StageDetails{
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNamePlaced),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusSucceeded),
	// 						StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T06:00:31.583Z"); return t}()),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameConfirmed),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameReadyToShip),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameShipped),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameDelivered),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 					},
	// 					{
	// 						StageName: to.Ptr(armedgeorder.StageNameInUse),
	// 						StageStatus: to.Ptr(armedgeorder.StageStatusNone),
	// 				}},
	// 				OrderItemType: to.Ptr(armedgeorder.OrderItemTypePurchase),
	// 				Preferences: &armedgeorder.Preferences{
	// 					TransportPreferences: &armedgeorder.TransportPreferences{
	// 						PreferredShipmentType: to.Ptr(armedgeorder.TransportShipmentTypesCustomerManaged),
	// 					},
	// 				},
	// 				ProductDetails: &armedgeorder.ProductDetails{
	// 					Count: to.Ptr[int32](0),
	// 					DisplayInfo: &armedgeorder.DisplayInfo{
	// 						ConfigurationDisplayName: to.Ptr("Azure Stack Edge Pro - 1 GPU"),
	// 						ProductFamilyDisplayName: to.Ptr("Azure Stack Edge"),
	// 					},
	// 					HierarchyInformation: &armedgeorder.HierarchyInformation{
	// 						ConfigurationName: to.Ptr("edgep_base"),
	// 						ProductFamilyName: to.Ptr("azurestackedge"),
	// 						ProductLineName: to.Ptr("azurestackedge"),
	// 						ProductName: to.Ptr("azurestackedgegpu"),
	// 					},
	// 					ProductDoubleEncryptionStatus: to.Ptr(armedgeorder.DoubleEncryptionStatusDisabled),
	// 				},
	// 				ReturnStatus: to.Ptr(armedgeorder.OrderItemReturnEnumNotReturnable),
	// 			},
	// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-03-04T05:59:47.348Z"); return t}()),
	// 		},
	// 		SystemData: &armedgeorder.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "1-01-01T00:00:00.000Z"); return t}()),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/CancelOrderItem.json
func ExampleManagementClient_CancelOrderItem() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewManagementClient().CancelOrderItem(ctx, "TestOrderItemName3", "YourResourceGroupName", armedgeorder.CancellationReason{
		Reason: to.Ptr("Order cancelled"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ReturnOrderItem.json
func ExampleManagementClient_BeginReturnOrderItem() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armedgeorder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagementClient().BeginReturnOrderItem(ctx, "TestOrderName4", "YourResourceGroupName", armedgeorder.ReturnOrderItemDetails{
		ReturnReason: to.Ptr("Order returned"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
