//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevtestlabs

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// ProviderOperationsClient contains the methods for the ProviderOperations group.
// Don't use this type directly, use NewProviderOperationsClient() instead.
type ProviderOperationsClient struct {
	internal *arm.Client
}

// NewProviderOperationsClient creates a new instance of ProviderOperationsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewProviderOperationsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ProviderOperationsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ProviderOperationsClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Result of the request to list REST API operations
//
// Generated from API version 2018-09-15
//   - options - ProviderOperationsClientListOptions contains the optional parameters for the ProviderOperationsClient.NewListPager
//     method.
func (client *ProviderOperationsClient) NewListPager(options *ProviderOperationsClientListOptions) *runtime.Pager[ProviderOperationsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ProviderOperationsClientListResponse]{
		More: func(page ProviderOperationsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ProviderOperationsClientListResponse) (ProviderOperationsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ProviderOperationsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ProviderOperationsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ProviderOperationsClient) listCreateRequest(ctx context.Context, options *ProviderOperationsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.DevTestLab/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-09-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ProviderOperationsClient) listHandleResponse(resp *http.Response) (ProviderOperationsClientListResponse, error) {
	result := ProviderOperationsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProviderOperationResult); err != nil {
		return ProviderOperationsClientListResponse{}, err
	}
	return result, nil
}
