//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/desktopvirtualization/armdesktopvirtualization/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
	"strconv"
)

// ScalingPlanPersonalSchedulesServer is a fake server for instances of the armdesktopvirtualization.ScalingPlanPersonalSchedulesClient type.
type ScalingPlanPersonalSchedulesServer struct {
	// Create is the fake for method ScalingPlanPersonalSchedulesClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, scalingPlanSchedule armdesktopvirtualization.ScalingPlanPersonalSchedule, options *armdesktopvirtualization.ScalingPlanPersonalSchedulesClientCreateOptions) (resp azfake.Responder[armdesktopvirtualization.ScalingPlanPersonalSchedulesClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ScalingPlanPersonalSchedulesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *armdesktopvirtualization.ScalingPlanPersonalSchedulesClientDeleteOptions) (resp azfake.Responder[armdesktopvirtualization.ScalingPlanPersonalSchedulesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ScalingPlanPersonalSchedulesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *armdesktopvirtualization.ScalingPlanPersonalSchedulesClientGetOptions) (resp azfake.Responder[armdesktopvirtualization.ScalingPlanPersonalSchedulesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ScalingPlanPersonalSchedulesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, scalingPlanName string, options *armdesktopvirtualization.ScalingPlanPersonalSchedulesClientListOptions) (resp azfake.PagerResponder[armdesktopvirtualization.ScalingPlanPersonalSchedulesClientListResponse])

	// Update is the fake for method ScalingPlanPersonalSchedulesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *armdesktopvirtualization.ScalingPlanPersonalSchedulesClientUpdateOptions) (resp azfake.Responder[armdesktopvirtualization.ScalingPlanPersonalSchedulesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewScalingPlanPersonalSchedulesServerTransport creates a new instance of ScalingPlanPersonalSchedulesServerTransport with the provided implementation.
// The returned ScalingPlanPersonalSchedulesServerTransport instance is connected to an instance of armdesktopvirtualization.ScalingPlanPersonalSchedulesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewScalingPlanPersonalSchedulesServerTransport(srv *ScalingPlanPersonalSchedulesServer) *ScalingPlanPersonalSchedulesServerTransport {
	return &ScalingPlanPersonalSchedulesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armdesktopvirtualization.ScalingPlanPersonalSchedulesClientListResponse]](),
	}
}

// ScalingPlanPersonalSchedulesServerTransport connects instances of armdesktopvirtualization.ScalingPlanPersonalSchedulesClient to instances of ScalingPlanPersonalSchedulesServer.
// Don't use this type directly, use NewScalingPlanPersonalSchedulesServerTransport instead.
type ScalingPlanPersonalSchedulesServerTransport struct {
	srv          *ScalingPlanPersonalSchedulesServer
	newListPager *tracker[azfake.PagerResponder[armdesktopvirtualization.ScalingPlanPersonalSchedulesClientListResponse]]
}

// Do implements the policy.Transporter interface for ScalingPlanPersonalSchedulesServerTransport.
func (s *ScalingPlanPersonalSchedulesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ScalingPlanPersonalSchedulesClient.Create":
		resp, err = s.dispatchCreate(req)
	case "ScalingPlanPersonalSchedulesClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "ScalingPlanPersonalSchedulesClient.Get":
		resp, err = s.dispatchGet(req)
	case "ScalingPlanPersonalSchedulesClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "ScalingPlanPersonalSchedulesClient.Update":
		resp, err = s.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ScalingPlanPersonalSchedulesServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if s.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/scalingPlans/(?P<scalingPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/personalSchedules/(?P<scalingPlanScheduleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdesktopvirtualization.ScalingPlanPersonalSchedule](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	scalingPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanName")])
	if err != nil {
		return nil, err
	}
	scalingPlanScheduleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanScheduleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Create(req.Context(), resourceGroupNameParam, scalingPlanNameParam, scalingPlanScheduleNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScalingPlanPersonalSchedule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScalingPlanPersonalSchedulesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/scalingPlans/(?P<scalingPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/personalSchedules/(?P<scalingPlanScheduleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	scalingPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanName")])
	if err != nil {
		return nil, err
	}
	scalingPlanScheduleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanScheduleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, scalingPlanNameParam, scalingPlanScheduleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScalingPlanPersonalSchedulesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/scalingPlans/(?P<scalingPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/personalSchedules/(?P<scalingPlanScheduleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	scalingPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanName")])
	if err != nil {
		return nil, err
	}
	scalingPlanScheduleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanScheduleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, scalingPlanNameParam, scalingPlanScheduleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScalingPlanPersonalSchedule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScalingPlanPersonalSchedulesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/scalingPlans/(?P<scalingPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/personalSchedules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		scalingPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanName")])
		if err != nil {
			return nil, err
		}
		pageSizeUnescaped, err := url.QueryUnescape(qp.Get("pageSize"))
		if err != nil {
			return nil, err
		}
		pageSizeParam, err := parseOptional(pageSizeUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		isDescendingUnescaped, err := url.QueryUnescape(qp.Get("isDescending"))
		if err != nil {
			return nil, err
		}
		isDescendingParam, err := parseOptional(isDescendingUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		initialSkipUnescaped, err := url.QueryUnescape(qp.Get("initialSkip"))
		if err != nil {
			return nil, err
		}
		initialSkipParam, err := parseOptional(initialSkipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdesktopvirtualization.ScalingPlanPersonalSchedulesClientListOptions
		if pageSizeParam != nil || isDescendingParam != nil || initialSkipParam != nil {
			options = &armdesktopvirtualization.ScalingPlanPersonalSchedulesClientListOptions{
				PageSize:     pageSizeParam,
				IsDescending: isDescendingParam,
				InitialSkip:  initialSkipParam,
			}
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, scalingPlanNameParam, options)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdesktopvirtualization.ScalingPlanPersonalSchedulesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *ScalingPlanPersonalSchedulesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/scalingPlans/(?P<scalingPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/personalSchedules/(?P<scalingPlanScheduleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdesktopvirtualization.ScalingPlanPersonalSchedulePatch](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	scalingPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanName")])
	if err != nil {
		return nil, err
	}
	scalingPlanScheduleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanScheduleName")])
	if err != nil {
		return nil, err
	}
	var options *armdesktopvirtualization.ScalingPlanPersonalSchedulesClientUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armdesktopvirtualization.ScalingPlanPersonalSchedulesClientUpdateOptions{
			ScalingPlanSchedule: &body,
		}
	}
	respr, errRespr := s.srv.Update(req.Context(), resourceGroupNameParam, scalingPlanNameParam, scalingPlanScheduleNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScalingPlanPersonalSchedule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
