//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"encoding/json"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datashare/armdatashare"
)

func unmarshalDataSetClassification(rawMsg json.RawMessage) (armdatashare.DataSetClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b armdatashare.DataSetClassification
	switch m["kind"] {
	case string(armdatashare.DataSetKindAdlsGen1File):
		b = &armdatashare.ADLSGen1FileDataSet{}
	case string(armdatashare.DataSetKindAdlsGen1Folder):
		b = &armdatashare.ADLSGen1FolderDataSet{}
	case string(armdatashare.DataSetKindAdlsGen2File):
		b = &armdatashare.ADLSGen2FileDataSet{}
	case string(armdatashare.DataSetKindAdlsGen2FileSystem):
		b = &armdatashare.ADLSGen2FileSystemDataSet{}
	case string(armdatashare.DataSetKindAdlsGen2Folder):
		b = &armdatashare.ADLSGen2FolderDataSet{}
	case string(armdatashare.DataSetKindBlob):
		b = &armdatashare.BlobDataSet{}
	case string(armdatashare.DataSetKindBlobFolder):
		b = &armdatashare.BlobFolderDataSet{}
	case string(armdatashare.DataSetKindContainer):
		b = &armdatashare.BlobContainerDataSet{}
	case string(armdatashare.DataSetKindKustoCluster):
		b = &armdatashare.KustoClusterDataSet{}
	case string(armdatashare.DataSetKindKustoDatabase):
		b = &armdatashare.KustoDatabaseDataSet{}
	case string(armdatashare.DataSetKindSQLDBTable):
		b = &armdatashare.SQLDBTableDataSet{}
	case string(armdatashare.DataSetKindSQLDWTable):
		b = &armdatashare.SQLDWTableDataSet{}
	case string(armdatashare.DataSetKindSynapseWorkspaceSQLPoolTable):
		b = &armdatashare.SynapseWorkspaceSQLPoolTableDataSet{}
	default:
		b = &armdatashare.DataSet{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDataSetMappingClassification(rawMsg json.RawMessage) (armdatashare.DataSetMappingClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b armdatashare.DataSetMappingClassification
	switch m["kind"] {
	case string(armdatashare.DataSetMappingKindAdlsGen2File):
		b = &armdatashare.ADLSGen2FileDataSetMapping{}
	case string(armdatashare.DataSetMappingKindAdlsGen2FileSystem):
		b = &armdatashare.ADLSGen2FileSystemDataSetMapping{}
	case string(armdatashare.DataSetMappingKindAdlsGen2Folder):
		b = &armdatashare.ADLSGen2FolderDataSetMapping{}
	case string(armdatashare.DataSetMappingKindBlob):
		b = &armdatashare.BlobDataSetMapping{}
	case string(armdatashare.DataSetMappingKindBlobFolder):
		b = &armdatashare.BlobFolderDataSetMapping{}
	case string(armdatashare.DataSetMappingKindContainer):
		b = &armdatashare.BlobContainerDataSetMapping{}
	case string(armdatashare.DataSetMappingKindKustoCluster):
		b = &armdatashare.KustoClusterDataSetMapping{}
	case string(armdatashare.DataSetMappingKindKustoDatabase):
		b = &armdatashare.KustoDatabaseDataSetMapping{}
	case string(armdatashare.DataSetMappingKindSQLDBTable):
		b = &armdatashare.SQLDBTableDataSetMapping{}
	case string(armdatashare.DataSetMappingKindSQLDWTable):
		b = &armdatashare.SQLDWTableDataSetMapping{}
	case string(armdatashare.DataSetMappingKindSynapseWorkspaceSQLPoolTable):
		b = &armdatashare.SynapseWorkspaceSQLPoolTableDataSetMapping{}
	default:
		b = &armdatashare.DataSetMapping{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalSynchronizationSettingClassification(rawMsg json.RawMessage) (armdatashare.SynchronizationSettingClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b armdatashare.SynchronizationSettingClassification
	switch m["kind"] {
	case string(armdatashare.SynchronizationSettingKindScheduleBased):
		b = &armdatashare.ScheduledSynchronizationSetting{}
	default:
		b = &armdatashare.SynchronizationSetting{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalTriggerClassification(rawMsg json.RawMessage) (armdatashare.TriggerClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b armdatashare.TriggerClassification
	switch m["kind"] {
	case string(armdatashare.TriggerKindScheduleBased):
		b = &armdatashare.ScheduledTrigger{}
	default:
		b = &armdatashare.Trigger{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
