//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdatamigration_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datamigration/armdatamigration"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_CreateOrUpdate.json
func ExampleServicesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginCreateOrUpdate(ctx, "DmsSdkRg", "DmsSdkService", armdatamigration.Service{
		Location: to.Ptr("southcentralus"),
		Properties: &armdatamigration.ServiceProperties{
			VirtualSubnetID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkTestNetwork/providers/Microsoft.Network/virtualNetworks/DmsSdkTestNetwork/subnets/default"),
		},
		SKU: &armdatamigration.ServiceSKU{
			Name: to.Ptr("Basic_1vCore"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Service = armdatamigration.Service{
	// 	Name: to.Ptr("DmsSdkService"),
	// 	Type: to.Ptr("Microsoft.DataMigration/services"),
	// 	ID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkRg/providers/Microsoft.DataMigration/services/DmsSdkService"),
	// 	Location: to.Ptr("southcentralus"),
	// 	Etag: to.Ptr("9QuK/U0GvTJpjIrlOzITXVy68+bmmQ3bFkHudLxmkUw="),
	// 	Properties: &armdatamigration.ServiceProperties{
	// 		ProvisioningState: to.Ptr(armdatamigration.ServiceProvisioningStateSucceeded),
	// 		VirtualSubnetID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkTestNetwork/providers/Microsoft.Network/virtualNetworks/DmsSdkTestNetwork/subnets/default"),
	// 	},
	// 	SKU: &armdatamigration.ServiceSKU{
	// 		Name: to.Ptr("Basic_1vCore"),
	// 		Size: to.Ptr("1 vCore"),
	// 		Tier: to.Ptr("Basic"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_Get.json
func ExampleServicesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().Get(ctx, "DmsSdkRg", "DmsSdkService", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Service = armdatamigration.Service{
	// 	Name: to.Ptr("DmsSdkService"),
	// 	Type: to.Ptr("Microsoft.DataMigration/services"),
	// 	ID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkRg/providers/Microsoft.DataMigration/services/DmsSdkService"),
	// 	Location: to.Ptr("southcentralus"),
	// 	Etag: to.Ptr("qt85+bWDN84/6PR8Gllxf63krZcXZX1h3wxAbs6pCjc="),
	// 	Properties: &armdatamigration.ServiceProperties{
	// 		ProvisioningState: to.Ptr(armdatamigration.ServiceProvisioningStateSucceeded),
	// 		PublicKey: to.Ptr("0;AQAB;sCMXX00QDnuOIEQdXyY96h3VPSk3ccsBeYOGxntqg7y6oXbq4JbQHf8GnUhf5NsmUYBq1rO+6xSumIuLLANIIqNPpHCT8x7W+tcuShlju4fdSKfpyKbJnTJJzGLhRJYG97hDPo9D76qpEYQN66k0IfkKJVDTh7LAxqcE3lxdA98LB2EDM6vYoZ+raKXygYc1UUHDpkfksLk2YRTVCaayTFBh5HT/+CY+48V+rbx/nruvEEEbSg720m5Fc0k8ivM3A+RGkeK9pzQx+TtskSCDXiWL50a8Rrb5ORkBusgY+s0XLyKOuxZCIUOEO8JzUjCeZYdOfLJzx8yfTxEmSlOPqQ=="),
	// 		VirtualSubnetID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkTestNetwork/providers/Microsoft.Network/virtualNetworks/DmsSdkTestNetwork/subnets/default"),
	// 	},
	// 	SKU: &armdatamigration.ServiceSKU{
	// 		Name: to.Ptr("Basic_1vCore"),
	// 		Size: to.Ptr("1 vCore"),
	// 		Tier: to.Ptr("Basic"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_Delete.json
func ExampleServicesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginDelete(ctx, "DmsSdkRg", "DmsSdkService", &armdatamigration.ServicesClientBeginDeleteOptions{DeleteRunningTasks: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_Update.json
func ExampleServicesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginUpdate(ctx, "DmsSdkRg", "DmsSdkService", armdatamigration.Service{
		Location: to.Ptr("southcentralus"),
		Properties: &armdatamigration.ServiceProperties{
			VirtualSubnetID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkTestNetwork/providers/Microsoft.Network/virtualNetworks/DmsSdkTestNetwork/subnets/default"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Service = armdatamigration.Service{
	// 	Name: to.Ptr("DmsSdkService"),
	// 	Type: to.Ptr("Microsoft.DataMigration/services"),
	// 	ID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkRg/providers/Microsoft.DataMigration/services/DmsSdkService"),
	// 	Location: to.Ptr("southcentralus"),
	// 	Etag: to.Ptr("9QuK/U0GvTJpjIrlOzITXVy68+bmmQ3bFkHudLxmkUw="),
	// 	Properties: &armdatamigration.ServiceProperties{
	// 		ProvisioningState: to.Ptr(armdatamigration.ServiceProvisioningStateSucceeded),
	// 		VirtualSubnetID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkTestNetwork/providers/Microsoft.Network/virtualNetworks/DmsSdkTestNetwork/subnets/default"),
	// 	},
	// 	SKU: &armdatamigration.ServiceSKU{
	// 		Name: to.Ptr("Basic_1vCore"),
	// 		Size: to.Ptr("1 vCore"),
	// 		Tier: to.Ptr("Basic"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_CheckStatus.json
func ExampleServicesClient_CheckStatus() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().CheckStatus(ctx, "DmsSdkRg", "DmsSdkService", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceStatusResponse = armdatamigration.ServiceStatusResponse{
	// 	AgentVersion: to.Ptr("3.3.3871.6"),
	// 	Status: to.Ptr("Online"),
	// 	SupportedTaskTypes: []*string{
	// 		to.Ptr("diagnostic.count"),
	// 		to.Ptr("diagnostic.echo"),
	// 		to.Ptr("diagnostic.error"),
	// 		to.Ptr("diagnostic.fastCount"),
	// 		to.Ptr("ConnectToSource.SqlServer.Sync"),
	// 		to.Ptr("SyncMigrationOperationalTelemetry.LogCollector"),
	// 		to.Ptr("GetUserTables.AzureSqlDb.Sync"),
	// 		to.Ptr("ConnectToTarget.SqlDb.Sync"),
	// 		to.Ptr("Migrate.MySql.AzureDbForMySql.Sync"),
	// 		to.Ptr("Migrate.SqlServer.AzureSqlDb.Sync"),
	// 		to.Ptr("ValidateMigrationInput.SqlServer.SqlDb.Sync"),
	// 		to.Ptr("DataMigration.AzureSqlDbPostMigrationValidationScenarioId"),
	// 		to.Ptr("GetTDECertificates.Sql"),
	// 		to.Ptr("Migrate.SqlServer.AzureSqlDbMI"),
	// 		to.Ptr("ValidateMigrationInput.SqlServer.AzureSqlDbMI"),
	// 		to.Ptr("ConnectToTarget.AzureDbForMySql"),
	// 		to.Ptr("ConnectToSource.SqlServer"),
	// 		to.Ptr("GetUserTables.Sql"),
	// 		to.Ptr("ConnectToTarget.AzureSqlDbMI"),
	// 		to.Ptr("ConnectToTarget.SqlDb"),
	// 		to.Ptr("Migrate.SqlServer.SqlDb"),
	// 		to.Ptr("ConnectToSource.MySql")},
	// 		VMSize: to.Ptr("Standard_A4_v2"),
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_Start.json
func ExampleServicesClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginStart(ctx, "DmsSdkRg", "DmsSdkService", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_Stop.json
func ExampleServicesClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServicesClient().BeginStop(ctx, "DmsSdkRg", "DmsSdkService", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_ListSkus.json
func ExampleServicesClient_NewListSKUsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServicesClient().NewListSKUsPager("DmsSdkRg", "DmsSdkService", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceSKUList = armdatamigration.ServiceSKUList{
		// 	Value: []*armdatamigration.AvailableServiceSKU{
		// 		{
		// 			ResourceType: to.Ptr("Microsoft.DataMigration/services"),
		// 			SKU: &armdatamigration.AvailableServiceSKUSKU{
		// 				Name: to.Ptr("Basic_1vCore"),
		// 				Size: to.Ptr("1 vCore"),
		// 				Tier: to.Ptr("Basic"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_CheckChildrenNameAvailability.json
func ExampleServicesClient_CheckChildrenNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().CheckChildrenNameAvailability(ctx, "DmsSdkRg", "DmsSdkService", armdatamigration.NameAvailabilityRequest{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailabilityResponse = armdatamigration.NameAvailabilityResponse{
	// 	NameAvailable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_ListByResourceGroup.json
func ExampleServicesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServicesClient().NewListByResourceGroupPager("DmsSdkRg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceList = armdatamigration.ServiceList{
		// 	Value: []*armdatamigration.Service{
		// 		{
		// 			Name: to.Ptr("DmsSdkService1"),
		// 			Type: to.Ptr("Microsoft.DataMigration/services"),
		// 			ID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkRg/providers/Microsoft.DataMigration/services/DmsSdkService1"),
		// 			Location: to.Ptr("southcentralus"),
		// 			SKU: &armdatamigration.ServiceSKU{
		// 				Name: to.Ptr("GeneralPurpose_4vCores"),
		// 				Size: to.Ptr("4 vCores"),
		// 				Tier: to.Ptr("General Purpose"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("DmsSdkService2"),
		// 			Type: to.Ptr("Microsoft.DataMigration/services"),
		// 			ID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkRg/providers/Microsoft.DataMigration/services/DmsSdkService2"),
		// 			Location: to.Ptr("southcentralus"),
		// 			SKU: &armdatamigration.ServiceSKU{
		// 				Name: to.Ptr("Basic_2vCores"),
		// 				Size: to.Ptr("2 vCores"),
		// 				Tier: to.Ptr("Basic"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_List.json
func ExampleServicesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServicesClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceList = armdatamigration.ServiceList{
		// 	Value: []*armdatamigration.Service{
		// 		{
		// 			Name: to.Ptr("DmsSdkService1"),
		// 			Type: to.Ptr("Microsoft.DataMigration/services"),
		// 			ID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkRg1/providers/Microsoft.DataMigration/services/DmsSdkService1"),
		// 			Location: to.Ptr("southcentralus"),
		// 			SKU: &armdatamigration.ServiceSKU{
		// 				Name: to.Ptr("GeneralPurpose_4vCores"),
		// 				Size: to.Ptr("4 vCores"),
		// 				Tier: to.Ptr("General Purpose"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("DmsSdkService2"),
		// 			Type: to.Ptr("Microsoft.DataMigration/services"),
		// 			ID: to.Ptr("/subscriptions/fc04246f-04c5-437e-ac5e-206a19e7193f/resourceGroups/DmsSdkRg2/providers/Microsoft.DataMigration/services/DmsSdkService2"),
		// 			Location: to.Ptr("centralus"),
		// 			SKU: &armdatamigration.ServiceSKU{
		// 				Name: to.Ptr("Basic_2vCores"),
		// 				Size: to.Ptr("2 vCores"),
		// 				Tier: to.Ptr("Basic"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/datamigration/resource-manager/Microsoft.DataMigration/stable/2021-06-30/examples/Services_CheckNameAvailability.json
func ExampleServicesClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatamigration.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().CheckNameAvailability(ctx, "eastus", armdatamigration.NameAvailabilityRequest{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailabilityResponse = armdatamigration.NameAvailabilityResponse{
	// 	NameAvailable: to.Ptr(true),
	// }
}
