//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datadog/armdatadog"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// MonitorsServer is a fake server for instances of the armdatadog.MonitorsClient type.
type MonitorsServer struct {
	// BeginCreate is the fake for method MonitorsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, monitorName string, options *armdatadog.MonitorsClientBeginCreateOptions) (resp azfake.PollerResponder[armdatadog.MonitorsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method MonitorsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, monitorName string, options *armdatadog.MonitorsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdatadog.MonitorsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method MonitorsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, monitorName string, options *armdatadog.MonitorsClientGetOptions) (resp azfake.Responder[armdatadog.MonitorsClientGetResponse], errResp azfake.ErrorResponder)

	// GetDefaultKey is the fake for method MonitorsClient.GetDefaultKey
	// HTTP status codes to indicate success: http.StatusOK
	GetDefaultKey func(ctx context.Context, resourceGroupName string, monitorName string, options *armdatadog.MonitorsClientGetDefaultKeyOptions) (resp azfake.Responder[armdatadog.MonitorsClientGetDefaultKeyResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method MonitorsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armdatadog.MonitorsClientListOptions) (resp azfake.PagerResponder[armdatadog.MonitorsClientListResponse])

	// NewListAPIKeysPager is the fake for method MonitorsClient.NewListAPIKeysPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAPIKeysPager func(resourceGroupName string, monitorName string, options *armdatadog.MonitorsClientListAPIKeysOptions) (resp azfake.PagerResponder[armdatadog.MonitorsClientListAPIKeysResponse])

	// NewListByResourceGroupPager is the fake for method MonitorsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armdatadog.MonitorsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armdatadog.MonitorsClientListByResourceGroupResponse])

	// NewListHostsPager is the fake for method MonitorsClient.NewListHostsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListHostsPager func(resourceGroupName string, monitorName string, options *armdatadog.MonitorsClientListHostsOptions) (resp azfake.PagerResponder[armdatadog.MonitorsClientListHostsResponse])

	// NewListLinkedResourcesPager is the fake for method MonitorsClient.NewListLinkedResourcesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListLinkedResourcesPager func(resourceGroupName string, monitorName string, options *armdatadog.MonitorsClientListLinkedResourcesOptions) (resp azfake.PagerResponder[armdatadog.MonitorsClientListLinkedResourcesResponse])

	// NewListMonitoredResourcesPager is the fake for method MonitorsClient.NewListMonitoredResourcesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMonitoredResourcesPager func(resourceGroupName string, monitorName string, options *armdatadog.MonitorsClientListMonitoredResourcesOptions) (resp azfake.PagerResponder[armdatadog.MonitorsClientListMonitoredResourcesResponse])

	// RefreshSetPasswordLink is the fake for method MonitorsClient.RefreshSetPasswordLink
	// HTTP status codes to indicate success: http.StatusOK
	RefreshSetPasswordLink func(ctx context.Context, resourceGroupName string, monitorName string, options *armdatadog.MonitorsClientRefreshSetPasswordLinkOptions) (resp azfake.Responder[armdatadog.MonitorsClientRefreshSetPasswordLinkResponse], errResp azfake.ErrorResponder)

	// SetDefaultKey is the fake for method MonitorsClient.SetDefaultKey
	// HTTP status codes to indicate success: http.StatusOK
	SetDefaultKey func(ctx context.Context, resourceGroupName string, monitorName string, options *armdatadog.MonitorsClientSetDefaultKeyOptions) (resp azfake.Responder[armdatadog.MonitorsClientSetDefaultKeyResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method MonitorsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginUpdate func(ctx context.Context, resourceGroupName string, monitorName string, options *armdatadog.MonitorsClientBeginUpdateOptions) (resp azfake.PollerResponder[armdatadog.MonitorsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewMonitorsServerTransport creates a new instance of MonitorsServerTransport with the provided implementation.
// The returned MonitorsServerTransport instance is connected to an instance of armdatadog.MonitorsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMonitorsServerTransport(srv *MonitorsServer) *MonitorsServerTransport {
	return &MonitorsServerTransport{
		srv:                            srv,
		beginCreate:                    newTracker[azfake.PollerResponder[armdatadog.MonitorsClientCreateResponse]](),
		beginDelete:                    newTracker[azfake.PollerResponder[armdatadog.MonitorsClientDeleteResponse]](),
		newListPager:                   newTracker[azfake.PagerResponder[armdatadog.MonitorsClientListResponse]](),
		newListAPIKeysPager:            newTracker[azfake.PagerResponder[armdatadog.MonitorsClientListAPIKeysResponse]](),
		newListByResourceGroupPager:    newTracker[azfake.PagerResponder[armdatadog.MonitorsClientListByResourceGroupResponse]](),
		newListHostsPager:              newTracker[azfake.PagerResponder[armdatadog.MonitorsClientListHostsResponse]](),
		newListLinkedResourcesPager:    newTracker[azfake.PagerResponder[armdatadog.MonitorsClientListLinkedResourcesResponse]](),
		newListMonitoredResourcesPager: newTracker[azfake.PagerResponder[armdatadog.MonitorsClientListMonitoredResourcesResponse]](),
		beginUpdate:                    newTracker[azfake.PollerResponder[armdatadog.MonitorsClientUpdateResponse]](),
	}
}

// MonitorsServerTransport connects instances of armdatadog.MonitorsClient to instances of MonitorsServer.
// Don't use this type directly, use NewMonitorsServerTransport instead.
type MonitorsServerTransport struct {
	srv                            *MonitorsServer
	beginCreate                    *tracker[azfake.PollerResponder[armdatadog.MonitorsClientCreateResponse]]
	beginDelete                    *tracker[azfake.PollerResponder[armdatadog.MonitorsClientDeleteResponse]]
	newListPager                   *tracker[azfake.PagerResponder[armdatadog.MonitorsClientListResponse]]
	newListAPIKeysPager            *tracker[azfake.PagerResponder[armdatadog.MonitorsClientListAPIKeysResponse]]
	newListByResourceGroupPager    *tracker[azfake.PagerResponder[armdatadog.MonitorsClientListByResourceGroupResponse]]
	newListHostsPager              *tracker[azfake.PagerResponder[armdatadog.MonitorsClientListHostsResponse]]
	newListLinkedResourcesPager    *tracker[azfake.PagerResponder[armdatadog.MonitorsClientListLinkedResourcesResponse]]
	newListMonitoredResourcesPager *tracker[azfake.PagerResponder[armdatadog.MonitorsClientListMonitoredResourcesResponse]]
	beginUpdate                    *tracker[azfake.PollerResponder[armdatadog.MonitorsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for MonitorsServerTransport.
func (m *MonitorsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MonitorsClient.BeginCreate":
		resp, err = m.dispatchBeginCreate(req)
	case "MonitorsClient.BeginDelete":
		resp, err = m.dispatchBeginDelete(req)
	case "MonitorsClient.Get":
		resp, err = m.dispatchGet(req)
	case "MonitorsClient.GetDefaultKey":
		resp, err = m.dispatchGetDefaultKey(req)
	case "MonitorsClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	case "MonitorsClient.NewListAPIKeysPager":
		resp, err = m.dispatchNewListAPIKeysPager(req)
	case "MonitorsClient.NewListByResourceGroupPager":
		resp, err = m.dispatchNewListByResourceGroupPager(req)
	case "MonitorsClient.NewListHostsPager":
		resp, err = m.dispatchNewListHostsPager(req)
	case "MonitorsClient.NewListLinkedResourcesPager":
		resp, err = m.dispatchNewListLinkedResourcesPager(req)
	case "MonitorsClient.NewListMonitoredResourcesPager":
		resp, err = m.dispatchNewListMonitoredResourcesPager(req)
	case "MonitorsClient.RefreshSetPasswordLink":
		resp, err = m.dispatchRefreshSetPasswordLink(req)
	case "MonitorsClient.SetDefaultKey":
		resp, err = m.dispatchSetDefaultKey(req)
	case "MonitorsClient.BeginUpdate":
		resp, err = m.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MonitorsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := m.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdatadog.MonitorResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		var options *armdatadog.MonitorsClientBeginCreateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armdatadog.MonitorsClientBeginCreateOptions{
				Body: &body,
			}
		}
		respr, errRespr := m.srv.BeginCreate(req.Context(), resourceGroupNameParam, monitorNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		m.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		m.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		m.beginCreate.remove(req)
	}

	return resp, nil
}

func (m *MonitorsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := m.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDelete(req.Context(), resourceGroupNameParam, monitorNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		m.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		m.beginDelete.remove(req)
	}

	return resp, nil
}

func (m *MonitorsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, monitorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MonitorResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchGetDefaultKey(req *http.Request) (*http.Response, error) {
	if m.srv.GetDefaultKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDefaultKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getDefaultKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetDefaultKey(req.Context(), resourceGroupNameParam, monitorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).APIKey, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := m.srv.NewListPager(nil)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdatadog.MonitorsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListAPIKeysPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListAPIKeysPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAPIKeysPager not implemented")}
	}
	newListAPIKeysPager := m.newListAPIKeysPager.get(req)
	if newListAPIKeysPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listApiKeys`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListAPIKeysPager(resourceGroupNameParam, monitorNameParam, nil)
		newListAPIKeysPager = &resp
		m.newListAPIKeysPager.add(req, newListAPIKeysPager)
		server.PagerResponderInjectNextLinks(newListAPIKeysPager, req, func(page *armdatadog.MonitorsClientListAPIKeysResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAPIKeysPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListAPIKeysPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAPIKeysPager) {
		m.newListAPIKeysPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := m.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		m.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armdatadog.MonitorsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		m.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListHostsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListHostsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListHostsPager not implemented")}
	}
	newListHostsPager := m.newListHostsPager.get(req)
	if newListHostsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listHosts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListHostsPager(resourceGroupNameParam, monitorNameParam, nil)
		newListHostsPager = &resp
		m.newListHostsPager.add(req, newListHostsPager)
		server.PagerResponderInjectNextLinks(newListHostsPager, req, func(page *armdatadog.MonitorsClientListHostsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListHostsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListHostsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListHostsPager) {
		m.newListHostsPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListLinkedResourcesPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListLinkedResourcesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListLinkedResourcesPager not implemented")}
	}
	newListLinkedResourcesPager := m.newListLinkedResourcesPager.get(req)
	if newListLinkedResourcesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listLinkedResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListLinkedResourcesPager(resourceGroupNameParam, monitorNameParam, nil)
		newListLinkedResourcesPager = &resp
		m.newListLinkedResourcesPager.add(req, newListLinkedResourcesPager)
		server.PagerResponderInjectNextLinks(newListLinkedResourcesPager, req, func(page *armdatadog.MonitorsClientListLinkedResourcesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListLinkedResourcesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListLinkedResourcesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListLinkedResourcesPager) {
		m.newListLinkedResourcesPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchNewListMonitoredResourcesPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMonitoredResourcesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMonitoredResourcesPager not implemented")}
	}
	newListMonitoredResourcesPager := m.newListMonitoredResourcesPager.get(req)
	if newListMonitoredResourcesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listMonitoredResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListMonitoredResourcesPager(resourceGroupNameParam, monitorNameParam, nil)
		newListMonitoredResourcesPager = &resp
		m.newListMonitoredResourcesPager.add(req, newListMonitoredResourcesPager)
		server.PagerResponderInjectNextLinks(newListMonitoredResourcesPager, req, func(page *armdatadog.MonitorsClientListMonitoredResourcesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMonitoredResourcesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMonitoredResourcesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMonitoredResourcesPager) {
		m.newListMonitoredResourcesPager.remove(req)
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchRefreshSetPasswordLink(req *http.Request) (*http.Response, error) {
	if m.srv.RefreshSetPasswordLink == nil {
		return nil, &nonRetriableError{errors.New("fake for method RefreshSetPasswordLink not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/refreshSetPasswordLink`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.RefreshSetPasswordLink(req.Context(), resourceGroupNameParam, monitorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SetPasswordLink, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchSetDefaultKey(req *http.Request) (*http.Response, error) {
	if m.srv.SetDefaultKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method SetDefaultKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/setDefaultKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatadog.APIKey](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
	if err != nil {
		return nil, err
	}
	var options *armdatadog.MonitorsClientSetDefaultKeyOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armdatadog.MonitorsClientSetDefaultKeyOptions{
			Body: &body,
		}
	}
	respr, errRespr := m.srv.SetDefaultKey(req.Context(), resourceGroupNameParam, monitorNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MonitorsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := m.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Datadog/monitors/(?P<monitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdatadog.MonitorResourceUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		monitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("monitorName")])
		if err != nil {
			return nil, err
		}
		var options *armdatadog.MonitorsClientBeginUpdateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armdatadog.MonitorsClientBeginUpdateOptions{
				Body: &body,
			}
		}
		respr, errRespr := m.srv.BeginUpdate(req.Context(), resourceGroupNameParam, monitorNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		m.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		m.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		m.beginUpdate.remove(req)
	}

	return resp, nil
}
