//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcosmos

// CassandraClustersClientCreateUpdateResponse contains the response from method CassandraClustersClient.BeginCreateUpdate.
type CassandraClustersClientCreateUpdateResponse struct {
	// Representation of a managed Cassandra cluster.
	ClusterResource
}

// CassandraClustersClientDeallocateResponse contains the response from method CassandraClustersClient.BeginDeallocate.
type CassandraClustersClientDeallocateResponse struct {
	// placeholder for future response values
}

// CassandraClustersClientDeleteResponse contains the response from method CassandraClustersClient.BeginDelete.
type CassandraClustersClientDeleteResponse struct {
	// placeholder for future response values
}

// CassandraClustersClientGetBackupResponse contains the response from method CassandraClustersClient.GetBackup.
type CassandraClustersClientGetBackupResponse struct {
	// A restorable backup of a Cassandra cluster.
	BackupResource
}

// CassandraClustersClientGetCommandAsyncResponse contains the response from method CassandraClustersClient.GetCommandAsync.
type CassandraClustersClientGetCommandAsyncResponse struct {
	// List of commands for cluster.
	ListCommands
}

// CassandraClustersClientGetResponse contains the response from method CassandraClustersClient.Get.
type CassandraClustersClientGetResponse struct {
	// Representation of a managed Cassandra cluster.
	ClusterResource
}

// CassandraClustersClientInvokeCommandAsyncResponse contains the response from method CassandraClustersClient.BeginInvokeCommandAsync.
type CassandraClustersClientInvokeCommandAsyncResponse struct {
	// resource representing a command
	CommandPublicResource
}

// CassandraClustersClientInvokeCommandResponse contains the response from method CassandraClustersClient.BeginInvokeCommand.
type CassandraClustersClientInvokeCommandResponse struct {
	// Response of /command api
	CommandOutput
}

// CassandraClustersClientListBackupsResponse contains the response from method CassandraClustersClient.NewListBackupsPager.
type CassandraClustersClientListBackupsResponse struct {
	// List of restorable backups for a Cassandra cluster.
	ListBackups
}

// CassandraClustersClientListByResourceGroupResponse contains the response from method CassandraClustersClient.NewListByResourceGroupPager.
type CassandraClustersClientListByResourceGroupResponse struct {
	// List of managed Cassandra clusters.
	ListClusters
}

// CassandraClustersClientListBySubscriptionResponse contains the response from method CassandraClustersClient.NewListBySubscriptionPager.
type CassandraClustersClientListBySubscriptionResponse struct {
	// List of managed Cassandra clusters.
	ListClusters
}

// CassandraClustersClientListCommandResponse contains the response from method CassandraClustersClient.NewListCommandPager.
type CassandraClustersClientListCommandResponse struct {
	// List of commands for cluster.
	ListCommands
}

// CassandraClustersClientStartResponse contains the response from method CassandraClustersClient.BeginStart.
type CassandraClustersClientStartResponse struct {
	// placeholder for future response values
}

// CassandraClustersClientStatusResponse contains the response from method CassandraClustersClient.Status.
type CassandraClustersClientStatusResponse struct {
	// Properties of a managed Cassandra cluster public status.
	CassandraClusterPublicStatus
}

// CassandraClustersClientUpdateResponse contains the response from method CassandraClustersClient.BeginUpdate.
type CassandraClustersClientUpdateResponse struct {
	// Representation of a managed Cassandra cluster.
	ClusterResource
}

// CassandraDataCentersClientCreateUpdateResponse contains the response from method CassandraDataCentersClient.BeginCreateUpdate.
type CassandraDataCentersClientCreateUpdateResponse struct {
	// A managed Cassandra data center.
	DataCenterResource
}

// CassandraDataCentersClientDeleteResponse contains the response from method CassandraDataCentersClient.BeginDelete.
type CassandraDataCentersClientDeleteResponse struct {
	// placeholder for future response values
}

// CassandraDataCentersClientGetResponse contains the response from method CassandraDataCentersClient.Get.
type CassandraDataCentersClientGetResponse struct {
	// A managed Cassandra data center.
	DataCenterResource
}

// CassandraDataCentersClientListResponse contains the response from method CassandraDataCentersClient.NewListPager.
type CassandraDataCentersClientListResponse struct {
	// List of managed Cassandra data centers and their properties.
	ListDataCenters
}

// CassandraDataCentersClientUpdateResponse contains the response from method CassandraDataCentersClient.BeginUpdate.
type CassandraDataCentersClientUpdateResponse struct {
	// A managed Cassandra data center.
	DataCenterResource
}

// CassandraResourcesClientCreateUpdateCassandraKeyspaceResponse contains the response from method CassandraResourcesClient.BeginCreateUpdateCassandraKeyspace.
type CassandraResourcesClientCreateUpdateCassandraKeyspaceResponse struct {
	// An Azure Cosmos DB Cassandra keyspace.
	CassandraKeyspaceGetResults
}

// CassandraResourcesClientCreateUpdateCassandraTableResponse contains the response from method CassandraResourcesClient.BeginCreateUpdateCassandraTable.
type CassandraResourcesClientCreateUpdateCassandraTableResponse struct {
	// An Azure Cosmos DB Cassandra table.
	CassandraTableGetResults
}

// CassandraResourcesClientCreateUpdateCassandraViewResponse contains the response from method CassandraResourcesClient.BeginCreateUpdateCassandraView.
type CassandraResourcesClientCreateUpdateCassandraViewResponse struct {
	// An Azure Cosmos DB Cassandra view.
	CassandraViewGetResults
}

// CassandraResourcesClientDeleteCassandraKeyspaceResponse contains the response from method CassandraResourcesClient.BeginDeleteCassandraKeyspace.
type CassandraResourcesClientDeleteCassandraKeyspaceResponse struct {
	// placeholder for future response values
}

// CassandraResourcesClientDeleteCassandraTableResponse contains the response from method CassandraResourcesClient.BeginDeleteCassandraTable.
type CassandraResourcesClientDeleteCassandraTableResponse struct {
	// placeholder for future response values
}

// CassandraResourcesClientDeleteCassandraViewResponse contains the response from method CassandraResourcesClient.BeginDeleteCassandraView.
type CassandraResourcesClientDeleteCassandraViewResponse struct {
	// placeholder for future response values
}

// CassandraResourcesClientGetCassandraKeyspaceResponse contains the response from method CassandraResourcesClient.GetCassandraKeyspace.
type CassandraResourcesClientGetCassandraKeyspaceResponse struct {
	// An Azure Cosmos DB Cassandra keyspace.
	CassandraKeyspaceGetResults
}

// CassandraResourcesClientGetCassandraKeyspaceThroughputResponse contains the response from method CassandraResourcesClient.GetCassandraKeyspaceThroughput.
type CassandraResourcesClientGetCassandraKeyspaceThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CassandraResourcesClientGetCassandraTableResponse contains the response from method CassandraResourcesClient.GetCassandraTable.
type CassandraResourcesClientGetCassandraTableResponse struct {
	// An Azure Cosmos DB Cassandra table.
	CassandraTableGetResults
}

// CassandraResourcesClientGetCassandraTableThroughputResponse contains the response from method CassandraResourcesClient.GetCassandraTableThroughput.
type CassandraResourcesClientGetCassandraTableThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CassandraResourcesClientGetCassandraViewResponse contains the response from method CassandraResourcesClient.GetCassandraView.
type CassandraResourcesClientGetCassandraViewResponse struct {
	// An Azure Cosmos DB Cassandra view.
	CassandraViewGetResults
}

// CassandraResourcesClientGetCassandraViewThroughputResponse contains the response from method CassandraResourcesClient.GetCassandraViewThroughput.
type CassandraResourcesClientGetCassandraViewThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CassandraResourcesClientListCassandraKeyspacesResponse contains the response from method CassandraResourcesClient.NewListCassandraKeyspacesPager.
type CassandraResourcesClientListCassandraKeyspacesResponse struct {
	// The List operation response, that contains the Cassandra keyspaces and their properties.
	CassandraKeyspaceListResult
}

// CassandraResourcesClientListCassandraTablesResponse contains the response from method CassandraResourcesClient.NewListCassandraTablesPager.
type CassandraResourcesClientListCassandraTablesResponse struct {
	// The List operation response, that contains the Cassandra tables and their properties.
	CassandraTableListResult
}

// CassandraResourcesClientListCassandraViewsResponse contains the response from method CassandraResourcesClient.NewListCassandraViewsPager.
type CassandraResourcesClientListCassandraViewsResponse struct {
	// The List operation response, that contains the Cassandra views and their properties.
	CassandraViewListResult
}

// CassandraResourcesClientMigrateCassandraKeyspaceToAutoscaleResponse contains the response from method CassandraResourcesClient.BeginMigrateCassandraKeyspaceToAutoscale.
type CassandraResourcesClientMigrateCassandraKeyspaceToAutoscaleResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CassandraResourcesClientMigrateCassandraKeyspaceToManualThroughputResponse contains the response from method CassandraResourcesClient.BeginMigrateCassandraKeyspaceToManualThroughput.
type CassandraResourcesClientMigrateCassandraKeyspaceToManualThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CassandraResourcesClientMigrateCassandraTableToAutoscaleResponse contains the response from method CassandraResourcesClient.BeginMigrateCassandraTableToAutoscale.
type CassandraResourcesClientMigrateCassandraTableToAutoscaleResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CassandraResourcesClientMigrateCassandraTableToManualThroughputResponse contains the response from method CassandraResourcesClient.BeginMigrateCassandraTableToManualThroughput.
type CassandraResourcesClientMigrateCassandraTableToManualThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CassandraResourcesClientMigrateCassandraViewToAutoscaleResponse contains the response from method CassandraResourcesClient.BeginMigrateCassandraViewToAutoscale.
type CassandraResourcesClientMigrateCassandraViewToAutoscaleResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CassandraResourcesClientMigrateCassandraViewToManualThroughputResponse contains the response from method CassandraResourcesClient.BeginMigrateCassandraViewToManualThroughput.
type CassandraResourcesClientMigrateCassandraViewToManualThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CassandraResourcesClientUpdateCassandraKeyspaceThroughputResponse contains the response from method CassandraResourcesClient.BeginUpdateCassandraKeyspaceThroughput.
type CassandraResourcesClientUpdateCassandraKeyspaceThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CassandraResourcesClientUpdateCassandraTableThroughputResponse contains the response from method CassandraResourcesClient.BeginUpdateCassandraTableThroughput.
type CassandraResourcesClientUpdateCassandraTableThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CassandraResourcesClientUpdateCassandraViewThroughputResponse contains the response from method CassandraResourcesClient.BeginUpdateCassandraViewThroughput.
type CassandraResourcesClientUpdateCassandraViewThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// CollectionClientListMetricDefinitionsResponse contains the response from method CollectionClient.NewListMetricDefinitionsPager.
type CollectionClientListMetricDefinitionsResponse struct {
	// The response to a list metric definitions request.
	MetricDefinitionsListResult
}

// CollectionClientListMetricsResponse contains the response from method CollectionClient.NewListMetricsPager.
type CollectionClientListMetricsResponse struct {
	// The response to a list metrics request.
	MetricListResult
}

// CollectionClientListUsagesResponse contains the response from method CollectionClient.NewListUsagesPager.
type CollectionClientListUsagesResponse struct {
	// The response to a list usage request.
	UsagesResult
}

// CollectionPartitionClientListMetricsResponse contains the response from method CollectionPartitionClient.NewListMetricsPager.
type CollectionPartitionClientListMetricsResponse struct {
	// The response to a list partition metrics request.
	PartitionMetricListResult
}

// CollectionPartitionClientListUsagesResponse contains the response from method CollectionPartitionClient.NewListUsagesPager.
type CollectionPartitionClientListUsagesResponse struct {
	// The response to a list partition level usage request.
	PartitionUsagesResult
}

// CollectionPartitionRegionClientListMetricsResponse contains the response from method CollectionPartitionRegionClient.NewListMetricsPager.
type CollectionPartitionRegionClientListMetricsResponse struct {
	// The response to a list partition metrics request.
	PartitionMetricListResult
}

// CollectionRegionClientListMetricsResponse contains the response from method CollectionRegionClient.NewListMetricsPager.
type CollectionRegionClientListMetricsResponse struct {
	// The response to a list metrics request.
	MetricListResult
}

// DataTransferJobsClientCancelResponse contains the response from method DataTransferJobsClient.Cancel.
type DataTransferJobsClientCancelResponse struct {
	// A Cosmos DB Data Transfer Job
	DataTransferJobGetResults
}

// DataTransferJobsClientCompleteResponse contains the response from method DataTransferJobsClient.Complete.
type DataTransferJobsClientCompleteResponse struct {
	// A Cosmos DB Data Transfer Job
	DataTransferJobGetResults
}

// DataTransferJobsClientCreateResponse contains the response from method DataTransferJobsClient.Create.
type DataTransferJobsClientCreateResponse struct {
	// A Cosmos DB Data Transfer Job
	DataTransferJobGetResults
}

// DataTransferJobsClientGetResponse contains the response from method DataTransferJobsClient.Get.
type DataTransferJobsClientGetResponse struct {
	// A Cosmos DB Data Transfer Job
	DataTransferJobGetResults
}

// DataTransferJobsClientListByDatabaseAccountResponse contains the response from method DataTransferJobsClient.NewListByDatabaseAccountPager.
type DataTransferJobsClientListByDatabaseAccountResponse struct {
	// The List operation response, that contains the Data Transfer jobs and their properties.
	DataTransferJobFeedResults
}

// DataTransferJobsClientPauseResponse contains the response from method DataTransferJobsClient.Pause.
type DataTransferJobsClientPauseResponse struct {
	// A Cosmos DB Data Transfer Job
	DataTransferJobGetResults
}

// DataTransferJobsClientResumeResponse contains the response from method DataTransferJobsClient.Resume.
type DataTransferJobsClientResumeResponse struct {
	// A Cosmos DB Data Transfer Job
	DataTransferJobGetResults
}

// DatabaseAccountRegionClientListMetricsResponse contains the response from method DatabaseAccountRegionClient.NewListMetricsPager.
type DatabaseAccountRegionClientListMetricsResponse struct {
	// The response to a list metrics request.
	MetricListResult
}

// DatabaseAccountsClientCheckNameExistsResponse contains the response from method DatabaseAccountsClient.CheckNameExists.
type DatabaseAccountsClientCheckNameExistsResponse struct {
	// Success indicates if the operation succeeded or failed.
	Success bool
}

// DatabaseAccountsClientCreateOrUpdateResponse contains the response from method DatabaseAccountsClient.BeginCreateOrUpdate.
type DatabaseAccountsClientCreateOrUpdateResponse struct {
	// An Azure Cosmos DB database account.
	DatabaseAccountGetResults
}

// DatabaseAccountsClientDeleteResponse contains the response from method DatabaseAccountsClient.BeginDelete.
type DatabaseAccountsClientDeleteResponse struct {
	// placeholder for future response values
}

// DatabaseAccountsClientFailoverPriorityChangeResponse contains the response from method DatabaseAccountsClient.BeginFailoverPriorityChange.
type DatabaseAccountsClientFailoverPriorityChangeResponse struct {
	// placeholder for future response values
}

// DatabaseAccountsClientGetReadOnlyKeysResponse contains the response from method DatabaseAccountsClient.GetReadOnlyKeys.
type DatabaseAccountsClientGetReadOnlyKeysResponse struct {
	// The read-only access keys for the given database account.
	DatabaseAccountListReadOnlyKeysResult
}

// DatabaseAccountsClientGetResponse contains the response from method DatabaseAccountsClient.Get.
type DatabaseAccountsClientGetResponse struct {
	// An Azure Cosmos DB database account.
	DatabaseAccountGetResults
}

// DatabaseAccountsClientListByResourceGroupResponse contains the response from method DatabaseAccountsClient.NewListByResourceGroupPager.
type DatabaseAccountsClientListByResourceGroupResponse struct {
	// The List operation response, that contains the database accounts and their properties.
	DatabaseAccountsListResult
}

// DatabaseAccountsClientListConnectionStringsResponse contains the response from method DatabaseAccountsClient.ListConnectionStrings.
type DatabaseAccountsClientListConnectionStringsResponse struct {
	// The connection strings for the given database account.
	DatabaseAccountListConnectionStringsResult
}

// DatabaseAccountsClientListKeysResponse contains the response from method DatabaseAccountsClient.ListKeys.
type DatabaseAccountsClientListKeysResponse struct {
	// The access keys for the given database account.
	DatabaseAccountListKeysResult
}

// DatabaseAccountsClientListMetricDefinitionsResponse contains the response from method DatabaseAccountsClient.NewListMetricDefinitionsPager.
type DatabaseAccountsClientListMetricDefinitionsResponse struct {
	// The response to a list metric definitions request.
	MetricDefinitionsListResult
}

// DatabaseAccountsClientListMetricsResponse contains the response from method DatabaseAccountsClient.NewListMetricsPager.
type DatabaseAccountsClientListMetricsResponse struct {
	// The response to a list metrics request.
	MetricListResult
}

// DatabaseAccountsClientListReadOnlyKeysResponse contains the response from method DatabaseAccountsClient.ListReadOnlyKeys.
type DatabaseAccountsClientListReadOnlyKeysResponse struct {
	// The read-only access keys for the given database account.
	DatabaseAccountListReadOnlyKeysResult
}

// DatabaseAccountsClientListResponse contains the response from method DatabaseAccountsClient.NewListPager.
type DatabaseAccountsClientListResponse struct {
	// The List operation response, that contains the database accounts and their properties.
	DatabaseAccountsListResult
}

// DatabaseAccountsClientListUsagesResponse contains the response from method DatabaseAccountsClient.NewListUsagesPager.
type DatabaseAccountsClientListUsagesResponse struct {
	// The response to a list usage request.
	UsagesResult
}

// DatabaseAccountsClientOfflineRegionResponse contains the response from method DatabaseAccountsClient.BeginOfflineRegion.
type DatabaseAccountsClientOfflineRegionResponse struct {
	// placeholder for future response values
}

// DatabaseAccountsClientOnlineRegionResponse contains the response from method DatabaseAccountsClient.BeginOnlineRegion.
type DatabaseAccountsClientOnlineRegionResponse struct {
	// placeholder for future response values
}

// DatabaseAccountsClientRegenerateKeyResponse contains the response from method DatabaseAccountsClient.BeginRegenerateKey.
type DatabaseAccountsClientRegenerateKeyResponse struct {
	// placeholder for future response values
}

// DatabaseAccountsClientUpdateResponse contains the response from method DatabaseAccountsClient.BeginUpdate.
type DatabaseAccountsClientUpdateResponse struct {
	// An Azure Cosmos DB database account.
	DatabaseAccountGetResults
}

// DatabaseClientListMetricDefinitionsResponse contains the response from method DatabaseClient.NewListMetricDefinitionsPager.
type DatabaseClientListMetricDefinitionsResponse struct {
	// The response to a list metric definitions request.
	MetricDefinitionsListResult
}

// DatabaseClientListMetricsResponse contains the response from method DatabaseClient.NewListMetricsPager.
type DatabaseClientListMetricsResponse struct {
	// The response to a list metrics request.
	MetricListResult
}

// DatabaseClientListUsagesResponse contains the response from method DatabaseClient.NewListUsagesPager.
type DatabaseClientListUsagesResponse struct {
	// The response to a list usage request.
	UsagesResult
}

// GraphResourcesClientCreateUpdateGraphResponse contains the response from method GraphResourcesClient.BeginCreateUpdateGraph.
type GraphResourcesClientCreateUpdateGraphResponse struct {
	// An Azure Cosmos DB Graph resource.
	GraphResourceGetResults
}

// GraphResourcesClientDeleteGraphResourceResponse contains the response from method GraphResourcesClient.BeginDeleteGraphResource.
type GraphResourcesClientDeleteGraphResourceResponse struct {
	// placeholder for future response values
}

// GraphResourcesClientGetGraphResponse contains the response from method GraphResourcesClient.GetGraph.
type GraphResourcesClientGetGraphResponse struct {
	// An Azure Cosmos DB Graph resource.
	GraphResourceGetResults
}

// GraphResourcesClientListGraphsResponse contains the response from method GraphResourcesClient.NewListGraphsPager.
type GraphResourcesClientListGraphsResponse struct {
	// The List operation response, that contains the Graph resource and their properties.
	GraphResourcesListResult
}

// GremlinResourcesClientCreateUpdateGremlinDatabaseResponse contains the response from method GremlinResourcesClient.BeginCreateUpdateGremlinDatabase.
type GremlinResourcesClientCreateUpdateGremlinDatabaseResponse struct {
	// An Azure Cosmos DB Gremlin database.
	GremlinDatabaseGetResults
}

// GremlinResourcesClientCreateUpdateGremlinGraphResponse contains the response from method GremlinResourcesClient.BeginCreateUpdateGremlinGraph.
type GremlinResourcesClientCreateUpdateGremlinGraphResponse struct {
	// An Azure Cosmos DB Gremlin graph.
	GremlinGraphGetResults
}

// GremlinResourcesClientDeleteGremlinDatabaseResponse contains the response from method GremlinResourcesClient.BeginDeleteGremlinDatabase.
type GremlinResourcesClientDeleteGremlinDatabaseResponse struct {
	// placeholder for future response values
}

// GremlinResourcesClientDeleteGremlinGraphResponse contains the response from method GremlinResourcesClient.BeginDeleteGremlinGraph.
type GremlinResourcesClientDeleteGremlinGraphResponse struct {
	// placeholder for future response values
}

// GremlinResourcesClientGetGremlinDatabaseResponse contains the response from method GremlinResourcesClient.GetGremlinDatabase.
type GremlinResourcesClientGetGremlinDatabaseResponse struct {
	// An Azure Cosmos DB Gremlin database.
	GremlinDatabaseGetResults
}

// GremlinResourcesClientGetGremlinDatabaseThroughputResponse contains the response from method GremlinResourcesClient.GetGremlinDatabaseThroughput.
type GremlinResourcesClientGetGremlinDatabaseThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// GremlinResourcesClientGetGremlinGraphResponse contains the response from method GremlinResourcesClient.GetGremlinGraph.
type GremlinResourcesClientGetGremlinGraphResponse struct {
	// An Azure Cosmos DB Gremlin graph.
	GremlinGraphGetResults
}

// GremlinResourcesClientGetGremlinGraphThroughputResponse contains the response from method GremlinResourcesClient.GetGremlinGraphThroughput.
type GremlinResourcesClientGetGremlinGraphThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// GremlinResourcesClientListGremlinDatabasesResponse contains the response from method GremlinResourcesClient.NewListGremlinDatabasesPager.
type GremlinResourcesClientListGremlinDatabasesResponse struct {
	// The List operation response, that contains the Gremlin databases and their properties.
	GremlinDatabaseListResult
}

// GremlinResourcesClientListGremlinGraphsResponse contains the response from method GremlinResourcesClient.NewListGremlinGraphsPager.
type GremlinResourcesClientListGremlinGraphsResponse struct {
	// The List operation response, that contains the graphs and their properties.
	GremlinGraphListResult
}

// GremlinResourcesClientMigrateGremlinDatabaseToAutoscaleResponse contains the response from method GremlinResourcesClient.BeginMigrateGremlinDatabaseToAutoscale.
type GremlinResourcesClientMigrateGremlinDatabaseToAutoscaleResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// GremlinResourcesClientMigrateGremlinDatabaseToManualThroughputResponse contains the response from method GremlinResourcesClient.BeginMigrateGremlinDatabaseToManualThroughput.
type GremlinResourcesClientMigrateGremlinDatabaseToManualThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// GremlinResourcesClientMigrateGremlinGraphToAutoscaleResponse contains the response from method GremlinResourcesClient.BeginMigrateGremlinGraphToAutoscale.
type GremlinResourcesClientMigrateGremlinGraphToAutoscaleResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// GremlinResourcesClientMigrateGremlinGraphToManualThroughputResponse contains the response from method GremlinResourcesClient.BeginMigrateGremlinGraphToManualThroughput.
type GremlinResourcesClientMigrateGremlinGraphToManualThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// GremlinResourcesClientRetrieveContinuousBackupInformationResponse contains the response from method GremlinResourcesClient.BeginRetrieveContinuousBackupInformation.
type GremlinResourcesClientRetrieveContinuousBackupInformationResponse struct {
	// Backup information of a resource.
	BackupInformation
}

// GremlinResourcesClientUpdateGremlinDatabaseThroughputResponse contains the response from method GremlinResourcesClient.BeginUpdateGremlinDatabaseThroughput.
type GremlinResourcesClientUpdateGremlinDatabaseThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// GremlinResourcesClientUpdateGremlinGraphThroughputResponse contains the response from method GremlinResourcesClient.BeginUpdateGremlinGraphThroughput.
type GremlinResourcesClientUpdateGremlinGraphThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// LocationsClientGetResponse contains the response from method LocationsClient.Get.
type LocationsClientGetResponse struct {
	// Cosmos DB location get result
	LocationGetResult
}

// LocationsClientListResponse contains the response from method LocationsClient.NewListPager.
type LocationsClientListResponse struct {
	// The List operation response, that contains Cosmos DB locations and their properties.
	LocationListResult
}

// MongoClustersClientCheckNameAvailabilityResponse contains the response from method MongoClustersClient.CheckNameAvailability.
type MongoClustersClientCheckNameAvailabilityResponse struct {
	// The check availability result.
	CheckNameAvailabilityResponse
}

// MongoClustersClientCreateOrUpdateFirewallRuleResponse contains the response from method MongoClustersClient.BeginCreateOrUpdateFirewallRule.
type MongoClustersClientCreateOrUpdateFirewallRuleResponse struct {
	// Represents a mongo cluster firewall rule.
	FirewallRule
}

// MongoClustersClientCreateOrUpdateResponse contains the response from method MongoClustersClient.BeginCreateOrUpdate.
type MongoClustersClientCreateOrUpdateResponse struct {
	// Represents a mongo cluster resource.
	MongoCluster
}

// MongoClustersClientDeleteFirewallRuleResponse contains the response from method MongoClustersClient.BeginDeleteFirewallRule.
type MongoClustersClientDeleteFirewallRuleResponse struct {
	// placeholder for future response values
}

// MongoClustersClientDeleteResponse contains the response from method MongoClustersClient.BeginDelete.
type MongoClustersClientDeleteResponse struct {
	// placeholder for future response values
}

// MongoClustersClientGetFirewallRuleResponse contains the response from method MongoClustersClient.GetFirewallRule.
type MongoClustersClientGetFirewallRuleResponse struct {
	// Represents a mongo cluster firewall rule.
	FirewallRule
}

// MongoClustersClientGetResponse contains the response from method MongoClustersClient.Get.
type MongoClustersClientGetResponse struct {
	// Represents a mongo cluster resource.
	MongoCluster
}

// MongoClustersClientListByResourceGroupResponse contains the response from method MongoClustersClient.NewListByResourceGroupPager.
type MongoClustersClientListByResourceGroupResponse struct {
	// A list of mongo clusters.
	MongoClusterListResult
}

// MongoClustersClientListConnectionStringsResponse contains the response from method MongoClustersClient.ListConnectionStrings.
type MongoClustersClientListConnectionStringsResponse struct {
	// The connection strings for the given mongo cluster.
	ListConnectionStringsResult
}

// MongoClustersClientListFirewallRulesResponse contains the response from method MongoClustersClient.NewListFirewallRulesPager.
type MongoClustersClientListFirewallRulesResponse struct {
	// A list of firewall rules.
	FirewallRuleListResult
}

// MongoClustersClientListResponse contains the response from method MongoClustersClient.NewListPager.
type MongoClustersClientListResponse struct {
	// A list of mongo clusters.
	MongoClusterListResult
}

// MongoClustersClientUpdateResponse contains the response from method MongoClustersClient.BeginUpdate.
type MongoClustersClientUpdateResponse struct {
	// Represents a mongo cluster resource.
	MongoCluster
}

// MongoDBResourcesClientCreateUpdateMongoDBCollectionResponse contains the response from method MongoDBResourcesClient.BeginCreateUpdateMongoDBCollection.
type MongoDBResourcesClientCreateUpdateMongoDBCollectionResponse struct {
	// An Azure Cosmos DB MongoDB collection.
	MongoDBCollectionGetResults
}

// MongoDBResourcesClientCreateUpdateMongoDBDatabaseResponse contains the response from method MongoDBResourcesClient.BeginCreateUpdateMongoDBDatabase.
type MongoDBResourcesClientCreateUpdateMongoDBDatabaseResponse struct {
	// An Azure Cosmos DB MongoDB database.
	MongoDBDatabaseGetResults
}

// MongoDBResourcesClientCreateUpdateMongoRoleDefinitionResponse contains the response from method MongoDBResourcesClient.BeginCreateUpdateMongoRoleDefinition.
type MongoDBResourcesClientCreateUpdateMongoRoleDefinitionResponse struct {
	// An Azure Cosmos DB Mongo Role Definition.
	MongoRoleDefinitionGetResults
}

// MongoDBResourcesClientCreateUpdateMongoUserDefinitionResponse contains the response from method MongoDBResourcesClient.BeginCreateUpdateMongoUserDefinition.
type MongoDBResourcesClientCreateUpdateMongoUserDefinitionResponse struct {
	// An Azure Cosmos DB User Definition
	MongoUserDefinitionGetResults
}

// MongoDBResourcesClientDeleteMongoDBCollectionResponse contains the response from method MongoDBResourcesClient.BeginDeleteMongoDBCollection.
type MongoDBResourcesClientDeleteMongoDBCollectionResponse struct {
	// placeholder for future response values
}

// MongoDBResourcesClientDeleteMongoDBDatabaseResponse contains the response from method MongoDBResourcesClient.BeginDeleteMongoDBDatabase.
type MongoDBResourcesClientDeleteMongoDBDatabaseResponse struct {
	// placeholder for future response values
}

// MongoDBResourcesClientDeleteMongoRoleDefinitionResponse contains the response from method MongoDBResourcesClient.BeginDeleteMongoRoleDefinition.
type MongoDBResourcesClientDeleteMongoRoleDefinitionResponse struct {
	// placeholder for future response values
}

// MongoDBResourcesClientDeleteMongoUserDefinitionResponse contains the response from method MongoDBResourcesClient.BeginDeleteMongoUserDefinition.
type MongoDBResourcesClientDeleteMongoUserDefinitionResponse struct {
	// placeholder for future response values
}

// MongoDBResourcesClientGetMongoDBCollectionResponse contains the response from method MongoDBResourcesClient.GetMongoDBCollection.
type MongoDBResourcesClientGetMongoDBCollectionResponse struct {
	// An Azure Cosmos DB MongoDB collection.
	MongoDBCollectionGetResults
}

// MongoDBResourcesClientGetMongoDBCollectionThroughputResponse contains the response from method MongoDBResourcesClient.GetMongoDBCollectionThroughput.
type MongoDBResourcesClientGetMongoDBCollectionThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// MongoDBResourcesClientGetMongoDBDatabaseResponse contains the response from method MongoDBResourcesClient.GetMongoDBDatabase.
type MongoDBResourcesClientGetMongoDBDatabaseResponse struct {
	// An Azure Cosmos DB MongoDB database.
	MongoDBDatabaseGetResults
}

// MongoDBResourcesClientGetMongoDBDatabaseThroughputResponse contains the response from method MongoDBResourcesClient.GetMongoDBDatabaseThroughput.
type MongoDBResourcesClientGetMongoDBDatabaseThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// MongoDBResourcesClientGetMongoRoleDefinitionResponse contains the response from method MongoDBResourcesClient.GetMongoRoleDefinition.
type MongoDBResourcesClientGetMongoRoleDefinitionResponse struct {
	// An Azure Cosmos DB Mongo Role Definition.
	MongoRoleDefinitionGetResults
}

// MongoDBResourcesClientGetMongoUserDefinitionResponse contains the response from method MongoDBResourcesClient.GetMongoUserDefinition.
type MongoDBResourcesClientGetMongoUserDefinitionResponse struct {
	// An Azure Cosmos DB User Definition
	MongoUserDefinitionGetResults
}

// MongoDBResourcesClientListMongoDBCollectionPartitionMergeResponse contains the response from method MongoDBResourcesClient.BeginListMongoDBCollectionPartitionMerge.
type MongoDBResourcesClientListMongoDBCollectionPartitionMergeResponse struct {
	// List of physical partitions and their properties returned by a merge operation.
	PhysicalPartitionStorageInfoCollection
}

// MongoDBResourcesClientListMongoDBCollectionsResponse contains the response from method MongoDBResourcesClient.NewListMongoDBCollectionsPager.
type MongoDBResourcesClientListMongoDBCollectionsResponse struct {
	// The List operation response, that contains the MongoDB collections and their properties.
	MongoDBCollectionListResult
}

// MongoDBResourcesClientListMongoDBDatabasesResponse contains the response from method MongoDBResourcesClient.NewListMongoDBDatabasesPager.
type MongoDBResourcesClientListMongoDBDatabasesResponse struct {
	// The List operation response, that contains the MongoDB databases and their properties.
	MongoDBDatabaseListResult
}

// MongoDBResourcesClientListMongoRoleDefinitionsResponse contains the response from method MongoDBResourcesClient.NewListMongoRoleDefinitionsPager.
type MongoDBResourcesClientListMongoRoleDefinitionsResponse struct {
	// The relevant Mongo Role Definitions.
	MongoRoleDefinitionListResult
}

// MongoDBResourcesClientListMongoUserDefinitionsResponse contains the response from method MongoDBResourcesClient.NewListMongoUserDefinitionsPager.
type MongoDBResourcesClientListMongoUserDefinitionsResponse struct {
	// The relevant User Definition.
	MongoUserDefinitionListResult
}

// MongoDBResourcesClientMigrateMongoDBCollectionToAutoscaleResponse contains the response from method MongoDBResourcesClient.BeginMigrateMongoDBCollectionToAutoscale.
type MongoDBResourcesClientMigrateMongoDBCollectionToAutoscaleResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// MongoDBResourcesClientMigrateMongoDBCollectionToManualThroughputResponse contains the response from method MongoDBResourcesClient.BeginMigrateMongoDBCollectionToManualThroughput.
type MongoDBResourcesClientMigrateMongoDBCollectionToManualThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// MongoDBResourcesClientMigrateMongoDBDatabaseToAutoscaleResponse contains the response from method MongoDBResourcesClient.BeginMigrateMongoDBDatabaseToAutoscale.
type MongoDBResourcesClientMigrateMongoDBDatabaseToAutoscaleResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// MongoDBResourcesClientMigrateMongoDBDatabaseToManualThroughputResponse contains the response from method MongoDBResourcesClient.BeginMigrateMongoDBDatabaseToManualThroughput.
type MongoDBResourcesClientMigrateMongoDBDatabaseToManualThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// MongoDBResourcesClientMongoDBContainerRedistributeThroughputResponse contains the response from method MongoDBResourcesClient.BeginMongoDBContainerRedistributeThroughput.
type MongoDBResourcesClientMongoDBContainerRedistributeThroughputResponse struct {
	// An Azure Cosmos DB PhysicalPartitionThroughputInfoResult object.
	PhysicalPartitionThroughputInfoResult
}

// MongoDBResourcesClientMongoDBContainerRetrieveThroughputDistributionResponse contains the response from method MongoDBResourcesClient.BeginMongoDBContainerRetrieveThroughputDistribution.
type MongoDBResourcesClientMongoDBContainerRetrieveThroughputDistributionResponse struct {
	// An Azure Cosmos DB PhysicalPartitionThroughputInfoResult object.
	PhysicalPartitionThroughputInfoResult
}

// MongoDBResourcesClientMongoDBDatabasePartitionMergeResponse contains the response from method MongoDBResourcesClient.BeginMongoDBDatabasePartitionMerge.
type MongoDBResourcesClientMongoDBDatabasePartitionMergeResponse struct {
	// List of physical partitions and their properties returned by a merge operation.
	PhysicalPartitionStorageInfoCollection
}

// MongoDBResourcesClientMongoDBDatabaseRedistributeThroughputResponse contains the response from method MongoDBResourcesClient.BeginMongoDBDatabaseRedistributeThroughput.
type MongoDBResourcesClientMongoDBDatabaseRedistributeThroughputResponse struct {
	// An Azure Cosmos DB PhysicalPartitionThroughputInfoResult object.
	PhysicalPartitionThroughputInfoResult
}

// MongoDBResourcesClientMongoDBDatabaseRetrieveThroughputDistributionResponse contains the response from method MongoDBResourcesClient.BeginMongoDBDatabaseRetrieveThroughputDistribution.
type MongoDBResourcesClientMongoDBDatabaseRetrieveThroughputDistributionResponse struct {
	// An Azure Cosmos DB PhysicalPartitionThroughputInfoResult object.
	PhysicalPartitionThroughputInfoResult
}

// MongoDBResourcesClientRetrieveContinuousBackupInformationResponse contains the response from method MongoDBResourcesClient.BeginRetrieveContinuousBackupInformation.
type MongoDBResourcesClientRetrieveContinuousBackupInformationResponse struct {
	// Backup information of a resource.
	BackupInformation
}

// MongoDBResourcesClientUpdateMongoDBCollectionThroughputResponse contains the response from method MongoDBResourcesClient.BeginUpdateMongoDBCollectionThroughput.
type MongoDBResourcesClientUpdateMongoDBCollectionThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// MongoDBResourcesClientUpdateMongoDBDatabaseThroughputResponse contains the response from method MongoDBResourcesClient.BeginUpdateMongoDBDatabaseThroughput.
type MongoDBResourcesClientUpdateMongoDBDatabaseThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// NotebookWorkspacesClientCreateOrUpdateResponse contains the response from method NotebookWorkspacesClient.BeginCreateOrUpdate.
type NotebookWorkspacesClientCreateOrUpdateResponse struct {
	// A notebook workspace resource
	NotebookWorkspace
}

// NotebookWorkspacesClientDeleteResponse contains the response from method NotebookWorkspacesClient.BeginDelete.
type NotebookWorkspacesClientDeleteResponse struct {
	// placeholder for future response values
}

// NotebookWorkspacesClientGetResponse contains the response from method NotebookWorkspacesClient.Get.
type NotebookWorkspacesClientGetResponse struct {
	// A notebook workspace resource
	NotebookWorkspace
}

// NotebookWorkspacesClientListByDatabaseAccountResponse contains the response from method NotebookWorkspacesClient.NewListByDatabaseAccountPager.
type NotebookWorkspacesClientListByDatabaseAccountResponse struct {
	// A list of notebook workspace resources
	NotebookWorkspaceListResult
}

// NotebookWorkspacesClientListConnectionInfoResponse contains the response from method NotebookWorkspacesClient.ListConnectionInfo.
type NotebookWorkspacesClientListConnectionInfoResponse struct {
	// The connection info for the given notebook workspace
	NotebookWorkspaceConnectionInfoResult
}

// NotebookWorkspacesClientRegenerateAuthTokenResponse contains the response from method NotebookWorkspacesClient.BeginRegenerateAuthToken.
type NotebookWorkspacesClientRegenerateAuthTokenResponse struct {
	// placeholder for future response values
}

// NotebookWorkspacesClientStartResponse contains the response from method NotebookWorkspacesClient.BeginStart.
type NotebookWorkspacesClientStartResponse struct {
	// placeholder for future response values
}

// OperationsClientListResponse contains the response from method OperationsClient.NewListPager.
type OperationsClientListResponse struct {
	// Result of the request to list Resource Provider operations. It contains a list of operations and a URL link to get the
	// next set of results.
	OperationListResult
}

// PartitionKeyRangeIDClientListMetricsResponse contains the response from method PartitionKeyRangeIDClient.NewListMetricsPager.
type PartitionKeyRangeIDClientListMetricsResponse struct {
	// The response to a list partition metrics request.
	PartitionMetricListResult
}

// PartitionKeyRangeIDRegionClientListMetricsResponse contains the response from method PartitionKeyRangeIDRegionClient.NewListMetricsPager.
type PartitionKeyRangeIDRegionClientListMetricsResponse struct {
	// The response to a list partition metrics request.
	PartitionMetricListResult
}

// PercentileClientListMetricsResponse contains the response from method PercentileClient.NewListMetricsPager.
type PercentileClientListMetricsResponse struct {
	// The response to a list percentile metrics request.
	PercentileMetricListResult
}

// PercentileSourceTargetClientListMetricsResponse contains the response from method PercentileSourceTargetClient.NewListMetricsPager.
type PercentileSourceTargetClientListMetricsResponse struct {
	// The response to a list percentile metrics request.
	PercentileMetricListResult
}

// PercentileTargetClientListMetricsResponse contains the response from method PercentileTargetClient.NewListMetricsPager.
type PercentileTargetClientListMetricsResponse struct {
	// The response to a list percentile metrics request.
	PercentileMetricListResult
}

// PrivateEndpointConnectionsClientCreateOrUpdateResponse contains the response from method PrivateEndpointConnectionsClient.BeginCreateOrUpdate.
type PrivateEndpointConnectionsClientCreateOrUpdateResponse struct {
	// A private endpoint connection
	PrivateEndpointConnection
}

// PrivateEndpointConnectionsClientDeleteResponse contains the response from method PrivateEndpointConnectionsClient.BeginDelete.
type PrivateEndpointConnectionsClientDeleteResponse struct {
	// placeholder for future response values
}

// PrivateEndpointConnectionsClientGetResponse contains the response from method PrivateEndpointConnectionsClient.Get.
type PrivateEndpointConnectionsClientGetResponse struct {
	// A private endpoint connection
	PrivateEndpointConnection
}

// PrivateEndpointConnectionsClientListByDatabaseAccountResponse contains the response from method PrivateEndpointConnectionsClient.NewListByDatabaseAccountPager.
type PrivateEndpointConnectionsClientListByDatabaseAccountResponse struct {
	// A list of private endpoint connections
	PrivateEndpointConnectionListResult
}

// PrivateLinkResourcesClientGetResponse contains the response from method PrivateLinkResourcesClient.Get.
type PrivateLinkResourcesClientGetResponse struct {
	// A private link resource
	PrivateLinkResource
}

// PrivateLinkResourcesClientListByDatabaseAccountResponse contains the response from method PrivateLinkResourcesClient.NewListByDatabaseAccountPager.
type PrivateLinkResourcesClientListByDatabaseAccountResponse struct {
	// A list of private link resources
	PrivateLinkResourceListResult
}

// RestorableDatabaseAccountsClientGetByLocationResponse contains the response from method RestorableDatabaseAccountsClient.GetByLocation.
type RestorableDatabaseAccountsClientGetByLocationResponse struct {
	// A Azure Cosmos DB restorable database account.
	RestorableDatabaseAccountGetResult
}

// RestorableDatabaseAccountsClientListByLocationResponse contains the response from method RestorableDatabaseAccountsClient.NewListByLocationPager.
type RestorableDatabaseAccountsClientListByLocationResponse struct {
	// The List operation response, that contains the restorable database accounts and their properties.
	RestorableDatabaseAccountsListResult
}

// RestorableDatabaseAccountsClientListResponse contains the response from method RestorableDatabaseAccountsClient.NewListPager.
type RestorableDatabaseAccountsClientListResponse struct {
	// The List operation response, that contains the restorable database accounts and their properties.
	RestorableDatabaseAccountsListResult
}

// RestorableGremlinDatabasesClientListResponse contains the response from method RestorableGremlinDatabasesClient.NewListPager.
type RestorableGremlinDatabasesClientListResponse struct {
	// The List operation response, that contains the Gremlin database events and their properties.
	RestorableGremlinDatabasesListResult
}

// RestorableGremlinGraphsClientListResponse contains the response from method RestorableGremlinGraphsClient.NewListPager.
type RestorableGremlinGraphsClientListResponse struct {
	// The List operation response, that contains the Gremlin graph events and their properties.
	RestorableGremlinGraphsListResult
}

// RestorableGremlinResourcesClientListResponse contains the response from method RestorableGremlinResourcesClient.NewListPager.
type RestorableGremlinResourcesClientListResponse struct {
	// The List operation response, that contains the restorable Gremlin resources.
	RestorableGremlinResourcesListResult
}

// RestorableMongodbCollectionsClientListResponse contains the response from method RestorableMongodbCollectionsClient.NewListPager.
type RestorableMongodbCollectionsClientListResponse struct {
	// The List operation response, that contains the MongoDB collection events and their properties.
	RestorableMongodbCollectionsListResult
}

// RestorableMongodbDatabasesClientListResponse contains the response from method RestorableMongodbDatabasesClient.NewListPager.
type RestorableMongodbDatabasesClientListResponse struct {
	// The List operation response, that contains the MongoDB database events and their properties.
	RestorableMongodbDatabasesListResult
}

// RestorableMongodbResourcesClientListResponse contains the response from method RestorableMongodbResourcesClient.NewListPager.
type RestorableMongodbResourcesClientListResponse struct {
	// The List operation response, that contains the restorable MongoDB resources.
	RestorableMongodbResourcesListResult
}

// RestorableSQLContainersClientListResponse contains the response from method RestorableSQLContainersClient.NewListPager.
type RestorableSQLContainersClientListResponse struct {
	// The List operation response, that contains the SQL container events and their properties.
	RestorableSQLContainersListResult
}

// RestorableSQLDatabasesClientListResponse contains the response from method RestorableSQLDatabasesClient.NewListPager.
type RestorableSQLDatabasesClientListResponse struct {
	// The List operation response, that contains the SQL database events and their properties.
	RestorableSQLDatabasesListResult
}

// RestorableSQLResourcesClientListResponse contains the response from method RestorableSQLResourcesClient.NewListPager.
type RestorableSQLResourcesClientListResponse struct {
	// The List operation response, that contains the restorable SQL resources.
	RestorableSQLResourcesListResult
}

// RestorableTableResourcesClientListResponse contains the response from method RestorableTableResourcesClient.NewListPager.
type RestorableTableResourcesClientListResponse struct {
	// List of restorable table names.
	RestorableTableResourcesListResult
}

// RestorableTablesClientListResponse contains the response from method RestorableTablesClient.NewListPager.
type RestorableTablesClientListResponse struct {
	// The List operation response, that contains the Table events and their properties.
	RestorableTablesListResult
}

// SQLResourcesClientCreateUpdateClientEncryptionKeyResponse contains the response from method SQLResourcesClient.BeginCreateUpdateClientEncryptionKey.
type SQLResourcesClientCreateUpdateClientEncryptionKeyResponse struct {
	// Client Encryption Key.
	ClientEncryptionKeyGetResults
}

// SQLResourcesClientCreateUpdateSQLContainerResponse contains the response from method SQLResourcesClient.BeginCreateUpdateSQLContainer.
type SQLResourcesClientCreateUpdateSQLContainerResponse struct {
	// An Azure Cosmos DB container.
	SQLContainerGetResults
}

// SQLResourcesClientCreateUpdateSQLDatabaseResponse contains the response from method SQLResourcesClient.BeginCreateUpdateSQLDatabase.
type SQLResourcesClientCreateUpdateSQLDatabaseResponse struct {
	// An Azure Cosmos DB SQL database.
	SQLDatabaseGetResults
}

// SQLResourcesClientCreateUpdateSQLRoleAssignmentResponse contains the response from method SQLResourcesClient.BeginCreateUpdateSQLRoleAssignment.
type SQLResourcesClientCreateUpdateSQLRoleAssignmentResponse struct {
	// An Azure Cosmos DB Role Assignment
	SQLRoleAssignmentGetResults
}

// SQLResourcesClientCreateUpdateSQLRoleDefinitionResponse contains the response from method SQLResourcesClient.BeginCreateUpdateSQLRoleDefinition.
type SQLResourcesClientCreateUpdateSQLRoleDefinitionResponse struct {
	// An Azure Cosmos DB SQL Role Definition.
	SQLRoleDefinitionGetResults
}

// SQLResourcesClientCreateUpdateSQLStoredProcedureResponse contains the response from method SQLResourcesClient.BeginCreateUpdateSQLStoredProcedure.
type SQLResourcesClientCreateUpdateSQLStoredProcedureResponse struct {
	// An Azure Cosmos DB storedProcedure.
	SQLStoredProcedureGetResults
}

// SQLResourcesClientCreateUpdateSQLTriggerResponse contains the response from method SQLResourcesClient.BeginCreateUpdateSQLTrigger.
type SQLResourcesClientCreateUpdateSQLTriggerResponse struct {
	// An Azure Cosmos DB trigger.
	SQLTriggerGetResults
}

// SQLResourcesClientCreateUpdateSQLUserDefinedFunctionResponse contains the response from method SQLResourcesClient.BeginCreateUpdateSQLUserDefinedFunction.
type SQLResourcesClientCreateUpdateSQLUserDefinedFunctionResponse struct {
	// An Azure Cosmos DB userDefinedFunction.
	SQLUserDefinedFunctionGetResults
}

// SQLResourcesClientDeleteSQLContainerResponse contains the response from method SQLResourcesClient.BeginDeleteSQLContainer.
type SQLResourcesClientDeleteSQLContainerResponse struct {
	// placeholder for future response values
}

// SQLResourcesClientDeleteSQLDatabaseResponse contains the response from method SQLResourcesClient.BeginDeleteSQLDatabase.
type SQLResourcesClientDeleteSQLDatabaseResponse struct {
	// placeholder for future response values
}

// SQLResourcesClientDeleteSQLRoleAssignmentResponse contains the response from method SQLResourcesClient.BeginDeleteSQLRoleAssignment.
type SQLResourcesClientDeleteSQLRoleAssignmentResponse struct {
	// placeholder for future response values
}

// SQLResourcesClientDeleteSQLRoleDefinitionResponse contains the response from method SQLResourcesClient.BeginDeleteSQLRoleDefinition.
type SQLResourcesClientDeleteSQLRoleDefinitionResponse struct {
	// placeholder for future response values
}

// SQLResourcesClientDeleteSQLStoredProcedureResponse contains the response from method SQLResourcesClient.BeginDeleteSQLStoredProcedure.
type SQLResourcesClientDeleteSQLStoredProcedureResponse struct {
	// placeholder for future response values
}

// SQLResourcesClientDeleteSQLTriggerResponse contains the response from method SQLResourcesClient.BeginDeleteSQLTrigger.
type SQLResourcesClientDeleteSQLTriggerResponse struct {
	// placeholder for future response values
}

// SQLResourcesClientDeleteSQLUserDefinedFunctionResponse contains the response from method SQLResourcesClient.BeginDeleteSQLUserDefinedFunction.
type SQLResourcesClientDeleteSQLUserDefinedFunctionResponse struct {
	// placeholder for future response values
}

// SQLResourcesClientGetClientEncryptionKeyResponse contains the response from method SQLResourcesClient.GetClientEncryptionKey.
type SQLResourcesClientGetClientEncryptionKeyResponse struct {
	// Client Encryption Key.
	ClientEncryptionKeyGetResults
}

// SQLResourcesClientGetSQLContainerResponse contains the response from method SQLResourcesClient.GetSQLContainer.
type SQLResourcesClientGetSQLContainerResponse struct {
	// An Azure Cosmos DB container.
	SQLContainerGetResults
}

// SQLResourcesClientGetSQLContainerThroughputResponse contains the response from method SQLResourcesClient.GetSQLContainerThroughput.
type SQLResourcesClientGetSQLContainerThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// SQLResourcesClientGetSQLDatabaseResponse contains the response from method SQLResourcesClient.GetSQLDatabase.
type SQLResourcesClientGetSQLDatabaseResponse struct {
	// An Azure Cosmos DB SQL database.
	SQLDatabaseGetResults
}

// SQLResourcesClientGetSQLDatabaseThroughputResponse contains the response from method SQLResourcesClient.GetSQLDatabaseThroughput.
type SQLResourcesClientGetSQLDatabaseThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// SQLResourcesClientGetSQLRoleAssignmentResponse contains the response from method SQLResourcesClient.GetSQLRoleAssignment.
type SQLResourcesClientGetSQLRoleAssignmentResponse struct {
	// An Azure Cosmos DB Role Assignment
	SQLRoleAssignmentGetResults
}

// SQLResourcesClientGetSQLRoleDefinitionResponse contains the response from method SQLResourcesClient.GetSQLRoleDefinition.
type SQLResourcesClientGetSQLRoleDefinitionResponse struct {
	// An Azure Cosmos DB SQL Role Definition.
	SQLRoleDefinitionGetResults
}

// SQLResourcesClientGetSQLStoredProcedureResponse contains the response from method SQLResourcesClient.GetSQLStoredProcedure.
type SQLResourcesClientGetSQLStoredProcedureResponse struct {
	// An Azure Cosmos DB storedProcedure.
	SQLStoredProcedureGetResults
}

// SQLResourcesClientGetSQLTriggerResponse contains the response from method SQLResourcesClient.GetSQLTrigger.
type SQLResourcesClientGetSQLTriggerResponse struct {
	// An Azure Cosmos DB trigger.
	SQLTriggerGetResults
}

// SQLResourcesClientGetSQLUserDefinedFunctionResponse contains the response from method SQLResourcesClient.GetSQLUserDefinedFunction.
type SQLResourcesClientGetSQLUserDefinedFunctionResponse struct {
	// An Azure Cosmos DB userDefinedFunction.
	SQLUserDefinedFunctionGetResults
}

// SQLResourcesClientListClientEncryptionKeysResponse contains the response from method SQLResourcesClient.NewListClientEncryptionKeysPager.
type SQLResourcesClientListClientEncryptionKeysResponse struct {
	// The List operation response, that contains the client encryption keys and their properties.
	ClientEncryptionKeysListResult
}

// SQLResourcesClientListSQLContainerPartitionMergeResponse contains the response from method SQLResourcesClient.BeginListSQLContainerPartitionMerge.
type SQLResourcesClientListSQLContainerPartitionMergeResponse struct {
	// List of physical partitions and their properties returned by a merge operation.
	PhysicalPartitionStorageInfoCollection
}

// SQLResourcesClientListSQLContainersResponse contains the response from method SQLResourcesClient.NewListSQLContainersPager.
type SQLResourcesClientListSQLContainersResponse struct {
	// The List operation response, that contains the containers and their properties.
	SQLContainerListResult
}

// SQLResourcesClientListSQLDatabasesResponse contains the response from method SQLResourcesClient.NewListSQLDatabasesPager.
type SQLResourcesClientListSQLDatabasesResponse struct {
	// The List operation response, that contains the SQL databases and their properties.
	SQLDatabaseListResult
}

// SQLResourcesClientListSQLRoleAssignmentsResponse contains the response from method SQLResourcesClient.NewListSQLRoleAssignmentsPager.
type SQLResourcesClientListSQLRoleAssignmentsResponse struct {
	// The relevant Role Assignments.
	SQLRoleAssignmentListResult
}

// SQLResourcesClientListSQLRoleDefinitionsResponse contains the response from method SQLResourcesClient.NewListSQLRoleDefinitionsPager.
type SQLResourcesClientListSQLRoleDefinitionsResponse struct {
	// The relevant Role Definitions.
	SQLRoleDefinitionListResult
}

// SQLResourcesClientListSQLStoredProceduresResponse contains the response from method SQLResourcesClient.NewListSQLStoredProceduresPager.
type SQLResourcesClientListSQLStoredProceduresResponse struct {
	// The List operation response, that contains the storedProcedures and their properties.
	SQLStoredProcedureListResult
}

// SQLResourcesClientListSQLTriggersResponse contains the response from method SQLResourcesClient.NewListSQLTriggersPager.
type SQLResourcesClientListSQLTriggersResponse struct {
	// The List operation response, that contains the triggers and their properties.
	SQLTriggerListResult
}

// SQLResourcesClientListSQLUserDefinedFunctionsResponse contains the response from method SQLResourcesClient.NewListSQLUserDefinedFunctionsPager.
type SQLResourcesClientListSQLUserDefinedFunctionsResponse struct {
	// The List operation response, that contains the userDefinedFunctions and their properties.
	SQLUserDefinedFunctionListResult
}

// SQLResourcesClientMigrateSQLContainerToAutoscaleResponse contains the response from method SQLResourcesClient.BeginMigrateSQLContainerToAutoscale.
type SQLResourcesClientMigrateSQLContainerToAutoscaleResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// SQLResourcesClientMigrateSQLContainerToManualThroughputResponse contains the response from method SQLResourcesClient.BeginMigrateSQLContainerToManualThroughput.
type SQLResourcesClientMigrateSQLContainerToManualThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// SQLResourcesClientMigrateSQLDatabaseToAutoscaleResponse contains the response from method SQLResourcesClient.BeginMigrateSQLDatabaseToAutoscale.
type SQLResourcesClientMigrateSQLDatabaseToAutoscaleResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// SQLResourcesClientMigrateSQLDatabaseToManualThroughputResponse contains the response from method SQLResourcesClient.BeginMigrateSQLDatabaseToManualThroughput.
type SQLResourcesClientMigrateSQLDatabaseToManualThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// SQLResourcesClientRetrieveContinuousBackupInformationResponse contains the response from method SQLResourcesClient.BeginRetrieveContinuousBackupInformation.
type SQLResourcesClientRetrieveContinuousBackupInformationResponse struct {
	// Backup information of a resource.
	BackupInformation
}

// SQLResourcesClientSQLContainerRedistributeThroughputResponse contains the response from method SQLResourcesClient.BeginSQLContainerRedistributeThroughput.
type SQLResourcesClientSQLContainerRedistributeThroughputResponse struct {
	// An Azure Cosmos DB PhysicalPartitionThroughputInfoResult object.
	PhysicalPartitionThroughputInfoResult
}

// SQLResourcesClientSQLContainerRetrieveThroughputDistributionResponse contains the response from method SQLResourcesClient.BeginSQLContainerRetrieveThroughputDistribution.
type SQLResourcesClientSQLContainerRetrieveThroughputDistributionResponse struct {
	// An Azure Cosmos DB PhysicalPartitionThroughputInfoResult object.
	PhysicalPartitionThroughputInfoResult
}

// SQLResourcesClientSQLDatabasePartitionMergeResponse contains the response from method SQLResourcesClient.BeginSQLDatabasePartitionMerge.
type SQLResourcesClientSQLDatabasePartitionMergeResponse struct {
	// List of physical partitions and their properties returned by a merge operation.
	PhysicalPartitionStorageInfoCollection
}

// SQLResourcesClientSQLDatabaseRedistributeThroughputResponse contains the response from method SQLResourcesClient.BeginSQLDatabaseRedistributeThroughput.
type SQLResourcesClientSQLDatabaseRedistributeThroughputResponse struct {
	// An Azure Cosmos DB PhysicalPartitionThroughputInfoResult object.
	PhysicalPartitionThroughputInfoResult
}

// SQLResourcesClientSQLDatabaseRetrieveThroughputDistributionResponse contains the response from method SQLResourcesClient.BeginSQLDatabaseRetrieveThroughputDistribution.
type SQLResourcesClientSQLDatabaseRetrieveThroughputDistributionResponse struct {
	// An Azure Cosmos DB PhysicalPartitionThroughputInfoResult object.
	PhysicalPartitionThroughputInfoResult
}

// SQLResourcesClientUpdateSQLContainerThroughputResponse contains the response from method SQLResourcesClient.BeginUpdateSQLContainerThroughput.
type SQLResourcesClientUpdateSQLContainerThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// SQLResourcesClientUpdateSQLDatabaseThroughputResponse contains the response from method SQLResourcesClient.BeginUpdateSQLDatabaseThroughput.
type SQLResourcesClientUpdateSQLDatabaseThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// ServiceClientCreateResponse contains the response from method ServiceClient.BeginCreate.
type ServiceClientCreateResponse struct {
	// Properties for the database account.
	ServiceResource
}

// ServiceClientDeleteResponse contains the response from method ServiceClient.BeginDelete.
type ServiceClientDeleteResponse struct {
	// placeholder for future response values
}

// ServiceClientGetResponse contains the response from method ServiceClient.Get.
type ServiceClientGetResponse struct {
	// Properties for the database account.
	ServiceResource
}

// ServiceClientListResponse contains the response from method ServiceClient.NewListPager.
type ServiceClientListResponse struct {
	// The List operation response, that contains the Service Resource and their properties.
	ServiceResourceListResult
}

// TableResourcesClientCreateUpdateTableResponse contains the response from method TableResourcesClient.BeginCreateUpdateTable.
type TableResourcesClientCreateUpdateTableResponse struct {
	// An Azure Cosmos DB Table.
	TableGetResults
}

// TableResourcesClientDeleteTableResponse contains the response from method TableResourcesClient.BeginDeleteTable.
type TableResourcesClientDeleteTableResponse struct {
	// placeholder for future response values
}

// TableResourcesClientGetTableResponse contains the response from method TableResourcesClient.GetTable.
type TableResourcesClientGetTableResponse struct {
	// An Azure Cosmos DB Table.
	TableGetResults
}

// TableResourcesClientGetTableThroughputResponse contains the response from method TableResourcesClient.GetTableThroughput.
type TableResourcesClientGetTableThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// TableResourcesClientListTablesResponse contains the response from method TableResourcesClient.NewListTablesPager.
type TableResourcesClientListTablesResponse struct {
	// The List operation response, that contains the Table and their properties.
	TableListResult
}

// TableResourcesClientMigrateTableToAutoscaleResponse contains the response from method TableResourcesClient.BeginMigrateTableToAutoscale.
type TableResourcesClientMigrateTableToAutoscaleResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// TableResourcesClientMigrateTableToManualThroughputResponse contains the response from method TableResourcesClient.BeginMigrateTableToManualThroughput.
type TableResourcesClientMigrateTableToManualThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// TableResourcesClientRetrieveContinuousBackupInformationResponse contains the response from method TableResourcesClient.BeginRetrieveContinuousBackupInformation.
type TableResourcesClientRetrieveContinuousBackupInformationResponse struct {
	// Backup information of a resource.
	BackupInformation
}

// TableResourcesClientUpdateTableThroughputResponse contains the response from method TableResourcesClient.BeginUpdateTableThroughput.
type TableResourcesClientUpdateTableThroughputResponse struct {
	// An Azure Cosmos DB resource throughput.
	ThroughputSettingsGetResults
}

// ThroughputPoolAccountClientCreateResponse contains the response from method ThroughputPoolAccountClient.BeginCreate.
type ThroughputPoolAccountClientCreateResponse struct {
	// An Azure Cosmos DB Throughputpool Account
	ThroughputPoolAccountResource
}

// ThroughputPoolAccountClientDeleteResponse contains the response from method ThroughputPoolAccountClient.BeginDelete.
type ThroughputPoolAccountClientDeleteResponse struct {
	// placeholder for future response values
}

// ThroughputPoolAccountClientGetResponse contains the response from method ThroughputPoolAccountClient.Get.
type ThroughputPoolAccountClientGetResponse struct {
	// An Azure Cosmos DB Throughputpool Account
	ThroughputPoolAccountResource
}

// ThroughputPoolAccountsClientListResponse contains the response from method ThroughputPoolAccountsClient.NewListPager.
type ThroughputPoolAccountsClientListResponse struct {
	// The List operation response, that contains the global database accounts and their properties.
	ThroughputPoolAccountsListResult
}

// ThroughputPoolClientCreateOrUpdateResponse contains the response from method ThroughputPoolClient.BeginCreateOrUpdate.
type ThroughputPoolClientCreateOrUpdateResponse struct {
	// An Azure Cosmos DB Throughputpool.
	ThroughputPoolResource
}

// ThroughputPoolClientDeleteResponse contains the response from method ThroughputPoolClient.BeginDelete.
type ThroughputPoolClientDeleteResponse struct {
	// placeholder for future response values
}

// ThroughputPoolClientGetResponse contains the response from method ThroughputPoolClient.Get.
type ThroughputPoolClientGetResponse struct {
	// An Azure Cosmos DB Throughputpool.
	ThroughputPoolResource
}

// ThroughputPoolClientUpdateResponse contains the response from method ThroughputPoolClient.BeginUpdate.
type ThroughputPoolClientUpdateResponse struct {
	// An Azure Cosmos DB Throughputpool.
	ThroughputPoolResource
}

// ThroughputPoolsClientListByResourceGroupResponse contains the response from method ThroughputPoolsClient.NewListByResourceGroupPager.
type ThroughputPoolsClientListByResourceGroupResponse struct {
	// The List operation response, that contains the throughput pools and their properties.
	ThroughputPoolsListResult
}

// ThroughputPoolsClientListResponse contains the response from method ThroughputPoolsClient.NewListPager.
type ThroughputPoolsClientListResponse struct {
	// The List operation response, that contains the throughput pools and their properties.
	ThroughputPoolsListResult
}
