//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
	"net/http"
	"net/url"
	"regexp"
)

// CassandraResourcesServer is a fake server for instances of the armcosmos.CassandraResourcesClient type.
type CassandraResourcesServer struct {
	// BeginCreateUpdateCassandraKeyspace is the fake for method CassandraResourcesClient.BeginCreateUpdateCassandraKeyspace
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateCassandraKeyspace func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, createUpdateCassandraKeyspaceParameters armcosmos.CassandraKeyspaceCreateUpdateParameters, options *armcosmos.CassandraResourcesClientBeginCreateUpdateCassandraKeyspaceOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientCreateUpdateCassandraKeyspaceResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateCassandraTable is the fake for method CassandraResourcesClient.BeginCreateUpdateCassandraTable
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateCassandraTable func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, createUpdateCassandraTableParameters armcosmos.CassandraTableCreateUpdateParameters, options *armcosmos.CassandraResourcesClientBeginCreateUpdateCassandraTableOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientCreateUpdateCassandraTableResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateCassandraView is the fake for method CassandraResourcesClient.BeginCreateUpdateCassandraView
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateCassandraView func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, createUpdateCassandraViewParameters armcosmos.CassandraViewCreateUpdateParameters, options *armcosmos.CassandraResourcesClientBeginCreateUpdateCassandraViewOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientCreateUpdateCassandraViewResponse], errResp azfake.ErrorResponder)

	// BeginDeleteCassandraKeyspace is the fake for method CassandraResourcesClient.BeginDeleteCassandraKeyspace
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteCassandraKeyspace func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, options *armcosmos.CassandraResourcesClientBeginDeleteCassandraKeyspaceOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientDeleteCassandraKeyspaceResponse], errResp azfake.ErrorResponder)

	// BeginDeleteCassandraTable is the fake for method CassandraResourcesClient.BeginDeleteCassandraTable
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteCassandraTable func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, options *armcosmos.CassandraResourcesClientBeginDeleteCassandraTableOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientDeleteCassandraTableResponse], errResp azfake.ErrorResponder)

	// BeginDeleteCassandraView is the fake for method CassandraResourcesClient.BeginDeleteCassandraView
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteCassandraView func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, options *armcosmos.CassandraResourcesClientBeginDeleteCassandraViewOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientDeleteCassandraViewResponse], errResp azfake.ErrorResponder)

	// GetCassandraKeyspace is the fake for method CassandraResourcesClient.GetCassandraKeyspace
	// HTTP status codes to indicate success: http.StatusOK
	GetCassandraKeyspace func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, options *armcosmos.CassandraResourcesClientGetCassandraKeyspaceOptions) (resp azfake.Responder[armcosmos.CassandraResourcesClientGetCassandraKeyspaceResponse], errResp azfake.ErrorResponder)

	// GetCassandraKeyspaceThroughput is the fake for method CassandraResourcesClient.GetCassandraKeyspaceThroughput
	// HTTP status codes to indicate success: http.StatusOK
	GetCassandraKeyspaceThroughput func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, options *armcosmos.CassandraResourcesClientGetCassandraKeyspaceThroughputOptions) (resp azfake.Responder[armcosmos.CassandraResourcesClientGetCassandraKeyspaceThroughputResponse], errResp azfake.ErrorResponder)

	// GetCassandraTable is the fake for method CassandraResourcesClient.GetCassandraTable
	// HTTP status codes to indicate success: http.StatusOK
	GetCassandraTable func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, options *armcosmos.CassandraResourcesClientGetCassandraTableOptions) (resp azfake.Responder[armcosmos.CassandraResourcesClientGetCassandraTableResponse], errResp azfake.ErrorResponder)

	// GetCassandraTableThroughput is the fake for method CassandraResourcesClient.GetCassandraTableThroughput
	// HTTP status codes to indicate success: http.StatusOK
	GetCassandraTableThroughput func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, options *armcosmos.CassandraResourcesClientGetCassandraTableThroughputOptions) (resp azfake.Responder[armcosmos.CassandraResourcesClientGetCassandraTableThroughputResponse], errResp azfake.ErrorResponder)

	// GetCassandraView is the fake for method CassandraResourcesClient.GetCassandraView
	// HTTP status codes to indicate success: http.StatusOK
	GetCassandraView func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, options *armcosmos.CassandraResourcesClientGetCassandraViewOptions) (resp azfake.Responder[armcosmos.CassandraResourcesClientGetCassandraViewResponse], errResp azfake.ErrorResponder)

	// GetCassandraViewThroughput is the fake for method CassandraResourcesClient.GetCassandraViewThroughput
	// HTTP status codes to indicate success: http.StatusOK
	GetCassandraViewThroughput func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, options *armcosmos.CassandraResourcesClientGetCassandraViewThroughputOptions) (resp azfake.Responder[armcosmos.CassandraResourcesClientGetCassandraViewThroughputResponse], errResp azfake.ErrorResponder)

	// NewListCassandraKeyspacesPager is the fake for method CassandraResourcesClient.NewListCassandraKeyspacesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCassandraKeyspacesPager func(resourceGroupName string, accountName string, options *armcosmos.CassandraResourcesClientListCassandraKeyspacesOptions) (resp azfake.PagerResponder[armcosmos.CassandraResourcesClientListCassandraKeyspacesResponse])

	// NewListCassandraTablesPager is the fake for method CassandraResourcesClient.NewListCassandraTablesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCassandraTablesPager func(resourceGroupName string, accountName string, keyspaceName string, options *armcosmos.CassandraResourcesClientListCassandraTablesOptions) (resp azfake.PagerResponder[armcosmos.CassandraResourcesClientListCassandraTablesResponse])

	// NewListCassandraViewsPager is the fake for method CassandraResourcesClient.NewListCassandraViewsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCassandraViewsPager func(resourceGroupName string, accountName string, keyspaceName string, options *armcosmos.CassandraResourcesClientListCassandraViewsOptions) (resp azfake.PagerResponder[armcosmos.CassandraResourcesClientListCassandraViewsResponse])

	// BeginMigrateCassandraKeyspaceToAutoscale is the fake for method CassandraResourcesClient.BeginMigrateCassandraKeyspaceToAutoscale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateCassandraKeyspaceToAutoscale func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, options *armcosmos.CassandraResourcesClientBeginMigrateCassandraKeyspaceToAutoscaleOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraKeyspaceToAutoscaleResponse], errResp azfake.ErrorResponder)

	// BeginMigrateCassandraKeyspaceToManualThroughput is the fake for method CassandraResourcesClient.BeginMigrateCassandraKeyspaceToManualThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateCassandraKeyspaceToManualThroughput func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, options *armcosmos.CassandraResourcesClientBeginMigrateCassandraKeyspaceToManualThroughputOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraKeyspaceToManualThroughputResponse], errResp azfake.ErrorResponder)

	// BeginMigrateCassandraTableToAutoscale is the fake for method CassandraResourcesClient.BeginMigrateCassandraTableToAutoscale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateCassandraTableToAutoscale func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, options *armcosmos.CassandraResourcesClientBeginMigrateCassandraTableToAutoscaleOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraTableToAutoscaleResponse], errResp azfake.ErrorResponder)

	// BeginMigrateCassandraTableToManualThroughput is the fake for method CassandraResourcesClient.BeginMigrateCassandraTableToManualThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateCassandraTableToManualThroughput func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, options *armcosmos.CassandraResourcesClientBeginMigrateCassandraTableToManualThroughputOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraTableToManualThroughputResponse], errResp azfake.ErrorResponder)

	// BeginMigrateCassandraViewToAutoscale is the fake for method CassandraResourcesClient.BeginMigrateCassandraViewToAutoscale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateCassandraViewToAutoscale func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, options *armcosmos.CassandraResourcesClientBeginMigrateCassandraViewToAutoscaleOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraViewToAutoscaleResponse], errResp azfake.ErrorResponder)

	// BeginMigrateCassandraViewToManualThroughput is the fake for method CassandraResourcesClient.BeginMigrateCassandraViewToManualThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateCassandraViewToManualThroughput func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, options *armcosmos.CassandraResourcesClientBeginMigrateCassandraViewToManualThroughputOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraViewToManualThroughputResponse], errResp azfake.ErrorResponder)

	// BeginUpdateCassandraKeyspaceThroughput is the fake for method CassandraResourcesClient.BeginUpdateCassandraKeyspaceThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateCassandraKeyspaceThroughput func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, updateThroughputParameters armcosmos.ThroughputSettingsUpdateParameters, options *armcosmos.CassandraResourcesClientBeginUpdateCassandraKeyspaceThroughputOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientUpdateCassandraKeyspaceThroughputResponse], errResp azfake.ErrorResponder)

	// BeginUpdateCassandraTableThroughput is the fake for method CassandraResourcesClient.BeginUpdateCassandraTableThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateCassandraTableThroughput func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, updateThroughputParameters armcosmos.ThroughputSettingsUpdateParameters, options *armcosmos.CassandraResourcesClientBeginUpdateCassandraTableThroughputOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientUpdateCassandraTableThroughputResponse], errResp azfake.ErrorResponder)

	// BeginUpdateCassandraViewThroughput is the fake for method CassandraResourcesClient.BeginUpdateCassandraViewThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateCassandraViewThroughput func(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, updateThroughputParameters armcosmos.ThroughputSettingsUpdateParameters, options *armcosmos.CassandraResourcesClientBeginUpdateCassandraViewThroughputOptions) (resp azfake.PollerResponder[armcosmos.CassandraResourcesClientUpdateCassandraViewThroughputResponse], errResp azfake.ErrorResponder)
}

// NewCassandraResourcesServerTransport creates a new instance of CassandraResourcesServerTransport with the provided implementation.
// The returned CassandraResourcesServerTransport instance is connected to an instance of armcosmos.CassandraResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCassandraResourcesServerTransport(srv *CassandraResourcesServer) *CassandraResourcesServerTransport {
	return &CassandraResourcesServerTransport{
		srv:                                             srv,
		beginCreateUpdateCassandraKeyspace:              newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientCreateUpdateCassandraKeyspaceResponse]](),
		beginCreateUpdateCassandraTable:                 newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientCreateUpdateCassandraTableResponse]](),
		beginCreateUpdateCassandraView:                  newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientCreateUpdateCassandraViewResponse]](),
		beginDeleteCassandraKeyspace:                    newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientDeleteCassandraKeyspaceResponse]](),
		beginDeleteCassandraTable:                       newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientDeleteCassandraTableResponse]](),
		beginDeleteCassandraView:                        newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientDeleteCassandraViewResponse]](),
		newListCassandraKeyspacesPager:                  newTracker[azfake.PagerResponder[armcosmos.CassandraResourcesClientListCassandraKeyspacesResponse]](),
		newListCassandraTablesPager:                     newTracker[azfake.PagerResponder[armcosmos.CassandraResourcesClientListCassandraTablesResponse]](),
		newListCassandraViewsPager:                      newTracker[azfake.PagerResponder[armcosmos.CassandraResourcesClientListCassandraViewsResponse]](),
		beginMigrateCassandraKeyspaceToAutoscale:        newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraKeyspaceToAutoscaleResponse]](),
		beginMigrateCassandraKeyspaceToManualThroughput: newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraKeyspaceToManualThroughputResponse]](),
		beginMigrateCassandraTableToAutoscale:           newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraTableToAutoscaleResponse]](),
		beginMigrateCassandraTableToManualThroughput:    newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraTableToManualThroughputResponse]](),
		beginMigrateCassandraViewToAutoscale:            newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraViewToAutoscaleResponse]](),
		beginMigrateCassandraViewToManualThroughput:     newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraViewToManualThroughputResponse]](),
		beginUpdateCassandraKeyspaceThroughput:          newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientUpdateCassandraKeyspaceThroughputResponse]](),
		beginUpdateCassandraTableThroughput:             newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientUpdateCassandraTableThroughputResponse]](),
		beginUpdateCassandraViewThroughput:              newTracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientUpdateCassandraViewThroughputResponse]](),
	}
}

// CassandraResourcesServerTransport connects instances of armcosmos.CassandraResourcesClient to instances of CassandraResourcesServer.
// Don't use this type directly, use NewCassandraResourcesServerTransport instead.
type CassandraResourcesServerTransport struct {
	srv                                             *CassandraResourcesServer
	beginCreateUpdateCassandraKeyspace              *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientCreateUpdateCassandraKeyspaceResponse]]
	beginCreateUpdateCassandraTable                 *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientCreateUpdateCassandraTableResponse]]
	beginCreateUpdateCassandraView                  *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientCreateUpdateCassandraViewResponse]]
	beginDeleteCassandraKeyspace                    *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientDeleteCassandraKeyspaceResponse]]
	beginDeleteCassandraTable                       *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientDeleteCassandraTableResponse]]
	beginDeleteCassandraView                        *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientDeleteCassandraViewResponse]]
	newListCassandraKeyspacesPager                  *tracker[azfake.PagerResponder[armcosmos.CassandraResourcesClientListCassandraKeyspacesResponse]]
	newListCassandraTablesPager                     *tracker[azfake.PagerResponder[armcosmos.CassandraResourcesClientListCassandraTablesResponse]]
	newListCassandraViewsPager                      *tracker[azfake.PagerResponder[armcosmos.CassandraResourcesClientListCassandraViewsResponse]]
	beginMigrateCassandraKeyspaceToAutoscale        *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraKeyspaceToAutoscaleResponse]]
	beginMigrateCassandraKeyspaceToManualThroughput *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraKeyspaceToManualThroughputResponse]]
	beginMigrateCassandraTableToAutoscale           *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraTableToAutoscaleResponse]]
	beginMigrateCassandraTableToManualThroughput    *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraTableToManualThroughputResponse]]
	beginMigrateCassandraViewToAutoscale            *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraViewToAutoscaleResponse]]
	beginMigrateCassandraViewToManualThroughput     *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientMigrateCassandraViewToManualThroughputResponse]]
	beginUpdateCassandraKeyspaceThroughput          *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientUpdateCassandraKeyspaceThroughputResponse]]
	beginUpdateCassandraTableThroughput             *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientUpdateCassandraTableThroughputResponse]]
	beginUpdateCassandraViewThroughput              *tracker[azfake.PollerResponder[armcosmos.CassandraResourcesClientUpdateCassandraViewThroughputResponse]]
}

// Do implements the policy.Transporter interface for CassandraResourcesServerTransport.
func (c *CassandraResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CassandraResourcesClient.BeginCreateUpdateCassandraKeyspace":
		resp, err = c.dispatchBeginCreateUpdateCassandraKeyspace(req)
	case "CassandraResourcesClient.BeginCreateUpdateCassandraTable":
		resp, err = c.dispatchBeginCreateUpdateCassandraTable(req)
	case "CassandraResourcesClient.BeginCreateUpdateCassandraView":
		resp, err = c.dispatchBeginCreateUpdateCassandraView(req)
	case "CassandraResourcesClient.BeginDeleteCassandraKeyspace":
		resp, err = c.dispatchBeginDeleteCassandraKeyspace(req)
	case "CassandraResourcesClient.BeginDeleteCassandraTable":
		resp, err = c.dispatchBeginDeleteCassandraTable(req)
	case "CassandraResourcesClient.BeginDeleteCassandraView":
		resp, err = c.dispatchBeginDeleteCassandraView(req)
	case "CassandraResourcesClient.GetCassandraKeyspace":
		resp, err = c.dispatchGetCassandraKeyspace(req)
	case "CassandraResourcesClient.GetCassandraKeyspaceThroughput":
		resp, err = c.dispatchGetCassandraKeyspaceThroughput(req)
	case "CassandraResourcesClient.GetCassandraTable":
		resp, err = c.dispatchGetCassandraTable(req)
	case "CassandraResourcesClient.GetCassandraTableThroughput":
		resp, err = c.dispatchGetCassandraTableThroughput(req)
	case "CassandraResourcesClient.GetCassandraView":
		resp, err = c.dispatchGetCassandraView(req)
	case "CassandraResourcesClient.GetCassandraViewThroughput":
		resp, err = c.dispatchGetCassandraViewThroughput(req)
	case "CassandraResourcesClient.NewListCassandraKeyspacesPager":
		resp, err = c.dispatchNewListCassandraKeyspacesPager(req)
	case "CassandraResourcesClient.NewListCassandraTablesPager":
		resp, err = c.dispatchNewListCassandraTablesPager(req)
	case "CassandraResourcesClient.NewListCassandraViewsPager":
		resp, err = c.dispatchNewListCassandraViewsPager(req)
	case "CassandraResourcesClient.BeginMigrateCassandraKeyspaceToAutoscale":
		resp, err = c.dispatchBeginMigrateCassandraKeyspaceToAutoscale(req)
	case "CassandraResourcesClient.BeginMigrateCassandraKeyspaceToManualThroughput":
		resp, err = c.dispatchBeginMigrateCassandraKeyspaceToManualThroughput(req)
	case "CassandraResourcesClient.BeginMigrateCassandraTableToAutoscale":
		resp, err = c.dispatchBeginMigrateCassandraTableToAutoscale(req)
	case "CassandraResourcesClient.BeginMigrateCassandraTableToManualThroughput":
		resp, err = c.dispatchBeginMigrateCassandraTableToManualThroughput(req)
	case "CassandraResourcesClient.BeginMigrateCassandraViewToAutoscale":
		resp, err = c.dispatchBeginMigrateCassandraViewToAutoscale(req)
	case "CassandraResourcesClient.BeginMigrateCassandraViewToManualThroughput":
		resp, err = c.dispatchBeginMigrateCassandraViewToManualThroughput(req)
	case "CassandraResourcesClient.BeginUpdateCassandraKeyspaceThroughput":
		resp, err = c.dispatchBeginUpdateCassandraKeyspaceThroughput(req)
	case "CassandraResourcesClient.BeginUpdateCassandraTableThroughput":
		resp, err = c.dispatchBeginUpdateCassandraTableThroughput(req)
	case "CassandraResourcesClient.BeginUpdateCassandraViewThroughput":
		resp, err = c.dispatchBeginUpdateCassandraViewThroughput(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginCreateUpdateCassandraKeyspace(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateUpdateCassandraKeyspace == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateCassandraKeyspace not implemented")}
	}
	beginCreateUpdateCassandraKeyspace := c.beginCreateUpdateCassandraKeyspace.get(req)
	if beginCreateUpdateCassandraKeyspace == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.CassandraKeyspaceCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateUpdateCassandraKeyspace(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateCassandraKeyspace = &respr
		c.beginCreateUpdateCassandraKeyspace.add(req, beginCreateUpdateCassandraKeyspace)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateCassandraKeyspace, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginCreateUpdateCassandraKeyspace.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateCassandraKeyspace) {
		c.beginCreateUpdateCassandraKeyspace.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginCreateUpdateCassandraTable(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateUpdateCassandraTable == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateCassandraTable not implemented")}
	}
	beginCreateUpdateCassandraTable := c.beginCreateUpdateCassandraTable.get(req)
	if beginCreateUpdateCassandraTable == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.CassandraTableCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateUpdateCassandraTable(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, tableNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateCassandraTable = &respr
		c.beginCreateUpdateCassandraTable.add(req, beginCreateUpdateCassandraTable)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateCassandraTable, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginCreateUpdateCassandraTable.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateCassandraTable) {
		c.beginCreateUpdateCassandraTable.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginCreateUpdateCassandraView(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateUpdateCassandraView == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateCassandraView not implemented")}
	}
	beginCreateUpdateCassandraView := c.beginCreateUpdateCassandraView.get(req)
	if beginCreateUpdateCassandraView == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.CassandraViewCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateUpdateCassandraView(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, viewNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateCassandraView = &respr
		c.beginCreateUpdateCassandraView.add(req, beginCreateUpdateCassandraView)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateCassandraView, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginCreateUpdateCassandraView.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateCassandraView) {
		c.beginCreateUpdateCassandraView.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginDeleteCassandraKeyspace(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDeleteCassandraKeyspace == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteCassandraKeyspace not implemented")}
	}
	beginDeleteCassandraKeyspace := c.beginDeleteCassandraKeyspace.get(req)
	if beginDeleteCassandraKeyspace == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDeleteCassandraKeyspace(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteCassandraKeyspace = &respr
		c.beginDeleteCassandraKeyspace.add(req, beginDeleteCassandraKeyspace)
	}

	resp, err := server.PollerResponderNext(beginDeleteCassandraKeyspace, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDeleteCassandraKeyspace.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteCassandraKeyspace) {
		c.beginDeleteCassandraKeyspace.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginDeleteCassandraTable(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDeleteCassandraTable == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteCassandraTable not implemented")}
	}
	beginDeleteCassandraTable := c.beginDeleteCassandraTable.get(req)
	if beginDeleteCassandraTable == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDeleteCassandraTable(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, tableNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteCassandraTable = &respr
		c.beginDeleteCassandraTable.add(req, beginDeleteCassandraTable)
	}

	resp, err := server.PollerResponderNext(beginDeleteCassandraTable, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDeleteCassandraTable.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteCassandraTable) {
		c.beginDeleteCassandraTable.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginDeleteCassandraView(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDeleteCassandraView == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteCassandraView not implemented")}
	}
	beginDeleteCassandraView := c.beginDeleteCassandraView.get(req)
	if beginDeleteCassandraView == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDeleteCassandraView(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, viewNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteCassandraView = &respr
		c.beginDeleteCassandraView.add(req, beginDeleteCassandraView)
	}

	resp, err := server.PollerResponderNext(beginDeleteCassandraView, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDeleteCassandraView.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteCassandraView) {
		c.beginDeleteCassandraView.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchGetCassandraKeyspace(req *http.Request) (*http.Response, error) {
	if c.srv.GetCassandraKeyspace == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCassandraKeyspace not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetCassandraKeyspace(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CassandraKeyspaceGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchGetCassandraKeyspaceThroughput(req *http.Request) (*http.Response, error) {
	if c.srv.GetCassandraKeyspaceThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCassandraKeyspaceThroughput not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetCassandraKeyspaceThroughput(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThroughputSettingsGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchGetCassandraTable(req *http.Request) (*http.Response, error) {
	if c.srv.GetCassandraTable == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCassandraTable not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
	if err != nil {
		return nil, err
	}
	tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetCassandraTable(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, tableNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CassandraTableGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchGetCassandraTableThroughput(req *http.Request) (*http.Response, error) {
	if c.srv.GetCassandraTableThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCassandraTableThroughput not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
	if err != nil {
		return nil, err
	}
	tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetCassandraTableThroughput(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, tableNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThroughputSettingsGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchGetCassandraView(req *http.Request) (*http.Response, error) {
	if c.srv.GetCassandraView == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCassandraView not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
	if err != nil {
		return nil, err
	}
	viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetCassandraView(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, viewNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CassandraViewGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchGetCassandraViewThroughput(req *http.Request) (*http.Response, error) {
	if c.srv.GetCassandraViewThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCassandraViewThroughput not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
	if err != nil {
		return nil, err
	}
	viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetCassandraViewThroughput(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, viewNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThroughputSettingsGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchNewListCassandraKeyspacesPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListCassandraKeyspacesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCassandraKeyspacesPager not implemented")}
	}
	newListCassandraKeyspacesPager := c.newListCassandraKeyspacesPager.get(req)
	if newListCassandraKeyspacesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListCassandraKeyspacesPager(resourceGroupNameParam, accountNameParam, nil)
		newListCassandraKeyspacesPager = &resp
		c.newListCassandraKeyspacesPager.add(req, newListCassandraKeyspacesPager)
	}
	resp, err := server.PagerResponderNext(newListCassandraKeyspacesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListCassandraKeyspacesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCassandraKeyspacesPager) {
		c.newListCassandraKeyspacesPager.remove(req)
	}
	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchNewListCassandraTablesPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListCassandraTablesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCassandraTablesPager not implemented")}
	}
	newListCassandraTablesPager := c.newListCassandraTablesPager.get(req)
	if newListCassandraTablesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListCassandraTablesPager(resourceGroupNameParam, accountNameParam, keyspaceNameParam, nil)
		newListCassandraTablesPager = &resp
		c.newListCassandraTablesPager.add(req, newListCassandraTablesPager)
	}
	resp, err := server.PagerResponderNext(newListCassandraTablesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListCassandraTablesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCassandraTablesPager) {
		c.newListCassandraTablesPager.remove(req)
	}
	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchNewListCassandraViewsPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListCassandraViewsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCassandraViewsPager not implemented")}
	}
	newListCassandraViewsPager := c.newListCassandraViewsPager.get(req)
	if newListCassandraViewsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/views`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListCassandraViewsPager(resourceGroupNameParam, accountNameParam, keyspaceNameParam, nil)
		newListCassandraViewsPager = &resp
		c.newListCassandraViewsPager.add(req, newListCassandraViewsPager)
	}
	resp, err := server.PagerResponderNext(newListCassandraViewsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListCassandraViewsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCassandraViewsPager) {
		c.newListCassandraViewsPager.remove(req)
	}
	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginMigrateCassandraKeyspaceToAutoscale(req *http.Request) (*http.Response, error) {
	if c.srv.BeginMigrateCassandraKeyspaceToAutoscale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateCassandraKeyspaceToAutoscale not implemented")}
	}
	beginMigrateCassandraKeyspaceToAutoscale := c.beginMigrateCassandraKeyspaceToAutoscale.get(req)
	if beginMigrateCassandraKeyspaceToAutoscale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToAutoscale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginMigrateCassandraKeyspaceToAutoscale(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateCassandraKeyspaceToAutoscale = &respr
		c.beginMigrateCassandraKeyspaceToAutoscale.add(req, beginMigrateCassandraKeyspaceToAutoscale)
	}

	resp, err := server.PollerResponderNext(beginMigrateCassandraKeyspaceToAutoscale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginMigrateCassandraKeyspaceToAutoscale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateCassandraKeyspaceToAutoscale) {
		c.beginMigrateCassandraKeyspaceToAutoscale.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginMigrateCassandraKeyspaceToManualThroughput(req *http.Request) (*http.Response, error) {
	if c.srv.BeginMigrateCassandraKeyspaceToManualThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateCassandraKeyspaceToManualThroughput not implemented")}
	}
	beginMigrateCassandraKeyspaceToManualThroughput := c.beginMigrateCassandraKeyspaceToManualThroughput.get(req)
	if beginMigrateCassandraKeyspaceToManualThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToManualThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginMigrateCassandraKeyspaceToManualThroughput(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateCassandraKeyspaceToManualThroughput = &respr
		c.beginMigrateCassandraKeyspaceToManualThroughput.add(req, beginMigrateCassandraKeyspaceToManualThroughput)
	}

	resp, err := server.PollerResponderNext(beginMigrateCassandraKeyspaceToManualThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginMigrateCassandraKeyspaceToManualThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateCassandraKeyspaceToManualThroughput) {
		c.beginMigrateCassandraKeyspaceToManualThroughput.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginMigrateCassandraTableToAutoscale(req *http.Request) (*http.Response, error) {
	if c.srv.BeginMigrateCassandraTableToAutoscale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateCassandraTableToAutoscale not implemented")}
	}
	beginMigrateCassandraTableToAutoscale := c.beginMigrateCassandraTableToAutoscale.get(req)
	if beginMigrateCassandraTableToAutoscale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToAutoscale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginMigrateCassandraTableToAutoscale(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, tableNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateCassandraTableToAutoscale = &respr
		c.beginMigrateCassandraTableToAutoscale.add(req, beginMigrateCassandraTableToAutoscale)
	}

	resp, err := server.PollerResponderNext(beginMigrateCassandraTableToAutoscale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginMigrateCassandraTableToAutoscale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateCassandraTableToAutoscale) {
		c.beginMigrateCassandraTableToAutoscale.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginMigrateCassandraTableToManualThroughput(req *http.Request) (*http.Response, error) {
	if c.srv.BeginMigrateCassandraTableToManualThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateCassandraTableToManualThroughput not implemented")}
	}
	beginMigrateCassandraTableToManualThroughput := c.beginMigrateCassandraTableToManualThroughput.get(req)
	if beginMigrateCassandraTableToManualThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToManualThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginMigrateCassandraTableToManualThroughput(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, tableNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateCassandraTableToManualThroughput = &respr
		c.beginMigrateCassandraTableToManualThroughput.add(req, beginMigrateCassandraTableToManualThroughput)
	}

	resp, err := server.PollerResponderNext(beginMigrateCassandraTableToManualThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginMigrateCassandraTableToManualThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateCassandraTableToManualThroughput) {
		c.beginMigrateCassandraTableToManualThroughput.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginMigrateCassandraViewToAutoscale(req *http.Request) (*http.Response, error) {
	if c.srv.BeginMigrateCassandraViewToAutoscale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateCassandraViewToAutoscale not implemented")}
	}
	beginMigrateCassandraViewToAutoscale := c.beginMigrateCassandraViewToAutoscale.get(req)
	if beginMigrateCassandraViewToAutoscale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToAutoscale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginMigrateCassandraViewToAutoscale(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, viewNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateCassandraViewToAutoscale = &respr
		c.beginMigrateCassandraViewToAutoscale.add(req, beginMigrateCassandraViewToAutoscale)
	}

	resp, err := server.PollerResponderNext(beginMigrateCassandraViewToAutoscale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginMigrateCassandraViewToAutoscale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateCassandraViewToAutoscale) {
		c.beginMigrateCassandraViewToAutoscale.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginMigrateCassandraViewToManualThroughput(req *http.Request) (*http.Response, error) {
	if c.srv.BeginMigrateCassandraViewToManualThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateCassandraViewToManualThroughput not implemented")}
	}
	beginMigrateCassandraViewToManualThroughput := c.beginMigrateCassandraViewToManualThroughput.get(req)
	if beginMigrateCassandraViewToManualThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToManualThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginMigrateCassandraViewToManualThroughput(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, viewNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateCassandraViewToManualThroughput = &respr
		c.beginMigrateCassandraViewToManualThroughput.add(req, beginMigrateCassandraViewToManualThroughput)
	}

	resp, err := server.PollerResponderNext(beginMigrateCassandraViewToManualThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginMigrateCassandraViewToManualThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateCassandraViewToManualThroughput) {
		c.beginMigrateCassandraViewToManualThroughput.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginUpdateCassandraKeyspaceThroughput(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdateCassandraKeyspaceThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateCassandraKeyspaceThroughput not implemented")}
	}
	beginUpdateCassandraKeyspaceThroughput := c.beginUpdateCassandraKeyspaceThroughput.get(req)
	if beginUpdateCassandraKeyspaceThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ThroughputSettingsUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdateCassandraKeyspaceThroughput(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateCassandraKeyspaceThroughput = &respr
		c.beginUpdateCassandraKeyspaceThroughput.add(req, beginUpdateCassandraKeyspaceThroughput)
	}

	resp, err := server.PollerResponderNext(beginUpdateCassandraKeyspaceThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdateCassandraKeyspaceThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateCassandraKeyspaceThroughput) {
		c.beginUpdateCassandraKeyspaceThroughput.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginUpdateCassandraTableThroughput(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdateCassandraTableThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateCassandraTableThroughput not implemented")}
	}
	beginUpdateCassandraTableThroughput := c.beginUpdateCassandraTableThroughput.get(req)
	if beginUpdateCassandraTableThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ThroughputSettingsUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdateCassandraTableThroughput(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, tableNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateCassandraTableThroughput = &respr
		c.beginUpdateCassandraTableThroughput.add(req, beginUpdateCassandraTableThroughput)
	}

	resp, err := server.PollerResponderNext(beginUpdateCassandraTableThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdateCassandraTableThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateCassandraTableThroughput) {
		c.beginUpdateCassandraTableThroughput.remove(req)
	}

	return resp, nil
}

func (c *CassandraResourcesServerTransport) dispatchBeginUpdateCassandraViewThroughput(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdateCassandraViewThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateCassandraViewThroughput not implemented")}
	}
	beginUpdateCassandraViewThroughput := c.beginUpdateCassandraViewThroughput.get(req)
	if beginUpdateCassandraViewThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cassandraKeyspaces/(?P<keyspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/views/(?P<viewName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ThroughputSettingsUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		keyspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("keyspaceName")])
		if err != nil {
			return nil, err
		}
		viewNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("viewName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdateCassandraViewThroughput(req.Context(), resourceGroupNameParam, accountNameParam, keyspaceNameParam, viewNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateCassandraViewThroughput = &respr
		c.beginUpdateCassandraViewThroughput.add(req, beginUpdateCassandraViewThroughput)
	}

	resp, err := server.PollerResponderNext(beginUpdateCassandraViewThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdateCassandraViewThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateCassandraViewThroughput) {
		c.beginUpdateCassandraViewThroughput.remove(req)
	}

	return resp, nil
}
