//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerinstance/armcontainerinstance/v2"
	"net/http"
	"net/url"
	"regexp"
)

// LocationServer is a fake server for instances of the armcontainerinstance.LocationClient type.
type LocationServer struct {
	// NewListCachedImagesPager is the fake for method LocationClient.NewListCachedImagesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCachedImagesPager func(location string, options *armcontainerinstance.LocationClientListCachedImagesOptions) (resp azfake.PagerResponder[armcontainerinstance.LocationClientListCachedImagesResponse])

	// NewListCapabilitiesPager is the fake for method LocationClient.NewListCapabilitiesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListCapabilitiesPager func(location string, options *armcontainerinstance.LocationClientListCapabilitiesOptions) (resp azfake.PagerResponder[armcontainerinstance.LocationClientListCapabilitiesResponse])

	// NewListUsagePager is the fake for method LocationClient.NewListUsagePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListUsagePager func(location string, options *armcontainerinstance.LocationClientListUsageOptions) (resp azfake.PagerResponder[armcontainerinstance.LocationClientListUsageResponse])
}

// NewLocationServerTransport creates a new instance of LocationServerTransport with the provided implementation.
// The returned LocationServerTransport instance is connected to an instance of armcontainerinstance.LocationClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLocationServerTransport(srv *LocationServer) *LocationServerTransport {
	return &LocationServerTransport{
		srv:                      srv,
		newListCachedImagesPager: newTracker[azfake.PagerResponder[armcontainerinstance.LocationClientListCachedImagesResponse]](),
		newListCapabilitiesPager: newTracker[azfake.PagerResponder[armcontainerinstance.LocationClientListCapabilitiesResponse]](),
		newListUsagePager:        newTracker[azfake.PagerResponder[armcontainerinstance.LocationClientListUsageResponse]](),
	}
}

// LocationServerTransport connects instances of armcontainerinstance.LocationClient to instances of LocationServer.
// Don't use this type directly, use NewLocationServerTransport instead.
type LocationServerTransport struct {
	srv                      *LocationServer
	newListCachedImagesPager *tracker[azfake.PagerResponder[armcontainerinstance.LocationClientListCachedImagesResponse]]
	newListCapabilitiesPager *tracker[azfake.PagerResponder[armcontainerinstance.LocationClientListCapabilitiesResponse]]
	newListUsagePager        *tracker[azfake.PagerResponder[armcontainerinstance.LocationClientListUsageResponse]]
}

// Do implements the policy.Transporter interface for LocationServerTransport.
func (l *LocationServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LocationClient.NewListCachedImagesPager":
		resp, err = l.dispatchNewListCachedImagesPager(req)
	case "LocationClient.NewListCapabilitiesPager":
		resp, err = l.dispatchNewListCapabilitiesPager(req)
	case "LocationClient.NewListUsagePager":
		resp, err = l.dispatchNewListUsagePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LocationServerTransport) dispatchNewListCachedImagesPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListCachedImagesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCachedImagesPager not implemented")}
	}
	newListCachedImagesPager := l.newListCachedImagesPager.get(req)
	if newListCachedImagesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerInstance/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cachedImages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListCachedImagesPager(locationParam, nil)
		newListCachedImagesPager = &resp
		l.newListCachedImagesPager.add(req, newListCachedImagesPager)
		server.PagerResponderInjectNextLinks(newListCachedImagesPager, req, func(page *armcontainerinstance.LocationClientListCachedImagesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListCachedImagesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListCachedImagesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCachedImagesPager) {
		l.newListCachedImagesPager.remove(req)
	}
	return resp, nil
}

func (l *LocationServerTransport) dispatchNewListCapabilitiesPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListCapabilitiesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListCapabilitiesPager not implemented")}
	}
	newListCapabilitiesPager := l.newListCapabilitiesPager.get(req)
	if newListCapabilitiesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerInstance/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capabilities`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListCapabilitiesPager(locationParam, nil)
		newListCapabilitiesPager = &resp
		l.newListCapabilitiesPager.add(req, newListCapabilitiesPager)
		server.PagerResponderInjectNextLinks(newListCapabilitiesPager, req, func(page *armcontainerinstance.LocationClientListCapabilitiesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListCapabilitiesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListCapabilitiesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListCapabilitiesPager) {
		l.newListCapabilitiesPager.remove(req)
	}
	return resp, nil
}

func (l *LocationServerTransport) dispatchNewListUsagePager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListUsagePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListUsagePager not implemented")}
	}
	newListUsagePager := l.newListUsagePager.get(req)
	if newListUsagePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerInstance/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListUsagePager(locationParam, nil)
		newListUsagePager = &resp
		l.newListUsagePager.add(req, newListUsagePager)
	}
	resp, err := server.PagerResponderNext(newListUsagePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListUsagePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListUsagePager) {
		l.newListUsagePager.remove(req)
	}
	return resp, nil
}
