//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcdn_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cdn/armcdn/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Endpoints_ListByProfile.json
func ExampleEndpointsClient_NewListByProfilePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEndpointsClient().NewListByProfilePager("RG", "profile1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EndpointListResult = armcdn.EndpointListResult{
		// 	Value: []*armcdn.Endpoint{
		// 		{
		// 			Name: to.Ptr("endpoint1"),
		// 			Type: to.Ptr("Microsoft.Cdn/profiles/endpoints"),
		// 			ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1"),
		// 			Location: to.Ptr("CentralUs"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armcdn.EndpointProperties{
		// 				ContentTypesToCompress: []*string{
		// 				},
		// 				DefaultOriginGroup: &armcdn.ResourceReference{
		// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/originGroups/originGroup1"),
		// 				},
		// 				GeoFilters: []*armcdn.GeoFilter{
		// 				},
		// 				IsCompressionEnabled: to.Ptr(false),
		// 				IsHTTPAllowed: to.Ptr(true),
		// 				IsHTTPSAllowed: to.Ptr(true),
		// 				OptimizationType: to.Ptr(armcdn.OptimizationTypeDynamicSiteAcceleration),
		// 				OriginHostHeader: to.Ptr("www.bing.com"),
		// 				ProbePath: to.Ptr("/image"),
		// 				QueryStringCachingBehavior: to.Ptr(armcdn.QueryStringCachingBehaviorNotSet),
		// 				CustomDomains: []*armcdn.DeepCreatedCustomDomain{
		// 					{
		// 						Name: to.Ptr("www-someDomain-net"),
		// 						Properties: &armcdn.DeepCreatedCustomDomainProperties{
		// 							HostName: to.Ptr("www.someDomain.Net"),
		// 						},
		// 				}},
		// 				HostName: to.Ptr("endpoint1.azureedge.net"),
		// 				OriginGroups: []*armcdn.DeepCreatedOriginGroup{
		// 					{
		// 						Name: to.Ptr("originGroup1"),
		// 						Properties: &armcdn.DeepCreatedOriginGroupProperties{
		// 							HealthProbeSettings: &armcdn.HealthProbeParameters{
		// 								ProbeIntervalInSeconds: to.Ptr[int32](120),
		// 								ProbePath: to.Ptr("/health.aspx"),
		// 								ProbeProtocol: to.Ptr(armcdn.ProbeProtocolHTTP),
		// 								ProbeRequestType: to.Ptr(armcdn.HealthProbeRequestTypeGET),
		// 							},
		// 							Origins: []*armcdn.ResourceReference{
		// 								{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/www-bing-com"),
		// 							}},
		// 							ResponseBasedOriginErrorDetectionSettings: &armcdn.ResponseBasedOriginErrorDetectionParameters{
		// 								ResponseBasedDetectedErrorTypes: to.Ptr(armcdn.ResponseBasedDetectedErrorTypesTCPErrorsOnly),
		// 								ResponseBasedFailoverThresholdPercentage: to.Ptr[int32](10),
		// 							},
		// 						},
		// 				}},
		// 				Origins: []*armcdn.DeepCreatedOrigin{
		// 					{
		// 						Name: to.Ptr("www-bing-com"),
		// 						Properties: &armcdn.DeepCreatedOriginProperties{
		// 							Enabled: to.Ptr(true),
		// 							HostName: to.Ptr("www.bing.com"),
		// 							HTTPPort: to.Ptr[int32](80),
		// 							HTTPSPort: to.Ptr[int32](443),
		// 							OriginHostHeader: to.Ptr("www.someDomain2.net"),
		// 							Priority: to.Ptr[int32](2),
		// 							Weight: to.Ptr[int32](50),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr(armcdn.EndpointProvisioningStateSucceeded),
		// 				ResourceState: to.Ptr(armcdn.EndpointResourceStateRunning),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Endpoints_Get.json
func ExampleEndpointsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEndpointsClient().Get(ctx, "RG", "profile1", "endpoint1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Endpoint = armcdn.Endpoint{
	// 	Name: to.Ptr("endpoint1"),
	// 	Type: to.Ptr("Microsoft.Cdn/profiles/endpoints"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1"),
	// 	Location: to.Ptr("CentralUs"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armcdn.EndpointProperties{
	// 		ContentTypesToCompress: []*string{
	// 		},
	// 		DefaultOriginGroup: &armcdn.ResourceReference{
	// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/originGroups/originGroup1"),
	// 		},
	// 		GeoFilters: []*armcdn.GeoFilter{
	// 		},
	// 		IsCompressionEnabled: to.Ptr(false),
	// 		IsHTTPAllowed: to.Ptr(true),
	// 		IsHTTPSAllowed: to.Ptr(true),
	// 		OptimizationType: to.Ptr(armcdn.OptimizationTypeDynamicSiteAcceleration),
	// 		OriginHostHeader: to.Ptr("www.bing.com"),
	// 		ProbePath: to.Ptr("/image"),
	// 		QueryStringCachingBehavior: to.Ptr(armcdn.QueryStringCachingBehaviorNotSet),
	// 		CustomDomains: []*armcdn.DeepCreatedCustomDomain{
	// 			{
	// 				Name: to.Ptr("www-someDomain-net"),
	// 				Properties: &armcdn.DeepCreatedCustomDomainProperties{
	// 					HostName: to.Ptr("www.someDomain.Net"),
	// 				},
	// 		}},
	// 		HostName: to.Ptr("endpoint1.azureedge.net"),
	// 		OriginGroups: []*armcdn.DeepCreatedOriginGroup{
	// 			{
	// 				Name: to.Ptr("originGroup1"),
	// 				Properties: &armcdn.DeepCreatedOriginGroupProperties{
	// 					HealthProbeSettings: &armcdn.HealthProbeParameters{
	// 						ProbeIntervalInSeconds: to.Ptr[int32](120),
	// 						ProbePath: to.Ptr("/health.aspx"),
	// 						ProbeProtocol: to.Ptr(armcdn.ProbeProtocolHTTP),
	// 						ProbeRequestType: to.Ptr(armcdn.HealthProbeRequestTypeGET),
	// 					},
	// 					Origins: []*armcdn.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/www-bing-com"),
	// 					}},
	// 				},
	// 		}},
	// 		Origins: []*armcdn.DeepCreatedOrigin{
	// 			{
	// 				Name: to.Ptr("www-bing-com"),
	// 				Properties: &armcdn.DeepCreatedOriginProperties{
	// 					Enabled: to.Ptr(true),
	// 					HostName: to.Ptr("www.bing.com"),
	// 					HTTPPort: to.Ptr[int32](80),
	// 					HTTPSPort: to.Ptr[int32](443),
	// 					OriginHostHeader: to.Ptr("www.someDomain2.net"),
	// 					Priority: to.Ptr[int32](2),
	// 					Weight: to.Ptr[int32](50),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armcdn.EndpointProvisioningStateSucceeded),
	// 		ResourceState: to.Ptr(armcdn.EndpointResourceStateRunning),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Endpoints_Create.json
func ExampleEndpointsClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointsClient().BeginCreate(ctx, "RG", "profile1", "endpoint1", armcdn.Endpoint{
		Location: to.Ptr("WestUs"),
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
		},
		Properties: &armcdn.EndpointProperties{
			ContentTypesToCompress: []*string{
				to.Ptr("text/html"),
				to.Ptr("application/octet-stream")},
			DefaultOriginGroup: &armcdn.ResourceReference{
				ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/originGroups/originGroup1"),
			},
			DeliveryPolicy: &armcdn.EndpointPropertiesUpdateParametersDeliveryPolicy{
				Description: to.Ptr("Test description for a policy."),
				Rules: []*armcdn.DeliveryRule{
					{
						Name: to.Ptr("rule1"),
						Actions: []armcdn.DeliveryRuleActionAutoGeneratedClassification{
							&armcdn.DeliveryRuleCacheExpirationAction{
								Name: to.Ptr(armcdn.DeliveryRuleActionCacheExpiration),
								Parameters: &armcdn.CacheExpirationActionParameters{
									CacheBehavior: to.Ptr(armcdn.CacheBehaviorOverride),
									CacheDuration: to.Ptr("10:10:09"),
									CacheType:     to.Ptr(armcdn.CacheTypeAll),
									TypeName:      to.Ptr(armcdn.CacheExpirationActionParametersTypeNameDeliveryRuleCacheExpirationActionParameters),
								},
							},
							&armcdn.DeliveryRuleResponseHeaderAction{
								Name: to.Ptr(armcdn.DeliveryRuleActionModifyResponseHeader),
								Parameters: &armcdn.HeaderActionParameters{
									HeaderAction: to.Ptr(armcdn.HeaderActionOverwrite),
									HeaderName:   to.Ptr("Access-Control-Allow-Origin"),
									TypeName:     to.Ptr(armcdn.HeaderActionParametersTypeNameDeliveryRuleHeaderActionParameters),
									Value:        to.Ptr("*"),
								},
							},
							&armcdn.DeliveryRuleRequestHeaderAction{
								Name: to.Ptr(armcdn.DeliveryRuleActionModifyRequestHeader),
								Parameters: &armcdn.HeaderActionParameters{
									HeaderAction: to.Ptr(armcdn.HeaderActionOverwrite),
									HeaderName:   to.Ptr("Accept-Encoding"),
									TypeName:     to.Ptr(armcdn.HeaderActionParametersTypeNameDeliveryRuleHeaderActionParameters),
									Value:        to.Ptr("gzip"),
								},
							}},
						Conditions: []armcdn.DeliveryRuleConditionClassification{
							&armcdn.DeliveryRuleRemoteAddressCondition{
								Name: to.Ptr(armcdn.MatchVariableRemoteAddress),
								Parameters: &armcdn.RemoteAddressMatchConditionParameters{
									MatchValues: []*string{
										to.Ptr("192.168.1.0/24"),
										to.Ptr("10.0.0.0/24")},
									NegateCondition: to.Ptr(true),
									Operator:        to.Ptr(armcdn.RemoteAddressOperatorIPMatch),
									TypeName:        to.Ptr(armcdn.RemoteAddressMatchConditionParametersTypeNameDeliveryRuleRemoteAddressConditionParameters),
								},
							}},
						Order: to.Ptr[int32](1),
					}},
			},
			IsCompressionEnabled:       to.Ptr(true),
			IsHTTPAllowed:              to.Ptr(true),
			IsHTTPSAllowed:             to.Ptr(true),
			OriginHostHeader:           to.Ptr("www.bing.com"),
			OriginPath:                 to.Ptr("/photos"),
			QueryStringCachingBehavior: to.Ptr(armcdn.QueryStringCachingBehaviorBypassCaching),
			OriginGroups: []*armcdn.DeepCreatedOriginGroup{
				{
					Name: to.Ptr("originGroup1"),
					Properties: &armcdn.DeepCreatedOriginGroupProperties{
						HealthProbeSettings: &armcdn.HealthProbeParameters{
							ProbeIntervalInSeconds: to.Ptr[int32](120),
							ProbePath:              to.Ptr("/health.aspx"),
							ProbeProtocol:          to.Ptr(armcdn.ProbeProtocolHTTP),
							ProbeRequestType:       to.Ptr(armcdn.HealthProbeRequestTypeGET),
						},
						Origins: []*armcdn.ResourceReference{
							{
								ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin1"),
							},
							{
								ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin2"),
							}},
						ResponseBasedOriginErrorDetectionSettings: &armcdn.ResponseBasedOriginErrorDetectionParameters{
							ResponseBasedDetectedErrorTypes:          to.Ptr(armcdn.ResponseBasedDetectedErrorTypesTCPErrorsOnly),
							ResponseBasedFailoverThresholdPercentage: to.Ptr[int32](10),
						},
					},
				}},
			Origins: []*armcdn.DeepCreatedOrigin{
				{
					Name: to.Ptr("origin1"),
					Properties: &armcdn.DeepCreatedOriginProperties{
						Enabled:          to.Ptr(true),
						HostName:         to.Ptr("www.someDomain1.net"),
						HTTPPort:         to.Ptr[int32](80),
						HTTPSPort:        to.Ptr[int32](443),
						OriginHostHeader: to.Ptr("www.someDomain1.net"),
						Priority:         to.Ptr[int32](1),
						Weight:           to.Ptr[int32](50),
					},
				},
				{
					Name: to.Ptr("origin2"),
					Properties: &armcdn.DeepCreatedOriginProperties{
						Enabled:          to.Ptr(true),
						HostName:         to.Ptr("www.someDomain2.net"),
						HTTPPort:         to.Ptr[int32](80),
						HTTPSPort:        to.Ptr[int32](443),
						OriginHostHeader: to.Ptr("www.someDomain2.net"),
						Priority:         to.Ptr[int32](2),
						Weight:           to.Ptr[int32](50),
					},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Endpoint = armcdn.Endpoint{
	// 	Name: to.Ptr("endpoint4899"),
	// 	Type: to.Ptr("Microsoft.Cdn/profiles/endpoints"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1"),
	// 	Location: to.Ptr("WestUs"),
	// 	Tags: map[string]*string{
	// 		"kay1": to.Ptr("value1"),
	// 	},
	// 	Properties: &armcdn.EndpointProperties{
	// 		ContentTypesToCompress: []*string{
	// 			to.Ptr("text/html"),
	// 			to.Ptr("application/octet-stream")},
	// 			DefaultOriginGroup: &armcdn.ResourceReference{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/originGroups/originGroup1"),
	// 			},
	// 			DeliveryPolicy: &armcdn.EndpointPropertiesUpdateParametersDeliveryPolicy{
	// 				Description: to.Ptr("Test description for a policy."),
	// 				Rules: []*armcdn.DeliveryRule{
	// 					{
	// 						Name: to.Ptr("rule1"),
	// 						Actions: []armcdn.DeliveryRuleActionAutoGeneratedClassification{
	// 							&armcdn.DeliveryRuleCacheExpirationAction{
	// 								Name: to.Ptr(armcdn.DeliveryRuleActionCacheExpiration),
	// 								Parameters: &armcdn.CacheExpirationActionParameters{
	// 									CacheBehavior: to.Ptr(armcdn.CacheBehaviorOverride),
	// 									CacheDuration: to.Ptr("10:10:09"),
	// 									CacheType: to.Ptr(armcdn.CacheTypeAll),
	// 									TypeName: to.Ptr(armcdn.CacheExpirationActionParametersTypeNameDeliveryRuleCacheExpirationActionParameters),
	// 								},
	// 							},
	// 							&armcdn.DeliveryRuleResponseHeaderAction{
	// 								Name: to.Ptr(armcdn.DeliveryRuleActionModifyResponseHeader),
	// 								Parameters: &armcdn.HeaderActionParameters{
	// 									HeaderAction: to.Ptr(armcdn.HeaderActionOverwrite),
	// 									HeaderName: to.Ptr("Access-Control-Allow-Origin"),
	// 									TypeName: to.Ptr(armcdn.HeaderActionParametersTypeNameDeliveryRuleHeaderActionParameters),
	// 									Value: to.Ptr("*"),
	// 								},
	// 							},
	// 							&armcdn.DeliveryRuleRequestHeaderAction{
	// 								Name: to.Ptr(armcdn.DeliveryRuleActionModifyRequestHeader),
	// 								Parameters: &armcdn.HeaderActionParameters{
	// 									HeaderAction: to.Ptr(armcdn.HeaderActionOverwrite),
	// 									HeaderName: to.Ptr("Accept-Encoding"),
	// 									TypeName: to.Ptr(armcdn.HeaderActionParametersTypeNameDeliveryRuleHeaderActionParameters),
	// 									Value: to.Ptr("gzip"),
	// 								},
	// 						}},
	// 						Conditions: []armcdn.DeliveryRuleConditionClassification{
	// 							&armcdn.DeliveryRuleRemoteAddressCondition{
	// 								Name: to.Ptr(armcdn.MatchVariableRemoteAddress),
	// 								Parameters: &armcdn.RemoteAddressMatchConditionParameters{
	// 									MatchValues: []*string{
	// 										to.Ptr("192.168.1.0/24"),
	// 										to.Ptr("10.0.0.0/24")},
	// 										NegateCondition: to.Ptr(true),
	// 										Operator: to.Ptr(armcdn.RemoteAddressOperatorIPMatch),
	// 										Transforms: []*armcdn.Transform{
	// 										},
	// 										TypeName: to.Ptr(armcdn.RemoteAddressMatchConditionParametersTypeNameDeliveryRuleRemoteAddressConditionParameters),
	// 									},
	// 							}},
	// 							Order: to.Ptr[int32](1),
	// 					}},
	// 				},
	// 				GeoFilters: []*armcdn.GeoFilter{
	// 				},
	// 				IsCompressionEnabled: to.Ptr(true),
	// 				IsHTTPAllowed: to.Ptr(true),
	// 				IsHTTPSAllowed: to.Ptr(true),
	// 				OriginHostHeader: to.Ptr("www.bing.com"),
	// 				OriginPath: to.Ptr("/photos"),
	// 				QueryStringCachingBehavior: to.Ptr(armcdn.QueryStringCachingBehaviorBypassCaching),
	// 				HostName: to.Ptr("endpoint4899.azureedge-test.net"),
	// 				OriginGroups: []*armcdn.DeepCreatedOriginGroup{
	// 					{
	// 						Name: to.Ptr("originGroup1"),
	// 						Properties: &armcdn.DeepCreatedOriginGroupProperties{
	// 							HealthProbeSettings: &armcdn.HealthProbeParameters{
	// 								ProbeIntervalInSeconds: to.Ptr[int32](120),
	// 								ProbePath: to.Ptr("/health.aspx"),
	// 								ProbeProtocol: to.Ptr(armcdn.ProbeProtocolHTTP),
	// 								ProbeRequestType: to.Ptr(armcdn.HealthProbeRequestTypeGET),
	// 							},
	// 							Origins: []*armcdn.ResourceReference{
	// 								{
	// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin1"),
	// 								},
	// 								{
	// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/origin2"),
	// 							}},
	// 							ResponseBasedOriginErrorDetectionSettings: &armcdn.ResponseBasedOriginErrorDetectionParameters{
	// 								ResponseBasedDetectedErrorTypes: to.Ptr(armcdn.ResponseBasedDetectedErrorTypesTCPErrorsOnly),
	// 								ResponseBasedFailoverThresholdPercentage: to.Ptr[int32](10),
	// 							},
	// 						},
	// 				}},
	// 				Origins: []*armcdn.DeepCreatedOrigin{
	// 					{
	// 						Name: to.Ptr("origin1"),
	// 						Properties: &armcdn.DeepCreatedOriginProperties{
	// 							Enabled: to.Ptr(true),
	// 							HostName: to.Ptr("www.someDomain1.net"),
	// 							HTTPPort: to.Ptr[int32](80),
	// 							HTTPSPort: to.Ptr[int32](443),
	// 							OriginHostHeader: to.Ptr("www.someDomain1.net"),
	// 							Priority: to.Ptr[int32](1),
	// 							Weight: to.Ptr[int32](50),
	// 						},
	// 					},
	// 					{
	// 						Name: to.Ptr("origin2"),
	// 						Properties: &armcdn.DeepCreatedOriginProperties{
	// 							Enabled: to.Ptr(true),
	// 							HostName: to.Ptr("www.someDomain2.net"),
	// 							HTTPPort: to.Ptr[int32](80),
	// 							HTTPSPort: to.Ptr[int32](443),
	// 							OriginHostHeader: to.Ptr("www.someDomain2.net"),
	// 							Priority: to.Ptr[int32](2),
	// 							Weight: to.Ptr[int32](50),
	// 						},
	// 				}},
	// 				ProvisioningState: to.Ptr(armcdn.EndpointProvisioningStateSucceeded),
	// 				ResourceState: to.Ptr(armcdn.EndpointResourceStateCreating),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Endpoints_Update.json
func ExampleEndpointsClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointsClient().BeginUpdate(ctx, "RG", "profile1", "endpoint1", armcdn.EndpointUpdateParameters{
		Tags: map[string]*string{
			"additionalProperties": to.Ptr("Tag1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Endpoint = armcdn.Endpoint{
	// 	Name: to.Ptr("endpoint1"),
	// 	Type: to.Ptr("Microsoft.Cdn/profiles/endpoints"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1"),
	// 	Location: to.Ptr("WestCentralUs"),
	// 	Tags: map[string]*string{
	// 		"additionalProperties": to.Ptr("Tag1"),
	// 	},
	// 	Properties: &armcdn.EndpointProperties{
	// 		ContentTypesToCompress: []*string{
	// 		},
	// 		DefaultOriginGroup: &armcdn.ResourceReference{
	// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/originGroups/originGroup1"),
	// 		},
	// 		GeoFilters: []*armcdn.GeoFilter{
	// 		},
	// 		IsCompressionEnabled: to.Ptr(false),
	// 		IsHTTPAllowed: to.Ptr(true),
	// 		IsHTTPSAllowed: to.Ptr(true),
	// 		QueryStringCachingBehavior: to.Ptr(armcdn.QueryStringCachingBehaviorIgnoreQueryString),
	// 		HostName: to.Ptr("endpoint1.azureedge.net"),
	// 		OriginGroups: []*armcdn.DeepCreatedOriginGroup{
	// 			{
	// 				Name: to.Ptr("originGroup1"),
	// 				Properties: &armcdn.DeepCreatedOriginGroupProperties{
	// 					HealthProbeSettings: &armcdn.HealthProbeParameters{
	// 						ProbeIntervalInSeconds: to.Ptr[int32](120),
	// 						ProbePath: to.Ptr("/health.aspx"),
	// 						ProbeProtocol: to.Ptr(armcdn.ProbeProtocolHTTP),
	// 						ProbeRequestType: to.Ptr(armcdn.HealthProbeRequestTypeGET),
	// 					},
	// 					Origins: []*armcdn.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/origins/www-bing-com"),
	// 					}},
	// 				},
	// 		}},
	// 		Origins: []*armcdn.DeepCreatedOrigin{
	// 			{
	// 				Name: to.Ptr("www-bing-com"),
	// 				Properties: &armcdn.DeepCreatedOriginProperties{
	// 					Enabled: to.Ptr(true),
	// 					HostName: to.Ptr("www.bing.com"),
	// 					HTTPPort: to.Ptr[int32](80),
	// 					HTTPSPort: to.Ptr[int32](443),
	// 					OriginHostHeader: to.Ptr("www.someDomain2.net"),
	// 					Priority: to.Ptr[int32](2),
	// 					Weight: to.Ptr[int32](50),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armcdn.EndpointProvisioningStateSucceeded),
	// 		ResourceState: to.Ptr(armcdn.EndpointResourceStateCreating),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Endpoints_Delete.json
func ExampleEndpointsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointsClient().BeginDelete(ctx, "RG", "profile1", "endpoint1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Endpoints_Start.json
func ExampleEndpointsClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointsClient().BeginStart(ctx, "RG", "profile1", "endpoint1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Endpoint = armcdn.Endpoint{
	// 	Name: to.Ptr("endpoint4899"),
	// 	Type: to.Ptr("Microsoft.Cdn/profiles/endpoints"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1"),
	// 	Location: to.Ptr("WestUs"),
	// 	Tags: map[string]*string{
	// 		"kay1": to.Ptr("value1"),
	// 	},
	// 	Properties: &armcdn.EndpointProperties{
	// 		ContentTypesToCompress: []*string{
	// 		},
	// 		GeoFilters: []*armcdn.GeoFilter{
	// 		},
	// 		IsCompressionEnabled: to.Ptr(false),
	// 		IsHTTPAllowed: to.Ptr(true),
	// 		IsHTTPSAllowed: to.Ptr(true),
	// 		OptimizationType: to.Ptr(armcdn.OptimizationTypeDynamicSiteAcceleration),
	// 		OriginHostHeader: to.Ptr("www.bing.com"),
	// 		ProbePath: to.Ptr("/image"),
	// 		QueryStringCachingBehavior: to.Ptr(armcdn.QueryStringCachingBehaviorNotSet),
	// 		HostName: to.Ptr("endpoint1.azureedge.net"),
	// 		Origins: []*armcdn.DeepCreatedOrigin{
	// 			{
	// 				Name: to.Ptr("www-bing-com"),
	// 				Properties: &armcdn.DeepCreatedOriginProperties{
	// 					HostName: to.Ptr("www.bing.com"),
	// 					HTTPPort: to.Ptr[int32](80),
	// 					HTTPSPort: to.Ptr[int32](443),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armcdn.EndpointProvisioningStateSucceeded),
	// 		ResourceState: to.Ptr(armcdn.EndpointResourceStateStarting),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Endpoints_Stop.json
func ExampleEndpointsClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointsClient().BeginStop(ctx, "RG", "profile1", "endpoint1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Endpoint = armcdn.Endpoint{
	// 	Name: to.Ptr("endpoint4899"),
	// 	Type: to.Ptr("Microsoft.Cdn/profiles/endpoints"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1"),
	// 	Location: to.Ptr("WestUs"),
	// 	Tags: map[string]*string{
	// 		"kay1": to.Ptr("value1"),
	// 	},
	// 	Properties: &armcdn.EndpointProperties{
	// 		ContentTypesToCompress: []*string{
	// 		},
	// 		GeoFilters: []*armcdn.GeoFilter{
	// 		},
	// 		IsCompressionEnabled: to.Ptr(false),
	// 		IsHTTPAllowed: to.Ptr(true),
	// 		IsHTTPSAllowed: to.Ptr(true),
	// 		OptimizationType: to.Ptr(armcdn.OptimizationTypeDynamicSiteAcceleration),
	// 		OriginHostHeader: to.Ptr("www.bing.com"),
	// 		ProbePath: to.Ptr("/image"),
	// 		QueryStringCachingBehavior: to.Ptr(armcdn.QueryStringCachingBehaviorNotSet),
	// 		HostName: to.Ptr("endpoint1.azureedge.net"),
	// 		Origins: []*armcdn.DeepCreatedOrigin{
	// 			{
	// 				Name: to.Ptr("www-bing-com"),
	// 				Properties: &armcdn.DeepCreatedOriginProperties{
	// 					HostName: to.Ptr("www.bing.com"),
	// 					HTTPPort: to.Ptr[int32](80),
	// 					HTTPSPort: to.Ptr[int32](443),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armcdn.EndpointProvisioningStateSucceeded),
	// 		ResourceState: to.Ptr(armcdn.EndpointResourceStateStopping),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Endpoints_PurgeContent.json
func ExampleEndpointsClient_BeginPurgeContent() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointsClient().BeginPurgeContent(ctx, "RG", "profile1", "endpoint1", armcdn.PurgeParameters{
		ContentPaths: []*string{
			to.Ptr("/folder1")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Endpoints_LoadContent.json
func ExampleEndpointsClient_BeginLoadContent() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEndpointsClient().BeginLoadContent(ctx, "RG", "profile1", "endpoint1", armcdn.LoadParameters{
		ContentPaths: []*string{
			to.Ptr("/folder1")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Endpoints_ValidateCustomDomain.json
func ExampleEndpointsClient_ValidateCustomDomain() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEndpointsClient().ValidateCustomDomain(ctx, "RG", "profile1", "endpoint1", armcdn.ValidateCustomDomainInput{
		HostName: to.Ptr("www.someDomain.com"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ValidateCustomDomainOutput = armcdn.ValidateCustomDomainOutput{
	// 	CustomDomainValidated: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/cdn/resource-manager/Microsoft.Cdn/stable/2024-02-01/examples/Endpoints_ListResourceUsage.json
func ExampleEndpointsClient_NewListResourceUsagePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEndpointsClient().NewListResourceUsagePager("RG", "profile1", "endpoint1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ResourceUsageListResult = armcdn.ResourceUsageListResult{
		// 	Value: []*armcdn.ResourceUsage{
		// 		{
		// 			CurrentValue: to.Ptr[int32](1),
		// 			Limit: to.Ptr[int32](20),
		// 			ResourceType: to.Ptr("customdomain"),
		// 			Unit: to.Ptr(armcdn.ResourceUsageUnitCount),
		// 		},
		// 		{
		// 			CurrentValue: to.Ptr[int32](0),
		// 			Limit: to.Ptr[int32](25),
		// 			ResourceType: to.Ptr("geofilter"),
		// 			Unit: to.Ptr(armcdn.ResourceUsageUnitCount),
		// 	}},
		// }
	}
}
