//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbillingbenefits

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AppliedScopeProperties.
func (a AppliedScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "managementGroupId", a.ManagementGroupID)
	populate(objectMap, "resourceGroupId", a.ResourceGroupID)
	populate(objectMap, "subscriptionId", a.SubscriptionID)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppliedScopeProperties.
func (a *AppliedScopeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "managementGroupId":
			err = unpopulate(val, "ManagementGroupID", &a.ManagementGroupID)
			delete(rawMsg, key)
		case "resourceGroupId":
			err = unpopulate(val, "ResourceGroupID", &a.ResourceGroupID)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingPlanInformation.
func (b BillingPlanInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateType(objectMap, "nextPaymentDueDate", b.NextPaymentDueDate)
	populate(objectMap, "pricingCurrencyTotal", b.PricingCurrencyTotal)
	populateDateType(objectMap, "startDate", b.StartDate)
	populate(objectMap, "transactions", b.Transactions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingPlanInformation.
func (b *BillingPlanInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextPaymentDueDate":
			err = unpopulateDateType(val, "NextPaymentDueDate", &b.NextPaymentDueDate)
			delete(rawMsg, key)
		case "pricingCurrencyTotal":
			err = unpopulate(val, "PricingCurrencyTotal", &b.PricingCurrencyTotal)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateType(val, "StartDate", &b.StartDate)
			delete(rawMsg, key)
		case "transactions":
			err = unpopulate(val, "Transactions", &b.Transactions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Commitment.
func (c Commitment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", c.Amount)
	populate(objectMap, "currencyCode", c.CurrencyCode)
	populate(objectMap, "grain", c.Grain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Commitment.
func (c *Commitment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &c.Amount)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &c.CurrencyCode)
			delete(rawMsg, key)
		case "grain":
			err = unpopulate(val, "Grain", &c.Grain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedStatusInfo.
func (e ExtendedStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "statusCode", e.StatusCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedStatusInfo.
func (e *ExtendedStatusInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &e.StatusCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PaymentDetail.
func (p PaymentDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingAccount", p.BillingAccount)
	populate(objectMap, "billingCurrencyTotal", p.BillingCurrencyTotal)
	populateDateType(objectMap, "dueDate", p.DueDate)
	populate(objectMap, "extendedStatusInfo", p.ExtendedStatusInfo)
	populateDateType(objectMap, "paymentDate", p.PaymentDate)
	populate(objectMap, "pricingCurrencyTotal", p.PricingCurrencyTotal)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PaymentDetail.
func (p *PaymentDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingAccount":
			err = unpopulate(val, "BillingAccount", &p.BillingAccount)
			delete(rawMsg, key)
		case "billingCurrencyTotal":
			err = unpopulate(val, "BillingCurrencyTotal", &p.BillingCurrencyTotal)
			delete(rawMsg, key)
		case "dueDate":
			err = unpopulateDateType(val, "DueDate", &p.DueDate)
			delete(rawMsg, key)
		case "extendedStatusInfo":
			err = unpopulate(val, "ExtendedStatusInfo", &p.ExtendedStatusInfo)
			delete(rawMsg, key)
		case "paymentDate":
			err = unpopulateDateType(val, "PaymentDate", &p.PaymentDate)
			delete(rawMsg, key)
		case "pricingCurrencyTotal":
			err = unpopulate(val, "PricingCurrencyTotal", &p.PricingCurrencyTotal)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Price.
func (p Price) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", p.Amount)
	populate(objectMap, "currencyCode", p.CurrencyCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Price.
func (p *Price) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &p.Amount)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &p.CurrencyCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PurchaseRequest.
func (p PurchaseRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurchaseRequest.
func (p *PurchaseRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PurchaseRequestProperties.
func (p PurchaseRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopeProperties", p.AppliedScopeProperties)
	populate(objectMap, "appliedScopeType", p.AppliedScopeType)
	populate(objectMap, "billingPlan", p.BillingPlan)
	populate(objectMap, "billingScopeId", p.BillingScopeID)
	populate(objectMap, "commitment", p.Commitment)
	populate(objectMap, "displayName", p.DisplayName)
	populateDateTimeRFC3339(objectMap, "effectiveDateTime", p.EffectiveDateTime)
	populate(objectMap, "renew", p.Renew)
	populate(objectMap, "term", p.Term)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurchaseRequestProperties.
func (p *PurchaseRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopeProperties":
			err = unpopulate(val, "AppliedScopeProperties", &p.AppliedScopeProperties)
			delete(rawMsg, key)
		case "appliedScopeType":
			err = unpopulate(val, "AppliedScopeType", &p.AppliedScopeType)
			delete(rawMsg, key)
		case "billingPlan":
			err = unpopulate(val, "BillingPlan", &p.BillingPlan)
			delete(rawMsg, key)
		case "billingScopeId":
			err = unpopulate(val, "BillingScopeID", &p.BillingScopeID)
			delete(rawMsg, key)
		case "commitment":
			err = unpopulate(val, "Commitment", &p.Commitment)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "effectiveDateTime":
			err = unpopulateDateTimeRFC3339(val, "EffectiveDateTime", &p.EffectiveDateTime)
			delete(rawMsg, key)
		case "renew":
			err = unpopulate(val, "Renew", &p.Renew)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &p.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RenewProperties.
func (r RenewProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "purchaseProperties", r.PurchaseProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RenewProperties.
func (r *RenewProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "purchaseProperties":
			err = unpopulate(val, "PurchaseProperties", &r.PurchaseProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationOrderAliasRequest.
func (r ReservationOrderAliasRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationOrderAliasRequest.
func (r *ReservationOrderAliasRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationOrderAliasRequestProperties.
func (r ReservationOrderAliasRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopeProperties", r.AppliedScopeProperties)
	populate(objectMap, "appliedScopeType", r.AppliedScopeType)
	populate(objectMap, "billingPlan", r.BillingPlan)
	populate(objectMap, "billingScopeId", r.BillingScopeID)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "quantity", r.Quantity)
	populate(objectMap, "renew", r.Renew)
	populate(objectMap, "reservedResourceProperties", r.ReservedResourceProperties)
	populate(objectMap, "reservedResourceType", r.ReservedResourceType)
	populateDateTimeRFC3339(objectMap, "reviewDateTime", r.ReviewDateTime)
	populate(objectMap, "term", r.Term)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationOrderAliasRequestProperties.
func (r *ReservationOrderAliasRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopeProperties":
			err = unpopulate(val, "AppliedScopeProperties", &r.AppliedScopeProperties)
			delete(rawMsg, key)
		case "appliedScopeType":
			err = unpopulate(val, "AppliedScopeType", &r.AppliedScopeType)
			delete(rawMsg, key)
		case "billingPlan":
			err = unpopulate(val, "BillingPlan", &r.BillingPlan)
			delete(rawMsg, key)
		case "billingScopeId":
			err = unpopulate(val, "BillingScopeID", &r.BillingScopeID)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &r.Quantity)
			delete(rawMsg, key)
		case "renew":
			err = unpopulate(val, "Renew", &r.Renew)
			delete(rawMsg, key)
		case "reservedResourceProperties":
			err = unpopulate(val, "ReservedResourceProperties", &r.ReservedResourceProperties)
			delete(rawMsg, key)
		case "reservedResourceType":
			err = unpopulate(val, "ReservedResourceType", &r.ReservedResourceType)
			delete(rawMsg, key)
		case "reviewDateTime":
			err = unpopulateDateTimeRFC3339(val, "ReviewDateTime", &r.ReviewDateTime)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &r.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationOrderAliasRequestPropertiesReservedResourceProperties.
func (r ReservationOrderAliasRequestPropertiesReservedResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceFlexibility", r.InstanceFlexibility)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationOrderAliasRequestPropertiesReservedResourceProperties.
func (r *ReservationOrderAliasRequestPropertiesReservedResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceFlexibility":
			err = unpopulate(val, "InstanceFlexibility", &r.InstanceFlexibility)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationOrderAliasResponse.
func (r ReservationOrderAliasResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationOrderAliasResponse.
func (r *ReservationOrderAliasResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationOrderAliasResponseProperties.
func (r ReservationOrderAliasResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopeProperties", r.AppliedScopeProperties)
	populate(objectMap, "appliedScopeType", r.AppliedScopeType)
	populate(objectMap, "billingPlan", r.BillingPlan)
	populate(objectMap, "billingScopeId", r.BillingScopeID)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "quantity", r.Quantity)
	populate(objectMap, "renew", r.Renew)
	populate(objectMap, "reservationOrderId", r.ReservationOrderID)
	populate(objectMap, "reservedResourceProperties", r.ReservedResourceProperties)
	populate(objectMap, "reservedResourceType", r.ReservedResourceType)
	populateDateTimeRFC3339(objectMap, "reviewDateTime", r.ReviewDateTime)
	populate(objectMap, "term", r.Term)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationOrderAliasResponseProperties.
func (r *ReservationOrderAliasResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopeProperties":
			err = unpopulate(val, "AppliedScopeProperties", &r.AppliedScopeProperties)
			delete(rawMsg, key)
		case "appliedScopeType":
			err = unpopulate(val, "AppliedScopeType", &r.AppliedScopeType)
			delete(rawMsg, key)
		case "billingPlan":
			err = unpopulate(val, "BillingPlan", &r.BillingPlan)
			delete(rawMsg, key)
		case "billingScopeId":
			err = unpopulate(val, "BillingScopeID", &r.BillingScopeID)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &r.Quantity)
			delete(rawMsg, key)
		case "renew":
			err = unpopulate(val, "Renew", &r.Renew)
			delete(rawMsg, key)
		case "reservationOrderId":
			err = unpopulate(val, "ReservationOrderID", &r.ReservationOrderID)
			delete(rawMsg, key)
		case "reservedResourceProperties":
			err = unpopulate(val, "ReservedResourceProperties", &r.ReservedResourceProperties)
			delete(rawMsg, key)
		case "reservedResourceType":
			err = unpopulate(val, "ReservedResourceType", &r.ReservedResourceType)
			delete(rawMsg, key)
		case "reviewDateTime":
			err = unpopulateDateTimeRFC3339(val, "ReviewDateTime", &r.ReviewDateTime)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &r.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationOrderAliasResponsePropertiesReservedResourceProperties.
func (r ReservationOrderAliasResponsePropertiesReservedResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceFlexibility", r.InstanceFlexibility)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationOrderAliasResponsePropertiesReservedResourceProperties.
func (r *ReservationOrderAliasResponsePropertiesReservedResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceFlexibility":
			err = unpopulate(val, "InstanceFlexibility", &r.InstanceFlexibility)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentEntity.
func (r RoleAssignmentEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentEntity.
func (r *RoleAssignmentEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoleAssignmentEntityProperties.
func (r RoleAssignmentEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	populate(objectMap, "scope", r.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoleAssignmentEntityProperties.
func (r *RoleAssignmentEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanModel.
func (s SavingsPlanModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanModel.
func (s *SavingsPlanModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanModelList.
func (s SavingsPlanModelList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanModelList.
func (s *SavingsPlanModelList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanModelListResult.
func (s SavingsPlanModelListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalProperties", s.AdditionalProperties)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanModelListResult.
func (s *SavingsPlanModelListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalProperties":
			err = unpopulate(val, "AdditionalProperties", &s.AdditionalProperties)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanModelProperties.
func (s SavingsPlanModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopeProperties", s.AppliedScopeProperties)
	populate(objectMap, "appliedScopeType", s.AppliedScopeType)
	populateDateTimeRFC3339(objectMap, "benefitStartTime", s.BenefitStartTime)
	populate(objectMap, "billingAccountId", s.BillingAccountID)
	populate(objectMap, "billingPlan", s.BillingPlan)
	populate(objectMap, "billingProfileId", s.BillingProfileID)
	populate(objectMap, "billingScopeId", s.BillingScopeID)
	populate(objectMap, "commitment", s.Commitment)
	populate(objectMap, "customerId", s.CustomerID)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "displayProvisioningState", s.DisplayProvisioningState)
	populateDateTimeRFC3339(objectMap, "effectiveDateTime", s.EffectiveDateTime)
	populateDateTimeRFC3339(objectMap, "expiryDateTime", s.ExpiryDateTime)
	populate(objectMap, "extendedStatusInfo", s.ExtendedStatusInfo)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populateDateTimeRFC3339(objectMap, "purchaseDateTime", s.PurchaseDateTime)
	populate(objectMap, "renew", s.Renew)
	populate(objectMap, "renewDestination", s.RenewDestination)
	populate(objectMap, "renewProperties", s.RenewProperties)
	populate(objectMap, "renewSource", s.RenewSource)
	populate(objectMap, "term", s.Term)
	populate(objectMap, "userFriendlyAppliedScopeType", s.UserFriendlyAppliedScopeType)
	populate(objectMap, "utilization", s.Utilization)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanModelProperties.
func (s *SavingsPlanModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopeProperties":
			err = unpopulate(val, "AppliedScopeProperties", &s.AppliedScopeProperties)
			delete(rawMsg, key)
		case "appliedScopeType":
			err = unpopulate(val, "AppliedScopeType", &s.AppliedScopeType)
			delete(rawMsg, key)
		case "benefitStartTime":
			err = unpopulateDateTimeRFC3339(val, "BenefitStartTime", &s.BenefitStartTime)
			delete(rawMsg, key)
		case "billingAccountId":
			err = unpopulate(val, "BillingAccountID", &s.BillingAccountID)
			delete(rawMsg, key)
		case "billingPlan":
			err = unpopulate(val, "BillingPlan", &s.BillingPlan)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &s.BillingProfileID)
			delete(rawMsg, key)
		case "billingScopeId":
			err = unpopulate(val, "BillingScopeID", &s.BillingScopeID)
			delete(rawMsg, key)
		case "commitment":
			err = unpopulate(val, "Commitment", &s.Commitment)
			delete(rawMsg, key)
		case "customerId":
			err = unpopulate(val, "CustomerID", &s.CustomerID)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "displayProvisioningState":
			err = unpopulate(val, "DisplayProvisioningState", &s.DisplayProvisioningState)
			delete(rawMsg, key)
		case "effectiveDateTime":
			err = unpopulateDateTimeRFC3339(val, "EffectiveDateTime", &s.EffectiveDateTime)
			delete(rawMsg, key)
		case "expiryDateTime":
			err = unpopulateDateTimeRFC3339(val, "ExpiryDateTime", &s.ExpiryDateTime)
			delete(rawMsg, key)
		case "extendedStatusInfo":
			err = unpopulate(val, "ExtendedStatusInfo", &s.ExtendedStatusInfo)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "purchaseDateTime":
			err = unpopulateDateTimeRFC3339(val, "PurchaseDateTime", &s.PurchaseDateTime)
			delete(rawMsg, key)
		case "renew":
			err = unpopulate(val, "Renew", &s.Renew)
			delete(rawMsg, key)
		case "renewDestination":
			err = unpopulate(val, "RenewDestination", &s.RenewDestination)
			delete(rawMsg, key)
		case "renewProperties":
			err = unpopulate(val, "RenewProperties", &s.RenewProperties)
			delete(rawMsg, key)
		case "renewSource":
			err = unpopulate(val, "RenewSource", &s.RenewSource)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &s.Term)
			delete(rawMsg, key)
		case "userFriendlyAppliedScopeType":
			err = unpopulate(val, "UserFriendlyAppliedScopeType", &s.UserFriendlyAppliedScopeType)
			delete(rawMsg, key)
		case "utilization":
			err = unpopulate(val, "Utilization", &s.Utilization)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanOrderAliasModel.
func (s SavingsPlanOrderAliasModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanOrderAliasModel.
func (s *SavingsPlanOrderAliasModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanOrderAliasProperties.
func (s SavingsPlanOrderAliasProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopeProperties", s.AppliedScopeProperties)
	populate(objectMap, "appliedScopeType", s.AppliedScopeType)
	populate(objectMap, "billingPlan", s.BillingPlan)
	populate(objectMap, "billingScopeId", s.BillingScopeID)
	populate(objectMap, "commitment", s.Commitment)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "savingsPlanOrderId", s.SavingsPlanOrderID)
	populate(objectMap, "term", s.Term)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanOrderAliasProperties.
func (s *SavingsPlanOrderAliasProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopeProperties":
			err = unpopulate(val, "AppliedScopeProperties", &s.AppliedScopeProperties)
			delete(rawMsg, key)
		case "appliedScopeType":
			err = unpopulate(val, "AppliedScopeType", &s.AppliedScopeType)
			delete(rawMsg, key)
		case "billingPlan":
			err = unpopulate(val, "BillingPlan", &s.BillingPlan)
			delete(rawMsg, key)
		case "billingScopeId":
			err = unpopulate(val, "BillingScopeID", &s.BillingScopeID)
			delete(rawMsg, key)
		case "commitment":
			err = unpopulate(val, "Commitment", &s.Commitment)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "savingsPlanOrderId":
			err = unpopulate(val, "SavingsPlanOrderID", &s.SavingsPlanOrderID)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &s.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanOrderModel.
func (s SavingsPlanOrderModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanOrderModel.
func (s *SavingsPlanOrderModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanOrderModelList.
func (s SavingsPlanOrderModelList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanOrderModelList.
func (s *SavingsPlanOrderModelList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanOrderModelProperties.
func (s SavingsPlanOrderModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "benefitStartTime", s.BenefitStartTime)
	populate(objectMap, "billingAccountId", s.BillingAccountID)
	populate(objectMap, "billingPlan", s.BillingPlan)
	populate(objectMap, "billingProfileId", s.BillingProfileID)
	populate(objectMap, "billingScopeId", s.BillingScopeID)
	populate(objectMap, "customerId", s.CustomerID)
	populate(objectMap, "displayName", s.DisplayName)
	populateDateTimeRFC3339(objectMap, "expiryDateTime", s.ExpiryDateTime)
	populate(objectMap, "extendedStatusInfo", s.ExtendedStatusInfo)
	populate(objectMap, "planInformation", s.PlanInformation)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "savingsPlans", s.SavingsPlans)
	populate(objectMap, "term", s.Term)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanOrderModelProperties.
func (s *SavingsPlanOrderModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "benefitStartTime":
			err = unpopulateDateTimeRFC3339(val, "BenefitStartTime", &s.BenefitStartTime)
			delete(rawMsg, key)
		case "billingAccountId":
			err = unpopulate(val, "BillingAccountID", &s.BillingAccountID)
			delete(rawMsg, key)
		case "billingPlan":
			err = unpopulate(val, "BillingPlan", &s.BillingPlan)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &s.BillingProfileID)
			delete(rawMsg, key)
		case "billingScopeId":
			err = unpopulate(val, "BillingScopeID", &s.BillingScopeID)
			delete(rawMsg, key)
		case "customerId":
			err = unpopulate(val, "CustomerID", &s.CustomerID)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "expiryDateTime":
			err = unpopulateDateTimeRFC3339(val, "ExpiryDateTime", &s.ExpiryDateTime)
			delete(rawMsg, key)
		case "extendedStatusInfo":
			err = unpopulate(val, "ExtendedStatusInfo", &s.ExtendedStatusInfo)
			delete(rawMsg, key)
		case "planInformation":
			err = unpopulate(val, "PlanInformation", &s.PlanInformation)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "savingsPlans":
			err = unpopulate(val, "SavingsPlans", &s.SavingsPlans)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &s.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanPurchaseValidateRequest.
func (s SavingsPlanPurchaseValidateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "benefits", s.Benefits)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanPurchaseValidateRequest.
func (s *SavingsPlanPurchaseValidateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "benefits":
			err = unpopulate(val, "Benefits", &s.Benefits)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanSummary.
func (s SavingsPlanSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanSummary.
func (s *SavingsPlanSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanSummaryCount.
func (s SavingsPlanSummaryCount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cancelledCount", s.CancelledCount)
	populate(objectMap, "expiredCount", s.ExpiredCount)
	populate(objectMap, "expiringCount", s.ExpiringCount)
	populate(objectMap, "failedCount", s.FailedCount)
	populate(objectMap, "noBenefitCount", s.NoBenefitCount)
	populate(objectMap, "pendingCount", s.PendingCount)
	populate(objectMap, "processingCount", s.ProcessingCount)
	populate(objectMap, "succeededCount", s.SucceededCount)
	populate(objectMap, "warningCount", s.WarningCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanSummaryCount.
func (s *SavingsPlanSummaryCount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cancelledCount":
			err = unpopulate(val, "CancelledCount", &s.CancelledCount)
			delete(rawMsg, key)
		case "expiredCount":
			err = unpopulate(val, "ExpiredCount", &s.ExpiredCount)
			delete(rawMsg, key)
		case "expiringCount":
			err = unpopulate(val, "ExpiringCount", &s.ExpiringCount)
			delete(rawMsg, key)
		case "failedCount":
			err = unpopulate(val, "FailedCount", &s.FailedCount)
			delete(rawMsg, key)
		case "noBenefitCount":
			err = unpopulate(val, "NoBenefitCount", &s.NoBenefitCount)
			delete(rawMsg, key)
		case "pendingCount":
			err = unpopulate(val, "PendingCount", &s.PendingCount)
			delete(rawMsg, key)
		case "processingCount":
			err = unpopulate(val, "ProcessingCount", &s.ProcessingCount)
			delete(rawMsg, key)
		case "succeededCount":
			err = unpopulate(val, "SucceededCount", &s.SucceededCount)
			delete(rawMsg, key)
		case "warningCount":
			err = unpopulate(val, "WarningCount", &s.WarningCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanUpdateRequest.
func (s SavingsPlanUpdateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanUpdateRequest.
func (s *SavingsPlanUpdateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanUpdateRequestProperties.
func (s SavingsPlanUpdateRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopeProperties", s.AppliedScopeProperties)
	populate(objectMap, "appliedScopeType", s.AppliedScopeType)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "renew", s.Renew)
	populate(objectMap, "renewProperties", s.RenewProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanUpdateRequestProperties.
func (s *SavingsPlanUpdateRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopeProperties":
			err = unpopulate(val, "AppliedScopeProperties", &s.AppliedScopeProperties)
			delete(rawMsg, key)
		case "appliedScopeType":
			err = unpopulate(val, "AppliedScopeType", &s.AppliedScopeType)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "renew":
			err = unpopulate(val, "Renew", &s.Renew)
			delete(rawMsg, key)
		case "renewProperties":
			err = unpopulate(val, "RenewProperties", &s.RenewProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanUpdateValidateRequest.
func (s SavingsPlanUpdateValidateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "benefits", s.Benefits)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanUpdateValidateRequest.
func (s *SavingsPlanUpdateValidateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "benefits":
			err = unpopulate(val, "Benefits", &s.Benefits)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanValidResponseProperty.
func (s SavingsPlanValidResponseProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reason", s.Reason)
	populate(objectMap, "reasonCode", s.ReasonCode)
	populate(objectMap, "valid", s.Valid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanValidResponseProperty.
func (s *SavingsPlanValidResponseProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reason":
			err = unpopulate(val, "Reason", &s.Reason)
			delete(rawMsg, key)
		case "reasonCode":
			err = unpopulate(val, "ReasonCode", &s.ReasonCode)
			delete(rawMsg, key)
		case "valid":
			err = unpopulate(val, "Valid", &s.Valid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanValidateResponse.
func (s SavingsPlanValidateResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "benefits", s.Benefits)
	populate(objectMap, "nextLink", s.NextLink)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanValidateResponse.
func (s *SavingsPlanValidateResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "benefits":
			err = unpopulate(val, "Benefits", &s.Benefits)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Utilization.
func (u Utilization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregates", u.Aggregates)
	populate(objectMap, "trend", u.Trend)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Utilization.
func (u *Utilization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregates":
			err = unpopulate(val, "Aggregates", &u.Aggregates)
			delete(rawMsg, key)
		case "trend":
			err = unpopulate(val, "Trend", &u.Trend)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UtilizationAggregates.
func (u UtilizationAggregates) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "grain", u.Grain)
	populate(objectMap, "grainUnit", u.GrainUnit)
	populate(objectMap, "value", u.Value)
	populate(objectMap, "valueUnit", u.ValueUnit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UtilizationAggregates.
func (u *UtilizationAggregates) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "grain":
			err = unpopulate(val, "Grain", &u.Grain)
			delete(rawMsg, key)
		case "grainUnit":
			err = unpopulate(val, "GrainUnit", &u.GrainUnit)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		case "valueUnit":
			err = unpopulate(val, "ValueUnit", &u.ValueUnit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
