//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
	"net/http"
	"net/url"
	"regexp"
)

// PermissionsServer is a fake server for instances of the armbilling.PermissionsClient type.
type PermissionsServer struct {
	// NewListByBillingAccountPager is the fake for method PermissionsClient.NewListByBillingAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingAccountPager func(billingAccountName string, options *armbilling.PermissionsClientListByBillingAccountOptions) (resp azfake.PagerResponder[armbilling.PermissionsClientListByBillingAccountResponse])

	// NewListByBillingProfilePager is the fake for method PermissionsClient.NewListByBillingProfilePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingProfilePager func(billingAccountName string, billingProfileName string, options *armbilling.PermissionsClientListByBillingProfileOptions) (resp azfake.PagerResponder[armbilling.PermissionsClientListByBillingProfileResponse])

	// NewListByCustomerPager is the fake for method PermissionsClient.NewListByCustomerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByCustomerPager func(billingAccountName string, customerName string, options *armbilling.PermissionsClientListByCustomerOptions) (resp azfake.PagerResponder[armbilling.PermissionsClientListByCustomerResponse])

	// NewListByInvoiceSectionsPager is the fake for method PermissionsClient.NewListByInvoiceSectionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByInvoiceSectionsPager func(billingAccountName string, billingProfileName string, invoiceSectionName string, options *armbilling.PermissionsClientListByInvoiceSectionsOptions) (resp azfake.PagerResponder[armbilling.PermissionsClientListByInvoiceSectionsResponse])
}

// NewPermissionsServerTransport creates a new instance of PermissionsServerTransport with the provided implementation.
// The returned PermissionsServerTransport instance is connected to an instance of armbilling.PermissionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPermissionsServerTransport(srv *PermissionsServer) *PermissionsServerTransport {
	return &PermissionsServerTransport{
		srv:                           srv,
		newListByBillingAccountPager:  newTracker[azfake.PagerResponder[armbilling.PermissionsClientListByBillingAccountResponse]](),
		newListByBillingProfilePager:  newTracker[azfake.PagerResponder[armbilling.PermissionsClientListByBillingProfileResponse]](),
		newListByCustomerPager:        newTracker[azfake.PagerResponder[armbilling.PermissionsClientListByCustomerResponse]](),
		newListByInvoiceSectionsPager: newTracker[azfake.PagerResponder[armbilling.PermissionsClientListByInvoiceSectionsResponse]](),
	}
}

// PermissionsServerTransport connects instances of armbilling.PermissionsClient to instances of PermissionsServer.
// Don't use this type directly, use NewPermissionsServerTransport instead.
type PermissionsServerTransport struct {
	srv                           *PermissionsServer
	newListByBillingAccountPager  *tracker[azfake.PagerResponder[armbilling.PermissionsClientListByBillingAccountResponse]]
	newListByBillingProfilePager  *tracker[azfake.PagerResponder[armbilling.PermissionsClientListByBillingProfileResponse]]
	newListByCustomerPager        *tracker[azfake.PagerResponder[armbilling.PermissionsClientListByCustomerResponse]]
	newListByInvoiceSectionsPager *tracker[azfake.PagerResponder[armbilling.PermissionsClientListByInvoiceSectionsResponse]]
}

// Do implements the policy.Transporter interface for PermissionsServerTransport.
func (p *PermissionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PermissionsClient.NewListByBillingAccountPager":
		resp, err = p.dispatchNewListByBillingAccountPager(req)
	case "PermissionsClient.NewListByBillingProfilePager":
		resp, err = p.dispatchNewListByBillingProfilePager(req)
	case "PermissionsClient.NewListByCustomerPager":
		resp, err = p.dispatchNewListByCustomerPager(req)
	case "PermissionsClient.NewListByInvoiceSectionsPager":
		resp, err = p.dispatchNewListByInvoiceSectionsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PermissionsServerTransport) dispatchNewListByBillingAccountPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByBillingAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingAccountPager not implemented")}
	}
	newListByBillingAccountPager := p.newListByBillingAccountPager.get(req)
	if newListByBillingAccountPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingPermissions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByBillingAccountPager(billingAccountNameParam, nil)
		newListByBillingAccountPager = &resp
		p.newListByBillingAccountPager.add(req, newListByBillingAccountPager)
		server.PagerResponderInjectNextLinks(newListByBillingAccountPager, req, func(page *armbilling.PermissionsClientListByBillingAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByBillingAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingAccountPager) {
		p.newListByBillingAccountPager.remove(req)
	}
	return resp, nil
}

func (p *PermissionsServerTransport) dispatchNewListByBillingProfilePager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByBillingProfilePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingProfilePager not implemented")}
	}
	newListByBillingProfilePager := p.newListByBillingProfilePager.get(req)
	if newListByBillingProfilePager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingPermissions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByBillingProfilePager(billingAccountNameParam, billingProfileNameParam, nil)
		newListByBillingProfilePager = &resp
		p.newListByBillingProfilePager.add(req, newListByBillingProfilePager)
		server.PagerResponderInjectNextLinks(newListByBillingProfilePager, req, func(page *armbilling.PermissionsClientListByBillingProfileResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingProfilePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByBillingProfilePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingProfilePager) {
		p.newListByBillingProfilePager.remove(req)
	}
	return resp, nil
}

func (p *PermissionsServerTransport) dispatchNewListByCustomerPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByCustomerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByCustomerPager not implemented")}
	}
	newListByCustomerPager := p.newListByCustomerPager.get(req)
	if newListByCustomerPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customers/(?P<customerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingPermissions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		customerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customerName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByCustomerPager(billingAccountNameParam, customerNameParam, nil)
		newListByCustomerPager = &resp
		p.newListByCustomerPager.add(req, newListByCustomerPager)
		server.PagerResponderInjectNextLinks(newListByCustomerPager, req, func(page *armbilling.PermissionsClientListByCustomerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByCustomerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByCustomerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByCustomerPager) {
		p.newListByCustomerPager.remove(req)
	}
	return resp, nil
}

func (p *PermissionsServerTransport) dispatchNewListByInvoiceSectionsPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByInvoiceSectionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByInvoiceSectionsPager not implemented")}
	}
	newListByInvoiceSectionsPager := p.newListByInvoiceSectionsPager.get(req)
	if newListByInvoiceSectionsPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingPermissions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByInvoiceSectionsPager(billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, nil)
		newListByInvoiceSectionsPager = &resp
		p.newListByInvoiceSectionsPager.add(req, newListByInvoiceSectionsPager)
		server.PagerResponderInjectNextLinks(newListByInvoiceSectionsPager, req, func(page *armbilling.PermissionsClientListByInvoiceSectionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByInvoiceSectionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByInvoiceSectionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByInvoiceSectionsPager) {
		p.newListByInvoiceSectionsPager.remove(req)
	}
	return resp, nil
}
