//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/avs/armavs"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// LocationsServer is a fake server for instances of the armavs.LocationsClient type.
type LocationsServer struct {
	// CheckQuotaAvailability is the fake for method LocationsClient.CheckQuotaAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckQuotaAvailability func(ctx context.Context, location string, options *armavs.LocationsClientCheckQuotaAvailabilityOptions) (resp azfake.Responder[armavs.LocationsClientCheckQuotaAvailabilityResponse], errResp azfake.ErrorResponder)

	// CheckTrialAvailability is the fake for method LocationsClient.CheckTrialAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckTrialAvailability func(ctx context.Context, location string, options *armavs.LocationsClientCheckTrialAvailabilityOptions) (resp azfake.Responder[armavs.LocationsClientCheckTrialAvailabilityResponse], errResp azfake.ErrorResponder)
}

// NewLocationsServerTransport creates a new instance of LocationsServerTransport with the provided implementation.
// The returned LocationsServerTransport instance is connected to an instance of armavs.LocationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLocationsServerTransport(srv *LocationsServer) *LocationsServerTransport {
	return &LocationsServerTransport{srv: srv}
}

// LocationsServerTransport connects instances of armavs.LocationsClient to instances of LocationsServer.
// Don't use this type directly, use NewLocationsServerTransport instead.
type LocationsServerTransport struct {
	srv *LocationsServer
}

// Do implements the policy.Transporter interface for LocationsServerTransport.
func (l *LocationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LocationsClient.CheckQuotaAvailability":
		resp, err = l.dispatchCheckQuotaAvailability(req)
	case "LocationsClient.CheckTrialAvailability":
		resp, err = l.dispatchCheckTrialAvailability(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LocationsServerTransport) dispatchCheckQuotaAvailability(req *http.Request) (*http.Response, error) {
	if l.srv.CheckQuotaAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckQuotaAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkQuotaAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.CheckQuotaAvailability(req.Context(), locationParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Quota, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LocationsServerTransport) dispatchCheckTrialAvailability(req *http.Request) (*http.Response, error) {
	if l.srv.CheckTrialAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckTrialAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AVS/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkTrialAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armavs.SKU](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	var options *armavs.LocationsClientCheckTrialAvailabilityOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armavs.LocationsClientCheckTrialAvailabilityOptions{
			SKU: &body,
		}
	}
	respr, errRespr := l.srv.CheckTrialAvailability(req.Context(), locationParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Trial, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
