//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomation_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/createOrUpdateSchedule.json
func ExampleScheduleClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScheduleClient().CreateOrUpdate(ctx, "rg", "myAutomationAccount33", "mySchedule", armautomation.ScheduleCreateOrUpdateParameters{
		Name: to.Ptr("mySchedule"),
		Properties: &armautomation.ScheduleCreateOrUpdateProperties{
			Description:      to.Ptr("my description of schedule goes here"),
			AdvancedSchedule: &armautomation.AdvancedSchedule{},
			ExpiryTime:       to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:57.249Z"); return t }()),
			Frequency:        to.Ptr(armautomation.ScheduleFrequencyHour),
			Interval:         float64(1),
			StartTime:        to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:28:57.249Z"); return t }()),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Schedule = armautomation.Schedule{
	// 	Name: to.Ptr("mySchedule"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule"),
	// 	Properties: &armautomation.ScheduleProperties{
	// 		Description: to.Ptr("my description of schedule goes here"),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T16:59:22.697Z"); return t}()),
	// 		ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
	// 		ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
	// 		Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
	// 		Interval: float64(1),
	// 		IsEnabled: to.Ptr(true),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T16:59:22.697Z"); return t}()),
	// 		NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:28:00.000Z"); return t}()),
	// 		NextRunOffsetMinutes: to.Ptr[float64](0),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:28:00.000Z"); return t}()),
	// 		StartTimeOffsetMinutes: to.Ptr[float64](0),
	// 		TimeZone: to.Ptr("UTC"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/updateSchedule.json
func ExampleScheduleClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScheduleClient().Update(ctx, "rg", "myAutomationAccount33", "mySchedule", armautomation.ScheduleUpdateParameters{
		Name: to.Ptr("mySchedule"),
		Properties: &armautomation.ScheduleUpdateProperties{
			Description: to.Ptr("my updated description of schedule goes here"),
			IsEnabled:   to.Ptr(false),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Schedule = armautomation.Schedule{
	// 	Name: to.Ptr("mySchedule"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule"),
	// 	Properties: &armautomation.ScheduleProperties{
	// 		Description: to.Ptr("my updated description of schedule goes here"),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T16:59:22.697Z"); return t}()),
	// 		ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
	// 		ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
	// 		Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
	// 		Interval: float64(1),
	// 		IsEnabled: to.Ptr(false),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T16:59:22.697Z"); return t}()),
	// 		NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:28:00.000Z"); return t}()),
	// 		NextRunOffsetMinutes: to.Ptr[float64](0),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:28:00.000Z"); return t}()),
	// 		StartTimeOffsetMinutes: to.Ptr[float64](0),
	// 		TimeZone: to.Ptr("UTC"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getSchedule.json
func ExampleScheduleClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScheduleClient().Get(ctx, "rg", "myAutomationAccount33", "mySchedule", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Schedule = armautomation.Schedule{
	// 	Name: to.Ptr("mySchedule"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule"),
	// 	Properties: &armautomation.ScheduleProperties{
	// 		Description: to.Ptr("my description of schedule goes here"),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T16:59:22.697Z"); return t}()),
	// 		ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
	// 		ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
	// 		Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
	// 		Interval: float64(1),
	// 		IsEnabled: to.Ptr(true),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T16:59:22.697Z"); return t}()),
	// 		NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:28:00.000Z"); return t}()),
	// 		NextRunOffsetMinutes: to.Ptr[float64](0),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:28:00.000Z"); return t}()),
	// 		StartTimeOffsetMinutes: to.Ptr[float64](0),
	// 		TimeZone: to.Ptr("UTC"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/deleteSchedule.json
func ExampleScheduleClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewScheduleClient().Delete(ctx, "rg", "myAutomationAccount33", "mySchedule", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listSchedulesByAutomationAccount_First100.json
func ExampleScheduleClient_NewListByAutomationAccountPager_listSchedulesByAutomationAccountFirst100() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewScheduleClient().NewListByAutomationAccountPager("rg", "myAutomationAccount33", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ScheduleListResult = armautomation.ScheduleListResult{
		// 	Value: []*armautomation.Schedule{
		// 		{
		// 			Name: to.Ptr("mySchedule"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my updated description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T16:59:22.697Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(false),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:14.027Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:28:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:28:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule0"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule0"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:17.180Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:17.180Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule1"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule1"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:17.493Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:17.493Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule10"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule10"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:20.540Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:20.540Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule100"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule100"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:50.103Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:50.103Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule101"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule101"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:50.433Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:50.433Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule102"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule102"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:50.713Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:50.713Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule103"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule103"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:51.040Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:51.040Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule104"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule104"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:51.323Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:51.323Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule105"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule105"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:51.620Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:51.620Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule106"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule106"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:51.900Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:51.900Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule107"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule107"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:52.183Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:52.183Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule108"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule108"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:52.480Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:52.480Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule109"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule109"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:52.760Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:52.760Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule11"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule11"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:20.883Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:20.883Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule110"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule110"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:53.073Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:53.073Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule111"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule111"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:53.480Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:53.480Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule112"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule112"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:53.807Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:53.807Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule113"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule113"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:54.073Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:54.073Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule114"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule114"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:54.353Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:54.353Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule115"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule115"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:54.650Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:54.650Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule116"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule116"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:54.933Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:54.933Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule117"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule117"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:55.277Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:55.277Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule118"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule118"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:55.650Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:55.650Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule119"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule119"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:55.950Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:55.950Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule12"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule12"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:21.213Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:21.213Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule120"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule120"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:56.353Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:56.353Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule121"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule121"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:56.650Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:56.650Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule122"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule122"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:56.950Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:56.950Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule123"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule123"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:57.247Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:57.247Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule124"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule124"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:57.573Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:57.573Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule125"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule125"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:57.900Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:57.900Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule126"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule126"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:58.387Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:58.387Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule127"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule127"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:58.700Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:58.700Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule128"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule128"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:59.400Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:59.400Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule129"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule129"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:59.730Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:59.730Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule13"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule13"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:21.603Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:21.603Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule130"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule130"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:00.090Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:00.090Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule131"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule131"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:00.400Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:00.400Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule132"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule132"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:00.683Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:00.683Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule133"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule133"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:01.073Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:01.073Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule134"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule134"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:01.387Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:01.387Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule135"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule135"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:01.667Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:01.667Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule136"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule136"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:01.950Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:01.950Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule137"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule137"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:02.247Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:02.247Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule138"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule138"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:02.557Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:02.557Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule139"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule139"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:02.853Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:02.853Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule14"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule14"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:21.980Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:21.980Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule140"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule140"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:03.247Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:03.247Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule141"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule141"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:03.573Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:03.573Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule142"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule142"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:03.870Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:03.870Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule143"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule143"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:04.200Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:04.200Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule144"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule144"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:04.480Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:04.480Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule145"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule145"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:04.760Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:04.760Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule146"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule146"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:05.027Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:05.027Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule147"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule147"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:05.353Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:05.353Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule148"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule148"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:05.650Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:05.650Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule149"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule149"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:05.950Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:05.950Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule15"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule15"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:22.353Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:22.353Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule150"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule150"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:06.247Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:06.247Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule151"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule151"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:06.527Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:06.527Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule152"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule152"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:06.810Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:06.810Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule153"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule153"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:07.157Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:07.157Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule154"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule154"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:07.453Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:07.453Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule155"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule155"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:07.750Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:07.750Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule156"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule156"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:08.093Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:08.093Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule157"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule157"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:08.513Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:08.513Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule158"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule158"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:08.873Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:08.873Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule159"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule159"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:09.203Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:09.203Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule16"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule16"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:22.697Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:22.697Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule160"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule160"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:09.547Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:09.547Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule161"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule161"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:09.843Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:09.843Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule162"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule162"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:10.140Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:10.140Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule163"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule163"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:10.437Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:10.437Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule164"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule164"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:10.720Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:10.720Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule165"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule165"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:11.013Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:11.013Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule166"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule166"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:11.297Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:11.297Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule167"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule167"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:11.610Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:11.610Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule168"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule168"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:11.890Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:11.890Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule169"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule169"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:12.203Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:12.203Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule17"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule17"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:23.027Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:23.027Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule170"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule170"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:12.453Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:12.453Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule171"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule171"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:12.733Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:12.733Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule172"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule172"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:13.030Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:13.030Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule173"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule173"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:13.310Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:13.310Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule174"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule174"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:13.623Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:13.623Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule175"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule175"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:13.937Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:01:13.937Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule18"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule18"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:23.337Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:23.337Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule19"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule19"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:23.667Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:23.667Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule2"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule2"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:17.823Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:17.823Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule20"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule20"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:24.010Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:24.010Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule21"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule21"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:24.337Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:24.337Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule22"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule22"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:24.667Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:24.667Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule23"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule23"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:24.980Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:24.980Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule24"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule24"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:25.353Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:25.353Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule25"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule25"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:25.680Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:25.680Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule26"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule26"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:26.010Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:26.010Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule27"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule27"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:26.323Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:26.323Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule28"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule28"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:26.650Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:26.650Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule29"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule29"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:26.947Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:26.947Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listSchedulesByAutomationAccount_Next100.json
func ExampleScheduleClient_NewListByAutomationAccountPager_listSchedulesByAutomationAccountNext100() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewScheduleClient().NewListByAutomationAccountPager("rg", "myAutomationAccount33", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ScheduleListResult = armautomation.ScheduleListResult{
		// 	Value: []*armautomation.Schedule{
		// 		{
		// 			Name: to.Ptr("mySchedule3"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule3"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:18.120Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:18.120Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule30"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule30"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:27.277Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:27.277Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule31"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule31"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:27.603Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:27.603Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule32"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule32"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:28.040Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:28.040Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule33"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule33"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:28.353Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:28.353Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule34"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule34"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:28.667Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:28.667Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule35"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule35"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:29.010Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:29.010Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule36"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule36"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:29.353Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:29.353Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule37"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule37"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:29.680Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:29.680Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule38"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule38"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:29.993Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:29.993Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule39"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule39"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:30.307Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:30.307Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule4"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule4"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:18.417Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:18.417Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule40"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule40"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:30.620Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:30.620Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule41"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule41"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:30.930Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:30.930Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule42"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule42"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:31.260Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:31.260Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule43"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule43"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:31.573Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:31.573Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule44"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule44"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:31.947Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:31.947Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule45"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule45"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:32.290Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:32.290Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule46"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule46"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:32.603Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:32.603Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule47"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule47"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:32.930Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:32.930Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule48"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule48"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:33.510Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:33.510Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule49"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule49"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:33.823Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:33.823Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule5"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule5"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:18.743Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:18.743Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule50"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule50"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:34.150Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:34.150Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule51"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule51"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:34.447Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:34.447Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule52"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule52"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:34.743Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:34.743Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule53"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule53"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:35.057Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:35.057Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule54"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule54"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:35.370Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:35.370Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule55"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule55"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:35.683Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:35.683Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule56"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule56"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:35.980Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:35.980Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule57"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule57"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:36.277Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:36.277Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule58"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule58"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:36.603Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:36.603Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule59"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule59"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:36.947Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:36.947Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule6"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule6"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:19.103Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:19.103Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule60"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule60"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:37.260Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:37.260Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule61"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule61"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:37.557Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:37.557Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule62"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule62"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:37.963Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:37.963Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule63"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule63"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:38.290Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:38.290Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule64"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule64"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:38.603Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:38.603Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule65"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule65"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:38.917Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:38.917Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule66"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule66"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:39.307Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:39.307Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule67"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule67"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:39.590Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:39.590Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule68"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule68"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:39.947Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:39.947Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule69"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule69"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:40.307Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:40.307Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule7"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule7"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:19.510Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:19.510Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule70"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule70"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:40.667Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:40.667Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule71"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule71"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:41.010Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:41.010Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule72"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule72"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:41.323Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:41.323Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule73"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule73"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:41.637Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:41.637Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule74"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule74"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:41.933Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:41.933Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule75"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule75"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:42.260Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:42.260Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule76"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule76"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:42.573Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:42.573Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule77"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule77"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:42.900Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:42.900Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule78"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule78"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:43.213Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:43.213Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule79"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule79"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:43.573Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:43.573Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule8"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule8"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:19.837Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:19.837Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule80"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule80"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:43.870Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:43.870Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule81"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule81"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:44.197Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:44.197Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule82"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule82"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:44.493Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:44.493Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule83"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule83"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:44.807Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:44.807Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule84"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule84"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:45.183Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:45.183Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule85"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule85"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:45.493Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:45.493Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule86"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule86"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:45.790Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:45.790Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule87"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule87"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:46.090Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:46.090Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule88"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule88"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:46.370Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:46.370Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule89"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule89"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:46.887Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:46.887Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule9"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule9"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:20.150Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:20.150Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule90"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule90"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:47.183Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:47.183Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule91"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule91"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:47.493Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:47.493Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule92"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule92"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:47.760Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:47.760Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule93"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule93"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:48.073Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:48.073Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule94"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule94"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:48.353Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:48.353Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule95"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule95"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:48.683Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:48.683Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule96"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule96"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:48.963Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:48.963Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule97"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule97"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:49.243Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:49.243Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule98"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule98"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:49.510Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:49.510Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySchedule99"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount33/schedules/mySchedule99"),
		// 			Properties: &armautomation.ScheduleProperties{
		// 				Description: to.Ptr("my description of schedule goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:49.790Z"); return t}()),
		// 				ExpiryTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T17:28:00.000Z"); return t}()),
		// 				ExpiryTimeOffsetMinutes: to.Ptr[float64](0),
		// 				Frequency: to.Ptr(armautomation.ScheduleFrequencyHour),
		// 				Interval: float64(1),
		// 				IsEnabled: to.Ptr(true),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T17:00:49.790Z"); return t}()),
		// 				NextRun: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				NextRunOffsetMinutes: to.Ptr[float64](0),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T18:59:00.000Z"); return t}()),
		// 				StartTimeOffsetMinutes: to.Ptr[float64](0),
		// 				TimeZone: to.Ptr("UTC"),
		// 			},
		// 	}},
		// }
	}
}
