//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// HybridRunbookWorkerGroupServer is a fake server for instances of the armautomation.HybridRunbookWorkerGroupClient type.
type HybridRunbookWorkerGroupServer struct {
	// Create is the fake for method HybridRunbookWorkerGroupClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, resourceGroupName string, automationAccountName string, hybridRunbookWorkerGroupName string, hybridRunbookWorkerGroupCreationParameters armautomation.HybridRunbookWorkerGroupCreateOrUpdateParameters, options *armautomation.HybridRunbookWorkerGroupClientCreateOptions) (resp azfake.Responder[armautomation.HybridRunbookWorkerGroupClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method HybridRunbookWorkerGroupClient.Delete
	// HTTP status codes to indicate success: http.StatusOK
	Delete func(ctx context.Context, resourceGroupName string, automationAccountName string, hybridRunbookWorkerGroupName string, options *armautomation.HybridRunbookWorkerGroupClientDeleteOptions) (resp azfake.Responder[armautomation.HybridRunbookWorkerGroupClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method HybridRunbookWorkerGroupClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, automationAccountName string, hybridRunbookWorkerGroupName string, options *armautomation.HybridRunbookWorkerGroupClientGetOptions) (resp azfake.Responder[armautomation.HybridRunbookWorkerGroupClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByAutomationAccountPager is the fake for method HybridRunbookWorkerGroupClient.NewListByAutomationAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAutomationAccountPager func(resourceGroupName string, automationAccountName string, options *armautomation.HybridRunbookWorkerGroupClientListByAutomationAccountOptions) (resp azfake.PagerResponder[armautomation.HybridRunbookWorkerGroupClientListByAutomationAccountResponse])

	// Update is the fake for method HybridRunbookWorkerGroupClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, automationAccountName string, hybridRunbookWorkerGroupName string, hybridRunbookWorkerGroupUpdationParameters armautomation.HybridRunbookWorkerGroupCreateOrUpdateParameters, options *armautomation.HybridRunbookWorkerGroupClientUpdateOptions) (resp azfake.Responder[armautomation.HybridRunbookWorkerGroupClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewHybridRunbookWorkerGroupServerTransport creates a new instance of HybridRunbookWorkerGroupServerTransport with the provided implementation.
// The returned HybridRunbookWorkerGroupServerTransport instance is connected to an instance of armautomation.HybridRunbookWorkerGroupClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewHybridRunbookWorkerGroupServerTransport(srv *HybridRunbookWorkerGroupServer) *HybridRunbookWorkerGroupServerTransport {
	return &HybridRunbookWorkerGroupServerTransport{
		srv:                             srv,
		newListByAutomationAccountPager: newTracker[azfake.PagerResponder[armautomation.HybridRunbookWorkerGroupClientListByAutomationAccountResponse]](),
	}
}

// HybridRunbookWorkerGroupServerTransport connects instances of armautomation.HybridRunbookWorkerGroupClient to instances of HybridRunbookWorkerGroupServer.
// Don't use this type directly, use NewHybridRunbookWorkerGroupServerTransport instead.
type HybridRunbookWorkerGroupServerTransport struct {
	srv                             *HybridRunbookWorkerGroupServer
	newListByAutomationAccountPager *tracker[azfake.PagerResponder[armautomation.HybridRunbookWorkerGroupClientListByAutomationAccountResponse]]
}

// Do implements the policy.Transporter interface for HybridRunbookWorkerGroupServerTransport.
func (h *HybridRunbookWorkerGroupServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "HybridRunbookWorkerGroupClient.Create":
		resp, err = h.dispatchCreate(req)
	case "HybridRunbookWorkerGroupClient.Delete":
		resp, err = h.dispatchDelete(req)
	case "HybridRunbookWorkerGroupClient.Get":
		resp, err = h.dispatchGet(req)
	case "HybridRunbookWorkerGroupClient.NewListByAutomationAccountPager":
		resp, err = h.dispatchNewListByAutomationAccountPager(req)
	case "HybridRunbookWorkerGroupClient.Update":
		resp, err = h.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (h *HybridRunbookWorkerGroupServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if h.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkerGroups/(?P<hybridRunbookWorkerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armautomation.HybridRunbookWorkerGroupCreateOrUpdateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Create(req.Context(), resourceGroupNameParam, automationAccountNameParam, hybridRunbookWorkerGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridRunbookWorkerGroup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HybridRunbookWorkerGroupServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if h.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkerGroups/(?P<hybridRunbookWorkerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Delete(req.Context(), resourceGroupNameParam, automationAccountNameParam, hybridRunbookWorkerGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HybridRunbookWorkerGroupServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if h.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkerGroups/(?P<hybridRunbookWorkerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Get(req.Context(), resourceGroupNameParam, automationAccountNameParam, hybridRunbookWorkerGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridRunbookWorkerGroup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (h *HybridRunbookWorkerGroupServerTransport) dispatchNewListByAutomationAccountPager(req *http.Request) (*http.Response, error) {
	if h.srv.NewListByAutomationAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAutomationAccountPager not implemented")}
	}
	newListByAutomationAccountPager := h.newListByAutomationAccountPager.get(req)
	if newListByAutomationAccountPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkerGroups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armautomation.HybridRunbookWorkerGroupClientListByAutomationAccountOptions
		if filterParam != nil {
			options = &armautomation.HybridRunbookWorkerGroupClientListByAutomationAccountOptions{
				Filter: filterParam,
			}
		}
		resp := h.srv.NewListByAutomationAccountPager(resourceGroupNameParam, automationAccountNameParam, options)
		newListByAutomationAccountPager = &resp
		h.newListByAutomationAccountPager.add(req, newListByAutomationAccountPager)
		server.PagerResponderInjectNextLinks(newListByAutomationAccountPager, req, func(page *armautomation.HybridRunbookWorkerGroupClientListByAutomationAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByAutomationAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		h.newListByAutomationAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAutomationAccountPager) {
		h.newListByAutomationAccountPager.remove(req)
	}
	return resp, nil
}

func (h *HybridRunbookWorkerGroupServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if h.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hybridRunbookWorkerGroups/(?P<hybridRunbookWorkerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armautomation.HybridRunbookWorkerGroupCreateOrUpdateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	hybridRunbookWorkerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hybridRunbookWorkerGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := h.srv.Update(req.Context(), resourceGroupNameParam, automationAccountNameParam, hybridRunbookWorkerGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HybridRunbookWorkerGroup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
