//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomation_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/deleteCredentialExisting.json
func ExampleCredentialClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewCredentialClient().Delete(ctx, "rg", "myAutomationAccount20", "myCredential", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getCredential.json
func ExampleCredentialClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCredentialClient().Get(ctx, "rg", "myAutomationAccount18", "myCredential", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Credential = armautomation.Credential{
	// 	Name: to.Ptr("myCredential"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount18/credentials/myCredential"),
	// 	Properties: &armautomation.CredentialProperties{
	// 		Description: to.Ptr("my description goes here"),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:04:10.270Z"); return t}()),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:04:16.423Z"); return t}()),
	// 		UserName: to.Ptr("mylingaiah"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/createOrUpdateCredential.json
func ExampleCredentialClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCredentialClient().CreateOrUpdate(ctx, "rg", "myAutomationAccount18", "myCredential", armautomation.CredentialCreateOrUpdateParameters{
		Name: to.Ptr("myCredential"),
		Properties: &armautomation.CredentialCreateOrUpdateProperties{
			Description: to.Ptr("my description goes here"),
			Password:    to.Ptr("<password>"),
			UserName:    to.Ptr("mylingaiah"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Credential = armautomation.Credential{
	// 	Name: to.Ptr("myCredential"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount18/credentials/myCredential"),
	// 	Properties: &armautomation.CredentialProperties{
	// 		Description: to.Ptr("my description goes here"),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:04:10.270Z"); return t}()),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:04:13.567Z"); return t}()),
	// 		UserName: to.Ptr("mylingaiah"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/updateCredential_patch.json
func ExampleCredentialClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCredentialClient().Update(ctx, "rg", "myAutomationAccount18", "myCredential", armautomation.CredentialUpdateParameters{
		Name: to.Ptr("myCredential"),
		Properties: &armautomation.CredentialUpdateProperties{
			Description: to.Ptr("my description goes here"),
			Password:    to.Ptr("<password>"),
			UserName:    to.Ptr("mylingaiah"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Credential = armautomation.Credential{
	// 	Name: to.Ptr("myCredential"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount18/credentials/myCredential"),
	// 	Properties: &armautomation.CredentialProperties{
	// 		Description: to.Ptr("my description goes here"),
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:04:10.270Z"); return t}()),
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:04:13.567Z"); return t}()),
	// 		UserName: to.Ptr("mylingaiah"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listCredentialsByAutomationAccount.json
func ExampleCredentialClient_NewListByAutomationAccountPager_listCredentialsByAutomationAccountFirst100() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCredentialClient().NewListByAutomationAccountPager("rg", "myAutomationAccount20", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CredentialListResult = armautomation.CredentialListResult{
		// 	Value: []*armautomation.Credential{
		// 		{
		// 			Name: to.Ptr("myCredential"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:38.910Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:45.393Z"); return t}()),
		// 				UserName: to.Ptr("mylingaiah"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential0"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential0"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:51.770Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:51.770Z"); return t}()),
		// 				UserName: to.Ptr("myCredential0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential1"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential1"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:52.113Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:52.113Z"); return t}()),
		// 				UserName: to.Ptr("myCredential1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential10"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential10"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:55.300Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:55.300Z"); return t}()),
		// 				UserName: to.Ptr("myCredential10"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential100"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential100"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:25.410Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:25.410Z"); return t}()),
		// 				UserName: to.Ptr("myCredential100"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential101"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential101"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:25.690Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:25.690Z"); return t}()),
		// 				UserName: to.Ptr("myCredential101"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential102"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential102"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:26.003Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:26.003Z"); return t}()),
		// 				UserName: to.Ptr("myCredential102"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential103"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential103"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:26.337Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:26.337Z"); return t}()),
		// 				UserName: to.Ptr("myCredential103"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential104"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential104"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:26.677Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:26.677Z"); return t}()),
		// 				UserName: to.Ptr("myCredential104"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential105"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential105"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:27.020Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:27.020Z"); return t}()),
		// 				UserName: to.Ptr("myCredential105"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential106"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential106"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:27.350Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:27.350Z"); return t}()),
		// 				UserName: to.Ptr("myCredential106"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential107"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential107"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:27.660Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:27.660Z"); return t}()),
		// 				UserName: to.Ptr("myCredential107"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential108"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential108"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:27.990Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:27.990Z"); return t}()),
		// 				UserName: to.Ptr("myCredential108"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential109"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential109"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:28.300Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:28.300Z"); return t}()),
		// 				UserName: to.Ptr("myCredential109"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential11"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential11"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:55.677Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:55.677Z"); return t}()),
		// 				UserName: to.Ptr("myCredential11"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential110"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential110"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:28.630Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:28.630Z"); return t}()),
		// 				UserName: to.Ptr("myCredential110"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential111"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential111"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:28.943Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:28.943Z"); return t}()),
		// 				UserName: to.Ptr("myCredential111"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential112"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential112"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:29.253Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:29.253Z"); return t}()),
		// 				UserName: to.Ptr("myCredential112"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential113"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential113"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:29.567Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:29.567Z"); return t}()),
		// 				UserName: to.Ptr("myCredential113"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential114"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential114"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:29.880Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:29.880Z"); return t}()),
		// 				UserName: to.Ptr("myCredential114"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential115"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential115"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:30.207Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:30.207Z"); return t}()),
		// 				UserName: to.Ptr("myCredential115"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential116"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential116"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:30.520Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:30.520Z"); return t}()),
		// 				UserName: to.Ptr("myCredential116"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential117"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential117"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:30.833Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:30.833Z"); return t}()),
		// 				UserName: to.Ptr("myCredential117"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential118"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential118"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:31.240Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:31.240Z"); return t}()),
		// 				UserName: to.Ptr("myCredential118"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential119"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential119"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:31.600Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:31.600Z"); return t}()),
		// 				UserName: to.Ptr("myCredential119"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential12"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential12"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:56.020Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:56.020Z"); return t}()),
		// 				UserName: to.Ptr("myCredential12"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential120"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential120"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:31.943Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:31.943Z"); return t}()),
		// 				UserName: to.Ptr("myCredential120"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential121"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential121"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:32.333Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:32.333Z"); return t}()),
		// 				UserName: to.Ptr("myCredential121"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential122"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential122"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:32.660Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:32.660Z"); return t}()),
		// 				UserName: to.Ptr("myCredential122"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential123"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential123"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:32.957Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:32.957Z"); return t}()),
		// 				UserName: to.Ptr("myCredential123"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential124"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential124"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:33.270Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:33.270Z"); return t}()),
		// 				UserName: to.Ptr("myCredential124"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential125"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential125"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:33.600Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:33.600Z"); return t}()),
		// 				UserName: to.Ptr("myCredential125"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential126"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential126"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:33.957Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:33.957Z"); return t}()),
		// 				UserName: to.Ptr("myCredential126"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential127"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential127"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:34.287Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:34.287Z"); return t}()),
		// 				UserName: to.Ptr("myCredential127"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential128"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential128"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:34.613Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:34.613Z"); return t}()),
		// 				UserName: to.Ptr("myCredential128"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential129"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential129"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:34.973Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:34.973Z"); return t}()),
		// 				UserName: to.Ptr("myCredential129"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential13"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential13"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:56.393Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:56.393Z"); return t}()),
		// 				UserName: to.Ptr("myCredential13"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential130"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential130"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:35.363Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:35.363Z"); return t}()),
		// 				UserName: to.Ptr("myCredential130"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential131"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential131"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:35.707Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:35.707Z"); return t}()),
		// 				UserName: to.Ptr("myCredential131"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential132"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential132"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:36.037Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:36.037Z"); return t}()),
		// 				UserName: to.Ptr("myCredential132"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential133"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential133"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:36.380Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:36.380Z"); return t}()),
		// 				UserName: to.Ptr("myCredential133"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential134"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential134"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:36.740Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:36.740Z"); return t}()),
		// 				UserName: to.Ptr("myCredential134"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential135"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential135"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:37.050Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:37.050Z"); return t}()),
		// 				UserName: to.Ptr("myCredential135"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential136"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential136"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:37.410Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:37.410Z"); return t}()),
		// 				UserName: to.Ptr("myCredential136"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential137"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential137"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:37.723Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:37.723Z"); return t}()),
		// 				UserName: to.Ptr("myCredential137"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential138"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential138"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:38.037Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:38.037Z"); return t}()),
		// 				UserName: to.Ptr("myCredential138"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential139"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential139"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:38.350Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:38.350Z"); return t}()),
		// 				UserName: to.Ptr("myCredential139"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential14"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential14"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:56.723Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:56.723Z"); return t}()),
		// 				UserName: to.Ptr("myCredential14"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential140"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential140"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:38.710Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:38.710Z"); return t}()),
		// 				UserName: to.Ptr("myCredential140"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential141"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential141"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:39.037Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:39.037Z"); return t}()),
		// 				UserName: to.Ptr("myCredential141"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential142"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential142"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:39.350Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:39.350Z"); return t}()),
		// 				UserName: to.Ptr("myCredential142"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential143"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential143"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:39.677Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:39.677Z"); return t}()),
		// 				UserName: to.Ptr("myCredential143"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential144"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential144"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:39.990Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:39.990Z"); return t}()),
		// 				UserName: to.Ptr("myCredential144"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential145"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential145"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:40.317Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:40.317Z"); return t}()),
		// 				UserName: to.Ptr("myCredential145"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential146"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential146"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:40.630Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:40.630Z"); return t}()),
		// 				UserName: to.Ptr("myCredential146"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential147"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential147"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:40.943Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:40.943Z"); return t}()),
		// 				UserName: to.Ptr("myCredential147"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential148"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential148"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:41.270Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:41.270Z"); return t}()),
		// 				UserName: to.Ptr("myCredential148"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential149"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential149"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:41.600Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:41.600Z"); return t}()),
		// 				UserName: to.Ptr("myCredential149"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential15"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential15"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:57.033Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:57.033Z"); return t}()),
		// 				UserName: to.Ptr("myCredential15"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential150"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential150"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:41.910Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:41.910Z"); return t}()),
		// 				UserName: to.Ptr("myCredential150"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential151"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential151"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:42.240Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:42.240Z"); return t}()),
		// 				UserName: to.Ptr("myCredential151"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential152"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential152"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:42.567Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:42.567Z"); return t}()),
		// 				UserName: to.Ptr("myCredential152"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential153"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential153"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:42.880Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:42.880Z"); return t}()),
		// 				UserName: to.Ptr("myCredential153"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential154"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential154"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:43.193Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:43.193Z"); return t}()),
		// 				UserName: to.Ptr("myCredential154"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential155"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential155"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:43.520Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:43.520Z"); return t}()),
		// 				UserName: to.Ptr("myCredential155"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential156"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential156"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:43.833Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:43.833Z"); return t}()),
		// 				UserName: to.Ptr("myCredential156"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential157"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential157"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:44.147Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:44.147Z"); return t}()),
		// 				UserName: to.Ptr("myCredential157"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential158"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential158"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:44.473Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:44.473Z"); return t}()),
		// 				UserName: to.Ptr("myCredential158"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential159"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential159"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:44.787Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:44.787Z"); return t}()),
		// 				UserName: to.Ptr("myCredential159"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential16"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential16"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:57.363Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:57.363Z"); return t}()),
		// 				UserName: to.Ptr("myCredential16"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential160"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential160"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:45.100Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:45.100Z"); return t}()),
		// 				UserName: to.Ptr("myCredential160"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential161"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential161"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:45.427Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:45.427Z"); return t}()),
		// 				UserName: to.Ptr("myCredential161"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential162"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential162"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:45.740Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:45.740Z"); return t}()),
		// 				UserName: to.Ptr("myCredential162"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential163"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential163"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:46.067Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:46.067Z"); return t}()),
		// 				UserName: to.Ptr("myCredential163"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential164"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential164"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:46.380Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:46.380Z"); return t}()),
		// 				UserName: to.Ptr("myCredential164"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential165"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential165"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:46.710Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:46.710Z"); return t}()),
		// 				UserName: to.Ptr("myCredential165"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential166"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential166"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:47.037Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:47.037Z"); return t}()),
		// 				UserName: to.Ptr("myCredential166"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential167"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential167"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:47.350Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:47.350Z"); return t}()),
		// 				UserName: to.Ptr("myCredential167"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential168"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential168"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:47.677Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:47.677Z"); return t}()),
		// 				UserName: to.Ptr("myCredential168"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential169"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential169"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:47.990Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:47.990Z"); return t}()),
		// 				UserName: to.Ptr("myCredential169"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential17"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential17"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:57.677Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:57.677Z"); return t}()),
		// 				UserName: to.Ptr("myCredential17"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential170"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential170"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:48.287Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:48.287Z"); return t}()),
		// 				UserName: to.Ptr("myCredential170"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential171"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential171"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:48.613Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:48.613Z"); return t}()),
		// 				UserName: to.Ptr("myCredential171"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential172"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential172"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:48.927Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:48.927Z"); return t}()),
		// 				UserName: to.Ptr("myCredential172"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential173"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential173"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:49.257Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:49.257Z"); return t}()),
		// 				UserName: to.Ptr("myCredential173"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential174"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential174"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:49.567Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:49.567Z"); return t}()),
		// 				UserName: to.Ptr("myCredential174"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential175"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential175"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:49.880Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:49.880Z"); return t}()),
		// 				UserName: to.Ptr("myCredential175"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential176"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential176"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:50.210Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:50.210Z"); return t}()),
		// 				UserName: to.Ptr("myCredential176"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential177"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential177"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:50.537Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:50.537Z"); return t}()),
		// 				UserName: to.Ptr("myCredential177"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential178"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential178"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:50.863Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:50.863Z"); return t}()),
		// 				UserName: to.Ptr("myCredential178"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential179"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential179"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:51.193Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:51.193Z"); return t}()),
		// 				UserName: to.Ptr("myCredential179"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential18"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential18"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:58.003Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:58.003Z"); return t}()),
		// 				UserName: to.Ptr("myCredential18"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential180"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential180"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:51.600Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:51.600Z"); return t}()),
		// 				UserName: to.Ptr("myCredential180"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential181"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential181"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:51.910Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:51.910Z"); return t}()),
		// 				UserName: to.Ptr("myCredential181"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential182"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential182"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:52.223Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:52.223Z"); return t}()),
		// 				UserName: to.Ptr("myCredential182"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential183"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential183"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:52.600Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:52.600Z"); return t}()),
		// 				UserName: to.Ptr("myCredential183"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential184"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential184"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:52.927Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:52.927Z"); return t}()),
		// 				UserName: to.Ptr("myCredential184"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential185"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential185"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:53.270Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:53.270Z"); return t}()),
		// 				UserName: to.Ptr("myCredential185"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential186"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential186"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:53.583Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:53.583Z"); return t}()),
		// 				UserName: to.Ptr("myCredential186"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential187"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential187"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:54.037Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:54.037Z"); return t}()),
		// 				UserName: to.Ptr("myCredential187"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listCredentialsByAutomationAccount_next100_using_nextLink.json
func ExampleCredentialClient_NewListByAutomationAccountPager_listCredentialsByAutomationAccountNext100() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCredentialClient().NewListByAutomationAccountPager("rg", "myAutomationAccount20", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CredentialListResult = armautomation.CredentialListResult{
		// 	Value: []*armautomation.Credential{
		// 		{
		// 			Name: to.Ptr("myCredential188"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential188"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:54.397Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:54.397Z"); return t}()),
		// 				UserName: to.Ptr("myCredential188"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential189"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential189"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:54.710Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:54.710Z"); return t}()),
		// 				UserName: to.Ptr("myCredential189"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential19"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential19"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:58.330Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:58.330Z"); return t}()),
		// 				UserName: to.Ptr("myCredential19"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential190"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential190"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:55.037Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:55.037Z"); return t}()),
		// 				UserName: to.Ptr("myCredential190"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential191"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential191"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:55.350Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:55.350Z"); return t}()),
		// 				UserName: to.Ptr("myCredential191"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential192"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential192"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:55.677Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:55.677Z"); return t}()),
		// 				UserName: to.Ptr("myCredential192"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential193"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential193"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:56.007Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:56.007Z"); return t}()),
		// 				UserName: to.Ptr("myCredential193"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential194"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential194"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:56.333Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:56.333Z"); return t}()),
		// 				UserName: to.Ptr("myCredential194"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential195"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential195"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:56.660Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:56.660Z"); return t}()),
		// 				UserName: to.Ptr("myCredential195"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential196"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential196"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:57.007Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:57.007Z"); return t}()),
		// 				UserName: to.Ptr("myCredential196"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential197"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential197"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:57.333Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:57.333Z"); return t}()),
		// 				UserName: to.Ptr("myCredential197"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential198"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential198"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:57.660Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:57.660Z"); return t}()),
		// 				UserName: to.Ptr("myCredential198"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential199"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential199"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:57.973Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:57.973Z"); return t}()),
		// 				UserName: to.Ptr("myCredential199"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential2"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential2"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:52.440Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:52.440Z"); return t}()),
		// 				UserName: to.Ptr("myCredential2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential20"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential20"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:58.660Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:58.660Z"); return t}()),
		// 				UserName: to.Ptr("myCredential20"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential200"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential200"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:58.303Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:58.303Z"); return t}()),
		// 				UserName: to.Ptr("myCredential200"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential21"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential21"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:59.033Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:59.033Z"); return t}()),
		// 				UserName: to.Ptr("myCredential21"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential22"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential22"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:59.363Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:59.363Z"); return t}()),
		// 				UserName: to.Ptr("myCredential22"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential23"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential23"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:59.707Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:59.707Z"); return t}()),
		// 				UserName: to.Ptr("myCredential23"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential24"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential24"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:00.020Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:00.020Z"); return t}()),
		// 				UserName: to.Ptr("myCredential24"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential25"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential25"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:00.330Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:00.330Z"); return t}()),
		// 				UserName: to.Ptr("myCredential25"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential26"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential26"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:00.707Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:00.707Z"); return t}()),
		// 				UserName: to.Ptr("myCredential26"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential27"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential27"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:01.020Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:01.020Z"); return t}()),
		// 				UserName: to.Ptr("myCredential27"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential28"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential28"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:01.347Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:01.347Z"); return t}()),
		// 				UserName: to.Ptr("myCredential28"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential29"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential29"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:01.847Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:01.847Z"); return t}()),
		// 				UserName: to.Ptr("myCredential29"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential3"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential3"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:52.863Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:52.863Z"); return t}()),
		// 				UserName: to.Ptr("myCredential3"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential30"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential30"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:02.160Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:02.160Z"); return t}()),
		// 				UserName: to.Ptr("myCredential30"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential31"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential31"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:02.503Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:02.503Z"); return t}()),
		// 				UserName: to.Ptr("myCredential31"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential32"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential32"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:02.880Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:02.880Z"); return t}()),
		// 				UserName: to.Ptr("myCredential32"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential33"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential33"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:03.177Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:03.177Z"); return t}()),
		// 				UserName: to.Ptr("myCredential33"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential34"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential34"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:03.550Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:03.550Z"); return t}()),
		// 				UserName: to.Ptr("myCredential34"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential35"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential35"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:03.893Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:03.893Z"); return t}()),
		// 				UserName: to.Ptr("myCredential35"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential36"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential36"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:04.207Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:04.207Z"); return t}()),
		// 				UserName: to.Ptr("myCredential36"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential37"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential37"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:04.550Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:04.550Z"); return t}()),
		// 				UserName: to.Ptr("myCredential37"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential38"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential38"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:04.847Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:04.847Z"); return t}()),
		// 				UserName: to.Ptr("myCredential38"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential39"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential39"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:05.177Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:05.177Z"); return t}()),
		// 				UserName: to.Ptr("myCredential39"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential4"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential4"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:53.253Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:53.253Z"); return t}()),
		// 				UserName: to.Ptr("myCredential4"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential40"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential40"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:05.490Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:05.490Z"); return t}()),
		// 				UserName: to.Ptr("myCredential40"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential41"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential41"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:05.830Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:05.830Z"); return t}()),
		// 				UserName: to.Ptr("myCredential41"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential42"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential42"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:06.143Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:06.143Z"); return t}()),
		// 				UserName: to.Ptr("myCredential42"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential43"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential43"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:06.457Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:06.457Z"); return t}()),
		// 				UserName: to.Ptr("myCredential43"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential44"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential44"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:06.940Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:06.940Z"); return t}()),
		// 				UserName: to.Ptr("myCredential44"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential45"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential45"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:07.300Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:07.300Z"); return t}()),
		// 				UserName: to.Ptr("myCredential45"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential46"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential46"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:07.630Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:07.630Z"); return t}()),
		// 				UserName: to.Ptr("myCredential46"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential47"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential47"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:07.957Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:07.957Z"); return t}()),
		// 				UserName: to.Ptr("myCredential47"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential48"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential48"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:08.270Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:08.270Z"); return t}()),
		// 				UserName: to.Ptr("myCredential48"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential49"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential49"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:08.580Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:08.580Z"); return t}()),
		// 				UserName: to.Ptr("myCredential49"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential5"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential5"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:53.567Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:53.567Z"); return t}()),
		// 				UserName: to.Ptr("myCredential5"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential50"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential50"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:09.020Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:09.020Z"); return t}()),
		// 				UserName: to.Ptr("myCredential50"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential51"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential51"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:09.330Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:09.330Z"); return t}()),
		// 				UserName: to.Ptr("myCredential51"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential52"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential52"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:09.643Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:09.643Z"); return t}()),
		// 				UserName: to.Ptr("myCredential52"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential53"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential53"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:09.973Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:09.973Z"); return t}()),
		// 				UserName: to.Ptr("myCredential53"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential54"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential54"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:10.287Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:10.287Z"); return t}()),
		// 				UserName: to.Ptr("myCredential54"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential55"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential55"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:10.660Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:10.660Z"); return t}()),
		// 				UserName: to.Ptr("myCredential55"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential56"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential56"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:10.973Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:10.973Z"); return t}()),
		// 				UserName: to.Ptr("myCredential56"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential57"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential57"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:11.330Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:11.330Z"); return t}()),
		// 				UserName: to.Ptr("myCredential57"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential58"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential58"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:11.643Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:11.643Z"); return t}()),
		// 				UserName: to.Ptr("myCredential58"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential59"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential59"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:11.990Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:11.990Z"); return t}()),
		// 				UserName: to.Ptr("myCredential59"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential6"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential6"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:53.863Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:53.863Z"); return t}()),
		// 				UserName: to.Ptr("myCredential6"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential60"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential60"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:12.300Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:12.300Z"); return t}()),
		// 				UserName: to.Ptr("myCredential60"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential61"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential61"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:12.630Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:12.630Z"); return t}()),
		// 				UserName: to.Ptr("myCredential61"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential62"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential62"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:12.957Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:12.957Z"); return t}()),
		// 				UserName: to.Ptr("myCredential62"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential63"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential63"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:13.270Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:13.270Z"); return t}()),
		// 				UserName: to.Ptr("myCredential63"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential64"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential64"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:13.583Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:13.583Z"); return t}()),
		// 				UserName: to.Ptr("myCredential64"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential65"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential65"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:13.893Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:13.893Z"); return t}()),
		// 				UserName: to.Ptr("myCredential65"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential66"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential66"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:14.207Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:14.207Z"); return t}()),
		// 				UserName: to.Ptr("myCredential66"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential67"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential67"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:14.537Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:14.537Z"); return t}()),
		// 				UserName: to.Ptr("myCredential67"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential68"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential68"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:14.847Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:14.847Z"); return t}()),
		// 				UserName: to.Ptr("myCredential68"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential69"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential69"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:15.190Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:15.190Z"); return t}()),
		// 				UserName: to.Ptr("myCredential69"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential7"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential7"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:54.190Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:54.190Z"); return t}()),
		// 				UserName: to.Ptr("myCredential7"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential70"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential70"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:15.503Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:15.503Z"); return t}()),
		// 				UserName: to.Ptr("myCredential70"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential71"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential71"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:15.910Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:15.910Z"); return t}()),
		// 				UserName: to.Ptr("myCredential71"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential72"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential72"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:16.253Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:16.253Z"); return t}()),
		// 				UserName: to.Ptr("myCredential72"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential73"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential73"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:16.567Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:16.567Z"); return t}()),
		// 				UserName: to.Ptr("myCredential73"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential74"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential74"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:16.927Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:16.927Z"); return t}()),
		// 				UserName: to.Ptr("myCredential74"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential75"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential75"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:17.253Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:17.253Z"); return t}()),
		// 				UserName: to.Ptr("myCredential75"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential76"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential76"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:17.567Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:17.567Z"); return t}()),
		// 				UserName: to.Ptr("myCredential76"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential77"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential77"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:17.880Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:17.880Z"); return t}()),
		// 				UserName: to.Ptr("myCredential77"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential78"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential78"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:18.190Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:18.190Z"); return t}()),
		// 				UserName: to.Ptr("myCredential78"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential79"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential79"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:18.520Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:18.520Z"); return t}()),
		// 				UserName: to.Ptr("myCredential79"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential8"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential8"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:54.503Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:54.503Z"); return t}()),
		// 				UserName: to.Ptr("myCredential8"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential80"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential80"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:18.833Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:18.833Z"); return t}()),
		// 				UserName: to.Ptr("myCredential80"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential81"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential81"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:19.177Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:19.177Z"); return t}()),
		// 				UserName: to.Ptr("myCredential81"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential82"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential82"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:19.490Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:19.490Z"); return t}()),
		// 				UserName: to.Ptr("myCredential82"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential83"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential83"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:19.833Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:19.833Z"); return t}()),
		// 				UserName: to.Ptr("myCredential83"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential84"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential84"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:20.177Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:20.177Z"); return t}()),
		// 				UserName: to.Ptr("myCredential84"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential85"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential85"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:20.503Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:20.503Z"); return t}()),
		// 				UserName: to.Ptr("myCredential85"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential86"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential86"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:20.817Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:20.817Z"); return t}()),
		// 				UserName: to.Ptr("myCredential86"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential87"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential87"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:21.143Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:21.143Z"); return t}()),
		// 				UserName: to.Ptr("myCredential87"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential88"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential88"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:21.457Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:21.457Z"); return t}()),
		// 				UserName: to.Ptr("myCredential88"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential89"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential89"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:21.787Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:21.787Z"); return t}()),
		// 				UserName: to.Ptr("myCredential89"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential9"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential9"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:54.957Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:43:54.957Z"); return t}()),
		// 				UserName: to.Ptr("myCredential9"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential90"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential90"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:22.100Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:22.100Z"); return t}()),
		// 				UserName: to.Ptr("myCredential90"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential91"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential91"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:22.427Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:22.427Z"); return t}()),
		// 				UserName: to.Ptr("myCredential91"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential92"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential92"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:22.770Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:22.770Z"); return t}()),
		// 				UserName: to.Ptr("myCredential92"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential93"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential93"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:23.083Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:23.083Z"); return t}()),
		// 				UserName: to.Ptr("myCredential93"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential94"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential94"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:23.410Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:23.410Z"); return t}()),
		// 				UserName: to.Ptr("myCredential94"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential95"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential95"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:23.753Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:23.753Z"); return t}()),
		// 				UserName: to.Ptr("myCredential95"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential96"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential96"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:24.100Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:24.100Z"); return t}()),
		// 				UserName: to.Ptr("myCredential96"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myCredential97"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount20/credentials/myCredential97"),
		// 			Properties: &armautomation.CredentialProperties{
		// 				Description: to.Ptr("my description goes here"),
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:24.427Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-26T21:44:24.427Z"); return t}()),
		// 				UserName: to.Ptr("myCredential97"),
		// 			},
		// 	}},
		// }
	}
}
